/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.concurrency;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import er.extensions.components.ERXNonSynchronizingComponent;
import er.extensions.concurrency.ERXLongResponseTask;
import er.extensions.eof.ERXConstant;
import org.apache.log4j.Logger;

public class ERXLongResponse
extends ERXNonSynchronizingComponent {
    static String WOMetaRefreshSenderId = "WOMetaRefresh";
    private static final Logger log = Logger.getLogger(ERXLongResponse.class);
    protected Number _refreshInterval = ERXConstant.ZeroInteger;
    protected boolean _performingAction = false;
    protected boolean _doneAndRefreshed = false;
    protected ERXLongResponseTask _task;

    public ERXLongResponse(WOContext aContext) {
        super(aContext);
    }

    public ERXLongResponseTask task() {
        if (this._task == null) {
            this._task = (ERXLongResponseTask)this.valueForBinding("task");
        }
        return this._task;
    }

    public void setTask(ERXLongResponseTask task) {
        this._task = task;
    }

    public int refreshInterval() {
        Number n;
        if (ERXConstant.ZeroInteger.equals(this._refreshInterval) && (n = (Number)this.valueForBinding("refreshInterval")) != null) {
            this._refreshInterval = n;
        }
        return this._refreshInterval.intValue();
    }

    public void setRefreshInterval(int value) {
        this._refreshInterval = new Integer(value);
    }

    public WOComponent refresh() {
        return this.task().nextPage();
    }

    public void appendToResponse(WOResponse aResponse, WOContext aContext) {
        int interval;
        boolean done;
        if (!this._performingAction) {
            this._performingAction = true;
            this.task().setLongResponse(this);
            this.task().start();
        }
        boolean doneButNotRefreshed = (done = this.task().isDone()) && !this._doneAndRefreshed;
        int n = interval = doneButNotRefreshed ? 0 : this.refreshInterval();
        if (!done || doneButNotRefreshed) {
            String modifiedDynamicUrl = aContext.urlWithRequestHandlerKey(WOApplication.application().componentRequestHandlerKey(), null, null);
            String header = interval + ";url=" + modifiedDynamicUrl + "/" + aContext.session().sessionID() + "/" + aContext.contextID() + "." + WOMetaRefreshSenderId;
            aResponse.setHeader(header, "Refresh");
            if (doneButNotRefreshed) {
                this._doneAndRefreshed = true;
            }
        }
        super.appendToResponse(aResponse, aContext);
    }

    public WOActionResults invokeAction(WORequest aRequest, WOContext aContext) {
        if (aContext.senderID().equals(WOMetaRefreshSenderId)) {
            return this.refresh();
        }
        return super.invokeAction(aRequest, aContext);
    }
}

