/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EOAdaptorOperation;
import com.webobjects.eoaccess.EODatabaseChannel;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOGeneralAdaptorException;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSRecursiveLock;
import er.extensions.eof.ERXEC;
import er.extensions.foundation.ERXProperties;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class ERXAdaptorOperationWrapper
implements Serializable {
    public static final Logger log = Logger.getLogger(ERXAdaptorOperationWrapper.class);
    public static final NSRecursiveLock adaptorOperationsLock = new NSRecursiveLock();
    public static final String AdaptorOperationsDidPerformNotification = "AdaptorOperationsDidPerform";
    private static Boolean postAdaptorOperationNotifications = null;
    transient EOAdaptorOperation operation;
    String entityName;
    private int operator;
    private NSArray attributes;
    private NSDictionary changedValues;
    private EOQualifier qualifier;

    public ERXAdaptorOperationWrapper(EOAdaptorOperation aop) {
        this.operation = aop;
        this.entityName = aop.entity().name();
        this.operator = aop.adaptorOperator();
        this.attributes = aop.attributes();
        this.changedValues = aop.changedValues();
        this.qualifier = aop.qualifier();
    }

    public EOAdaptorOperation operation() {
        if (this.operation == null) {
            EOEntity entity = EOModelGroup.defaultGroup().entityNamed(this.entityName);
            this.operation = new EOAdaptorOperation(entity);
            this.operation.setAdaptorOperator(this.operator);
            this.operation.setAttributes(this.attributes);
            this.operation.setChangedValues(this.changedValues);
            this.operation.setQualifier(this.qualifier);
        }
        return this.operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSArray wrappedAdaptorOperations(NSArray adaptorOps) {
        NSMutableArray<ERXAdaptorOperationWrapper> nSMutableArray;
        adaptorOperationsLock.lock();
        try {
            NSMutableArray<ERXAdaptorOperationWrapper> ops = new NSMutableArray<ERXAdaptorOperationWrapper>();
            if (adaptorOps.count() > 0) {
                for (int i = 0; i < adaptorOps.count(); ++i) {
                    EOAdaptorOperation a = (EOAdaptorOperation)adaptorOps.objectAtIndex(i);
                    ERXAdaptorOperationWrapper wrapper = new ERXAdaptorOperationWrapper(a);
                    ops.addObject(wrapper);
                }
            }
            nSMutableArray = ops;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            adaptorOperationsLock.unlock();
            throw throwable;
        }
        adaptorOperationsLock.unlock();
        return nSMutableArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performWrappedAdaptorOperations(NSArray ops) {
        EOEditingContext ec = ERXEC.newEditingContext();
        ec.lock();
        try {
            ERXAdaptorOperationWrapper op = (ERXAdaptorOperationWrapper)ops.lastObject();
            EODatabaseContext context = EOUtilities.databaseContextForModelNamed((EOEditingContext)ec, (String)op.operation().entity().model().name());
            context.lock();
            adaptorOperationsLock.lock();
            EODatabaseChannel dchannel = context.availableChannel();
            EOAdaptorChannel achannel = dchannel.adaptorChannel();
            achannel.adaptorContext().beginTransaction();
            try {
                boolean wasOpen = achannel.isOpen();
                if (!wasOpen) {
                    achannel.openChannel();
                }
                for (int i = 0; i < ops.count(); ++i) {
                    op = (ERXAdaptorOperationWrapper)ops.objectAtIndex(i);
                    try {
                        achannel.performAdaptorOperation(op.operation());
                        continue;
                    }
                    catch (EOGeneralAdaptorException ex) {
                        log.error((Object)("Failed op " + i + ": " + (Object)((Object)ex) + "\n" + op));
                        throw ex;
                    }
                }
                achannel.adaptorContext().commitTransaction();
                if (!wasOpen) {
                    achannel.closeChannel();
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                adaptorOperationsLock.unlock();
                context.unlock();
                throw throwable;
            }
            adaptorOperationsLock.unlock();
            context.unlock();
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            ec.unlock();
            throw throwable;
        }
        ec.unlock();
    }

    public static void adaptorOperationsDidPerform(NSArray ops) {
        if (ERXAdaptorOperationWrapper.postAdaptorOperationNotifications() && ops.count() > 0) {
            NSNotificationCenter.defaultCenter().postNotification(AdaptorOperationsDidPerformNotification, (Object)ops);
        }
    }

    private static boolean postAdaptorOperationNotifications() {
        if (postAdaptorOperationNotifications == null) {
            postAdaptorOperationNotifications = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXAdaptorationWrapper.postAdaptorOperationNotifications", false) ? Boolean.TRUE : Boolean.FALSE;
        }
        return postAdaptorOperationNotifications;
    }
}

