/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EODatabaseChannel;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import er.extensions.foundation.ERXMulticastingDelegate;
import java.lang.reflect.Method;

public class ERXDatabaseContextMulticastingDelegate
extends ERXMulticastingDelegate {
    private Method orderAdaptorOperations;
    private Method currentEditingContext;

    public ERXDatabaseContextMulticastingDelegate() {
        try {
            this.orderAdaptorOperations = EODatabaseContext.class.getDeclaredMethod("orderAdaptorOperations", new Class[0]);
            this.orderAdaptorOperations.setAccessible(true);
            this.currentEditingContext = EODatabaseChannel.class.getDeclaredMethod("currentEditingContext", new Class[0]);
            this.currentEditingContext.setAccessible(true);
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static void addDefaultDelegate(Object newDelegate) {
        ERXDatabaseContextMulticastingDelegate multiDelegate;
        if (EODatabaseContext.defaultDelegate() == null) {
            multiDelegate = new ERXDatabaseContextMulticastingDelegate();
        } else if (EODatabaseContext.defaultDelegate() instanceof ERXDatabaseContextMulticastingDelegate) {
            multiDelegate = (ERXDatabaseContextMulticastingDelegate)EODatabaseContext.defaultDelegate();
        } else {
            multiDelegate = new ERXDatabaseContextMulticastingDelegate();
            multiDelegate.addDelegate(EODatabaseContext.defaultDelegate());
        }
        multiDelegate.addDelegate(newDelegate);
        EODatabaseContext.setDefaultDelegate((Object)multiDelegate);
    }

    public void databaseContextDidFetchObjects(EODatabaseContext dbCtxt, NSArray array, EOFetchSpecification fetchSpec, EOEditingContext ec) {
        this.perform("databaseContextDidFetchObjects", new Object[]{dbCtxt, array, fetchSpec, ec}, (Object)null);
    }

    public void databaseContextDidSelectObjects(EODatabaseContext dbCtxt, EOFetchSpecification fetchSpec, EODatabaseChannel dbChannel) {
        this.perform("databaseContextDidSelectObjects", new Object[]{dbCtxt, fetchSpec, dbChannel}, (Object)null);
    }

    public boolean databaseContextFailedToFetchObject(EODatabaseContext dbCtxt, Object object, EOGlobalID gid) {
        return this.booleanPerform("databaseContextFailedToFetchObject", new Object[]{dbCtxt, object, gid}, false);
    }

    public NSDictionary databaseContextNewPrimaryKey(EODatabaseContext dbCtxt, Object object, EOEntity entity) {
        return (NSDictionary)this.perform("databaseContextNewPrimaryKey", new Object[]{dbCtxt, object, entity}, (Object)null);
    }

    public boolean databaseContextShouldFetchArrayFault(EODatabaseContext dbCtxt, Object object) {
        return this.booleanPerform("databaseContextShouldFetchArrayFault", new Object[]{dbCtxt, object}, true);
    }

    public boolean databaseContextShouldFetchObjectFault(EODatabaseContext dbCtxt, Object object) {
        return this.booleanPerform("databaseContextShouldFetchObjectFault", new Object[]{dbCtxt, object}, true);
    }

    public NSArray databaseContextShouldFetchObjects(EODatabaseContext dbCtxt, EOFetchSpecification fetchSpec, EOEditingContext ec) {
        return (NSArray)this.perform("databaseContextShouldFetchObjects", new Object[]{dbCtxt, fetchSpec, ec}, (Object)null);
    }

    public boolean databaseContextShouldHandleDatabaseException(EODatabaseContext dbCtxt, Throwable exception) {
        return this.booleanPerform("databaseContextShouldHandleDatabaseException", new Object[]{dbCtxt, exception}, true);
    }

    public boolean databaseContextShouldInvalidateObjectWithGlobalID(EODatabaseContext dbCtxt, EOGlobalID gid, NSDictionary dic) {
        return this.booleanPerform("databaseContextShouldInvalidateObjectWithGlobalID", new Object[]{dbCtxt, gid, dic}, true);
    }

    public boolean databaseContextShouldLockObjectWithGlobalID(EODatabaseContext dbCtxt, EOGlobalID gid, NSDictionary dic) {
        return this.booleanPerform("databaseContextShouldLockObjectWithGlobalID", new Object[]{dbCtxt, gid, dic}, true);
    }

    public boolean databaseContextShouldRaiseExceptionForLockFailure(EODatabaseContext dbCtxt, Throwable exception) {
        return this.booleanPerform("databaseContextShouldRaiseExceptionForLockFailure", new Object[]{dbCtxt, exception}, true);
    }

    public boolean databaseContextShouldSelectObjects(EODatabaseContext dbCtxt, EOFetchSpecification fetchSpec, EODatabaseChannel dbChannel) {
        return this.booleanPerform("databaseContextShouldSelectObjects", new Object[]{dbCtxt, fetchSpec, dbChannel}, true);
    }

    public NSDictionary databaseContextShouldUpdateCurrentSnapshot(EODatabaseContext dbCtxt, NSDictionary existingSnapshot, NSDictionary fetchedRow, EOGlobalID gid, EODatabaseChannel dbChannel) {
        NSDictionary resultSnapshot = (NSDictionary)this.perform("databaseContextShouldUpdateCurrentSnapshot", dbCtxt, existingSnapshot, fetchedRow, gid, dbChannel, null);
        if (resultSnapshot != null) {
            return resultSnapshot;
        }
        try {
            EOEditingContext ec = (EOEditingContext)this.currentEditingContext.invoke((Object)dbChannel, new Object[0]);
            NSDictionary cachedSnapshot = dbCtxt.database().snapshotForGlobalID(gid, ec.fetchTimestamp());
            if (existingSnapshot.equals(fetchedRow) && (dbChannel.isRefreshingObjects() || cachedSnapshot == null)) {
                dbCtxt.database().recordSnapshotForGlobalID(existingSnapshot, gid);
            }
            if (dbChannel.isRefreshingObjects()) {
                return existingSnapshot.equals(fetchedRow) ? existingSnapshot : fetchedRow;
            }
            if (cachedSnapshot == null && existingSnapshot.equals(fetchedRow)) {
                return existingSnapshot;
            }
            return cachedSnapshot != null ? existingSnapshot : fetchedRow;
        }
        catch (Exception e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public boolean databaseContextShouldUsePessimisticLock(EODatabaseContext dbCtxt, EOFetchSpecification fetchSpec, EODatabaseChannel dbChannel) {
        return this.booleanPerform("databaseContextShouldUsePessimisticLock", new Object[]{dbCtxt, fetchSpec, dbChannel}, false);
    }

    public void databaseContextWillFireArrayFaultForGlobalID(EODatabaseContext dbCtxt, EOGlobalID gid, EORelationship rel, EOFetchSpecification fetchSpec, EOEditingContext ec) {
        this.perform("databaseContextWillFireArrayFaultForGlobalID", new Object[]{dbCtxt, gid, rel, fetchSpec, ec}, (Object)null);
    }

    public void databaseContextWillFireObjectFaultForGlobalID(EODatabaseContext dbCtxt, EOGlobalID gid, EOFetchSpecification fetchSpec, EOEditingContext ec) {
        this.perform("databaseContextWillFireObjectFaultForGlobalID", new Object[]{dbCtxt, gid, fetchSpec, ec}, (Object)null);
    }

    public NSArray databaseContextWillOrderAdaptorOperations(EODatabaseContext dbCtxt, NSArray databaseOps) {
        NSArray result = (NSArray)this.perform("databaseContextWillOrderAdaptorOperations", new Object[]{dbCtxt, databaseOps}, (Object)null);
        if (result == null) {
            try {
                result = (NSArray)this.orderAdaptorOperations.invoke((Object)dbCtxt, new Object[0]);
            }
            catch (Exception e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
        return result;
    }

    public NSArray databaseContextWillPerformAdaptorOperations(EODatabaseContext dbCtxt, NSArray adaptorOps, EOAdaptorChannel adChannel) {
        return (NSArray)this.perform("databaseContextWillPerformAdaptorOperations", new Object[]{dbCtxt, adaptorOps, adChannel}, (Object)adaptorOps);
    }

    public boolean databaseContextWillRunLoginPanelToOpenDatabaseChannel(EODatabaseContext dbCtxt, EODatabaseChannel dbChannel) {
        return this.booleanPerform("databaseContextWillRunLoginPanelToOpenDatabaseChannel", new Object[]{dbCtxt, dbChannel}, true);
    }
}

