/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOEntityClassDescription;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGenericRecord;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValidation;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.foundation.ERXFileNotificationCenter;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXMutableDictionary;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXThreadStorage;
import er.extensions.foundation.ERXTimestampUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;
import er.extensions.partials.ERXPartial;
import er.extensions.validation.ERXValidationException;
import er.extensions.validation.ERXValidationFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXEntityClassDescription
extends EOEntityClassDescription {
    public static final Logger log = Logger.getLogger(ERXEntityClassDescription.class);
    public static final Logger validationLog = Logger.getLogger((String)"er.validation.ERXEntityClassDescription");
    public static final Logger defaultLog = Logger.getLogger((String)"er.default.ERXEntityClassDescription");
    protected NSDictionary _validationInfo;
    protected NSMutableDictionary _validationQualiferCache;
    protected NSMutableDictionary _initialDefaultValues;
    private static Factory _factory;
    private static Method[] validityMethods;
    private static int VALIDITY_SAVE;
    private static int VALIDITY_DELETE;
    private static int VALIDITY_INSERT;
    private static int VALIDITY_UPDATE;
    private static Object sharedGSVEngineInstance;
    private static Boolean useValidity;
    public static final String ValidateEntityClassAvailability = "ERXEntityClassDescription.validateEntityClassAvailability";
    protected String defaultKey = "default";
    private NSMutableArray<Class<ERXPartial>> _partialClasses = new NSMutableArray();

    public static Factory factory() {
        return _factory;
    }

    public static void registerDescription() {
        if (_factory == null) {
            _factory = null;
            try {
                String className = ERXProperties.stringForKey("er.extensions.ERXClassDescription.factoryClass");
                if (className != null) {
                    _factory = (Factory)Class.forName(className).newInstance();
                }
            }
            catch (Exception ex) {
                log.warn((Object)("Exception while registering factory, using default: " + ex));
            }
            if (_factory == null) {
                _factory = new Factory();
            }
        }
    }

    public ERXEntityClassDescription(EOEntity entity) {
        super(entity);
        this._validationInfo = ERXValueUtilities.dictionaryValue(entity.userInfo().objectForKey("ERXValidation"));
        this._validationQualiferCache = ERXMutableDictionary.synchronizedDictionary();
    }

    public void modelFileDidChange(NSNotification n) {
        File file = (File)n.object();
        try {
            defaultLog.debug((Object)("Reading .plist for entity <" + this.entity() + ">"));
            NSDictionary userInfo = (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)ERXFileUtilities.stringFromFile(file));
            this.entity().setUserInfo((NSDictionary)userInfo.objectForKey("userInfo"));
            this._validationInfo = ERXValueUtilities.dictionaryValue(this.entity().userInfo().objectForKey("ERXValidation"));
            this._validationQualiferCache = ERXMutableDictionary.synchronizedDictionary();
            this._initialDefaultValues = null;
            this.readDefaultValues();
        }
        catch (Exception ex) {
            defaultLog.error((Object)("Can't read file <" + file.getAbsolutePath() + ">"), (Throwable)ex);
        }
    }

    public void validateObjectForDelete(EOEnterpriseObject obj) throws NSValidation.ValidationException {
        try {
            if (ERXEntityClassDescription.useValidity()) {
                this.invokeValidityMethodWithType(VALIDITY_DELETE, obj);
            }
            super.validateObjectForDelete(obj);
            this.validateObjectWithUserInfo(obj, null, "validateForDelete", "validateForDelete");
        }
        catch (ERXValidationException eov) {
            throw eov;
        }
        catch (NSValidation.ValidationException eov) {
            ERXValidationException erv;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caught validation exception: " + (Object)((Object)eov)));
            }
            throw (erv = ERXValidationFactory.defaultFactory().convertException(eov, obj)) != null ? erv : eov;
        }
    }

    public EOEntity entity() {
        this.checkEntity();
        return super.entity();
    }

    protected void checkEntity() {
        if (this._entity.model() == null) {
            try {
                EOEntity registeredEntity = ERXEOAccessUtilities.entityNamed(null, this._entity.name());
                if (registeredEntity != null) {
                    this._entity = registeredEntity;
                } else {
                    EOModel model = this._entity.model();
                    if (model == null) {
                        model = (EOModel)ERXEOAccessUtilities.modelGroup(null).models().lastObject();
                    }
                    model.addEntity(this._entity);
                    log.warn((Object)("Added <" + this._entity.name() + "> to default model group."));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Model or modelgroup for <" + this._entity.name() + "> is null: " + this.entity().model(), ex);
            }
        }
    }

    public EOEnterpriseObject createInstanceWithEditingContext(EOEditingContext ec, EOGlobalID gid) {
        this.checkEntity();
        return super.createInstanceWithEditingContext(ec, gid);
    }

    public void validateObjectForUpdate(EOEnterpriseObject obj) throws NSValidation.ValidationException {
        try {
            if (ERXEntityClassDescription.useValidity()) {
                this.invokeValidityMethodWithType(VALIDITY_UPDATE, obj);
            }
            this.validateObjectWithUserInfo(obj, null, "validateForUpdate", "validateForUpdate");
        }
        catch (ERXValidationException eov) {
            throw eov;
        }
        catch (NSValidation.ValidationException eov) {
            ERXValidationException erv;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caught validation exception: " + (Object)((Object)eov)));
            }
            throw (erv = ERXValidationFactory.defaultFactory().convertException(eov, obj)) != null ? erv : eov;
        }
    }

    public void validateObjectForInsert(EOEnterpriseObject obj) throws NSValidation.ValidationException {
        try {
            if (ERXEntityClassDescription.useValidity()) {
                this.invokeValidityMethodWithType(VALIDITY_INSERT, obj);
            }
            this.validateObjectWithUserInfo(obj, null, "validateForInsert", "validateForInsert");
        }
        catch (ERXValidationException eov) {
            throw eov;
        }
        catch (NSValidation.ValidationException eov) {
            ERXValidationException erv;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caught validation exception: " + (Object)((Object)eov)));
            }
            throw (erv = ERXValidationFactory.defaultFactory().convertException(eov, obj)) != null ? erv : eov;
        }
    }

    public Object validateValueForKey(Object obj, String s) throws NSValidation.ValidationException {
        Object validated = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validate value: " + obj + " for key: " + s));
        }
        try {
            validated = obj instanceof ERXConstant ? obj : super.validateValueForKey(obj, s);
        }
        catch (ERXValidationException eov) {
            throw eov;
        }
        catch (NSValidation.ValidationException eov) {
            ERXValidationException erv;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caught validation exception: " + (Object)((Object)eov)));
            }
            throw (erv = ERXValidationFactory.defaultFactory().convertException(eov, obj)) != null ? erv : eov;
        }
        return validated;
    }

    public void validateObjectForSave(EOEnterpriseObject obj) throws NSValidation.ValidationException {
        try {
            NSArray additionalValidationKeys;
            if (ERXEntityClassDescription.useValidity()) {
                this.invokeValidityMethodWithType(VALIDITY_SAVE, obj);
            }
            if (this._validationInfo != null && (additionalValidationKeys = (NSArray)this._validationInfo.objectForKey("additionalValidationKeys")) != null) {
                Enumeration e = additionalValidationKeys.objectEnumerator();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    NSSelector selector = new NSSelector(key);
                    if (selector.implementedByObject((Object)obj)) {
                        try {
                            selector.invoke((Object)obj);
                        }
                        catch (Exception ex) {
                            if (ex instanceof NSValidation.ValidationException) {
                                throw (NSValidation.ValidationException)((Object)ex);
                            }
                            log.error((Object)ex);
                        }
                        continue;
                    }
                    this.validateObjectWithUserInfo(obj, null, "validateForKey." + key, key);
                }
            }
            this.validateObjectWithUserInfo(obj, null, "validateForSave", "validateForSave");
        }
        catch (ERXValidationException eov) {
            throw eov;
        }
        catch (NSValidation.ValidationException eov) {
            ERXValidationException erv;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Caught validation exception: " + (Object)((Object)eov)));
            }
            throw (erv = ERXValidationFactory.defaultFactory().convertException(eov, obj)) != null ? erv : eov;
        }
    }

    protected boolean validateObjectValueDictWithInfo(ValidationObjectValue values, NSDictionary info, String cacheKey) {
        EOQualifierEvaluation q = (EOQualifierEvaluation)this._validationQualiferCache.objectForKey(cacheKey);
        if (q == null) {
            try {
                String className = (String)info.objectForKey("className");
                if (className == null) {
                    className = QualiferValidation.class.getName();
                }
                Class cl = ERXPatcher.classForName(className);
                Constructor co = cl.getConstructor(Object.class);
                Object o = co.newInstance(info);
                q = (EOQualifierEvaluation)o;
            }
            catch (Exception ex) {
                throw new NSForwardException((Throwable)ex);
            }
            this._validationQualiferCache.setObjectForKey(q, cacheKey);
        }
        if (values.value() == null && "true".equals(info.objectForKey("ignoreIfNull"))) {
            return true;
        }
        if (q != null) {
            return q.evaluateWithObject((Object)values);
        }
        return true;
    }

    public void validateObjectWithUserInfo(EOEnterpriseObject object, Object value, String validationTypeString, String property) {
        NSArray qualifiers;
        if (this._validationInfo != null && (qualifiers = (NSArray)this._validationInfo.valueForKeyPath(validationTypeString)) != null) {
            ValidationObjectValue values = new ValidationObjectValue(object, value);
            int i = 0;
            Enumeration e = qualifiers.objectEnumerator();
            while (e.hasMoreElements()) {
                NSDictionary info = (NSDictionary)e.nextElement();
                if (validationLog.isDebugEnabled()) {
                    validationLog.debug((Object)("Validate " + validationTypeString + "." + property + " with <" + value + "> on " + object + "\nRule: " + info));
                }
                if (!this.validateObjectValueDictWithInfo(values, info, validationTypeString + property + i)) {
                    String message = (String)info.objectForKey("message");
                    String keyPaths = (String)info.objectForKey("keyPaths");
                    String string = property = keyPaths == null ? property : keyPaths;
                    if (validationLog.isDebugEnabled()) {
                        validationLog.info((Object)("Validation failed " + validationTypeString + "." + property + " with <" + value + "> on " + object));
                    }
                    throw ERXValidationFactory.defaultFactory().createException(object, property, value, message);
                }
                ++i;
            }
        }
    }

    public String displayNameForKey(String key) {
        if (ERXLocalizer.isLocalizationEnabled()) {
            return ERXLocalizer.currentLocalizer().localizedDisplayNameForKey(this.entityName(), key);
        }
        return ERXStringUtilities.displayNameForKey(key);
    }

    public void readDefaultValues() {
        if (this._initialDefaultValues == null) {
            String defaultValue;
            this._initialDefaultValues = new NSMutableDictionary();
            EOEntity entity = this.entity();
            NSDictionary entityInfo = (NSDictionary)entity.userInfo().objectForKey("ERXDefaultValues");
            Enumeration e = entity.attributes().objectEnumerator();
            while (e.hasMoreElements()) {
                EOAttribute attr = (EOAttribute)e.nextElement();
                defaultValue = null;
                if (attr.userInfo() != null) {
                    defaultValue = (String)attr.userInfo().objectForKey(this.defaultKey);
                }
                if (defaultValue == null && entityInfo != null) {
                    defaultValue = (String)entityInfo.objectForKey(attr.name());
                }
                if (defaultValue == null) continue;
                this.setDefaultAttributeValue(attr, defaultValue);
            }
            e = entity.relationships().objectEnumerator();
            while (e.hasMoreElements()) {
                EORelationship rel = (EORelationship)e.nextElement();
                defaultValue = null;
                if (rel.userInfo() != null) {
                    defaultValue = (String)rel.userInfo().objectForKey(this.defaultKey);
                }
                if (defaultValue == null && entityInfo != null) {
                    defaultValue = (String)entityInfo.objectForKey(rel.name());
                }
                if (defaultValue == null) continue;
                this.setDefaultRelationshipValue(rel, defaultValue);
            }
        }
    }

    public void setDefaultAttributeValue(EOAttribute attr, String defaultValue) {
        String name = attr.name();
        defaultLog.debug((Object)("Adding: " + name + "-" + defaultValue));
        AttributeDefault d = new AttributeDefault(attr, defaultValue);
        this._initialDefaultValues.setObjectForKey(d, name);
    }

    public void setDefaultRelationshipValue(EORelationship rel, String defaultValue) {
        String name = rel.name();
        defaultLog.debug((Object)("Adding: " + name + "-" + defaultValue));
        NSArray attrs = rel.destinationAttributes();
        if (!rel.isFlattened() && attrs != null && attrs.count() == 1) {
            EOAttribute relAttr = (EOAttribute)attrs.objectAtIndex(0);
            if (defaultValue != null) {
                RelationshipDefault d = new RelationshipDefault(name, defaultValue, relAttr.adaptorValueType(), rel.destinationEntity().name());
                this._initialDefaultValues.setObjectForKey(d, name);
            }
        }
    }

    public void setDefaultValuesInObject(EOEnterpriseObject eo, EOEditingContext ec) {
        defaultLog.debug((Object)"About to set values in EO");
        if (this._initialDefaultValues == null) {
            this.readDefaultValues();
        }
        Enumeration e = this._initialDefaultValues.keyEnumerator();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            defaultLog.debug((Object)("About to set <" + key + "> in EO"));
            ((Default)this._initialDefaultValues.objectForKey(key)).setValueInObject(eo);
        }
    }

    public void awakeObjectFromInsertion(EOEnterpriseObject eo, EOEditingContext ec) {
        super.awakeObjectFromInsertion(eo, ec);
        this.setDefaultValuesInObject(eo, ec);
    }

    public String localizedKey(String key) {
        key = key + "_" + ERXLocalizer.currentLocalizer().languageCode();
        if (!this.allPropertyKeys().containsObject(key)) {
            key = null;
        }
        return key;
    }

    public String inverseForRelationshipKey(String relationshipKey) {
        String result = null;
        EORelationship relationship = this.entity().relationshipNamed(relationshipKey);
        if (relationship != null && relationship.userInfo() != null) {
            result = (String)relationship.userInfo().objectForKey("ERXInverseRelationshipName");
        }
        if (result == null) {
            result = super.inverseForRelationshipKey(relationshipKey);
        }
        return result;
    }

    private static boolean useValidity() {
        if (useValidity == null) {
            useValidity = "true".equals(System.getProperty("er.extensions.ERXGenericRecord.useValidity")) ? Boolean.TRUE : Boolean.FALSE;
        }
        return useValidity;
    }

    private void invokeValidityMethodWithType(int type, EOEnterpriseObject eo) throws NSValidation.ValidationException {
        try {
            Object dummy = null;
            Method m = this.validityMethods()[type];
            m.invoke(ERXEntityClassDescription.sharedGSVEngineInstance(), eo);
        }
        catch (IllegalAccessException e1) {
            log.error((Object)"an exception occured in validityValidateEOObjectOnSave", (Throwable)e1);
        }
        catch (IllegalArgumentException e2) {
            log.error((Object)"an exception occured in validityValidateEOObjectOnSave", (Throwable)e2);
        }
        catch (NullPointerException e3) {
            log.error((Object)"an exception occured in validityValidateEOObjectOnSave", (Throwable)e3);
        }
        catch (InvocationTargetException e4) {
            Throwable targetException = e4.getTargetException();
            if (targetException instanceof NSValidation.ValidationException) {
                throw (NSValidation.ValidationException)targetException;
            }
            log.error((Object)"an exception occured in validityValidateEOObjectOnSave", (Throwable)e4);
        }
    }

    private Method[] validityMethods() {
        if (validityMethods == null) {
            Method m;
            validityMethods = new Method[4];
            ERXEntityClassDescription.validityMethods[0] = m = ERXEntityClassDescription.methodInSharedGSVEngineInstanceWithName("validateEOObjectOnSave");
            ERXEntityClassDescription.validityMethods[1] = m = ERXEntityClassDescription.methodInSharedGSVEngineInstanceWithName("validateEOObjectOnDelete");
            ERXEntityClassDescription.validityMethods[2] = m = ERXEntityClassDescription.methodInSharedGSVEngineInstanceWithName("validateEOObjectOnInsert");
            ERXEntityClassDescription.validityMethods[3] = m = ERXEntityClassDescription.methodInSharedGSVEngineInstanceWithName("validateEOObjectOnUpdate");
        }
        return validityMethods;
    }

    private static Method methodInSharedGSVEngineInstanceWithName(String name) {
        try {
            return ERXEntityClassDescription.sharedGSVEngineInstance().getClass().getMethod(name, EOEnterpriseObject.class);
        }
        catch (IllegalArgumentException e2) {
            throw new NSForwardException((Throwable)e2);
        }
        catch (NullPointerException e3) {
            throw new NSForwardException((Throwable)e3);
        }
        catch (NoSuchMethodException e4) {
            throw new NSForwardException((Throwable)e4);
        }
    }

    private static Object sharedGSVEngineInstance() {
        if (sharedGSVEngineInstance == null) {
            try {
                Class<?> gsvEngineClass = Class.forName("com.gammastream.validity.GSVEngine");
                Method m = gsvEngineClass.getMethod("sharedValidationEngine", new Class[0]);
                Object dummy = null;
                sharedGSVEngineInstance = m.invoke(dummy, new Object[0]);
            }
            catch (ClassNotFoundException e1) {
                throw new NSForwardException((Throwable)e1);
            }
            catch (NoSuchMethodException e2) {
                throw new NSForwardException((Throwable)e2);
            }
            catch (IllegalAccessException e3) {
                throw new NSForwardException((Throwable)e3);
            }
            catch (InvocationTargetException e4) {
                throw new NSForwardException((Throwable)e4);
            }
        }
        return sharedGSVEngineInstance;
    }

    public Class _enforcedKVCNumberClassForKey(String key) {
        String className;
        EOAttribute attribute = this.entity().attributeNamed(key);
        if (attribute != null && attribute.userInfo() != null && (className = (String)attribute.userInfo().objectForKey("ERXConstantClassName")) != null) {
            Class c = ERXPatcher.classForName(className);
            return c;
        }
        return super._enforcedKVCNumberClassForKey(key);
    }

    public void _addPartialClass(Class<ERXPartial> partialClass) {
        this._partialClasses.addObject(partialClass);
    }

    public NSArray<Class<ERXPartial>> partialClasses() {
        return this._partialClasses;
    }

    static {
        validityMethods = null;
        VALIDITY_SAVE = 0;
        VALIDITY_DELETE = 1;
        VALIDITY_INSERT = 2;
        VALIDITY_UPDATE = 3;
    }

    public static class RelationshipDefault
    implements Default {
        String key;
        String stringValue;
        int adaptorType;
        String relationshipEntityName;

        public RelationshipDefault(String key, String stringValue, int adaptorType, String relationshipEntityName) {
            this.key = key;
            this.stringValue = stringValue;
            this.adaptorType = adaptorType;
            this.relationshipEntityName = relationshipEntityName;
        }

        public void setValueInObject(EOEnterpriseObject eo) {
            Object defaultValue = this.stringValue;
            EOEditingContext ec = eo.editingContext();
            if (this.stringValue.charAt(0) == '@') {
                if (this.stringValue.equals("@new")) {
                    EOClassDescription cd = EOClassDescription.classDescriptionForEntityName((String)this.relationshipEntityName);
                    EOEnterpriseObject newObject = cd.createInstanceWithEditingContext(eo.editingContext(), null);
                    ec.insertObject(newObject);
                    eo.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)newObject, this.key);
                } else if (this.stringValue.startsWith("@threadStorage.")) {
                    String keyPath = this.stringValue.substring("@threadStorage.".length());
                    Object o = ERXThreadStorage.valueForKey(keyPath);
                    if (keyPath.indexOf(".") > 0) {
                        keyPath = this.stringValue.substring(keyPath.indexOf(".") + 1);
                        o = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)o, (String)keyPath);
                    }
                    if (o != null) {
                        if (o instanceof EOEnterpriseObject) {
                            ERXEOControlUtilities.addObjectToObjectOnBothSidesOfRelationshipWithKey((EOEnterpriseObject)o, eo, this.key);
                        } else if (o instanceof NSArray) {
                            NSArray newObjects = (NSArray)o;
                            Enumeration e = newObjects.objectEnumerator();
                            while (e.hasMoreElements()) {
                                ERXEOControlUtilities.addObjectToObjectOnBothSidesOfRelationshipWithKey((EOEnterpriseObject)e.nextElement(), eo, this.key);
                            }
                        } else {
                            defaultLog.warn((Object)"setValueInObject: Object is neither an EO nor an array");
                        }
                    }
                }
            } else {
                if (this.adaptorType == 0) {
                    defaultValue = new Integer(Integer.parseInt(this.stringValue));
                }
                EOKeyGlobalID gid = EOKeyGlobalID.globalIDWithEntityName((String)this.relationshipEntityName, (Object[])new Object[]{defaultValue});
                EOEnterpriseObject fault = ec.faultForGlobalID((EOGlobalID)gid, ec);
                eo.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)fault, this.key);
            }
        }
    }

    public static class AttributeDefault
    implements Default {
        String key;
        String stringValue;
        int adaptorType;
        EOAttribute attribute;

        public AttributeDefault(EOAttribute attribute, String stringValue) {
            this(attribute.name(), stringValue, attribute.adaptorValueType());
            this.attribute = attribute;
        }

        public AttributeDefault(String key, String stringValue, int adaptorType) {
            this.key = key;
            this.stringValue = stringValue;
            this.adaptorType = adaptorType;
        }

        public AttributeDefault(String key, String stringValue) {
            this(key, stringValue, 1);
        }

        public void setValueInObject(EOEnterpriseObject eo) {
            Object defaultValue = this.stringValue;
            if (this.stringValue.startsWith("@threadStorage.")) {
                String keyPath = this.stringValue.substring("@threadStorage.".length());
                defaultValue = ERXThreadStorage.valueForKeyPath(keyPath);
            } else if (this.attribute != null && this.attribute.valueFactoryMethodName() != null && this.attribute.factoryMethodArgumentType() == 1) {
                defaultValue = this.attribute.newValueForString(this.stringValue);
            }
            if (defaultValue != null) {
                String s = defaultValue.toString();
                s = s.substring(s.indexOf("@") + 1);
                if (this.adaptorType == 3) {
                    defaultValue = ERXTimestampUtilities.timestampForString(s);
                } else if (this.adaptorType == 0) {
                    NSTimestamp temp = ERXTimestampUtilities.timestampForString(s);
                    defaultValue = temp != null ? ERXTimestampUtilities.unixTimestamp(temp) : ERXValueUtilities.bigDecimalValue(s);
                }
            }
            eo.takeValueForKey(defaultValue, this.key);
        }
    }

    public static interface Default {
        public static final int AdaptorNumberType = 0;
        public static final int AdaptorCharactersType = 1;
        public static final int AdaptorBytesType = 2;
        public static final int AdaptorDateType = 3;

        public void setValueInObject(EOEnterpriseObject var1);
    }

    public static class QualiferValidation
    implements EOQualifierEvaluation {
        protected EOQualifier qualifier;

        public QualiferValidation(Object info) {
            NSDictionary dict = (NSDictionary)info;
            this.qualifier = EOQualifier.qualifierWithQualifierFormat((String)((String)dict.objectForKey("qualifier")), null);
        }

        public boolean evaluateWithObject(Object o) {
            return this.qualifier.evaluateWithObject(o);
        }
    }

    public static class ValidationObjectValue {
        protected EOEnterpriseObject object;
        protected Object value;

        public ValidationObjectValue(EOEnterpriseObject object, Object value) {
            this.object = object;
            this.value = value;
        }

        public Object value() {
            return this.value;
        }

        public EOEnterpriseObject object() {
            return this.object;
        }
    }

    public static class Factory {
        private NSMutableArray _registeredModelNames = new NSMutableArray();
        private NSMutableDictionary _entitiesForClass = new NSMutableDictionary();
        private NSMutableDictionary _classDescriptionForEntity = new NSMutableDictionary();

        public Factory() {
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("modelWasAdded", ERXConstant.NotificationClassArray), "EOModelAddedNotification", null);
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("modelGroupWasAdded", ERXConstant.NotificationClassArray), "ERXModelGroupAddedNotification", null);
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("classDescriptionNeededForEntityName", ERXConstant.NotificationClassArray), "EOClassDescriptionNeededForEntityNameNotification", null);
            NSNotificationCenter.defaultCenter().addObserver((Object)this, new NSSelector("classDescriptionNeededForClass", ERXConstant.NotificationClassArray), "EOClassDescriptionNeededNotification", null);
        }

        public void reset() {
            this._registeredModelNames = new NSMutableArray();
            this._entitiesForClass = new NSMutableDictionary();
            this._classDescriptionForEntity = new NSMutableDictionary();
        }

        protected boolean isRapidTurnaroundEnabled() {
            return ERXProperties.booleanForKey("er.extensions.ERXEntityClassDescription.isRapidTurnaroundEnabled");
        }

        protected boolean isFixingRelationshipsEnabled() {
            return ERXProperties.booleanForKey("er.extensions.ERXEntityClassDescription.isFixingRelationshipsEnabled");
        }

        public final void modelGroupWasAdded(NSNotification n) {
            log.debug((Object)("modelGroupWasAdded: " + n));
            EOModelGroup group = (EOModelGroup)n.object();
            this.processModelGroup(group);
        }

        protected void processModelGroup(EOModelGroup group) {
            Enumeration ge = group.models().objectEnumerator();
            while (ge.hasMoreElements()) {
                EOModel model = (EOModel)ge.nextElement();
                String frameworkName = null;
                String modelPath = null;
                log.debug((Object)("ApplicationDidFinishLaunching: " + model.name()));
                if (this.isRapidTurnaroundEnabled()) {
                    Enumeration<String> e = NSArray.componentsSeparatedByString(model.pathURL().getFile(), File.separator).reverseObjectEnumerator();
                    while (e.hasMoreElements()) {
                        String a = e.nextElement();
                        if (a.indexOf(".framework") <= 0) continue;
                        frameworkName = a.substring(0, a.indexOf(".framework"));
                        break;
                    }
                    if (frameworkName == null) {
                        frameworkName = "app";
                    }
                    modelPath = ERXFileUtilities.pathForResourceNamed(model.name() + ".eomodeld", frameworkName, null);
                    defaultLog.debug((Object)("Path for model <" + model.name() + "> in framework <" + frameworkName + ">: " + modelPath));
                }
                Enumeration ee = model.entities().objectEnumerator();
                while (ee.hasMoreElements()) {
                    EOEntity entity = (EOEntity)ee.nextElement();
                    this.checkForeignKeys(entity);
                    EOClassDescription cd = EOClassDescription.classDescriptionForEntityName((String)entity.name());
                    defaultLog.debug((Object)("Reading defaults for: " + entity.name()));
                    if (cd instanceof ERXEntityClassDescription) {
                        ((ERXEntityClassDescription)cd).readDefaultValues();
                        if (!this.isRapidTurnaroundEnabled() || modelPath == null) continue;
                        String path = modelPath + File.separator + entity.name() + ".plist";
                        ERXFileNotificationCenter.defaultCenter().addObserver((Object)cd, new NSSelector("modelFileDidChange", ERXConstant.NotificationClassArray), path);
                        continue;
                    }
                    defaultLog.warn((Object)("Entity classDescription is not ERXEntityClassDescription: " + entity.name()));
                }
            }
        }

        public final void modelWasAdded(NSNotification n) {
            EOModel model = (EOModel)n.object();
            log.debug((Object)("ModelWasAddedNotification: " + model.name()));
            NSNotificationCenter.defaultCenter().removeObserver((Object)model);
            try {
                this.registerDescriptionForEntitiesInModel(model);
            }
            catch (RuntimeException e) {
                log.error((Object)("Error registering model: " + model.name()), (Throwable)e);
                throw e;
            }
        }

        public void classDescriptionNeededForEntityName(NSNotification n) {
            log.debug((Object)("classDescriptionNeededForEntityName: " + (String)n.object()));
            String name = (String)n.object();
            EOEntity e = ERXEOAccessUtilities.entityNamed(null, name);
            if (e == null) {
                log.error((Object)("Entity " + name + " not found in the default model group!"));
            }
            if (e != null) {
                this.registerDescriptionForEntity(e);
            }
        }

        public void classDescriptionNeededForClass(NSNotification n) {
            Class c = (Class)n.object();
            log.debug((Object)("classDescriptionNeededForClass: " + c.getName()));
            this.registerDescriptionForClass(c);
        }

        protected ERXEntityClassDescription newClassDescriptionForEntity(EOEntity entity) {
            ERXEntityClassDescription classDescription;
            String key = entity.name();
            EOModel model = entity.model();
            if (model != null) {
                key = model.name() + " " + key;
            }
            if ((classDescription = (ERXEntityClassDescription)((Object)this._classDescriptionForEntity.objectForKey(key))) == null) {
                classDescription = new ERXEntityClassDescription(entity);
                this._classDescriptionForEntity.setObjectForKey(classDescription, key);
            }
            return classDescription;
        }

        protected void prepareEntityForRegistration(EOEntity eoentity) {
            String className = eoentity.className();
            String defaultClassName = ERXProperties.stringForKeyWithDefault("er.extensions.ERXEntityClassDescription.defaultClassName", ERXGenericRecord.class.getName());
            String alternateClassName = ERXProperties.stringForKey("er.extensions.ERXEntityClassDescription." + eoentity.name() + ".ClassName");
            if (alternateClassName != null) {
                log.debug((Object)(eoentity.name() + ": setting class from: " + className + " to: " + alternateClassName));
                eoentity.setClassName(alternateClassName);
            } else if (className.equals("EOGenericRecord")) {
                eoentity.setClassName(defaultClassName);
            }
        }

        protected void handleOptionalRelationshipError(EOEntity eoentity, EORelationship relationship, EOAttribute attribute) {
            if (this.isFixingRelationshipsEnabled()) {
                relationship.setIsMandatory(true);
                log.info((Object)(eoentity.name() + ": relationship '" + relationship.name() + "' was switched to mandatory, because the foreign key '" + attribute.name() + "' does NOT allow NULL values"));
            } else {
                log.warn((Object)(eoentity.name() + ": relationship '" + relationship.name() + "' is marked to-one and optional, but the foreign key '" + attribute.name() + "' does NOT allow NULL values"));
            }
        }

        protected void handleMandatoryRelationshipError(EOEntity eoentity, EORelationship relationship, EOAttribute attribute) {
            if (this.isFixingRelationshipsEnabled()) {
                relationship.setIsMandatory(false);
                log.info((Object)(eoentity.name() + ": relationship '" + relationship.name() + "' was switched to optional, because the foreign key '" + attribute.name() + "' allows NULL values"));
            } else {
                log.warn((Object)(eoentity.name() + ": relationship '" + relationship.name() + "' is marked to-one and mandatory, but the foreign key '" + attribute.name() + "' allows NULL values"));
            }
        }

        public void checkForeignKeys(EOEntity eoentity) {
            NSArray primaryKeys = eoentity.primaryKeyAttributes();
            Enumeration relationships = eoentity.relationships().objectEnumerator();
            while (relationships.hasMoreElements()) {
                EOAttribute attribute;
                Enumeration attributes;
                EORelationship relationship = (EORelationship)relationships.nextElement();
                if (relationship.isToMany()) continue;
                if (relationship.isMandatory()) {
                    attributes = relationship.sourceAttributes().objectEnumerator();
                    while (attributes.hasMoreElements()) {
                        attribute = (EOAttribute)attributes.nextElement();
                        if (!attribute.allowsNull()) continue;
                        this.handleMandatoryRelationshipError(eoentity, relationship, attribute);
                    }
                    continue;
                }
                attributes = relationship.sourceAttributes().objectEnumerator();
                while (attributes.hasMoreElements()) {
                    attribute = (EOAttribute)attributes.nextElement();
                    if (attribute.allowsNull() || primaryKeys.containsObject(attribute)) continue;
                    this.handleOptionalRelationshipError(eoentity, relationship, attribute);
                }
            }
        }

        protected void registerDescriptionForEntitiesInModel(EOModel model) {
            if (!this._registeredModelNames.containsObject(model.name())) {
                Enumeration e = model.entities().objectEnumerator();
                while (e.hasMoreElements()) {
                    EOEntity eoentity = (EOEntity)e.nextElement();
                    String className = eoentity.className();
                    this.prepareEntityForRegistration(eoentity);
                    NSMutableArray<EOEntity> array = (NSMutableArray<EOEntity>)this._entitiesForClass.objectForKey(className);
                    if (array == null) {
                        array = new NSMutableArray<EOEntity>();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding entity " + eoentity.name() + " with class " + eoentity.className()));
                    }
                    array.addObject(eoentity);
                    this._entitiesForClass.setObjectForKey(array, eoentity.className());
                    this.registerDescriptionForEntity(eoentity);
                }
                this._registeredModelNames.addObject(model.name());
            }
            NSNotificationCenter.defaultCenter().removeObserver((Object)model);
        }

        private void _setClassDescriptionOnEntity(EOEntity entity, ERXEntityClassDescription cd) {
            try {
                NSKeyValueCoding.Utility.takeValueForKey((Object)entity, (Object)((Object)cd), (String)"classDescription");
            }
            catch (RuntimeException ex) {
                log.warn((Object)("_setClassDescriptionOnEntity: " + ex));
            }
        }

        protected void registerDescriptionForEntity(EOEntity entity) {
            Class<EOGenericRecord> entityClass = EOGenericRecord.class;
            String className = entity.className();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering description for entity: " + entity.name() + " with class: " + className));
            }
            if (ERXProperties.booleanForKeyWithDefault(ERXEntityClassDescription.ValidateEntityClassAvailability, true)) {
                try {
                    entityClass = className.endsWith("EOGenericRecord") ? EOGenericRecord.class : Class.forName(className);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Invalid class name '" + className + "' for entity '" + entity.name() + "'." + (!className.contains(".") ? "  (The class name should include the full package path of the class.)" : ""), ex);
                }
            }
            ERXEntityClassDescription cd = this.newClassDescriptionForEntity(entity);
            EOClassDescription.registerClassDescription((EOClassDescription)cd, entityClass);
            this._setClassDescriptionOnEntity(entity, cd);
        }

        protected void registerDescriptionForClass(Class class1) {
            NSArray entities = (NSArray)this._entitiesForClass.objectForKey(class1.getName());
            if (entities != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Registering descriptions for class: " + class1.getName() + " found entities: " + entities.valueForKey("name")));
                }
                Enumeration e = entities.objectEnumerator();
                while (e.hasMoreElements()) {
                    EOEntity entity = (EOEntity)e.nextElement();
                    ERXEntityClassDescription cd = this.newClassDescriptionForEntity(entity);
                    EOClassDescription.registerClassDescription((EOClassDescription)cd, (Class)class1);
                    this._setClassDescriptionOnEntity(entity, cd);
                }
            } else if (class1.getName().indexOf(36) < 0) {
                log.error((Object)("Unable to register descriptions for class: " + class1.getName()), (Throwable)new RuntimeException("Dummy"));
            }
        }
    }
}

