/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EORelationshipManipulation;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXEnterpriseObject;
import er.extensions.eof.ERXFetchSpecification;
import er.extensions.eof.ERXKey;
import er.extensions.eof.ERXQ;
import er.extensions.eof.ERXS;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXUnmodeledToManyRelationship<S extends ERXEnterpriseObject, D extends ERXEnterpriseObject> {
    private final S _sourceObject;
    private final String _destinationEntityName;
    private final ERXKey<S> _reverseRelationshipKey;
    private final boolean _isDeep;
    private static ConcurrentHashMap<String, NSArray<String>> _entityHierarchies = new ConcurrentHashMap();
    private NSArray<String> _destinationEntityNames;

    public ERXUnmodeledToManyRelationship(S sourceObject, String destinationEntityName, ERXKey<S> reverseRelationshipKey) {
        this(sourceObject, destinationEntityName, reverseRelationshipKey, false);
    }

    public ERXUnmodeledToManyRelationship(S sourceObject, String destinationEntityName, ERXKey<S> reverseRelationshipKey, boolean isDeep) {
        this._sourceObject = sourceObject;
        this._destinationEntityName = destinationEntityName;
        this._reverseRelationshipKey = reverseRelationshipKey;
        this._isDeep = isDeep;
    }

    public Integer countObjects() {
        int count = 0;
        if (!this._sourceObject.isNewObject()) {
            count += ERXEOControlUtilities.objectCountWithQualifier(this._sourceObject.editingContext(), this._destinationEntityName, this.qualifierForObjects()).intValue();
        }
        return count += this.insertedObjects().count();
    }

    public EOQualifier qualifierForObjects() {
        return this._reverseRelationshipKey.eq(this._sourceObject);
    }

    public NSArray<D> objects() {
        NSMutableArray<D> objects = this.insertedObjects();
        objects.addObjectsFromArray(this.persistedObjects());
        return objects.immutableClone();
    }

    public ERXFetchSpecification<D> fetchSpecificationForObjects() {
        return new ERXFetchSpecification(this._destinationEntityName, this.qualifierForObjects(), null, false, this._isDeep, null);
    }

    public NSArray<D> objects(EOQualifier qualifier) {
        return this.objects(qualifier, null, false);
    }

    public NSArray<D> objects(EOQualifier qualifier, boolean fetch) {
        return this.objects(qualifier, null, fetch);
    }

    public NSArray<D> objects(EOQualifier qualifier, NSArray<EOSortOrdering> sortOrderings, boolean fetch) {
        NSArray<D> results;
        if (fetch) {
            EOQualifier fullQualifier;
            EOQualifier inverseQualifier = this.qualifierForObjects();
            if (qualifier == null) {
                fullQualifier = inverseQualifier;
            } else {
                NSMutableArray<EOQualifier> qualifiers = new NSMutableArray<EOQualifier>();
                qualifiers.addObject(qualifier);
                qualifiers.addObject(inverseQualifier);
                fullQualifier = new EOAndQualifier(qualifiers);
            }
            ERXFetchSpecification<D> fs = this.fetchSpecificationForObjects();
            fs.setSortOrderings(sortOrderings);
            fs.setQualifier(fullQualifier);
            fs.setRefreshesRefetchedObjects(fetch);
            results = fs.fetchObjects(this._sourceObject.editingContext());
        } else {
            results = this.objects();
            if (qualifier != null) {
                results = ERXQ.filtered(results, qualifier);
            }
            if (sortOrderings != null) {
                results = ERXS.sorted(results, sortOrderings);
            }
        }
        return results;
    }

    private NSArray<D> persistedObjects() {
        ERXFetchSpecification<D> fs = this.fetchSpecificationForObjects();
        return fs.fetchObjects(this._sourceObject.editingContext());
    }

    private NSMutableArray<D> insertedObjects() {
        return ERXEOControlUtilities.insertedObjects(this._sourceObject.editingContext(), this.destinationEntityNames(), this.qualifierForObjects());
    }

    public void addToObjectsRelationship(D object) {
        object.addObjectToBothSidesOfRelationshipWithKey(this._sourceObject, this._reverseRelationshipKey.toString());
    }

    public void addToObjectsRelationship(NSArray<D> objects) {
        for (ERXEnterpriseObject object : objects) {
            object.addObjectToBothSidesOfRelationshipWithKey((EORelationshipManipulation)this._sourceObject, this._reverseRelationshipKey.toString());
        }
    }

    public void removeFromObjectsRelationship(D object) {
        object.removeObjectFromBothSidesOfRelationshipWithKey(this._sourceObject, this._reverseRelationshipKey.toString());
    }

    public void removeFromObjectsRelationship(NSArray<D> objects) {
        for (ERXEnterpriseObject object : objects) {
            object.removeObjectFromBothSidesOfRelationshipWithKey((EORelationshipManipulation)this._sourceObject, this._reverseRelationshipKey.toString());
        }
    }

    public void deleteObjectRelationship(D object) {
        this.removeFromObjectsRelationship(object);
        this._sourceObject.editingContext().deleteObject(object);
    }

    public void deleteAllObjectsRelationships() {
        NSArray<D> objects = this.objects().immutableClone();
        for (ERXEnterpriseObject object : objects) {
            this.deleteObjectRelationship(object);
        }
    }

    private NSArray<String> destinationEntityNames() {
        if (this._destinationEntityNames == null) {
            this._destinationEntityNames = this._isDeep ? ERXUnmodeledToManyRelationship.entityHierarchyNamesForEntityNamed(this._sourceObject.editingContext(), this._destinationEntityName) : new NSArray<String>(this._destinationEntityName);
        }
        return this._destinationEntityNames;
    }

    private static NSArray<String> entityHierarchyNamesForEntityNamed(EOEditingContext ec, String rootEntityName) {
        NSArray<String> cachedResult = _entityHierarchies.get(rootEntityName);
        if (cachedResult == null) {
            cachedResult = ERXEOAccessUtilities.entityHierarchyNamesForEntityNamed(ec, rootEntityName);
            _entityHierarchies.put(rootEntityName, cachedResult);
        }
        return cachedResult;
    }
}

