/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof.qualifiers;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EOQualifierSQLGeneration;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.qualifiers.ERXKeyValueQualifier;
import org.apache.log4j.Logger;

public class ERXToManyQualifier
extends ERXKeyValueQualifier
implements Cloneable {
    public static final String MatchesAllInArraySelectorName = "matchesAllInArray";
    public static final Logger log;
    private String _toManyKey;
    private NSArray _elements;
    private int _minCount = 0;

    public ERXToManyQualifier(String toManyKey, NSArray elements) {
        this(toManyKey, elements, 0);
    }

    public ERXToManyQualifier(String toManyKey, NSArray elements, int minCount) {
        super(toManyKey, EOQualifier.QualifierOperatorEqual, elements);
        this._toManyKey = toManyKey;
        this._elements = elements;
        this._minCount = minCount;
    }

    public NSArray elements() {
        return this._elements;
    }

    public String key() {
        return this._toManyKey;
    }

    public int minCount() {
        return this._minCount;
    }

    public String toString() {
        return "<" + this._toManyKey + " contains " + (this._minCount > 0 ? " " + this._minCount + " " : " all ") + " of " + this._elements + ">";
    }

    public Object clone() {
        return new ERXToManyQualifier(this._toManyKey, this._elements, this._minCount);
    }

    public EOQualifier qualifierWithBindings(NSDictionary arg0, boolean arg1) {
        if (arg0 != null && arg0.count() > 0) {
            throw new IllegalStateException(this.getClass().getName() + " doesn't support bindings");
        }
        return this;
    }

    public void validateKeysWithRootClassDescription(EOClassDescription arg0) {
    }

    public void addQualifierKeysToSet(NSMutableSet arg0) {
        throw new IllegalStateException(this.getClass().getName() + " doesn't support adding keys");
    }

    public boolean evaluateWithObject(Object object) {
        NSArray objArray;
        int objArrayCount;
        Object obj;
        boolean result = false;
        if (object != null && object instanceof NSKeyValueCoding && (obj = ((NSKeyValueCoding)object).valueForKey(this.key())) instanceof NSArray && (objArrayCount = (objArray = (NSArray)obj).count()) > 0) {
            if (this._minCount == 0) {
                result = ERXArrayUtilities.arrayContainsArray(objArray, this.elements());
            } else {
                return ERXArrayUtilities.intersectingElements(objArray, this.elements()).count() >= this._minCount;
            }
        }
        return result;
    }

    static {
        EOQualifierSQLGeneration.Support.setSupportForClass((EOQualifierSQLGeneration.Support)new ToManyQualifierSQLGenerationSupport(), ERXToManyQualifier.class);
        log = Logger.getLogger(ERXToManyQualifier.class);
    }

    public static class ToManyQualifierSQLGenerationSupport
    extends EOQualifierSQLGeneration.Support {
        protected static void appendColumnForAttributeToStringBuffer(EOAttribute attribute, StringBuffer sb) {
            sb.append(attribute.entity().externalName());
            sb.append('.');
            sb.append(attribute.columnName());
        }

        public String sqlStringForSQLExpression(EOQualifier eoqualifier, EOSQLExpression e) {
            ERXToManyQualifier qualifier = (ERXToManyQualifier)eoqualifier;
            StringBuffer result = new StringBuffer();
            EOEntity targetEntity = e.entity();
            NSArray<String> toManyKeys = NSArray.componentsSeparatedByString(qualifier.key(), ".");
            EORelationship targetRelationship = null;
            for (int i = 0; i < toManyKeys.count() - 1; ++i) {
                targetRelationship = targetEntity.anyRelationshipNamed(toManyKeys.objectAtIndex(i));
                targetEntity = targetRelationship.destinationEntity();
            }
            targetRelationship = targetEntity.relationshipNamed(toManyKeys.lastObject());
            targetEntity = targetRelationship.destinationEntity();
            if (targetRelationship.joins() == null || targetRelationship.joins().count() == 0) {
                String definitionKeyPath = targetRelationship.definition();
                NSArray<String> definitionKeys = NSArray.componentsSeparatedByString(definitionKeyPath, ".");
                EOEntity lastStopEntity = targetRelationship.entity();
                EORelationship firstHopRelationship = lastStopEntity.relationshipNamed(definitionKeys.objectAtIndex(0));
                EOEntity endOfFirstHopEntity = firstHopRelationship.destinationEntity();
                EOJoin join = (EOJoin)firstHopRelationship.joins().objectAtIndex(0);
                EOAttribute sourceAttribute = join.sourceAttribute();
                EOAttribute targetAttribute = join.destinationAttribute();
                EORelationship secondHopRelationship = endOfFirstHopEntity.relationshipNamed(definitionKeys.objectAtIndex(1));
                join = (EOJoin)secondHopRelationship.joins().objectAtIndex(0);
                EOAttribute secondHopSourceAttribute = join.sourceAttribute();
                NSMutableArray<String> lastStopPKeyPath = new NSMutableArray<String>(toManyKeys);
                lastStopPKeyPath.removeLastObject();
                lastStopPKeyPath.addObject(firstHopRelationship.name());
                lastStopPKeyPath.addObject(targetAttribute.name());
                String firstHopRelationshipKeyPath = lastStopPKeyPath.componentsJoinedByString(".");
                result.append(e.sqlStringForAttributeNamed(firstHopRelationshipKeyPath));
                result.append(" IN ( SELECT ");
                result.append(lastStopEntity.externalName());
                result.append('.');
                result.append(((EOAttribute)lastStopEntity.primaryKeyAttributes().objectAtIndex(0)).columnName());
                result.append(" FROM ");
                result.append(lastStopEntity.externalName());
                result.append(',');
                lastStopPKeyPath.removeLastObject();
                String tableAliasForJoinTable = (String)e.aliasesByRelationshipPath().objectForKey(lastStopPKeyPath.componentsJoinedByString("."));
                result.append(endOfFirstHopEntity.externalName());
                result.append(' ');
                result.append(tableAliasForJoinTable);
                result.append(" WHERE ");
                ToManyQualifierSQLGenerationSupport.appendColumnForAttributeToStringBuffer(sourceAttribute, result);
                result.append('=');
                result.append(e.sqlStringForAttributeNamed(firstHopRelationshipKeyPath));
                if (qualifier.elements() != null) {
                    NSArray pKeys = ERXEOAccessUtilities.primaryKeysForObjects(qualifier.elements());
                    result.append(" AND ");
                    result.append(tableAliasForJoinTable);
                    result.append('.');
                    result.append(secondHopSourceAttribute.columnName());
                    result.append(" IN (");
                    EOAttribute pk = (EOAttribute)targetEntity.primaryKeyAttributes().lastObject();
                    for (int i = 0; i < pKeys.count(); ++i) {
                        Object key = pKeys.objectAtIndex(i);
                        String keyString = e.formatValueForAttribute(key, pk);
                        if ("NULL".equals(keyString)) {
                            keyString = "" + key;
                        }
                        result.append(keyString);
                        if (i >= pKeys.count() - 1) continue;
                        result.append(",");
                    }
                    result.append(") ");
                }
                result.append(" GROUP BY ");
                ToManyQualifierSQLGenerationSupport.appendColumnForAttributeToStringBuffer(sourceAttribute, result);
                result.append(" HAVING COUNT(*)");
                if (qualifier.minCount() <= 0) {
                    result.append("=" + qualifier.elements().count());
                } else {
                    result.append(">=" + qualifier.minCount());
                }
            } else {
                throw new RuntimeException("not implemented!!");
            }
            result.append(" )");
            return result.toString();
        }

        public EOQualifier schemaBasedQualifierWithRootEntity(EOQualifier eoqualifier, EOEntity eoentity) {
            EOQualifier result = null;
            EOKeyValueQualifier qualifier = (EOKeyValueQualifier)eoqualifier;
            String key = qualifier.key();
            if (qualifier.selector().name().equals(ERXToManyQualifier.MatchesAllInArraySelectorName)) {
                EOQualifierSQLGeneration.Support support = EOQualifierSQLGeneration.Support.supportForClass(ERXToManyQualifier.class);
                NSArray array = (NSArray)qualifier.value();
                ERXToManyQualifier q = new ERXToManyQualifier(key, array, array.count());
                result = support.schemaBasedQualifierWithRootEntity((EOQualifier)q, eoentity);
                return result;
            }
            return (EOQualifier)eoqualifier.clone();
        }

        public EOQualifier qualifierMigratedFromEntityRelationshipPath(EOQualifier eoqualifier, EOEntity eoentity, String relationshipPath) {
            ERXToManyQualifier qualifier = (ERXToManyQualifier)eoqualifier;
            String newPath = EOQualifierSQLGeneration.Support._translateKeyAcrossRelationshipPath((String)qualifier.key(), (String)relationshipPath, (EOEntity)eoentity);
            return new ERXToManyQualifier(newPath, qualifier.elements(), qualifier.minCount());
        }
    }
}

