/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.appserver.WOMessage;
import com.webobjects.eocontrol.EOKeyValueCoding;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXUtilities;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXDictionaryUtilities {
    public static <K, V> NSDictionary<K, V> dictionaryWithDictionaryAndDictionary(NSDictionary<? extends K, ? extends V> dict1, NSDictionary<? extends K, ? extends V> dict2) {
        if (dict1 == null || dict1.allKeys().count() == 0) {
            return dict2;
        }
        if (dict2 == null || dict2.allKeys().count() == 0) {
            return dict1;
        }
        NSMutableDictionary<K, V> result = new NSMutableDictionary<K, V>(dict2);
        result.addEntriesFromDictionary(dict1);
        return new NSDictionary<K, V>(result);
    }

    public static NSDictionary dictionaryFromPropertyList(String name, NSBundle bundle) {
        String string = ERXStringUtilities.stringFromResource(name, "plist", bundle);
        return (NSDictionary)NSPropertyListSerialization.propertyListFromString((String)string);
    }

    public static NSDictionary dictionaryWithObjectsAndKeys(Object[] objectsAndKeys) {
        Object object;
        NSMutableDictionary<String, Object> result = new NSMutableDictionary<String, Object>();
        int length = objectsAndKeys.length;
        for (int i = 0; i < length && (object = objectsAndKeys[i]) != null; i += 2) {
            String key = (String)objectsAndKeys[i + 1];
            result.setObjectForKey(object, key);
        }
        return new NSDictionary(result);
    }

    public static <K, V> NSDictionary<K, V> dictionaryByRemovingFromDictionaryKeysInArray(NSDictionary<K, V> d, NSArray<K> a) {
        NSMutableDictionary<K, V> result = new NSMutableDictionary<K, V>();
        if (d != null && a != null) {
            Enumeration<K> e = d.allKeys().objectEnumerator();
            while (e.hasMoreElements()) {
                K key = e.nextElement();
                if (a.containsObject(key)) continue;
                result.setObjectForKey(d.objectForKey(key), key);
            }
        }
        return result.immutableClone();
    }

    public static <K, V> NSDictionary<K, V> dictionaryByRemovingKeysNotInArray(NSDictionary<K, V> d, NSArray<K> a) {
        NSMutableDictionary<K, V> result = new NSMutableDictionary<K, V>();
        if (d != null && a != null) {
            Enumeration<K> e = a.objectEnumerator();
            while (e.hasMoreElements()) {
                K key = e.nextElement();
                V value = d.objectForKey(key);
                if (value == null) continue;
                result.setObjectForKey(value, key);
            }
        }
        return result.immutableClone();
    }

    public static <K, V> NSDictionary<K, V> removeNullValues(NSDictionary<K, V> dict) {
        NSMutableDictionary<K, V> d = new NSMutableDictionary<K, V>();
        Enumeration<K> e = dict.keyEnumerator();
        while (e.hasMoreElements()) {
            K key = e.nextElement();
            V o = dict.objectForKey(key);
            if (o instanceof NSKeyValueCoding.Null) continue;
            d.setObjectForKey(o, key);
        }
        return d;
    }

    public static NSDictionary<String, Object> dictionaryFromObjectWithKeys(Object object, NSArray<String> keys) {
        NSMutableDictionary<String, Object> result = new NSMutableDictionary<String, Object>();
        if (object != null && keys != null) {
            Enumeration<String> e = keys.objectEnumerator();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)object, (String)key);
                if (value == null) continue;
                result.setObjectForKey(value, key);
            }
        }
        return result.immutableClone();
    }

    public static NSArray<String> stringKeysSortedAscending(NSDictionary<String, ?> d) {
        NSArray<String> result = null;
        if (d != null && d.count() > 0) {
            NSArray<String> keys = d.allKeys();
            result = ERXArrayUtilities.sortedArrayUsingComparator(keys, NSComparator.AscendingStringComparator);
        }
        return result != null ? result : NSArray.EmptyArray;
    }

    public static <T> NSArray<T> keysSortedByValueAscending(NSDictionary<T, ?> d) {
        NSArray<T> result = null;
        if (d != null && d.count() > 0) {
            NSArray<T> keys = d.allKeys();
            result = ERXArrayUtilities.sortedArrayUsingComparator(keys, new NSDictionaryKeyValueComparator(d));
        }
        return result != null ? result : NSArray.EmptyArray;
    }

    public static <K, V> void removeMatchingEntries(NSMutableDictionary<? extends K, ? extends V> dict1, NSMutableDictionary<? extends K, ? extends V> dict2) {
        ERXDictionaryUtilities._removeMatchingEntries(dict1, dict2, true);
    }

    public static <K, V> void _removeMatchingEntries(NSMutableDictionary<? extends K, ? extends V> snapshot1, NSMutableDictionary<? extends K, ? extends V> snapshot2, boolean removeInverse) {
        Enumeration keys1Enum = snapshot1.allKeys().immutableClone().objectEnumerator();
        while (keys1Enum.hasMoreElements()) {
            boolean value2IsNull;
            String key = (String)keys1Enum.nextElement();
            Object value1 = snapshot1.objectForKey(key);
            Object value2 = snapshot2.objectForKey(key);
            boolean value1IsNull = value1 == null || value1 == EOKeyValueCoding.NullValue || value1 == NSKeyValueCoding.NullValue;
            boolean bl = value2IsNull = value2 == null || value2 == EOKeyValueCoding.NullValue || value2 == NSKeyValueCoding.NullValue;
            if (value1IsNull && value2IsNull) {
                snapshot1.removeObjectForKey(key);
                snapshot2.removeObjectForKey(key);
                continue;
            }
            if (value1 == null || !value1.equals(value2)) continue;
            snapshot1.removeObjectForKey(key);
            snapshot2.removeObjectForKey(key);
        }
        if (removeInverse) {
            ERXDictionaryUtilities._removeMatchingEntries(snapshot2, snapshot1, false);
        }
    }

    public static <K, V> void setObjectForKeys(NSMutableDictionary<K, V> dictionary, V object, NSArray<K> keys) {
        if (dictionary != null && keys != null && keys.count() > 0) {
            if (keys.count() == 1) {
                dictionary.setObjectForKey(object, keys.objectAtIndex(0));
            } else {
                Enumeration<K> e = keys.objectEnumerator();
                while (e.hasMoreElements()) {
                    dictionary.setObjectForKey(object, e.nextElement());
                }
            }
        }
    }

    public static <K, V> NSDictionary<K, V> deepClone(NSDictionary<K, V> dict, boolean onlyCollections) {
        NSMutableDictionary<K, V> clonedDict = null;
        if (dict != null) {
            clonedDict = dict.mutableClone();
            for (K key : dict.allKeys()) {
                V value = dict.objectForKey(key);
                K cloneKey = ERXUtilities.deepClone(key, onlyCollections);
                V cloneValue = ERXUtilities.deepClone(value, onlyCollections);
                if (cloneKey != key) {
                    clonedDict.removeObjectForKey(key);
                    if (cloneValue == null) continue;
                    clonedDict.setObjectForKey(cloneValue, cloneKey);
                    continue;
                }
                if (cloneValue != null) {
                    if (cloneValue == value) continue;
                    clonedDict.setObjectForKey(cloneValue, cloneKey);
                    continue;
                }
                clonedDict.removeObjectForKey(key);
            }
        }
        return clonedDict;
    }

    public static String queryStringForDictionary(NSDictionary<?, ?> dict, String separator) {
        return ERXDictionaryUtilities.queryStringForDictionary(dict, separator, WOMessage.defaultURLEncoding());
    }

    public static String queryStringForDictionary(NSDictionary<?, ?> dict, String separator, String encoding) {
        if (separator == null) {
            separator = "&";
        }
        StringBuffer sb = new StringBuffer(100);
        Enumeration<?> e = dict.allKeys().objectEnumerator();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            try {
                sb.append(URLEncoder.encode(key.toString(), encoding));
                sb.append("=");
                sb.append(URLEncoder.encode(dict.objectForKey(key).toString(), encoding));
                if (!e.hasMoreElements()) continue;
                sb.append(separator);
            }
            catch (UnsupportedEncodingException ex) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)ex);
            }
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NSDictionaryKeyValueComparator
    extends NSComparator {
        private NSDictionary<?, ?> dictionary;

        public NSDictionaryKeyValueComparator(NSDictionary<?, ?> aDictionary) {
            this.dictionary = aDictionary;
        }

        public int compare(Object key1, Object key2) throws NSComparator.ComparisonException {
            Object value1 = this.dictionary.objectForKey(key1);
            Object value2 = this.dictionary.objectForKey(key2);
            if (!(value1 instanceof Comparable) || !(value2 instanceof Comparable)) {
                throw new NSComparator.ComparisonException("dictionary values are not comparable");
            }
            return ((Comparable)value1).compareTo(value2);
        }
    }
}

