/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.ERXExtensions;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ERXExceptionUtilities {
    public static final Logger log = Logger.getLogger(ERXExceptionUtilities.class);
    private static NSArray<Pattern> _skipPatterns;

    protected static Throwable getCause(Throwable t) {
        Throwable cause = null;
        if (t != null && (cause = t.getCause()) == null) {
            try {
                Class<?> ognlExceptionClass = Class.forName("ognl.OgnlException");
                if (ognlExceptionClass.isAssignableFrom(t.getClass())) {
                    Method reasonMethod = ognlExceptionClass.getDeclaredMethod("getReason", new Class[0]);
                    cause = (Throwable)reasonMethod.invoke((Object)t, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (t == cause) {
            cause = null;
        }
        return cause;
    }

    public static String toParagraph(Throwable t) {
        return ERXExceptionUtilities.toParagraph(t, true);
    }

    public static String toParagraph(Throwable t, boolean removeHtmlTags) {
        StringBuffer messageBuffer = new StringBuffer();
        boolean foundInternalError = false;
        Throwable throwable = t;
        while (throwable != null) {
            Throwable oldThrowable = ERXExceptionUtilities.getMeaningfulThrowable(throwable);
            String message = throwable.getLocalizedMessage();
            if (message == null) {
                if (!foundInternalError) {
                    message = "Your request produced an error.";
                    foundInternalError = true;
                } else {
                    message = "";
                }
            }
            if (removeHtmlTags) {
                message = message.replaceAll("<[^>]+>", "");
            }
            message = message.trim();
            messageBuffer.append(message);
            if (!message.endsWith(".")) {
                messageBuffer.append(". ");
            } else {
                messageBuffer.append(" ");
            }
            throwable = ERXExceptionUtilities.getCause(oldThrowable);
        }
        return messageBuffer.toString();
    }

    public static Throwable getMeaningfulThrowable(Throwable t) {
        Throwable meaningfulThrowable = t instanceof NSForwardException ? ((NSForwardException)t).originalException() : (t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : (t instanceof WeDontNeedAStackTraceException && t.getMessage() == null ? t.getCause() : t));
        if (meaningfulThrowable != t) {
            meaningfulThrowable = ERXExceptionUtilities.getMeaningfulThrowable(meaningfulThrowable);
        }
        return meaningfulThrowable;
    }

    public static void printStackTrace() {
        Exception e = new Exception("DEBUG");
        e.fillInStackTrace();
        ERXExceptionUtilities.printStackTrace(e);
    }

    public static void logStackTrace() {
        Exception e = new Exception("DEBUG");
        e.fillInStackTrace();
        log.error(null, (Throwable)e);
    }

    public static void printStackTrace(Throwable t) {
        ERXExceptionUtilities.printStackTrace(t, System.out);
    }

    public static void printStackTrace(Throwable t, OutputStream os) {
        ERXExceptionUtilities.printStackTrace(t, new PrintWriter(os, true), 0);
    }

    public static void printStackTrace(Throwable t, Writer writer) {
        ERXExceptionUtilities.printStackTrace(t, new PrintWriter(writer, true), 0);
    }

    public static void printStackTrace(Throwable t, PrintWriter writer) {
        ERXExceptionUtilities.printStackTrace(t, writer, 0);
    }

    protected static void _printSingleStackTrace(Throwable t, PrintWriter writer, int exceptionDepth, boolean cleanupStackTrace) {
        NSArray<Pattern> skipPatterns = _skipPatterns;
        if (cleanupStackTrace && skipPatterns == null) {
            String skipPatternsFile = ERXProperties.stringForKey("er.extensions.stackTrace.skipPatternsFile");
            if (skipPatternsFile != null) {
                NSMutableArray<Pattern> mutableSkipPatterns = new NSMutableArray<Pattern>();
                Enumeration<String> frameworksEnum = ERXLocalizer.frameworkSearchPath().reverseObjectEnumerator();
                while (frameworksEnum.hasMoreElements()) {
                    String framework = frameworksEnum.nextElement();
                    URL path = ERXFileUtilities.pathURLForResourceNamed(skipPatternsFile, framework, null);
                    if (path == null) continue;
                    try {
                        NSArray skipPatternStrings = (NSArray)ERXExtensions.readPropertyListFromFileInFramework(skipPatternsFile, framework, null);
                        if (skipPatternStrings == null) continue;
                        for (String skipPatternString : skipPatternStrings) {
                            try {
                                mutableSkipPatterns.addObject(Pattern.compile(skipPatternString));
                            }
                            catch (Throwable patternThrowable) {
                                log.error((Object)("Skipping invalid exception pattern '" + skipPatternString + "' in '" + skipPatternsFile + "' in the framework '" + framework + "' (" + ERXExceptionUtilities.toParagraph(patternThrowable) + ")"));
                            }
                        }
                    }
                    catch (Throwable patternThrowable) {
                        log.error((Object)("Failed to read pattern file '" + skipPatternsFile + "' in the framework '" + framework + "' (" + ERXExceptionUtilities.toParagraph(patternThrowable) + ")"));
                    }
                }
                skipPatterns = mutableSkipPatterns;
            }
            if (ERXProperties.booleanForKeyWithDefault("er.extensions.stackTrace.cachePatterns", true)) {
                _skipPatterns = skipPatterns == null ? NSArray.EmptyArray : skipPatterns;
            }
        }
        StackTraceElement[] elements = t.getStackTrace();
        ERXStringUtilities.indent(writer, exceptionDepth);
        if (exceptionDepth > 0) {
            writer.print("Caused by a ");
        }
        if (cleanupStackTrace) {
            writer.print(t.getClass().getSimpleName());
        } else {
            writer.print(t.getClass().getName());
        }
        String message = t.getLocalizedMessage();
        if (message != null) {
            writer.print(": ");
            writer.print(message);
        }
        writer.println();
        int stackDepth = 0;
        int skippedCount = 0;
        for (StackTraceElement element : elements) {
            boolean showElement = true;
            if (stackDepth > 0 && cleanupStackTrace && skipPatterns != null && !skipPatterns.isEmpty()) {
                String elementName = element.getClassName() + "." + element.getMethodName();
                for (Pattern skipPattern : skipPatterns) {
                    if (!skipPattern.matcher(elementName).matches()) continue;
                    showElement = false;
                    break;
                }
            }
            if (!showElement) {
                ++skippedCount;
            } else {
                if (skippedCount > 0) {
                    ERXStringUtilities.indent(writer, exceptionDepth + 1);
                    writer.println("   ... skipped " + skippedCount + " stack elements");
                    skippedCount = 0;
                }
                ERXStringUtilities.indent(writer, exceptionDepth + 1);
                writer.print("at ");
                writer.print(element.getClassName());
                writer.print(".");
                writer.print(element.getMethodName());
                writer.print("(");
                if (element.isNativeMethod()) {
                    writer.print("Native Method");
                } else if (element.getLineNumber() < 0) {
                    writer.print(element.getFileName());
                    writer.print(":Unknown");
                } else {
                    writer.print(element.getFileName());
                    writer.print(":");
                    writer.print(element.getLineNumber());
                }
                writer.print(")");
                writer.println();
            }
            ++stackDepth;
        }
        if (skippedCount > 0) {
            ERXStringUtilities.indent(writer, exceptionDepth + 1);
            writer.println("... skipped " + skippedCount + " stack elements");
        }
    }

    public static void printStackTrace(Throwable t, PrintWriter writer, int exceptionDepth) {
        try {
            boolean cleanupStackTrace = ERXProperties.booleanForKeyWithDefault("er.extensions.stackTrace.cleanup", false);
            Throwable actualThrowable = cleanupStackTrace ? t : ERXExceptionUtilities.getMeaningfulThrowable(t);
            if (actualThrowable == null) {
                return;
            }
            Throwable cause = ERXExceptionUtilities.getCause(actualThrowable);
            boolean showOnlyBottomException = ERXProperties.booleanForKeyWithDefault("er.extensions.stackTrace.bottomOnly", true);
            if (!showOnlyBottomException || cause == null) {
                ERXExceptionUtilities._printSingleStackTrace(actualThrowable, writer, exceptionDepth, cleanupStackTrace);
            }
            if (cause != null && cause != actualThrowable) {
                ERXExceptionUtilities.printStackTrace(cause, writer, exceptionDepth);
            }
        }
        catch (Throwable thisSucks) {
            writer.println("ERXExceptionUtilities.printStackTrace Failed!");
            thisSucks.printStackTrace(writer);
        }
    }

    public static class HideStackTraceException
    extends NSForwardException {
        public HideStackTraceException(Throwable cause) {
            super(cause);
        }

        public void printStackTrace(PrintWriter s) {
            s.println("[stack trace already printed]");
        }
    }

    public static interface WeDontNeedAStackTraceException {
    }
}

