/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPropertyListSerialization;
import er.extensions.ERXExtensions;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXFile;
import er.extensions.foundation.ERXRuntimeUtilities;
import er.extensions.foundation.ERXStringUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXFileUtilities {
    public static final Logger log = Logger.getLogger(ERXFileUtilities.class);

    public static File writeUrlToTempFile(String url, String prefix, String suffix) throws IOException {
        return ERXFileUtilities.writeUrlToTempFile(new URL(url), prefix, suffix);
    }

    public static File writeUrlToTempFile(URL url, String prefix, String suffix) throws IOException {
        int questionMarkIndex;
        String urlStr;
        int dotIndex;
        String extension = suffix == null ? ((dotIndex = (urlStr = url.toExternalForm()).lastIndexOf(46)) >= 0 ? ((questionMarkIndex = urlStr.indexOf(63, dotIndex)) == -1 ? urlStr.substring(dotIndex) : urlStr.substring(dotIndex, questionMarkIndex)) : "") : suffix;
        File tempFile = ERXFileUtilities.writeInputStreamToTempFile(url.openStream(), prefix, extension);
        return tempFile;
    }

    public static void writeUrlToTempFile(String url, File file) throws IOException {
        ERXFileUtilities.writeUrlToTempFile(new URL(url), file);
    }

    public static void writeUrlToTempFile(URL url, File file) throws IOException {
        ERXFileUtilities.writeInputStreamToFile(url.openStream(), file);
    }

    public static byte[] bytesFromInputStream(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("null input stream");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int read = -1;
        byte[] buf = new byte[51200];
        while ((read = in.read(buf)) != -1) {
            bout.write(buf, 0, read);
        }
        return bout.toByteArray();
    }

    public static String stringFromInputStream(InputStream in, String encoding) throws IOException {
        return new String(ERXFileUtilities.bytesFromInputStream(in), encoding);
    }

    public static String stringFromInputStream(InputStream in) throws IOException {
        return new String(ERXFileUtilities.bytesFromInputStream(in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromURL(URL url) throws IOException {
        String string;
        InputStream is = url.openStream();
        try {
            string = ERXFileUtilities.stringFromInputStream(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return string;
    }

    public static byte[] bytesFromGZippedFile(File f) throws IOException {
        if (f == null) {
            throw new IllegalArgumentException("null file");
        }
        FileInputStream fis = new FileInputStream(f);
        GZIPInputStream gis = new GZIPInputStream(fis);
        byte[] result = ERXFileUtilities.bytesFromInputStream(gis);
        fis.close();
        gis.close();
        return result;
    }

    public static byte[] bytesFromFile(File f) throws IOException {
        if (f == null) {
            throw new IllegalArgumentException("null file");
        }
        return ERXFileUtilities.bytesFromFile(f, (int)f.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytesFromFile(File f, int n) throws IOException {
        byte[] byArray;
        if (f == null) {
            throw new IllegalArgumentException("null file");
        }
        FileInputStream fis = new FileInputStream(f);
        try {
            byte[] result;
            byArray = result = ERXFileUtilities.bytesFromInputStream(fis, n);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        return byArray;
    }

    public static byte[] bytesFromInputStream(InputStream fis, int n) throws IOException {
        byte[] data = new byte[n];
        for (int bytesRead = 0; bytesRead < n; bytesRead += fis.read(data, bytesRead, n - bytesRead)) {
        }
        return data;
    }

    public static void writeInputStreamToFile(File f, InputStream is) throws IOException {
        ERXFileUtilities.writeInputStreamToFile(is, f);
    }

    public static File writeInputStreamToTempFile(InputStream stream) throws IOException {
        return ERXFileUtilities.writeInputStreamToTempFile(stream, "_Wonder", ".tmp");
    }

    public static File writeInputStreamToTempFile(InputStream stream, String prefix, String suffix) throws IOException {
        File tempFile;
        try {
            tempFile = File.createTempFile(prefix, suffix);
            try {
                ERXFileUtilities.writeInputStreamToFile(stream, tempFile);
            }
            catch (RuntimeException e) {
                tempFile.delete();
                throw e;
            }
            catch (IOException e) {
                tempFile.delete();
                throw e;
            }
        }
        catch (RuntimeException e) {
            stream.close();
            throw e;
        }
        catch (IOException e) {
            stream.close();
            throw e;
        }
        return tempFile;
    }

    public static void writeInputStreamToFile(InputStream stream, File file) throws IOException {
        FileOutputStream out;
        try {
            if (file == null) {
                throw new IllegalArgumentException("Attempting to write to a null file!");
            }
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            out = new FileOutputStream(file);
        }
        catch (IOException e) {
            stream.close();
            throw e;
        }
        catch (RuntimeException e) {
            stream.close();
            throw e;
        }
        ERXFileUtilities.writeInputStreamToOutputStream(stream, true, out, true);
    }

    public static void writeInputStreamToGZippedFile(InputStream stream, File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Attempting to write to a null file!");
        }
        FileOutputStream out = new FileOutputStream(file);
        ERXFileUtilities.writeInputStreamToOutputStream(stream, false, new GZIPOutputStream(out), true);
    }

    public static void writeInputStreamToOutputStream(InputStream in, OutputStream out) throws IOException {
        ERXFileUtilities.writeInputStreamToOutputStream(in, true, out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeInputStreamToOutputStream(InputStream in, boolean closeInputStream, OutputStream out, boolean closeOutputStream) throws IOException {
        try {
            block5: {
                BufferedInputStream bis = new BufferedInputStream(in);
                try {
                    byte[] buf = new byte[51200];
                    int read = -1;
                    while ((read = bis.read(buf)) != -1) {
                        out.write(buf, 0, read);
                    }
                    Object var8_7 = null;
                    if (!closeInputStream) break block5;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (!closeInputStream) throw throwable;
                    bis.close();
                    throw throwable;
                }
                bis.close();
            }
            out.flush();
            Object var10_10 = null;
            if (!closeOutputStream) return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (!closeOutputStream) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public static void stringToGZippedFile(String s, File f) throws IOException {
        if (s == null) {
            throw new NullPointerException("string argument cannot be null");
        }
        if (f == null) {
            throw new NullPointerException("file argument cannot be null");
        }
        byte[] bytes = s.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ERXFileUtilities.writeInputStreamToGZippedFile(bais, f);
    }

    public static void stringToFile(String s, File f) throws IOException {
        ERXFileUtilities.stringToFile(s, f, System.getProperty("file.encoding"));
    }

    public static void stringToFile(String s, File f, String encoding) throws IOException {
        if (s == null) {
            throw new IllegalArgumentException("string argument cannot be null");
        }
        if (f == null) {
            throw new IllegalArgumentException("file argument cannot be null");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding argument cannot be null");
        }
        BufferedReader reader = new BufferedReader(new StringReader(s));
        FileOutputStream fos = new FileOutputStream(f);
        BufferedWriter out = encoding == null ? new BufferedWriter(new OutputStreamWriter(fos)) : new BufferedWriter(new OutputStreamWriter((OutputStream)fos, encoding));
        char[] buf = new char[51200];
        int read = -1;
        while ((read = reader.read(buf)) != -1) {
            ((Writer)out).write(buf, 0, read);
        }
        ((Reader)reader).close();
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    public static void remoteCopyFile(String srcHost, String srcPath, String dstHost, String dstPath) throws IOException {
        if (srcPath == null) {
            throw new IllegalArgumentException("null source path not allowed");
        }
        if (dstPath == null) {
            throw new IllegalArgumentException("null source path not allowed");
        }
        NSMutableArray<int> args = new NSMutableArray<int>(7);
        args.addObject((int)"/usr/bin/scp");
        args.addObject((int)"-B");
        args.addObject((int)"-q");
        args.addObject((int)"-o");
        args.addObject((int)"StrictHostKeyChecking=no");
        args.addObject((int)((srcHost != null ? srcHost + ":" : "") + srcPath));
        args.addObject((int)((dstHost != null ? dstHost + ":" : "") + dstPath));
        String[] cmd = ERXArrayUtilities.toStringArray(args);
        try {
            ERXRuntimeUtilities.Result result = ERXRuntimeUtilities.execute(cmd, null, null, 0L);
            if (result.getExitValue() != 0) {
                throw new IOException("Unable to remote copy file: (exit status = " + result.getExitValue() + ") " + result.getErrorAsString() + "\n");
            }
        }
        catch (ERXRuntimeUtilities.TimeoutException e) {
            throw new IOException("Command timed out");
        }
    }

    public static void remoteCopyFile(File srcFile, String dstHost, String dstPath) throws IOException {
        ERXFileUtilities.remoteCopyFile(null, srcFile.getPath(), dstHost, dstPath);
    }

    public static void remoteCopyFile(String srcHost, String srcPath, File dstFile) throws IOException {
        ERXFileUtilities.remoteCopyFile(srcHost, srcPath, null, dstFile.getPath());
    }

    public static String stringFromGZippedFile(File f) throws IOException {
        return new String(ERXFileUtilities.bytesFromGZippedFile(f));
    }

    public static String stringFromFile(File f) throws IOException {
        return new String(ERXFileUtilities.bytesFromFile(f));
    }

    public static String stringFromFile(File f, String encoding) throws IOException {
        if (encoding == null) {
            return new String(ERXFileUtilities.bytesFromFile(f));
        }
        return new String(ERXFileUtilities.bytesFromFile(f), encoding);
    }

    public static String pathForResourceNamed(String fileName, String frameworkName, NSArray languages) {
        NSBundle bundle;
        String path = null;
        NSBundle nSBundle = bundle = "app".equals(frameworkName) ? NSBundle.mainBundle() : NSBundle.bundleForName((String)frameworkName);
        if (bundle != null && bundle.isJar()) {
            log.warn((Object)("Can't get path when run as jar: " + frameworkName + " - " + fileName));
        } else {
            URL url;
            WOApplication application = WOApplication.application();
            if (application != null) {
                URL url2 = application.resourceManager().pathURLForResourceNamed(fileName, frameworkName, languages);
                if (url2 != null) {
                    path = url2.getFile();
                }
            } else if (bundle != null && (url = bundle.pathURLForResourcePath(fileName)) != null) {
                path = url.getFile();
            }
        }
        return path;
    }

    public static boolean resourceExists(String fileName, String frameworkName, NSArray languages) {
        URL url = WOApplication.application().resourceManager().pathURLForResourceNamed(fileName, frameworkName, languages);
        return url != null;
    }

    public static InputStream inputStreamForResourceNamed(String fileName, String frameworkName, NSArray languages) {
        return WOApplication.application().resourceManager().inputStreamForResourceNamed(fileName, frameworkName, languages);
    }

    public static String datePathWithRoot(String rootPath) {
        Calendar defaultCalendar = Calendar.getInstance();
        defaultCalendar.setTime(new Date());
        int year = defaultCalendar.get(1);
        int month = defaultCalendar.get(2) + 1;
        int day = defaultCalendar.get(5);
        int hour = defaultCalendar.get(11);
        String datePath = rootPath + "/y" + year + (month > 9 ? "/m" : "/m0") + month + (day > 9 ? "/d" : "/d0") + day + (hour > 9 ? "/h" : "/h0") + hour;
        return datePath;
    }

    public static URL pathURLForResourceNamed(String fileName, String frameworkName, NSArray languages) {
        WOResourceManager resourceManager;
        URL url = null;
        WOApplication application = WOApplication.application();
        if (application != null && (resourceManager = application.resourceManager()) != null) {
            url = resourceManager.pathURLForResourceNamed(fileName, frameworkName, languages);
        }
        return url;
    }

    public static URL URLFromFile(File file) {
        URL url = null;
        if (file != null) {
            try {
                url = ERXFileUtilities.URLFromPath(file.getCanonicalPath());
            }
            catch (IOException ex) {
                throw new NSForwardException((Throwable)ex);
            }
        }
        return url;
    }

    public static URL URLFromPath(String fileName) {
        URL url = null;
        if (fileName != null) {
            try {
                url = new URL("file://" + fileName);
            }
            catch (MalformedURLException ex) {
                throw new NSForwardException((Throwable)ex);
            }
        }
        return url;
    }

    public static long lastModifiedDateForFileInFramework(String fileName, String frameworkName) {
        long lastModified = 0L;
        String filePath = ERXFileUtilities.pathForResourceNamed(fileName, frameworkName, null);
        if (filePath != null) {
            lastModified = new File(filePath).lastModified();
        }
        return lastModified;
    }

    public static Object readPropertyListFromFileInFramework(String fileName, String aFrameWorkName) {
        return ERXFileUtilities.readPropertyListFromFileInFramework(fileName, aFrameWorkName, null, System.getProperty("file.encoding"));
    }

    public static Object readPropertyListFromFileInFramework(String fileName, String aFrameWorkName, String encoding) {
        return ERXFileUtilities.readPropertyListFromFileInFramework(fileName, aFrameWorkName, null, encoding);
    }

    public static Object readPropertyListFromFileInFramework(String fileName, String aFrameWorkName, NSArray languageList) {
        Object plist = null;
        try {
            plist = ERXFileUtilities.readPropertyListFromFileInFramework(fileName, aFrameWorkName, languageList, System.getProperty("file.encoding"));
        }
        catch (IllegalArgumentException e) {
            try {
                plist = ERXFileUtilities.readPropertyListFromFileInFramework(fileName, aFrameWorkName, languageList, "UTF-16");
            }
            catch (IllegalArgumentException e1) {
                plist = ERXFileUtilities.readPropertyListFromFileInFramework(fileName, aFrameWorkName, languageList, "UTF-8");
            }
        }
        return plist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object readPropertyListFromFileInFramework(String fileName, String aFrameWorkName, NSArray languageList, String encoding) {
        Object result;
        block12: {
            InputStream stream;
            block11: {
                result = null;
                stream = ERXFileUtilities.inputStreamForResourceNamed(fileName, aFrameWorkName, languageList);
                if (stream == null) break block11;
                String stringFromFile = ERXFileUtilities.stringFromInputStream(stream, encoding);
                result = NSPropertyListSerialization.propertyListFromString((String)stringFromFile);
            }
            Object var8_8 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block12;
            }
            catch (IOException e) {
                log.error((Object)"Failed attempt to close stream.");
            }
            break block12;
            {
                catch (IOException ioe) {
                    log.error((Object)("ConfigurationManager: Error reading file <" + fileName + "> from framework " + aFrameWorkName));
                    Object var8_9 = null;
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        log.error((Object)"Failed attempt to close stream.");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Failed attempt to close stream.");
                }
                throw throwable;
            }
        }
        return result;
    }

    public static void deleteFilesInDirectory(File directory, boolean recurseIntoDirectories) {
        ERXFileUtilities.deleteFilesInDirectory(directory, null, recurseIntoDirectories, true);
    }

    public static void deleteFilesInDirectory(File directory, FileFilter filter, boolean recurseIntoDirectories, boolean removeDirectories) {
        File[] files;
        if (!directory.exists()) {
            throw new RuntimeException("Attempting to delete files from a non-existant directory: " + directory);
        }
        if (!directory.isDirectory()) {
            throw new RuntimeException("Attmepting to delete files from a file that is not a directory: " + directory);
        }
        File[] fileArray = files = filter != null ? directory.listFiles(filter) : directory.listFiles();
        if (files != null && files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                File aFile = files[i];
                if (aFile.isDirectory() && recurseIntoDirectories) {
                    ERXFileUtilities.deleteFilesInDirectory(aFile, filter, recurseIntoDirectories, removeDirectories);
                }
                if (!aFile.isFile() && (!aFile.isDirectory() || !removeDirectories || aFile.listFiles() != null && aFile.listFiles().length != 0)) continue;
                aFile.delete();
            }
        }
    }

    public static boolean deleteDirectory(File directory) {
        if (!directory.isDirectory()) {
            return directory.delete();
        }
        boolean deletedAllFiles = true;
        String[] fileNames = directory.list();
        for (int i = 0; i < fileNames.length; ++i) {
            File file = new File(directory, fileNames[i]);
            if (file.isDirectory()) {
                if (ERXFileUtilities.deleteDirectory(file) || !deletedAllFiles) continue;
                deletedAllFiles = false;
                continue;
            }
            if (file.delete() || !deletedAllFiles) continue;
            deletedAllFiles = false;
        }
        if (!directory.delete() && deletedAllFiles) {
            deletedAllFiles = false;
        }
        return deletedAllFiles;
    }

    public static void chmod(File file, String mode) throws IOException {
        Runtime.getRuntime().exec(new String[]{"chmod", mode, file.getAbsolutePath()});
    }

    public static void chmodRecursively(File dir, String mode) throws IOException {
        Runtime.getRuntime().exec(new String[]{"chmod", "-R", mode, dir.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void linkFiles(File source, File destination, boolean symbolic, boolean allowUnlink, boolean followSymbolicLinks) throws IOException {
        if (destination == null || source == null) {
            throw new IllegalArgumentException("null source or destination not allowed");
        }
        ArrayList<String> array = new ArrayList<String>();
        array.add("ln");
        if (allowUnlink) {
            array.add("-f");
        }
        if (symbolic) {
            array.add("-s");
        }
        if (!followSymbolicLinks) {
            array.add("-n");
        }
        array.add(source.getPath());
        array.add(destination.getPath());
        String[] cmd = new String[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            cmd[i] = (String)array.get(i);
        }
        Process task = null;
        try {
            task = Runtime.getRuntime().exec(cmd);
            while (true) {
                try {
                    task.waitFor();
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            if (task.exitValue() != 0) {
                BufferedReader err = new BufferedReader(new InputStreamReader(task.getErrorStream()));
                throw new IOException("Unable to create link: " + err.readLine());
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            ERXExtensions.freeProcessResources(task);
            throw throwable;
        }
        ERXExtensions.freeProcessResources(task);
    }

    public static void copyFilesFromDirectory(File srcDirectory, File dstDirectory, boolean deleteOriginals, boolean recursiveCopy, FileFilter filter) throws FileNotFoundException, IOException {
        ERXFileUtilities.copyFilesFromDirectory(srcDirectory, dstDirectory, deleteOriginals, true, recursiveCopy, filter);
    }

    public static void copyFilesFromDirectory(File srcDirectory, File dstDirectory, boolean deleteOriginals, boolean replaceExistingFiles, boolean recursiveCopy, FileFilter filter) throws FileNotFoundException, IOException {
        File[] srcFiles;
        if (!srcDirectory.exists() || !dstDirectory.exists()) {
            throw new RuntimeException("Both the src and dst directories must exist! Src: " + srcDirectory + " Dst: " + dstDirectory);
        }
        File[] fileArray = srcFiles = filter != null ? srcDirectory.listFiles(filter) : srcDirectory.listFiles();
        if (srcFiles != null && srcFiles.length > 0) {
            for (int i = 0; i < srcFiles.length; ++i) {
                File srcFile = srcFiles[i];
                File dstFile = new File(dstDirectory, srcFile.getName());
                if (srcFile.isDirectory() && recursiveCopy) {
                    if (deleteOriginals) {
                        ERXFileUtilities.renameTo(srcFile, dstFile);
                        continue;
                    }
                    dstFile.mkdirs();
                    ERXFileUtilities.copyFilesFromDirectory(srcFile, dstFile, deleteOriginals, replaceExistingFiles, recursiveCopy, filter);
                    continue;
                }
                if (!srcFile.isDirectory()) {
                    if (replaceExistingFiles || !dstFile.exists()) {
                        ERXFileUtilities.copyFileToFile(srcFile, dstFile, deleteOriginals, true);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Destination file: " + dstFile + " skipped as it exists and replaceExistingFiles is set to false."));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Source file: " + srcFile + " is a directory inside: " + dstDirectory + " and recursive copy is set to false."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyFileToFile(File srcFile, File dstFile, boolean deleteOriginals, boolean forceDelete) throws FileNotFoundException, IOException {
        if (srcFile.exists() && srcFile.isFile()) {
            boolean copied = false;
            if (deleteOriginals && (!forceDelete || srcFile.canWrite())) {
                copied = srcFile.renameTo(dstFile);
            }
            if (!copied) {
                Throwable thrownException;
                block36: {
                    FileInputStream in;
                    block35: {
                        thrownException = null;
                        File parent = dstFile.getParentFile();
                        if (!parent.exists() && !parent.mkdirs()) {
                            throw new IOException("Failed to create the directory " + parent + ".");
                        }
                        in = new FileInputStream(srcFile);
                        FileChannel srcChannel = in.getChannel();
                        try {
                            block34: {
                                FileOutputStream out = new FileOutputStream(dstFile);
                                try {
                                    block33: {
                                        FileChannel dstChannel = out.getChannel();
                                        try {
                                            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
                                            Object var13_14 = null;
                                        }
                                        catch (Throwable throwable) {
                                            Object var13_16 = null;
                                            dstChannel.close();
                                            throw throwable;
                                        }
                                        dstChannel.close();
                                        {
                                            break block33;
                                            catch (Throwable t) {
                                                thrownException = t;
                                                Object var13_15 = null;
                                                dstChannel.close();
                                            }
                                        }
                                    }
                                    Object var15_19 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var15_21 = null;
                                    out.close();
                                    throw throwable;
                                }
                                out.close();
                                {
                                    break block34;
                                    catch (Throwable t) {
                                        if (thrownException == null) {
                                            thrownException = t;
                                        }
                                        Object var15_20 = null;
                                        out.close();
                                    }
                                }
                            }
                            Object var17_23 = null;
                        }
                        catch (Throwable throwable) {
                            Object var17_25 = null;
                            srcChannel.close();
                            throw throwable;
                        }
                        srcChannel.close();
                        {
                            break block35;
                            catch (Throwable t) {
                                if (thrownException == null) {
                                    thrownException = t;
                                }
                                Object var17_24 = null;
                                srcChannel.close();
                            }
                        }
                    }
                    Object var19_27 = null;
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        if (thrownException == null) {
                            thrownException = e;
                        }
                        break block36;
                    }
                    {
                        catch (Throwable t) {
                            if (thrownException == null) {
                                thrownException = t;
                            }
                            Object var19_28 = null;
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                if (thrownException == null) {
                                    thrownException = e;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        block37: {
                            Object var19_29 = null;
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                if (thrownException != null) break block37;
                                thrownException = e;
                            }
                        }
                        throw throwable;
                    }
                }
                if (deleteOriginals && (srcFile.canWrite() || forceDelete) && !srcFile.delete()) {
                    throw new IOException("Failed to delete " + srcFile + ".");
                }
                if (thrownException != null) {
                    if (thrownException instanceof IOException) {
                        throw (IOException)thrownException;
                    }
                    if (thrownException instanceof Error) {
                        throw (Error)thrownException;
                    }
                    throw (RuntimeException)thrownException;
                }
            }
        }
    }

    public static final File createTempDir() throws IOException {
        File f = File.createTempFile("WonderTempDir", "");
        f.delete();
        f.delete();
        f.mkdirs();
        return f;
    }

    public static final File createTempDir(String prefix, String suffix) throws IOException {
        File f = File.createTempFile(prefix, suffix);
        f.delete();
        f.delete();
        f.mkdirs();
        return f;
    }

    public static NSArray<File> arrayByAddingFilesInDirectory(File directory, boolean recursive) {
        ERXFile erxDirectory = new ERXFile(directory.getAbsolutePath());
        NSMutableArray<File> files = new NSMutableArray<File>();
        if (!erxDirectory.exists()) {
            return files;
        }
        File[] fileList = erxDirectory.listFiles();
        if (fileList == null) {
            return files;
        }
        for (int i = 0; i < fileList.length; ++i) {
            File f = fileList[i];
            if (f.isDirectory() && recursive) {
                files.addObjectsFromArray(ERXFileUtilities.arrayByAddingFilesInDirectory(f, true));
                continue;
            }
            files.addObject(f);
        }
        return files;
    }

    public static String replaceFileExtension(String path, String newExtension) {
        String tmp = "." + newExtension;
        if (path.endsWith(tmp)) {
            return path;
        }
        int index = path.lastIndexOf(".");
        if (index > 0) {
            String p = path.substring(0, index);
            return p + tmp;
        }
        return path + tmp;
    }

    public static File unzipFile(File f, File destination) throws IOException {
        ZipFile zipFile;
        Enumeration<? extends ZipEntry> en;
        String absolutePath;
        if (!f.exists()) {
            throw new FileNotFoundException("file " + f + " does not exist");
        }
        if (destination != null) {
            absolutePath = destination.getAbsolutePath();
            if (!destination.exists()) {
                destination.mkdirs();
            } else if (!destination.isDirectory()) {
                absolutePath = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
            }
        } else {
            absolutePath = System.getProperty("java.io.tmpdir");
        }
        if (!absolutePath.endsWith(File.separator)) {
            absolutePath = absolutePath + File.separator;
        }
        if ((en = (zipFile = new ZipFile(f)).entries()).hasMoreElements()) {
            ZipEntry firstEntry = en.nextElement();
            if (firstEntry.isDirectory() || en.hasMoreElements()) {
                String dir = absolutePath + f.getName();
                if (dir.endsWith(".zip")) {
                    dir = dir.substring(0, dir.length() - 4);
                }
                new File(dir).mkdirs();
                absolutePath = dir + File.separator;
            }
        } else {
            return null;
        }
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            String name = ze.getName();
            if (ze.isDirectory()) {
                File d = new File(absolutePath + name);
                d.mkdirs();
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("created directory " + d.getAbsolutePath()));
                continue;
            }
            InputStream is = zipFile.getInputStream(ze);
            ERXFileUtilities.writeInputStreamToFile(new File(absolutePath + name), is);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("unzipped file " + ze.getName() + " into " + absolutePath + name));
        }
        return new File(absolutePath);
    }

    public static File zipFile(File f, boolean absolutePaths, boolean deleteOriginal, boolean forceDelete) throws IOException {
        return ERXFileUtilities.zipFile(f, absolutePaths, deleteOriginal, forceDelete, 9);
    }

    public static File zipFile(File f, boolean absolutePaths, boolean deleteOriginal, boolean forceDelete, int level) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException("file " + f + " does not exist");
        }
        File destination = new File(f.getAbsolutePath() + ".zip");
        if (destination.exists()) {
            throw new IOException("zipped file " + destination + " exists");
        }
        ZipOutputStream zout = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
        zout.setLevel(level);
        NSArray<File> files = f.isDirectory() ? ERXFileUtilities.arrayByAddingFilesInDirectory(f, true) : new NSArray<File>(f);
        try {
            BufferedInputStream origin = null;
            byte[] data = new byte[2048];
            for (int i = 0; i < files.count(); ++i) {
                int count;
                File currentFile = files.objectAtIndex(i);
                FileInputStream fi = new FileInputStream(currentFile);
                origin = new BufferedInputStream(fi, 2048);
                String entryName = currentFile.getAbsolutePath();
                if (!absolutePaths) {
                    entryName = f.isDirectory() ? entryName.substring(f.getAbsolutePath().length() + 1, entryName.length()) : entryName.substring(f.getParentFile().getAbsolutePath().length() + 1, entryName.length());
                }
                ZipEntry entry = new ZipEntry(entryName);
                zout.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    zout.write(data, 0, count);
                }
                origin.close();
            }
            zout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (deleteOriginal && (f.canWrite() || forceDelete) && !ERXFileUtilities.deleteDirectory(f)) {
            ERXFileUtilities.deleteDirectory(f);
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] md5(File file) throws IOException {
        byte[] byArray;
        FileInputStream fis = new FileInputStream(file);
        try {
            byArray = ERXFileUtilities.md5(fis);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
        return byArray;
    }

    public static byte[] md5(InputStream in) throws IOException {
        try {
            int numRead;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buf = new byte[51200];
            while ((numRead = in.read(buf)) != -1) {
                md5.update(buf, 0, numRead);
            }
            return md5.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NSForwardException((Throwable)e);
        }
    }

    public static String md5Hex(File file) throws IOException {
        return ERXStringUtilities.byteArrayToHexString(ERXFileUtilities.md5(file));
    }

    public static String md5Hex(InputStream in) throws IOException {
        return ERXStringUtilities.byteArrayToHexString(ERXFileUtilities.md5(in));
    }

    public static long length(File f) {
        if (!f.isDirectory()) {
            return f.length();
        }
        long length = 0L;
        File[] files = f.listFiles();
        int i = files.length;
        while (i-- > 0) {
            length += ERXFileUtilities.length(files[i]);
        }
        return length;
    }

    public static String shortenFilename(String name, int maxLength) {
        String ext = ERXFileUtilities.fileExtension(name);
        String s = ERXFileUtilities.removeFileExtension(name);
        String elips = "...";
        int elipsLength = elips.length();
        int stringLength = s.length();
        if (stringLength == maxLength) {
            return name;
        }
        if (maxLength <= elipsLength) {
            maxLength = elipsLength + 1;
        }
        int noOfChars = maxLength - elipsLength;
        int mod = noOfChars % 2;
        int firstHalf = noOfChars / 2 + mod;
        int secondHalf = firstHalf - mod;
        StringBuffer sb = new StringBuffer();
        sb.append(s.substring(0, firstHalf));
        sb.append(elips);
        sb.append(s.substring(stringLength - secondHalf, stringLength));
        sb.append(".");
        sb.append(ext);
        return sb.toString();
    }

    public static String removeFileExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return name;
        }
        return name.substring(0, index);
    }

    public static String fileExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return name.substring(index + 1);
    }

    public static boolean deleteFiles(NSMutableArray filesToDelete) {
        boolean deletedAllFiles = true;
        int i = filesToDelete.count();
        while (i-- > 0) {
            File currentFile = (File)filesToDelete.objectAtIndex(i);
            if (ERXFileUtilities.deleteFile(currentFile) || !deletedAllFiles) continue;
            deletedAllFiles = false;
        }
        return deletedAllFiles;
    }

    public static boolean deleteFile(File fileToDelete) {
        return ERXFileUtilities.deleteDirectory(fileToDelete);
    }

    public static File[] listDirectories(File baseDir, boolean recursive) {
        File[] files = baseDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (recursive) {
            NSMutableArray<File> a = new NSMutableArray<File>(files);
            int i = files.length;
            while (i-- > 0) {
                File currentDir = files[i];
                File[] currentDirs = ERXFileUtilities.listDirectories(currentDir, true);
                a.addObjects((File[])currentDirs);
            }
            Object[] objects = a.objects();
            files = new File[objects.length];
            System.arraycopy(objects, 0, files, 0, objects.length);
        }
        return files;
    }

    public static File[] listFiles(File baseDir, boolean recursive, FileFilter filter) {
        File[] files = baseDir.listFiles(filter);
        if (files != null && recursive) {
            NSMutableArray<File> a = new NSMutableArray<File>();
            int i = files.length;
            while (i-- > 0) {
                File currentFile = files[i];
                a.addObject(currentFile);
                if (!currentFile.isDirectory()) continue;
                File[] currentFiles = ERXFileUtilities.listFiles(currentFile, true, filter);
                a.addObjects(currentFiles);
            }
            Object[] objects = a.objects();
            files = new File[objects.length];
            System.arraycopy(objects, 0, files, 0, objects.length);
        }
        return files;
    }

    public static void renameTo(File source, File destination) throws FileNotFoundException, IOException {
        if (!source.renameTo(destination)) {
            ERXFileUtilities.copyFileToFile(source, destination, true, true);
        }
    }

    public static String fileNameFromBrowserSubmittedPath(String path) {
        String fileName = path;
        if (path != null) {
            int separatorIndex = path.lastIndexOf("\\");
            if (separatorIndex == -1) {
                separatorIndex = path.lastIndexOf("/");
            }
            if (separatorIndex == -1) {
                separatorIndex = path.lastIndexOf(":");
            }
            if (separatorIndex != -1) {
                fileName = path.substring(separatorIndex + 1);
            }
            fileName = fileName.replaceAll("\\.\\.", "_");
        }
        return fileName;
    }

    public static File reserveUniqueFile(File desiredFile, boolean overwrite) throws IOException {
        File destinationFile = desiredFile;
        File destinationFolder = destinationFile.getParentFile();
        if (!(destinationFolder.exists() || destinationFolder.mkdirs() || destinationFolder.exists())) {
            throw new IOException("Unable to create the destination folder '" + destinationFolder + "'.");
        }
        if (!overwrite && !desiredFile.createNewFile()) {
            String suffix;
            String prefix;
            File parentFolder = desiredFile.getParentFile();
            String fileName = desiredFile.getName();
            int dotIndex = fileName.lastIndexOf(46);
            if (dotIndex < 0) {
                prefix = fileName;
                suffix = "";
            } else {
                prefix = fileName.substring(0, dotIndex);
                suffix = fileName.substring(dotIndex);
            }
            int counter = 1;
            do {
                destinationFile = new File(parentFolder, prefix + "-" + counter + suffix);
                ++counter;
            } while (!destinationFile.createNewFile());
        }
        return destinationFile;
    }
}

