/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.ERXExtensions;
import er.extensions.eof.ERXConstant;
import er.extensions.foundation.ERXKeyValuePair;
import er.extensions.foundation.ERXStringUtilities;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXKeyValueCodingUtilities {
    private static Hashtable _classes = new Hashtable();
    public static final NSKeyValueCodingAdditions Statics = new NSKeyValueCodingAdditions(){

        public Object valueForKeyPath(String arg0) {
            String name = ERXStringUtilities.firstPropertyKeyInKeyPath(arg0);
            String rest = ERXStringUtilities.keyPathWithoutFirstProperty(arg0);
            Class clazz = (Class)_classes.get(name);
            if (clazz == null) {
                throw new IllegalArgumentException("Class not found: " + arg0);
            }
            String field = ERXStringUtilities.keyPathWithoutFirstProperty(arg0);
            Object result = ERXKeyValueCodingUtilities.classValueForKey(clazz, field);
            if (field.length() > rest.length()) {
                rest = ERXStringUtilities.keyPathWithoutFirstProperty(arg0);
                result = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)result, (String)rest);
            }
            return result;
        }

        public void takeValueForKeyPath(Object arg0, String arg1) {
            throw new UnsupportedOperationException("Can't set values on class yet");
        }

        public Object valueForKey(String arg0) {
            return this.valueForKeyPath(arg0);
        }

        public void takeValueForKey(Object arg0, String arg1) {
            this.takeValueForKeyPath(arg0, arg1);
        }
    };

    public static void registerClass(Class clazz) {
        _classes.put(ERXStringUtilities.lastPropertyKeyInKeyPath(clazz.getName()), clazz);
    }

    public static Object classValueForKey(Class clazz, String key) {
        NSMutableArray<int> result = null;
        if (key != null) {
            try {
                String getKey = "get" + ERXStringUtilities.capitalize(key);
                Method[] methods = clazz.getDeclaredMethods();
                boolean found = false;
                for (int i = 0; i < methods.length && !found; ++i) {
                    Method current = methods[i];
                    if (current.getParameterTypes().length != 0 || !current.getName().equals(key) && !current.getName().equals(getKey)) continue;
                    result = current.invoke((Object)clazz, ERXConstant.EmptyObjectArray);
                    found = true;
                }
                if (!found) {
                    Field[] fields = clazz.getDeclaredFields();
                    for (int i = 0; i < fields.length && !found; ++i) {
                        Field current = fields[i];
                        if (!current.getName().equals(key)) continue;
                        boolean isAccessible = current.isAccessible();
                        result = current.get(clazz);
                        found = true;
                    }
                }
                if (!found) {
                    throw new NSKeyValueCoding.UnknownKeyException("Key + " + key + " not found in class " + clazz.getName(), (Object)clazz, key);
                }
            }
            catch (Exception e) {
                throw new NSForwardException((Throwable)e);
            }
            if (result != null) {
                if (result.getClass().getComponentType() != null) {
                    result = new NSArray<Object>((Object[])result);
                } else if (result instanceof Collection) {
                    NSMutableArray<int> array = new NSMutableArray<int>(((Collection)result).size());
                    Iterator iter = ((Collection)result).iterator();
                    while (iter.hasNext()) {
                        array.addObject((int)iter.next());
                    }
                    result = array;
                }
            }
        }
        return result;
    }

    public static NSArray<ERXKeyValuePair> staticStringsForClass(Class c) {
        NSMutableArray<ERXKeyValuePair> result = new NSMutableArray<ERXKeyValuePair>();
        if (c.getSuperclass() != null) {
            result.addObjectsFromArray(ERXKeyValueCodingUtilities.staticStringsForClass(c.getSuperclass()));
        }
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            try {
                if (!Modifier.isFinal(field.getModifiers()) || !field.getType().equals(String.class)) continue;
                String key = field.getName();
                String value = (String)field.get(c);
                result.addObject(new ERXKeyValuePair<String, String>(key, value));
                continue;
            }
            catch (IllegalArgumentException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }
        return result;
    }

    public static Object privateValueForKey(Object target, String key) {
        Field field = ERXKeyValueCodingUtilities.accessibleFieldForKey(target, key);
        try {
            if (field != null) {
                return field.get(target);
            }
            Method method = ERXKeyValueCodingUtilities.accessibleMethodForKey(target, key);
            if (method != null) {
                return method.invoke(target, null);
            }
            throw new NSKeyValueCoding.UnknownKeyException("Key " + key + " not found", target, key);
        }
        catch (IllegalArgumentException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static void takePrivateValueForKey(Object target, Object value, String key) {
        Field field = ERXKeyValueCodingUtilities.accessibleFieldForKey(target, key);
        try {
            if (field == null) {
                throw new NSKeyValueCoding.UnknownKeyException("Key " + key + " not found", target, key);
            }
            field.set(target, value);
        }
        catch (IllegalArgumentException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    private static Field accessibleFieldForKey(Object target, String key) {
        Field f = ERXKeyValueCodingUtilities.fieldForKey(target, key);
        if (f != null) {
            f.setAccessible(true);
        }
        return f;
    }

    private static Method accessibleMethodForKey(Object target, String key) {
        Method f = ERXKeyValueCodingUtilities.methodForKey(target, key);
        if (f != null) {
            f.setAccessible(true);
        }
        return f;
    }

    public static Field fieldForKey(Object target, String key) {
        Field result = null;
        Class<?> c = target.getClass();
        while (result == null && c != null) {
            try {
                result = c.getDeclaredField(key);
                if (result == null) continue;
                return result;
            }
            catch (SecurityException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (NoSuchFieldException e) {
                c = c.getSuperclass();
            }
        }
        return null;
    }

    public static Method methodForKey(Object target, String key) {
        Method result = null;
        Class<?> c = target.getClass();
        while (result == null && c != null) {
            try {
                result = c.getDeclaredMethod(key, new Class[0]);
                if (result == null) continue;
                return result;
            }
            catch (SecurityException e) {
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                c = c.getSuperclass();
            }
        }
        return null;
    }

    public static void takeChangedValuesFromDictionary(Object object, NSDictionary<String, ?> dictionary) {
        if (dictionary == null) {
            return;
        }
        NSKeyValueCoding keyValueCodingObject = object instanceof NSKeyValueCoding ? (NSKeyValueCoding)object : null;
        NSArray<String> keys = dictionary.allKeys();
        int count = keys.count();
        for (int i = 0; i < count; ++i) {
            String key = keys.objectAtIndex(i);
            Object value = dictionary.objectForKey(key);
            if (value == NSKeyValueCoding.NullValue) {
                value = null;
            }
            if (keyValueCodingObject != null) {
                if (!ERXExtensions.safeDifferent(value, keyValueCodingObject.valueForKey(key))) continue;
                keyValueCodingObject.takeValueForKey(value, key);
                continue;
            }
            if (!ERXExtensions.safeDifferent(value, NSKeyValueCoding.DefaultImplementation.valueForKey((Object)object, (String)key))) continue;
            NSKeyValueCoding.DefaultImplementation.takeValueForKey((Object)object, value, (String)key);
        }
    }
}

