/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSKeyValueCodingAdditions;
import er.extensions.ERXExtensions;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.appserver.ERXWOContext;
import er.extensions.foundation.ERXThreadStorage;
import java.util.UUID;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXLazyValue<T> {
    public static Logger log = Logger.getLogger(ERXLazyValue.class);
    private Source<T> _dataSource;
    private Invalidator _invalidator;
    private boolean _valueCached;
    private T _value;

    public ERXLazyValue(Source<T> dataSource) {
        this(dataSource, new NeverInvalidator());
    }

    public ERXLazyValue(Object target, String keyPath) {
        this(new KVCSource(target, keyPath), new NeverInvalidator());
    }

    public ERXLazyValue(Object target, String keyPath, Invalidator invalidator) {
        this(new KVCSource(target, keyPath), invalidator);
    }

    public ERXLazyValue(Source<T> dataSource, Invalidator invalidator) {
        this._dataSource = dataSource;
        this._invalidator = invalidator;
    }

    public synchronized void invalidate() {
        this._valueCached = false;
        this._value = null;
    }

    public synchronized T value() {
        if (!this._valueCached || this._invalidator.shouldInvalidate()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Fetching from " + this._dataSource + " with invalidator " + this._invalidator + " ..."));
            }
            this._value = this._dataSource.value();
            this._invalidator.fetchedValue(this._value);
            this._valueCached = true;
        }
        return this._value;
    }

    public synchronized void setValue(T value) {
        this._value = value;
        this._valueCached = true;
        this._dataSource.setValue(value);
        this._invalidator.fetchedValue(value);
    }

    public static class AjaxPageUserInfoCacheKeyInvalidator
    extends MutableCacheKeyInvalidator {
        private String _key;

        public AjaxPageUserInfoCacheKeyInvalidator(String key) {
            this._key = key;
        }

        protected Object cacheKey() {
            return ERXResponseRewriter.ajaxPageUserInfo(ERXWOContext.currentContext()).objectForKey(this._key);
        }

        public void setCacheKey(Object value) {
            ERXResponseRewriter.ajaxPageUserInfo(ERXWOContext.currentContext()).setObjectForKey(value, this._key);
        }
    }

    public static class PageUserInfoCacheKeyInvalidator
    extends MutableCacheKeyInvalidator {
        private String _key;

        public PageUserInfoCacheKeyInvalidator(String key) {
            this._key = key;
        }

        protected Object cacheKey() {
            return ERXResponseRewriter.pageUserInfo(ERXWOContext.currentContext()).objectForKey(this._key);
        }

        public void setCacheKey(Object value) {
            ERXResponseRewriter.pageUserInfo(ERXWOContext.currentContext()).setObjectForKey(value, this._key);
        }
    }

    public static class ThreadStorageCacheKeyInvalidator
    extends MutableCacheKeyInvalidator {
        private String _key;

        public ThreadStorageCacheKeyInvalidator(String key) {
            this._key = key;
        }

        protected Object cacheKey() {
            return ERXThreadStorage.valueForKey(this._key);
        }

        public void setCacheKey(Object value) {
            ERXThreadStorage.takeValueForKey(value, this._key);
        }
    }

    public static abstract class MutableCacheKeyInvalidator
    extends CacheKeyInvalidator {
        protected abstract void setCacheKey(Object var1);

        public void uuid() {
            this.setCacheKey(UUID.randomUUID());
        }

        public void timestamp() {
            this.setCacheKey(System.currentTimeMillis());
        }
    }

    public static abstract class CacheKeyInvalidator
    implements Invalidator {
        private Object _lastCacheKey;

        public void fetchedValue(Object value) {
            this._lastCacheKey = this.cacheKey();
        }

        protected abstract Object cacheKey();

        public boolean shouldInvalidate() {
            Object currentCacheKey = this.cacheKey();
            return !ERXExtensions.safeEquals(this._lastCacheKey, currentCacheKey);
        }
    }

    public static class NeverInvalidator
    implements Invalidator {
        public void fetchedValue(Object value) {
        }

        public boolean shouldInvalidate() {
            return false;
        }
    }

    public static class AlwaysInvalidator
    implements Invalidator {
        public void fetchedValue(Object value) {
        }

        public boolean shouldInvalidate() {
            return true;
        }
    }

    public static class TimedInvalidator
    implements Invalidator {
        private long _timeToLiveInMillis;
        private long _cacheTime;

        public TimedInvalidator(long timeToLiveInMillis) {
            this._timeToLiveInMillis = timeToLiveInMillis;
            this._cacheTime = -1L;
        }

        public void fetchedValue(Object value) {
            this._cacheTime = System.currentTimeMillis();
        }

        public boolean shouldInvalidate() {
            return this._cacheTime == -1L || System.currentTimeMillis() - this._cacheTime > this._timeToLiveInMillis;
        }
    }

    public static interface Invalidator {
        public void fetchedValue(Object var1);

        public boolean shouldInvalidate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KVCSource<T>
    implements Source<T> {
        private Object _target;
        private String _keyPath;

        public KVCSource(Object target, String keyPath) {
            this._target = target;
            this._keyPath = keyPath;
        }

        @Override
        public T value() {
            return (T)NSKeyValueCodingAdditions.DefaultImplementation.valueForKeyPath((Object)this._target, (String)this._keyPath);
        }

        @Override
        public void setValue(T value) {
            NSKeyValueCodingAdditions.DefaultImplementation.takeValueForKeyPath((Object)this._target, value, (String)this._keyPath);
        }

        public String toString() {
            return "[KVCSource: target=" + this._target.getClass().getSimpleName() + "; keyPath=" + this._keyPath + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConstantSource<T>
    implements Source<T> {
        private T _value;

        public ConstantSource(T value) {
            this._value = value;
        }

        @Override
        public T value() {
            return this._value;
        }

        @Override
        public void setValue(T value) {
            this._value = value;
        }

        public String toString() {
            return "[ConstantSource: value=" + this._value + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Source<T> {
        public T value();

        public void setValue(T var1);
    }
}

