/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import er.extensions.appserver.ERXApplication;
import er.extensions.crypting.ERXCrypto;
import er.extensions.foundation.ERXConfigurationManager;
import er.extensions.foundation.ERXFileUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXSystem;
import er.extensions.foundation.ERXValueUtilities;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXProperties
extends Properties
implements NSKeyValueCoding {
    public static final String DefaultString = "Default";
    private static Boolean RetainDefaultsEnabled;
    private static String UndefinedMarker;
    public static final Logger log;
    private static final Map AppSpecificPropertyNames;
    private static String _webObjectsVersion;
    private static double _webObjectsVersionDouble;
    private static Map _cache;
    protected String applicationNameForAppending;
    private static final NSMutableDictionary<String, Operator> operators;

    private static boolean retainDefaultsEnabled() {
        if (RetainDefaultsEnabled == null) {
            String propertyValue = ERXSystem.getProperty("er.extensions.ERXProperties.RetainDefaultsEnabled", "false");
            boolean isEnabled = "true".equals(propertyValue);
            RetainDefaultsEnabled = isEnabled;
        }
        return RetainDefaultsEnabled;
    }

    public static void populateSystemProperties() {
        System.setProperty("com.webobjects.version", ERXProperties.webObjectsVersion());
    }

    public static String versionStringForApplication() {
        NSBundle bundle = NSBundle.mainBundle();
        String versionString = (String)bundle.infoDictionary().objectForKey("CFBundleShortVersionString");
        return versionString == null ? "" : versionString.trim();
    }

    public static String versionStringForFrameworkNamed(String frameworkName) {
        NSBundle bundle = NSBundle.bundleForName((String)frameworkName);
        if (bundle == null) {
            return "";
        }
        String versionString = (String)bundle.infoDictionary().objectForKey("CFBundleShortVersionString");
        return versionString == null ? "" : versionString.trim();
    }

    public static String sourceVersionString() {
        NSBundle bundle = NSBundle.bundleForName((String)"JavaWebObjects");
        if (bundle == null) {
            return "";
        }
        String dictString = new String(bundle.bytesForResourcePath("version.plist"));
        NSDictionary versionDictionary = NSPropertyListSerialization.dictionaryForString((String)dictString);
        String versionString = (String)versionDictionary.objectForKey("SourceVersion");
        return versionString == null ? "" : versionString.trim();
    }

    public static String webObjectsVersion() {
        if (_webObjectsVersion == null && (_webObjectsVersion = ERXProperties.versionStringForFrameworkNamed("JavaWebObjects")).equals("")) {
            _webObjectsVersion = "5.1";
        }
        return _webObjectsVersion;
    }

    public static double webObjectsVersionAsDouble() {
        if (_webObjectsVersionDouble == 0.0) {
            String woVersionString = ERXStringUtilities.removeExtraDotsFromVersionString(ERXProperties.webObjectsVersion());
            try {
                _webObjectsVersionDouble = Double.parseDouble(woVersionString);
            }
            catch (NumberFormatException ex) {
                log.error((Object)("An exception occurred while parsing webObjectVersion " + woVersionString + " as a double value: " + ex.getClass().getName() + " " + ex.getMessage()));
            }
        }
        return _webObjectsVersionDouble;
    }

    public static boolean webObjectsVersionIs52OrHigher() {
        if (ERXProperties.booleanForKey("er.extensions.ERXProperties.checkOldVersions")) {
            return ERXProperties.webObjectsVersionAsDouble() >= 5.2;
        }
        return true;
    }

    public static boolean webObjectsVersionIs522OrHigher() {
        if (ERXProperties.booleanForKey("er.extensions.ERXProperties.checkOldVersions")) {
            String sourceVersion;
            String webObjectsVersion = ERXProperties.webObjectsVersion();
            if ("5.2".equals(webObjectsVersion) && "9260000".equals(sourceVersion = ERXProperties.sourceVersionString())) {
                return true;
            }
            return ERXProperties.webObjectsVersionAsDouble() >= 5.22;
        }
        return true;
    }

    public static NSArray arrayForKey(String s) {
        return ERXProperties.arrayForKeyWithDefault(s, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getApplicationSpecificPropertyName(String propertyName) {
        Map map = AppSpecificPropertyNames;
        synchronized (map) {
            String appSpecificPropertyName;
            if (AppSpecificPropertyNames.size() > 128) {
                AppSpecificPropertyNames.clear();
            }
            if ((appSpecificPropertyName = (String)AppSpecificPropertyNames.get(propertyName)) == null) {
                WOApplication application = WOApplication.application();
                if (application != null) {
                    String appName = application.name();
                    appSpecificPropertyName = propertyName + "." + appName;
                } else {
                    appSpecificPropertyName = propertyName;
                }
                String propertyValue = ERXSystem.getProperty(appSpecificPropertyName);
                if (propertyValue == null) {
                    appSpecificPropertyName = propertyName;
                }
                AppSpecificPropertyNames.put(propertyName, appSpecificPropertyName);
            }
            return appSpecificPropertyName;
        }
    }

    public static NSArray arrayForKeyWithDefault(String s, NSArray defaultValue) {
        NSArray value;
        String propertyName = ERXProperties.getApplicationSpecificPropertyName(s);
        Object cachedValue = _cache.get(propertyName);
        if (cachedValue == UndefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof NSArray) {
            value = (NSArray)cachedValue;
        } else {
            value = ERXValueUtilities.arrayValueWithDefault(ERXSystem.getProperty(propertyName), null);
            _cache.put(s, value == null ? UndefinedMarker : value);
            if (value == null) {
                value = defaultValue;
            }
            if (ERXProperties.retainDefaultsEnabled() && value == null && defaultValue != null) {
                ERXProperties.setArrayForKey(defaultValue, propertyName);
            }
        }
        return value;
    }

    public static boolean booleanForKey(String s) {
        return ERXProperties.booleanForKeyWithDefault(s, false);
    }

    public static boolean booleanForKeyWithDefault(String s, boolean defaultValue) {
        boolean value;
        String propertyName = ERXProperties.getApplicationSpecificPropertyName(s);
        Object cachedValue = _cache.get(propertyName);
        if (cachedValue == UndefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Boolean) {
            value = (Boolean)cachedValue;
        } else {
            Boolean objValue = ERXValueUtilities.BooleanValueWithDefault(ERXSystem.getProperty(propertyName), null);
            _cache.put(propertyName, objValue == null ? UndefinedMarker : objValue);
            value = objValue == null ? defaultValue : objValue;
            if (ERXProperties.retainDefaultsEnabled() && objValue == null) {
                System.setProperty(propertyName, Boolean.toString(defaultValue));
            }
        }
        return value;
    }

    public static NSDictionary dictionaryForKey(String s) {
        return ERXProperties.dictionaryForKeyWithDefault(s, null);
    }

    public static NSDictionary dictionaryForKeyWithDefault(String s, NSDictionary defaultValue) {
        NSDictionary value;
        String propertyName = ERXProperties.getApplicationSpecificPropertyName(s);
        Object cachedValue = _cache.get(propertyName);
        if (cachedValue == UndefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof NSDictionary) {
            value = (NSDictionary)cachedValue;
        } else {
            value = ERXValueUtilities.dictionaryValueWithDefault(ERXSystem.getProperty(propertyName), null);
            _cache.put(s, value == null ? UndefinedMarker : value);
            if (value == null) {
                value = defaultValue;
            }
            if (ERXProperties.retainDefaultsEnabled() && value == null && defaultValue != null) {
                ERXProperties.setDictionaryForKey(defaultValue, propertyName);
            }
        }
        return value;
    }

    public static int intForKey(String s) {
        return ERXProperties.intForKeyWithDefault(s, 0);
    }

    public static long longForKey(String s) {
        return ERXProperties.longForKeyWithDefault(s, 0L);
    }

    public static float floatForKey(String s) {
        return ERXProperties.floatForKeyWithDefault(s, 0.0f);
    }

    public static double doubleForKey(String s) {
        return ERXProperties.doubleForKeyWithDefault(s, 0.0);
    }

    public static BigDecimal bigDecimalForKey(String s) {
        return ERXProperties.bigDecimalForKeyWithDefault(s, null);
    }

    public static BigDecimal bigDecimalForKeyWithDefault(String s, BigDecimal defaultValue) {
        String propertyName = ERXProperties.getApplicationSpecificPropertyName(s);
        Object value = _cache.get(propertyName);
        if (value == UndefinedMarker) {
            return defaultValue;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        String propertyValue = ERXSystem.getProperty(propertyName);
        BigDecimal bigDecimal = ERXValueUtilities.bigDecimalValueWithDefault(propertyValue, defaultValue);
        if (ERXProperties.retainDefaultsEnabled() && propertyValue == null && bigDecimal != null) {
            propertyValue = bigDecimal.toString();
            System.setProperty(propertyName, propertyValue);
        }
        _cache.put(propertyName, propertyValue == null ? UndefinedMarker : bigDecimal);
        return bigDecimal;
    }

    public static int intForKeyWithDefault(String s, int defaultValue) {
        int value;
        String propertyName = ERXProperties.getApplicationSpecificPropertyName(s);
        Object cachedValue = _cache.get(propertyName);
        if (cachedValue == UndefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Integer) {
            value = (Integer)cachedValue;
        } else {
            Integer objValue = ERXValueUtilities.IntegerValueWithDefault(ERXSystem.getProperty(propertyName), null);
            _cache.put(s, objValue == null ? UndefinedMarker : objValue);
            value = objValue == null ? defaultValue : objValue;
            if (ERXProperties.retainDefaultsEnabled() && objValue == null) {
                System.setProperty(propertyName, Integer.toString(defaultValue));
            }
        }
        return value;
    }

    public static long longForKeyWithDefault(String s, long defaultValue) {
        long value;
        String propertyName = ERXProperties.getApplicationSpecificPropertyName(s);
        Object cachedValue = _cache.get(propertyName);
        if (cachedValue == UndefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Long) {
            value = (Long)cachedValue;
        } else {
            Long objValue = ERXValueUtilities.LongValueWithDefault(ERXSystem.getProperty(propertyName), null);
            _cache.put(s, objValue == null ? UndefinedMarker : objValue);
            value = objValue == null ? defaultValue : objValue;
            if (ERXProperties.retainDefaultsEnabled() && objValue == null) {
                System.setProperty(propertyName, Long.toString(defaultValue));
            }
        }
        return value;
    }

    public static float floatForKeyWithDefault(String s, float defaultValue) {
        float value;
        String propertyName = ERXProperties.getApplicationSpecificPropertyName(s);
        Object cachedValue = _cache.get(propertyName);
        if (cachedValue == UndefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Float) {
            value = ((Float)cachedValue).floatValue();
        } else {
            Float objValue = ERXValueUtilities.FloatValueWithDefault(ERXSystem.getProperty(propertyName), null);
            _cache.put(s, objValue == null ? UndefinedMarker : objValue);
            value = objValue == null ? defaultValue : objValue.floatValue();
            if (ERXProperties.retainDefaultsEnabled() && objValue == null) {
                System.setProperty(propertyName, Float.toString(defaultValue));
            }
        }
        return value;
    }

    public static double doubleForKeyWithDefault(String s, double defaultValue) {
        double value;
        String propertyName = ERXProperties.getApplicationSpecificPropertyName(s);
        Object cachedValue = _cache.get(propertyName);
        if (cachedValue == UndefinedMarker) {
            value = defaultValue;
        } else if (cachedValue instanceof Double) {
            value = (Double)cachedValue;
        } else {
            Double objValue = ERXValueUtilities.DoubleValueWithDefault(ERXSystem.getProperty(propertyName), null);
            _cache.put(s, objValue == null ? UndefinedMarker : objValue);
            value = objValue == null ? defaultValue : objValue;
            if (ERXProperties.retainDefaultsEnabled() && objValue == null) {
                System.setProperty(propertyName, Double.toString(defaultValue));
            }
        }
        return value;
    }

    public static String stringForKey(String s) {
        return ERXProperties.stringForKeyWithDefault(s, null);
    }

    public static String stringForKeyWithDefault(String s, String defaultValue) {
        String stringValue;
        String propertyName = ERXProperties.getApplicationSpecificPropertyName(s);
        String propertyValue = ERXSystem.getProperty(propertyName);
        String string = stringValue = propertyValue == null ? defaultValue : propertyValue;
        if (ERXProperties.retainDefaultsEnabled() && propertyValue == null) {
            System.setProperty(propertyName, stringValue == null ? UndefinedMarker : stringValue);
        }
        return stringValue == UndefinedMarker ? null : stringValue;
    }

    public static String decryptedStringForKey(String propertyName) {
        return ERXProperties.decryptedStringForKeyWithDefault(propertyName, null);
    }

    public static String decryptedStringForKeyWithDefault(String propertyName, String defaultValue) {
        String decryptedPassword;
        boolean propertyNameEncrypted = ERXProperties.booleanForKeyWithDefault(propertyName + ".encrypted", false);
        if (propertyNameEncrypted) {
            String encryptedPassword = ERXProperties.stringForKey(propertyName);
            decryptedPassword = ERXCrypto.defaultCrypter().decrypt(encryptedPassword);
        } else {
            decryptedPassword = ERXProperties.stringForKey(propertyName);
        }
        if (decryptedPassword == null) {
            decryptedPassword = defaultValue;
        }
        return decryptedPassword;
    }

    public static String decryptedStringForKeyWithEncryptedDefault(String propertyName, String defaultValue) {
        String encryptedPassword = ERXProperties.stringForKeyWithDefault(propertyName, defaultValue);
        return ERXCrypto.defaultCrypter().decrypt(encryptedPassword);
    }

    public static NSArray<String> componentsSeparatedByString(String key, String separator) {
        return ERXProperties.componentsSeparatedByStringWithDefault(key, separator, NSArray.EmptyArray);
    }

    public static NSArray<String> componentsSeparatedByStringWithDefault(String key, String separator, NSArray<String> defaultValue) {
        String str = ERXProperties.stringForKeyWithDefault(key, null);
        NSArray<String> array = str == null ? defaultValue : NSArray.componentsSeparatedByString(str, separator);
        return array;
    }

    public static void setArrayForKey(NSArray array, String key) {
        ERXProperties.setStringForKey(NSPropertyListSerialization.stringFromPropertyList((Object)array), key);
    }

    public static void setDictionaryForKey(NSDictionary dictionary, String key) {
        ERXProperties.setStringForKey(NSPropertyListSerialization.stringFromPropertyList((Object)dictionary), key);
    }

    public static void setStringForKey(String string, String key) {
        System.setProperty(key, string);
        _cache.remove(key);
    }

    public static void removeKey(String key) {
        System.getProperties().remove(key);
        _cache.remove(key);
    }

    public static void transferPropertiesFromSourceToDest(Properties source, Properties dest) {
        if (source != null) {
            dest.putAll((Map<?, ?>)source);
            if (dest == System.getProperties()) {
                ERXProperties.systemPropertiesChanged();
            }
        }
    }

    public static Properties propertiesFromPath(String path) {
        _Properties prop = new _Properties();
        if (path == null || path.length() == 0) {
            log.warn((Object)"Attempting to read property file for null file path");
            return prop;
        }
        File file = new File(path);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            log.warn((Object)("File " + path + " doesn't exist or can't be read."));
            return prop;
        }
        try {
            prop.load(file);
            log.debug((Object)("Loaded configuration file at path: " + path));
        }
        catch (IOException e) {
            log.error((Object)("Unable to initialize properties from file \"" + path + "\""), (Throwable)e);
        }
        return prop;
    }

    public static Properties propertiesFromFile(File file) throws IOException {
        if (file == null) {
            throw new IllegalStateException("Attempting to get properties for a null file!");
        }
        _Properties prop = new _Properties();
        prop.load(file);
        return prop;
    }

    public static Properties propertiesFromArgv(String[] argv) {
        _Properties properties = new _Properties();
        NSDictionary argvDict = NSProperties.valuesFromArgv((String[])argv);
        Enumeration e = argvDict.allKeys().objectEnumerator();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            properties.put(key, argvDict.objectForKey(key));
        }
        return properties;
    }

    public static NSArray pathsForUserAndBundleProperties() {
        return ERXProperties.pathsForUserAndBundleProperties(false);
    }

    private static void addIfPresent(String info, String path, NSMutableArray<String> propertiesPaths, NSMutableArray<String> projectsInfo) {
        if (path != null && path.length() > 0) {
            if (propertiesPaths.containsObject(path = ERXProperties.getActualPath(path))) {
                log.error((Object)("Path was already included: " + path + ""));
            }
            projectsInfo.addObject("  " + info + " -> " + path);
            propertiesPaths.addObject(path);
        }
    }

    public static NSArray pathsForUserAndBundleProperties(boolean reportLoggingEnabled) {
        File file;
        String userHome;
        NSMutableArray<String> propertiesPaths = new NSMutableArray<String>();
        NSMutableArray<String> projectsInfo = new NSMutableArray<String>();
        NSArray frameworkNames = (NSArray)NSBundle.frameworkBundles().valueForKey("name");
        Enumeration e = frameworkNames.reverseObjectEnumerator();
        while (e.hasMoreElements()) {
            String frameworkName = (String)e.nextElement();
            String propertyPath = ERXFileUtilities.pathForResourceNamed("Properties", frameworkName, null);
            ERXProperties.addIfPresent(frameworkName + ".framework", propertyPath, propertiesPaths, projectsInfo);
            String devPropertiesPath = ERXApplication.isDevelopmentModeSafe() ? ERXProperties.variantPropertiesInBundle("dev", frameworkName) : null;
            ERXProperties.addIfPresent(frameworkName + ".framework.dev", devPropertiesPath, propertiesPaths, projectsInfo);
            String userPropertiesPath = ERXProperties.variantPropertiesInBundle(ERXSystem.getProperty("user.name"), frameworkName);
            ERXProperties.addIfPresent(frameworkName + ".framework.user", userPropertiesPath, propertiesPaths, projectsInfo);
        }
        NSBundle mainBundle = NSBundle.mainBundle();
        if (mainBundle != null) {
            String mainBundleName = mainBundle.name();
            String appPath = ERXFileUtilities.pathForResourceNamed("Properties", "app", null);
            ERXProperties.addIfPresent(mainBundleName + ".app", appPath, propertiesPaths, projectsInfo);
        }
        if ((userHome = ERXSystem.getProperty("user.home")) != null && userHome.length() > 0 && (file = new File(userHome, "WebObjects.properties")).exists() && file.isFile() && file.canRead()) {
            try {
                String userHomePath = file.getCanonicalPath();
                ERXProperties.addIfPresent("{$user.home}/WebObjects.properties", userHomePath, propertiesPaths, projectsInfo);
            }
            catch (IOException ex) {
                log.error((Object)("Failed to load the configuration file '" + file.getAbsolutePath() + "'."), (Throwable)ex);
            }
        }
        if (ERXProperties.optionalConfigurationFiles() != null && ERXProperties.optionalConfigurationFiles().count() > 0) {
            Enumeration configEnumerator = ERXProperties.optionalConfigurationFiles().objectEnumerator();
            while (configEnumerator.hasMoreElements()) {
                String configFile = (String)configEnumerator.nextElement();
                File file2 = new File(configFile);
                if (file2.exists() && file2.isFile() && file2.canRead()) {
                    try {
                        String optionalPath = file2.getCanonicalPath();
                        ERXProperties.addIfPresent("Optional Configuration", optionalPath, propertiesPaths, projectsInfo);
                    }
                    catch (IOException ex) {
                        log.error((Object)("Failed to load configuration file '" + file2.getAbsolutePath() + "'."), (Throwable)ex);
                    }
                    continue;
                }
                log.error((Object)("The optional configuration file '" + file2.getAbsolutePath() + "' either does not exist or could not be read."));
            }
        }
        String applicationMachinePropertiesPath = ERXProperties.applicationMachinePropertiesPath("Properties");
        ERXProperties.addIfPresent("Application-Machine Properties", applicationMachinePropertiesPath, propertiesPaths, projectsInfo);
        String applicationDeveloperPropertiesPath = ERXProperties.applicationDeveloperProperties();
        ERXProperties.addIfPresent("Application-Developer Properties", applicationDeveloperPropertiesPath, propertiesPaths, projectsInfo);
        String applicationUserPropertiesPath = ERXProperties.applicationUserProperties();
        ERXProperties.addIfPresent("Application-User Properties", applicationUserPropertiesPath, propertiesPaths, projectsInfo);
        if (reportLoggingEnabled && projectsInfo.count() > 0 && log.isInfoEnabled()) {
            StringBuffer message = new StringBuffer();
            message.append("\n\n").append("ERXProperties has found the following Properties files: \n");
            message.append(projectsInfo.componentsJoinedByString("\n"));
            message.append("\n");
            message.append("ERXProperties currently has the following properties:\n");
            message.append(ERXProperties.logString(ERXSystem.getProperties()));
            log.info((Object)message.toString());
        }
        return propertiesPaths.immutableClone();
    }

    public static Properties applyConfiguration(Properties source, Properties commandLine) {
        Properties dest = source != null ? (Properties)source.clone() : new Properties();
        NSArray additionalConfigurationFiles = ERXProperties.pathsForUserAndBundleProperties(false);
        if (additionalConfigurationFiles.count() > 0) {
            Enumeration configEnumerator = additionalConfigurationFiles.objectEnumerator();
            while (configEnumerator.hasMoreElements()) {
                String configFile = (String)configEnumerator.nextElement();
                File file = new File(configFile);
                if (file.exists() && file.isFile() && file.canRead()) {
                    try {
                        Properties props = ERXProperties.propertiesFromFile(file);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Loaded: " + file + "\n" + ERXProperties.logString(props)));
                        }
                        ERXProperties.transferPropertiesFromSourceToDest(props, dest);
                    }
                    catch (IOException ex) {
                        log.error((Object)("Unable to load optional configuration file: " + configFile), (Throwable)ex);
                    }
                    continue;
                }
                ERXConfigurationManager.log.error((Object)("The optional configuration file '" + file.getAbsolutePath() + "' either does not exist or cannot be read."));
            }
        }
        if (commandLine != null) {
            ERXProperties.transferPropertiesFromSourceToDest(commandLine, dest);
        }
        return dest;
    }

    public static Map<String, String> allPropertiesMap(boolean protectValues) {
        return ERXProperties.propertiesMap(ERXSystem.getProperties(), protectValues);
    }

    public static Map<String, String> propertiesMap(Properties properties, boolean protectValues) {
        TreeMap<String, String> props = new TreeMap<String, String>();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (protectValues && key.toLowerCase().contains("password")) {
                props.put(key, "<deleted for log>");
                continue;
            }
            props.put(key, String.valueOf(properties.getProperty(key)));
        }
        return props;
    }

    public static String logString(Properties properties) {
        StringBuffer message = new StringBuffer();
        for (Map.Entry<String, String> entry : ERXProperties.propertiesMap(properties, true).entrySet()) {
            message.append("  " + entry.getKey() + "=" + entry.getValue() + "\n");
        }
        return message.toString();
    }

    public static NSArray<Property> allProperties() {
        NSMutableArray<Property> props = new NSMutableArray<Property>();
        Enumeration<Object> e = ERXSystem.getProperties().keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String object = "" + ERXSystem.getProperty(key);
            props.addObject(new Property(key, object));
        }
        return (NSArray)props.valueForKey("@sortAsc.key");
    }

    public static String pathForPropertiesUnderProjectPath(String projectPath) {
        String path = null;
        NSArray<Object> supportedPropertiesPaths = new NSArray<Object>(new Object[]{"/Properties", "/Resources/Properties"});
        Enumeration<Object> e = supportedPropertiesPaths.objectEnumerator();
        while (e.hasMoreElements()) {
            File file = new File(projectPath + (String)e.nextElement());
            if (!file.exists() || !file.isFile() || !file.canRead()) continue;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException ex) {
                log.error((Object)(ex.getClass().getName() + ": " + ex.getMessage()));
            }
            break;
        }
        return path;
    }

    public static String applicationDeveloperProperties() {
        String applicationDeveloperPropertiesPath = null;
        if (ERXApplication.isDevelopmentModeSafe()) {
            String devName = ERXSystem.getProperty("er.extensions.ERXProperties.devPropertiesName", "dev");
            applicationDeveloperPropertiesPath = ERXProperties.variantPropertiesInBundle(devName, "app");
        }
        return applicationDeveloperPropertiesPath;
    }

    public static String variantPropertiesInBundle(String userName, String bundleName) {
        String resourceApplicationUserPropertiesPath;
        String applicationUserPropertiesPath = null;
        if (userName != null && userName.length() > 0 && (resourceApplicationUserPropertiesPath = ERXFileUtilities.pathForResourceNamed("Properties." + userName, bundleName, null)) != null) {
            applicationUserPropertiesPath = ERXProperties.getActualPath(resourceApplicationUserPropertiesPath);
        }
        return applicationUserPropertiesPath;
    }

    public static String applicationUserProperties() {
        return ERXProperties.variantPropertiesInBundle(ERXSystem.getProperty("user.name"), "app");
    }

    public static String applicationMachinePropertiesPath(String fileName) {
        String applicationName;
        String applicationMachinePropertiesPath = null;
        String machinePropertiesPath = ERXSystem.getProperty("er.extensions.ERXProperties.machinePropertiesPath", "/etc/WebObjects");
        WOApplication application = WOApplication.application();
        if (application != null) {
            applicationName = application.name();
        } else {
            applicationName = ERXSystem.getProperty("WOApplicationName");
            if (applicationName == null) {
                NSBundle mainBundle = NSBundle.mainBundle();
                if (mainBundle != null) {
                    applicationName = mainBundle.name();
                }
                if (applicationName == null) {
                    applicationName = "Unknown";
                }
            }
        }
        File applicationPropertiesFile = new File(machinePropertiesPath + File.separator + fileName);
        if (!applicationPropertiesFile.exists()) {
            applicationPropertiesFile = new File(machinePropertiesPath + File.separator + applicationName + File.separator + fileName);
        }
        if (applicationPropertiesFile.exists()) {
            try {
                applicationMachinePropertiesPath = applicationPropertiesFile.getCanonicalPath();
            }
            catch (IOException e) {
                log.error((Object)("Failed to load machine Properties file '" + fileName + "'."), (Throwable)e);
            }
        }
        return applicationMachinePropertiesPath;
    }

    public static NSArray optionalConfigurationFiles() {
        NSArray immutableOptionalConfigurationFiles = ERXProperties.arrayForKey("er.extensions.ERXProperties.OptionalConfigurationFiles");
        NSMutableArray<String> optionalConfigurationFiles = null;
        if (immutableOptionalConfigurationFiles != null) {
            optionalConfigurationFiles = immutableOptionalConfigurationFiles.mutableClone();
            for (int i = 0; i < optionalConfigurationFiles.count(); ++i) {
                String resourcePropertiesPath;
                String optionalConfigurationFile = (String)optionalConfigurationFiles.objectAtIndex(i);
                if (new File(optionalConfigurationFile).exists() || (resourcePropertiesPath = ERXFileUtilities.pathForResourceNamed(optionalConfigurationFile, "app", null)) == null) continue;
                optionalConfigurationFiles.replaceObjectAtIndex(ERXProperties.getActualPath(resourcePropertiesPath), i);
            }
        }
        return optionalConfigurationFiles;
    }

    public static String getActualPath(String path) {
        String actualPath = null;
        File file = new File(path);
        try {
            actualPath = file.getCanonicalPath();
        }
        catch (Exception ex) {
            log.warn((Object)("The file at " + path + " does not seem to exist: " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
        return actualPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemPropertiesChanged() {
        Map map = AppSpecificPropertyNames;
        synchronized (map) {
            AppSpecificPropertyNames.clear();
        }
        _cache.clear();
        NSNotificationCenter.defaultCenter().postNotification("PropertiesDidChange", null, null);
    }

    protected String applicationNameForAppending() {
        if (this.applicationNameForAppending == null) {
            String string = this.applicationNameForAppending = WOApplication.application() != null ? WOApplication.application().name() : null;
            if (this.applicationNameForAppending != null) {
                this.applicationNameForAppending = "." + this.applicationNameForAppending;
            }
        }
        return this.applicationNameForAppending;
    }

    @Override
    public String getProperty(String key) {
        String property = null;
        String application = this.applicationNameForAppending();
        if (application != null) {
            property = super.getProperty(key + application);
        }
        if (property == null) {
            property = super.getProperty(key);
            if (property == null) {
                property = super.getProperty(key + DefaultString);
            }
            if (property != null && application != null) {
                this.setProperty(key + application, property);
            }
        }
        return property;
    }

    public Object toExternalForm() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.store(os, null);
        return new String(os.toByteArray());
    }

    public static ERXProperties fromExternalForm(String string) {
        ERXProperties result = new ERXProperties();
        try {
            result.load(new ByteArrayInputStream(string.getBytes()));
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        return result;
    }

    public void takeValueForKey(Object anObject, String aKey) {
        this.setProperty(aKey, anObject != null ? anObject.toString() : null);
    }

    public Object valueForKey(String aKey) {
        return this.getProperty(aKey);
    }

    public static void setOperatorForKey(Operator operator, String key) {
        operators.setObjectForKey(operator, key);
    }

    public static void evaluatePropertyOperators(Properties originalProperties, Properties destinationProperties) {
        NSArray operatorKeys = operators.allKeys();
        for (Object keyObj : new TreeSet<Object>(originalProperties.keySet())) {
            String key = (String)keyObj;
            if (key == null || key.length() <= 0) continue;
            String value = originalProperties.getProperty(key);
            if (operatorKeys.count() > 0 && key.indexOf(".@") != -1) {
                Operator operator = null;
                NSDictionary<String, String> computedProperties = null;
                for (String operatorKey : operatorKeys) {
                    String operatorKeyWithAt = ".@" + operatorKey;
                    if (key.endsWith(operatorKeyWithAt)) {
                        operator = (Operator)operators.objectForKey(operatorKey);
                        computedProperties = operator.compute(key.substring(0, key.length() - operatorKeyWithAt.length()), value, null);
                        break;
                    }
                    int keyIndex = key.indexOf(operatorKeyWithAt + ".");
                    if (keyIndex == -1) continue;
                    operator = (Operator)operators.objectForKey(operatorKey);
                    computedProperties = operator.compute(key.substring(0, keyIndex), value, key.substring(keyIndex + operatorKeyWithAt.length() + 1));
                    break;
                }
                if (computedProperties == null) {
                    destinationProperties.put(key, value);
                    continue;
                }
                originalProperties.remove(key);
                if (System.getProperty(key) != null && !System.getProperty(key).equals(value)) {
                    originalProperties.put(key, value);
                }
                for (String computedKey : computedProperties.allKeys()) {
                    destinationProperties.put(computedKey, computedProperties.objectForKey(computedKey));
                }
                continue;
            }
            destinationProperties.put(key, value);
        }
    }

    public static void setCommandLineArguments(String[] argv) {
    }

    static {
        UndefinedMarker = "-undefined-";
        log = Logger.getLogger(ERXProperties.class);
        AppSpecificPropertyNames = new HashMap(128);
        _cache = Collections.synchronizedMap(new HashMap());
        operators = new NSMutableDictionary();
    }

    public static class _Properties
    extends Properties {
        public static final String IncludePropsKey = ".includeProps";
        private Stack<File> _files = new Stack();

        public synchronized Object put(Object key, Object value) {
            if (IncludePropsKey.equals(key)) {
                String existingIncludeProps;
                String propsFileName = (String)value;
                File propsFile = new File(propsFileName);
                if (!propsFile.isAbsolute()) {
                    File cwd = null;
                    cwd = this._files.size() > 0 ? this._files.peek() : new File(System.getProperty("user.home"));
                    propsFile = new File(cwd, propsFileName);
                }
                if ((existingIncludeProps = this.getProperty(IncludePropsKey)) == null) {
                    existingIncludeProps = "";
                }
                if (existingIncludeProps.indexOf(propsFile.getPath()) > -1) {
                    log.error((Object)("_Properties.load(): recursive includeProps detected! " + propsFile + " in " + existingIncludeProps));
                    log.error((Object)"_Properties.load() cannot proceed - QUITTING!");
                    System.exit(1);
                }
                if (existingIncludeProps.length() > 0) {
                    existingIncludeProps = existingIncludeProps + ", ";
                }
                existingIncludeProps = existingIncludeProps + propsFile;
                super.put(IncludePropsKey, existingIncludeProps);
                try {
                    log.info((Object)("_Properties.load(): Including props file: " + propsFile));
                    this.load(propsFile);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load the property file '" + value + "'.", e);
                }
                return null;
            }
            return super.put(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void load(File propsFile) throws IOException {
            this._files.push(propsFile.getParentFile());
            try {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(propsFile));
                try {
                    this.load(is);
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                Object var6_6 = null;
                this._files.pop();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this._files.pop();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EncryptedOperator
    implements Operator {
        public static final String Key = "encrypted";

        public static void register() {
            ERXProperties.setOperatorForKey(new EncryptedOperator(), Key);
        }

        @Override
        public NSDictionary<String, String> compute(String key, String value, String parameters) {
            String decryptedValue = ERXCrypto.defaultCrypter().decrypt(value);
            return new NSDictionary<String, String>(decryptedValue, key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InRangeOperator
    implements Operator {
        public static final String ForInstanceKey = "forInstance";
        private int _instanceNumber;

        public InRangeOperator(int value) {
            this._instanceNumber = value;
        }

        @Override
        public NSDictionary<String, String> compute(String key, String value, String parameters) {
            NSDictionary<String, String> computedProperties = null;
            if (parameters != null && parameters.length() > 0) {
                computedProperties = ERXStringUtilities.isValueInRange(this._instanceNumber, parameters) ? new NSDictionary<String, String>(value, key) : NSDictionary.EmptyDictionary;
            }
            return computedProperties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Operator {
        public NSDictionary<String, String> compute(String var1, String var2, String var3);
    }

    public static class Property {
        public String key;
        public String value;

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + " = " + this.value;
        }
    }
}

