/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.partials;

import com.webobjects.eoaccess.EOAttribute;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEntityClassDescription;
import er.extensions.eof.ERXModelGroup;
import er.extensions.foundation.ERXProperties;
import er.extensions.partials.ERXPartial;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXPartialInitializer {
    private static final ERXPartialInitializer _initializer = new ERXPartialInitializer();
    private NSMutableDictionary<EOEntity, NSMutableArray<Class<ERXPartial>>> _partialsForEntity = new NSMutableDictionary();

    public static ERXPartialInitializer initializer() {
        return _initializer;
    }

    public static void registerModelGroupListener() {
        if (ERXProperties.booleanForKeyWithDefault("er.extensions.partials.enabled", false)) {
            NSNotificationCenter.defaultCenter().addObserver((Object)_initializer, new NSSelector("modelGroupAdded", ERXConstant.NotificationClassArray), "ERXModelGroupAddedNotification", null);
        }
    }

    public void workaroundClassDescriptionResetProblem() {
        if (ERXProperties.booleanForKeyWithDefault("er.extensions.partials.enabled", false)) {
            for (EOEntity partialEntity : this._partialsForEntity.keySet()) {
                ERXEntityClassDescription ecd = (ERXEntityClassDescription)partialEntity.classDescriptionForInstances();
                for (Class partialClass : (NSMutableArray)this._partialsForEntity.objectForKey(partialEntity)) {
                    ecd._addPartialClass(partialClass);
                }
            }
        }
    }

    public void modelGroupAdded(NSNotification notification) {
        ERXModelGroup modelGroup = (ERXModelGroup)((Object)notification.object());
        this.initializePartialEntities(modelGroup);
    }

    public void initializePartialEntities(EOModelGroup modelGroup) {
        NSMutableDictionary<EOEntity, EOEntity> baseForPartial = new NSMutableDictionary<EOEntity, EOEntity>();
        Enumeration modelsEnum = modelGroup.models().objectEnumerator();
        while (modelsEnum.hasMoreElements()) {
            EOModel model = (EOModel)modelsEnum.nextElement();
            Enumeration entitiesEnum = model.entities().objectEnumerator();
            while (entitiesEnum.hasMoreElements()) {
                String partialEntityName;
                EOEntity partialExtensionEntity = (EOEntity)entitiesEnum.nextElement();
                NSDictionary userInfo = partialExtensionEntity.userInfo();
                NSDictionary entityModelerDictionary = (NSDictionary)userInfo.objectForKey("_EntityModeler");
                if (entityModelerDictionary == null || (partialEntityName = (String)entityModelerDictionary.objectForKey("partialEntity")) == null) continue;
                EOEntity partialEntity = modelGroup.entityNamed(partialEntityName);
                if (partialEntity == null) {
                    throw new IllegalArgumentException("The entity '" + partialExtensionEntity.name() + "' claimed to be a partialEntity for the entity '" + partialEntity.name() + "', but there is no entity of that name.");
                }
                Enumeration partialAttributes = partialExtensionEntity.attributes().objectEnumerator();
                while (partialAttributes.hasMoreElements()) {
                    EOAttribute partialAttribute = (EOAttribute)partialAttributes.nextElement();
                    if (partialEntity.attributeNamed(partialAttribute.name()) == null) {
                        NSMutableDictionary<String, String> attributePropertyList = new NSMutableDictionary<String, String>();
                        partialAttribute.encodeIntoPropertyList(attributePropertyList);
                        String factoryMethodArgumentType = (String)attributePropertyList.objectForKey("factoryMethodArgumentType");
                        if ("EOFactoryMethodArgumentIsString".equals(factoryMethodArgumentType)) {
                            attributePropertyList.setObjectForKey("EOFactoryMethodArgumentIsNSString", "factoryMethodArgumentType");
                        }
                        EOAttribute primaryAttribute = new EOAttribute(attributePropertyList, (Object)partialEntity);
                        primaryAttribute.awakeWithPropertyList(attributePropertyList);
                        partialEntity.addAttribute(primaryAttribute);
                        continue;
                    }
                    ERXModelGroup.log.debug((Object)("Skipping partial attribute " + partialExtensionEntity.name() + "." + partialAttribute.name() + " because " + partialEntity.name() + " already has an attribute of the same name."));
                }
                Enumeration partialRelationships = partialExtensionEntity.relationships().objectEnumerator();
                while (partialRelationships.hasMoreElements()) {
                    EORelationship partialRelationship = (EORelationship)partialRelationships.nextElement();
                    if (partialEntity.relationshipNamed(partialRelationship.name()) == null) {
                        NSMutableDictionary relationshipPropertyList = new NSMutableDictionary();
                        partialRelationship.encodeIntoPropertyList(relationshipPropertyList);
                        EORelationship primaryRelationship = new EORelationship(relationshipPropertyList, partialEntity);
                        primaryRelationship.awakeWithPropertyList(relationshipPropertyList);
                        partialEntity.addRelationship(primaryRelationship);
                        continue;
                    }
                    ERXModelGroup.log.debug((Object)("Skipping partial relationship " + partialExtensionEntity.name() + "." + partialRelationship.name() + " because " + partialEntity.name() + " already has a relationship of the same name."));
                }
                NSMutableArray<Class> partialsForEntity = (NSMutableArray<Class>)this._partialsForEntity.objectForKey(partialEntity);
                if (partialsForEntity == null) {
                    partialsForEntity = new NSMutableArray<Class>();
                    this._partialsForEntity.setObjectForKey(partialsForEntity, partialEntity);
                }
                Class partialClass = _NSUtilities.classWithName((String)partialExtensionEntity.className());
                ERXEntityClassDescription ecd = (ERXEntityClassDescription)partialEntity.classDescriptionForInstances();
                ecd._addPartialClass(partialClass);
                partialsForEntity.addObject(partialClass);
                baseForPartial.setObjectForKey(partialEntity, partialExtensionEntity);
            }
        }
        NSMutableSet<EOEntity> convertedEntities = new NSMutableSet<EOEntity>();
        modelsEnum = modelGroup.models().objectEnumerator();
        while (modelsEnum.hasMoreElements()) {
            EOModel model = (EOModel)modelsEnum.nextElement();
            Enumeration entitiesEnum = model.entities().objectEnumerator();
            while (entitiesEnum.hasMoreElements()) {
                EOEntity entity = (EOEntity)entitiesEnum.nextElement();
                this.convertEntityPartialReferences(entity, baseForPartial, convertedEntities);
            }
        }
        for (EOEntity partialExtensionEntity : baseForPartial.allKeys()) {
            partialExtensionEntity.model().removeEntity(partialExtensionEntity);
        }
    }

    protected void convertEntityPartialReferences(EOEntity entity, NSMutableDictionary<EOEntity, EOEntity> baseForPartial, NSMutableSet<EOEntity> convertedEntities) {
        if (!convertedEntities.containsObject(entity)) {
            convertedEntities.addObject(entity);
            Enumeration relationships = entity.relationships().immutableClone().objectEnumerator();
            while (relationships.hasMoreElements()) {
                EORelationship relationship = (EORelationship)relationships.nextElement();
                this.convertRelationshipPartialReferences(entity, relationship, baseForPartial, convertedEntities);
            }
        }
    }

    protected void convertRelationshipPartialReferences(EOEntity entity, EORelationship relationship, NSMutableDictionary<EOEntity, EOEntity> baseForPartial, NSMutableSet<EOEntity> convertedEntities) {
        EOEntity destinationEntity = relationship.destinationEntity();
        EOEntity baseEntity = (EOEntity)baseForPartial.objectForKey(destinationEntity);
        if (baseEntity != null) {
            if (relationship.isFlattened()) {
                for (EORelationship componentRelationship : relationship.componentRelationships()) {
                    EOEntity componentEntity = componentRelationship.destinationEntity();
                    if (componentEntity == entity) {
                        this.convertRelationshipPartialReferences(entity, componentRelationship, baseForPartial, convertedEntities);
                        continue;
                    }
                    this.convertEntityPartialReferences(componentEntity, baseForPartial, convertedEntities);
                }
            }
            NSMutableDictionary<String, String> relationshipPropertyList = new NSMutableDictionary<String, String>();
            relationship.encodeIntoPropertyList(relationshipPropertyList);
            relationshipPropertyList.setObjectForKey(baseEntity.name(), "destination");
            EORelationship primaryRelationship = new EORelationship(relationshipPropertyList, entity);
            primaryRelationship.awakeWithPropertyList(relationshipPropertyList);
            entity.relationshipNamed(relationship.name());
            entity.removeRelationship(relationship);
            entity.addRelationship(primaryRelationship);
        }
    }
}

