/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.validation;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSValidation;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.localization.ERXLocalizer;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class ERXValidation {
    public static final Logger log = Logger.getLogger((String)"er.validation.ERValidation");
    public static final boolean PUSH_INCORRECT_VALUE_ON_EO = true;
    public static final boolean DO_NOT_PUSH_INCORRECT_VALUE_ON_EO = false;
    private static boolean pushChangesDefault = false;

    public static void setPushChangesDefault(boolean val) {
        pushChangesDefault = val;
    }

    public static void validationFailedWithException(Throwable e, Object value, String keyPath, NSMutableDictionary errorMessages, String displayPropertyKeyPath, ERXLocalizer localizer) {
        ERXValidation.validationFailedWithException(e, value, keyPath, errorMessages, displayPropertyKeyPath, localizer, null);
    }

    public static void validationFailedWithException(Throwable e, Object value, String keyPath, NSMutableDictionary errorMessages, String displayPropertyKeyPath, ERXLocalizer localizer, EOEntity entity) {
        ERXValidation.validationFailedWithException(e, value, keyPath, errorMessages, displayPropertyKeyPath, localizer, entity, pushChangesDefault);
    }

    public static void validationFailedWithException(Throwable e, Object value, String keyPath, NSMutableDictionary errorMessages, String displayPropertyKeyPath, ERXLocalizer localizer, EOEntity entity, boolean pushChanges) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("ValidationFailedWithException: " + e.getClass().getName() + " message: " + e.getMessage()));
        }
        String key = null;
        String newErrorMessage = e.getMessage();
        if (e instanceof NSValidation.ValidationException && ((NSValidation.ValidationException)e).key() != null && ((NSValidation.ValidationException)e).object() != null) {
            NSValidation.ValidationException nve = (NSValidation.ValidationException)e;
            key = nve.key();
            Object eo = nve.object();
            if (eo instanceof EOEnterpriseObject) {
                if (pushChanges) {
                    try {
                        ((EOEnterpriseObject)eo).takeValueForKeyPath(value, key);
                    }
                    catch (NSKeyValueCoding.UnknownKeyException ex) {
                    }
                    catch (NoSuchElementException ex) {
                    }
                    catch (Exception ex) {
                        log.error((Object)("Can't push value to key '" + key + "': " + value), (Throwable)ex);
                    }
                }
                entity = EOUtilities.entityForObject((EOEditingContext)((EOEnterpriseObject)eo).editingContext(), (EOEnterpriseObject)((EOEnterpriseObject)eo));
            } else {
                key = NSArray.componentsSeparatedByString(displayPropertyKeyPath, ".").lastObject();
                newErrorMessage = "<b>" + key + "</b>:" + newErrorMessage;
            }
        } else {
            key = keyPath;
        }
        if (key != null && newErrorMessage != null) {
            String displayName = ERXValidation.localizedDisplayNameForKey(entity != null ? entity.classDescriptionForInstances() : null, key, localizer);
            errorMessages.setObjectForKey(newErrorMessage, displayName);
        } else if (key != null) {
            log.warn((Object)("NULL message for key:'" + key + "': " + e), e);
        } else {
            log.warn((Object)("NULL key for message:'" + newErrorMessage + "'"), e);
        }
    }

    public static String localizedDisplayNameForKey(EOClassDescription ecd, String key, ERXLocalizer localizer) {
        String displayName = localizer != null ? (ecd != null ? localizer.localizedDisplayNameForKey(ecd.entityName(), key) : localizer.localizedStringForKeyWithDefault(key)) : (ecd != null ? ecd.displayNameForKey(key) : ERXStringUtilities.displayNameForKey(key));
        return displayName;
    }
}

