/*
 * Decompiled with CFR 0.152.
 */
package er.googlechart.components;

import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import er.ajax.AjaxUtils;
import er.extensions.foundation.ERXMutableURL;
import er.googlechart.components.GCAbstractChart;

public class GCBarChart
extends GCAbstractChart {
    protected WOAssociation _orientation;
    protected WOAssociation _stacked;
    protected WOAssociation _barWidth;
    protected WOAssociation _spacing;
    protected WOAssociation _groupSpacing;
    protected WOAssociation _zeroLine;

    public GCBarChart(String name, NSDictionary associations, WOElement element) {
        super(name, associations, element);
        this._orientation = (WOAssociation)associations.objectForKey((Object)"orientation");
        this._stacked = (WOAssociation)associations.objectForKey((Object)"stacked");
        this._barWidth = (WOAssociation)associations.objectForKey((Object)"barWidth");
        this._spacing = (WOAssociation)associations.objectForKey((Object)"spacing");
        this._groupSpacing = (WOAssociation)associations.objectForKey((Object)"groupSpacing");
        this._zeroLine = (WOAssociation)associations.objectForKey((Object)"zeroLine");
    }

    protected void addQueryParameters(ERXMutableURL chartUrl, WOResponse response, WOContext context) {
        NSArray zeroLine;
        super.addQueryParameters(chartUrl, response, context);
        WOComponent component = context.component();
        String orientation = "vertical";
        if (this._orientation != null) {
            orientation = (String)this._orientation.valueInComponent(component);
        }
        boolean stacked = true;
        if (this._stacked != null) {
            stacked = this._stacked.booleanValueInComponent(component);
        }
        if (!"horizontal".equals(orientation) && !"vertical".equals(orientation)) {
            throw new IllegalArgumentException("Unknown orientation '" + orientation + "'.");
        }
        String orientationKey = orientation.substring(0, 1);
        String stackedKey = stacked ? "s" : "g";
        chartUrl.setQueryParameter("cht", "b" + orientationKey + stackedKey);
        StringBuffer chbh = new StringBuffer();
        String barWidth = "23";
        String spacing = "4";
        if (this._barWidth != null) {
            barWidth = (String)this._barWidth.valueInComponent(component);
            chbh.append(barWidth);
        }
        if (this._spacing != null) {
            if (this._barWidth == null) {
                chbh.append(barWidth);
            }
            chbh.append(",");
            spacing = (String)this._spacing.valueInComponent(component);
            chbh.append(spacing);
        }
        if (this._groupSpacing != null) {
            if (this._barWidth == null) {
                chbh.append(barWidth);
                chbh.append(",");
            }
            if (this._spacing == null) {
                chbh.append(spacing);
            }
            chbh.append(",");
            String groupSpacing = (String)this._groupSpacing.valueInComponent(component);
            chbh.append(groupSpacing);
        }
        if (chbh.length() > 0) {
            chartUrl.setQueryParameter("chbh", chbh.toString());
        }
        if ((zeroLine = AjaxUtils.arrayValueForAssociation((WOComponent)component, (WOAssociation)this._zeroLine)) != null) {
            chartUrl.setQueryParameter("chp", zeroLine.componentsJoinedByString(","));
        }
    }
}

