/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.openxri.AuthorityPath;
import org.openxri.IRIAuthority;
import org.openxri.XRI;
import org.openxri.XRIAbsolutePath;
import org.openxri.XRIAuthority;
import org.openxri.XRIParseException;
import org.openxri.XRIPath;
import org.openxri.XRIQuery;
import org.openxri.XRISegment;
import org.openxri.http.BaseFetcher;
import org.openxri.resolve.ResolverState;
import org.openxri.resolve.SEPSelector;
import org.openxri.resolve.TrustType;
import org.openxri.resolve.exception.InvalidAuthorityURIException;
import org.openxri.resolve.exception.PartialResolutionException;
import org.openxri.resolve.exception.XRIResolutionException;
import org.openxri.util.DOMUtils;
import org.openxri.util.IO;
import org.openxri.util.PrioritizedList;
import org.openxri.xml.Ref;
import org.openxri.xml.SEPUri;
import org.openxri.xml.Service;
import org.openxri.xml.Status;
import org.openxri.xml.XRD;
import org.openxri.xml.XRDS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Resolver
extends BaseFetcher {
    private static Log log = LogFactory.getLog((String)Resolver.class.getName());
    protected HashMap root = new HashMap();
    protected int maxFollowRefs = -1;
    protected int maxRequests = -1;
    protected URI proxyURI = null;
    private int maxTotalBytes = -1;
    private int maxBytesPerRequest = -1;

    public void setAuthority(String auth, XRD authXRD) {
        this.root.put(auth, authXRD);
    }

    public boolean hasAuthority(String auth) {
        return this.root.containsKey(auth);
    }

    public XRD getAuthority(String auth) {
        Object xrd = this.root.get(auth);
        return xrd == null ? null : (XRD)xrd;
    }

    public URI getProxyURI() {
        return this.proxyURI;
    }

    public void setProxyURI(URI proxyURI) {
        this.proxyURI = proxyURI;
    }

    public XRDS resolveAuthToXRDS(String qxri, TrustType trustType, boolean followRefs) throws PartialResolutionException {
        return this.resolveAuthToXRDS(qxri, trustType, followRefs, new ResolverState());
    }

    public XRDS resolveAuthToXRDS(String qxri, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthToXRDS(s'" + qxri + "', trustType=" + trustType + ", followRefs=" + followRefs + ")"));
        XRI xri = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveAuthToXRDS(xri, trustType, followRefs, state);
    }

    public XRDS resolveAuthToXRDS(XRI qxri, TrustType trustType, boolean followRefs) throws PartialResolutionException {
        return this.resolveAuthToXRDS(qxri, trustType, followRefs, new ResolverState());
    }

    public XRDS resolveAuthToXRDS(XRI qxri, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthToXRDS('" + qxri + "', trustType=" + trustType + ", followRefs=" + followRefs + ")"));
        if (this.proxyURI != null) {
            return this.resolveViaProxy(qxri, trustType, null, null, false, followRefs, state);
        }
        return this.resolveAuthTop(qxri, trustType, followRefs, state);
    }

    public XRD resolveAuthToXRD(String qxri, TrustType trustType, boolean followRefs) throws PartialResolutionException {
        return this.resolveAuthToXRD(qxri, trustType, followRefs, new ResolverState());
    }

    public XRD resolveAuthToXRD(String qxri, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthToXRD(s'" + qxri + "', trustType=" + trustType + ", followRefs=" + followRefs + ")"));
        XRI xri = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveAuthToXRD(xri, trustType, followRefs, state);
    }

    public XRD resolveAuthToXRD(XRI qxri, TrustType trustType, boolean followRefs) throws PartialResolutionException {
        return this.resolveAuthToXRD(qxri, trustType, followRefs, new ResolverState());
    }

    public XRD resolveAuthToXRD(XRI qxri, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthToXRD('" + qxri + "', trustType=" + trustType + ", followRefs=" + followRefs + ")"));
        XRDS xrds = null;
        xrds = this.proxyURI != null ? this.resolveViaProxy(qxri, trustType, null, null, false, followRefs, state) : this.resolveAuthToXRDS(qxri, trustType, followRefs, state);
        return xrds.getFinalXRD();
    }

    public XRDS resolveSEPToXRDS(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToXRDS(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public XRDS resolveSEPToXRDS(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRDS(s'" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRI xri = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveSEPToXRDS(xri, trustType, sepType, sepMediaType, followRefs, state);
    }

    public XRDS resolveSEPToXRDS(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToXRDS(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public XRDS resolveSEPToXRDS(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRDS('" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRDS xrds = this.resolveAuthToXRDS(qxri, trustType, followRefs, state);
        XRD finalXRD = xrds.getFinalXRD();
        XRDS resultXRDS = null;
        try {
            resultXRDS = this.selectServiceFromXRD(finalXRD, qxri, trustType, sepType, sepMediaType, followRefs, state);
        }
        catch (PartialResolutionException e) {
            xrds.replaceFinalXRD(e.getPartialXRDS());
            throw new PartialResolutionException(xrds);
        }
        xrds.replaceFinalXRD(resultXRDS);
        return xrds;
    }

    public XRD resolveSEPToXRD(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToXRD(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public XRD resolveSEPToXRD(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRD(s'" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRI xri = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveSEPToXRD(xri, trustType, sepType, sepMediaType, followRefs, state);
    }

    public XRD resolveSEPToXRD(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToXRD(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public XRD resolveSEPToXRD(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToXRD('" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRDS xrds = this.resolveSEPToXRDS(qxri, trustType, sepType, sepMediaType, followRefs, state);
        return xrds.getFinalXRD();
    }

    public ArrayList resolveSEPToURIList(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToURIList(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public ArrayList resolveSEPToURIList(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToURIList(s'" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRI xri = this.parseAbsoluteQXRIOrError(qxri);
        return this.resolveSEPToURIList(xri, trustType, sepType, sepMediaType, followRefs, state);
    }

    public ArrayList resolveSEPToURIList(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToURIList(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public ArrayList resolveSEPToURIList(XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToURIList('" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        XRD xrd = this.resolveSEPToXRD(qxri, trustType, sepType, sepMediaType, followRefs, state);
        if (xrd == null) {
            return new ArrayList();
        }
        if (xrd.getSelectedServices().getList().size() < 1) {
            log.error((Object)"SEP Selection succeeded but no Service found!?");
            return new ArrayList();
        }
        Service topService = (Service)xrd.getSelectedServices().getList().get(0);
        ArrayList<String> urisOut = new ArrayList<String>();
        ArrayList uris = topService.getPrioritizedURIs();
        for (int i = 0; uris != null && i < uris.size(); ++i) {
            SEPUri uri = (SEPUri)uris.get(i);
            String append = uri.getAppend();
            if (append == null) {
                append = "local";
            }
            urisOut.add(this.constructURI(uri.getURI(), append, qxri));
        }
        return urisOut;
    }

    public String resolveSEPToTextURIList(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs) throws PartialResolutionException {
        return this.resolveSEPToTextURIList(qxri, trustType, sepType, sepMediaType, followRefs, new ResolverState());
    }

    public String resolveSEPToTextURIList(String qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveSEPToTextURIList('" + qxri + "', trustType=" + trustType + ", sepType=" + sepType + ", sepMediaType=" + sepMediaType + ", followRefs=" + followRefs + ")"));
        ArrayList uris = this.resolveSEPToURIList(qxri, trustType, sepType, sepMediaType, followRefs, state);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; uris != null && i < uris.size(); ++i) {
            buf.append(uris.get(i).toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public XRDS resolveAuthTop(XRI qxri, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthTop('" + qxri + "', trustType=" + trustType + ", followRefs=" + followRefs + ")"));
        XRDS xrdsOut = new XRDS();
        xrdsOut.setRef("xri://" + qxri.getAuthorityPath().toString());
        AuthorityPath ap = qxri.getAuthorityPath();
        if (ap instanceof XRIAuthority) {
            String rootAuth = ((XRIAuthority)ap).getRootAuthority();
            if (rootAuth == null) {
                throw new RuntimeException("First subsegment of '" + ap + "' is null");
            }
            XRD authXRD = this.getAuthority(rootAuth);
            if (authXRD == null) {
                XRD err = this.createErrorXRD(qxri.toURINormalForm(), "215", "Authority '" + rootAuth + "' is not configured");
                xrdsOut.add(err);
                throw new PartialResolutionException(xrdsOut);
            }
            XRISegment unresolved = ((XRIAuthority)ap).getXRISegment();
            try {
                XRDS newXRDS = this.resolveAuthSegment(authXRD, unresolved, trustType, followRefs, state);
                xrdsOut.addAll(newXRDS);
                return xrdsOut;
            }
            catch (PartialResolutionException e) {
                xrdsOut.addAll(e.getPartialXRDS());
                throw new PartialResolutionException(xrdsOut);
            }
        }
        if (ap instanceof IRIAuthority) {
            try {
                XRDS newXRDS = this.resolveIRIAuth((IRIAuthority)ap, trustType, followRefs, state);
                xrdsOut.addAll(newXRDS);
                return xrdsOut;
            }
            catch (PartialResolutionException e) {
                xrdsOut.addAll(e.getPartialXRDS());
                throw new PartialResolutionException(xrdsOut);
            }
        }
        throw new RuntimeException("Unknown authority");
    }

    protected XRDS resolveIRIAuth(IRIAuthority iriAuth, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveIRIAuth('" + iriAuth + "', trustType=" + trustType + ", followRefs=" + followRefs + ")"));
        XRDS xrdsOut = new XRDS();
        if (trustType.isSAML()) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "201", "SAML is not supported for an IRI authority");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        String scheme = trustType.isHTTPS() ? "https" : "http";
        URI uri = null;
        try {
            uri = new URI(scheme, iriAuth.getIUserInfo(), iriAuth.getIHost(), iriAuth.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "210", "Unable to construct URI to resolve IRI authority: " + e.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        InputStream in = null;
        try {
            in = this.getDataFromURI(uri.toString(), uri, trustType, state);
        }
        catch (Exception e) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "320", "Network error occurred while resolving IRI authority: " + e.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        if (in == null) {
            throw new RuntimeException("resolveIRIAuth - getDataFromURI returned null");
        }
        try {
            xrdsOut = this.readXRDS(in);
            if (xrdsOut.getNumChildren() != 1) {
                XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "321", "Expected 1 XRD from IRI authority, got " + xrdsOut.getNumChildren() + " instead");
                xrdsOut.add(err);
                throw new PartialResolutionException(xrdsOut);
            }
        }
        catch (XRIResolutionException e) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "321", "Error reading XRDS from server: " + e.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        XRD xrd = xrdsOut.getDescriptorAt(0);
        if (!xrd.isValid()) {
            XRD err = this.createErrorXRD(iriAuth.toURINormalForm(), "223", "XRD is invalid");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        return xrdsOut;
    }

    protected XRDS resolveViaProxy(XRI qxri, TrustType trustType, String serviceType, String serviceMediaType, boolean sepSelect, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveViaProxy('" + qxri + "', trustType=" + trustType + ", serviceType=" + serviceType + ", serviceMediaType=" + serviceMediaType + ", followRefs=" + followRefs + ")"));
        XRDS xrdsOut = new XRDS();
        URI newURI = null;
        try {
            StringBuffer query = new StringBuffer();
            if (serviceType != null) {
                query.append("_xrd_t=");
                query.append(URLEncoder.encode(serviceType, "UTF-8"));
                query.append('&');
            }
            if (serviceMediaType != null) {
                query.append("_xrd_m=");
                query.append(URLEncoder.encode(serviceMediaType, "UTF-8"));
                query.append('&');
            }
            query.append("_xrd_r=");
            query.append("application/xrds+xml");
            query.append(';');
            query.append(trustType.getParameterPair());
            query.append(";sep=");
            query.append(sepSelect);
            query.append(";ref=");
            query.append(followRefs);
            query.append('&');
            if (this.proxyURI.getQuery() != null) {
                query.append(this.proxyURI.getQuery());
            }
            StringBuffer uriBuf = new StringBuffer();
            uriBuf.append(this.proxyURI.getScheme());
            uriBuf.append("://");
            uriBuf.append(this.proxyURI.getAuthority());
            uriBuf.append(this.proxyURI.getPath());
            if (uriBuf.charAt(uriBuf.length() - 1) != '/') {
                uriBuf.append('/');
            }
            uriBuf.append(qxri.getAuthorityPath().toURINormalForm());
            uriBuf.append('?');
            uriBuf.append(query);
            log.trace((Object)("resolveViaProxy - constructed proxy query URI '" + uriBuf + "'"));
            newURI = new URI(uriBuf.toString());
        }
        catch (URISyntaxException oEx) {
            XRD err = this.createErrorXRD(qxri.getAuthorityPath().toURINormalForm(), "210", "Unable to construct URI to access proxy resolution service");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        catch (UnsupportedEncodingException e) {
            XRD err = this.createErrorXRD(qxri.getAuthorityPath().toURINormalForm(), "210", "Charset not supported");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        InputStream in = null;
        try {
            in = this.getDataFromURI(qxri.toURINormalForm(), newURI, trustType, state);
            XRDS xrds = this.readXRDS(in);
            XRD finalXRD = xrds.getFinalXRD();
            String code = finalXRD.getStatusCode();
            if (followRefs && !code.equals("100") && !code.equals("101") || !code.equals("100")) {
                throw new PartialResolutionException(xrds);
            }
            return xrds;
        }
        catch (PartialResolutionException e) {
            throw e;
        }
        catch (Exception e) {
            XRD err = this.createErrorXRD(qxri.getAuthorityPath().toURINormalForm(), "200", "Error fetching XRDS from proxy: " + e.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
    }

    protected XRDS processAuthRefs(ArrayList servicesOut, XRD parent, XRISegment segment, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        XRDS xrdsOut = new XRDS();
        ArrayList selectedServices = this.selectServices(parent.getServices(), "xri://$res*auth*($v*2.0)", null, "application/xrds+xml;" + trustType.getParameterPair());
        if (selectedServices.size() > 0) {
            servicesOut.addAll(selectedServices);
            return xrdsOut;
        }
        ArrayList refs = parent.getPrioritizedRefs();
        if (refs.size() < 1) {
            XRD err = this.createErrorXRD(segment.getSubSegmentAt(0).toURINormalForm(), "220", "Requested service endpoint not found");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        if (!followRefs) {
            XRD err = this.createErrorXRD(segment.getSubSegmentAt(0).toURINormalForm(), "101", "References not followed");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        if (this.maxFollowRefs >= 0 && state.getNumRefsFollowed() >= this.maxFollowRefs) {
            XRD err = this.createErrorXRD(segment.getSubSegmentAt(0).toURINormalForm(), "202", "Maximum number of references exceeded");
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        for (int i = 0; i < refs.size(); ++i) {
            Ref r = (Ref)refs.get(i);
            XRI refXRI = null;
            try {
                refXRI = this.parseAbsoluteQXRIOrError(r.getValue());
            }
            catch (PartialResolutionException e) {
                log.warn((Object)("resolveAuthSegment - Invalid ref encountered: " + e.getMessage()));
                continue;
            }
            state.pushFollowingRef(refXRI);
            XRDS xrds = null;
            try {
                xrds = this.resolveAuthTop(refXRI, trustType, followRefs, state);
                xrdsOut.add(xrds);
            }
            catch (PartialResolutionException e) {
                xrdsOut.add(e.getPartialXRDS());
                throw new PartialResolutionException(xrdsOut);
            }
            try {
                XRDS xrds2 = this.processAuthRefs(servicesOut, xrds.getFinalXRD(), segment, trustType, followRefs, state);
                if (xrds2.getNumChildren() > 0) {
                    xrds.addAll(xrds2);
                }
                return xrdsOut;
            }
            catch (PartialResolutionException e) {
                xrdsOut.addAll(e.getPartialXRDS());
                throw new PartialResolutionException(xrdsOut);
            }
        }
        XRD err = this.createErrorXRD(segment.getSubSegmentAt(0).toURINormalForm(), "220", "Requested service endpoint not found");
        xrdsOut.add(err);
        throw new PartialResolutionException(xrdsOut);
    }

    public XRDS resolveAuthSegment(XRD parent, XRISegment segment, TrustType trustType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        log.trace((Object)("resolveAuthSegment - segment='" + segment + "'"));
        ArrayList selectedServices = new ArrayList();
        XRDS xrdsOut = this.processAuthRefs(selectedServices, parent, segment, trustType, followRefs, state);
        if (this.maxRequests >= 0 && state.getNumRequests() >= this.maxRequests) {
            XRD finalXRD = xrdsOut.getFinalXRD();
            if (finalXRD == null) {
                finalXRD = this.createErrorXRD(segment.toURINormalForm(true), "202", "Maximum of authority resolution requests exceeded");
                xrdsOut.add(finalXRD);
            } else {
                finalXRD.setStatus(new Status("202", "Maximum of authority resolution requests exceeded"));
            }
            throw new PartialResolutionException(xrdsOut);
        }
        Throwable savedException = null;
        Iterator srvIterator = selectedServices.iterator();
        while (srvIterator.hasNext()) {
            Service srv = (Service)srvIterator.next();
            Iterator uriIterator = srv.getPrioritizedURIs().iterator();
            while (uriIterator.hasNext()) {
                URI newURI;
                SEPUri sepURI = (SEPUri)uriIterator.next();
                URI uri = sepURI.getURI();
                log.trace((Object)("resolveAuthSegment - trying URI='" + uri + "'"));
                if (trustType.isHTTPS() && !uri.getScheme().equals("https")) {
                    log.trace((Object)"resolveAuthSegment - skipping non HTTPS URI");
                    continue;
                }
                try {
                    newURI = this.constructAuthResURI(uri.toString(), segment.toURINormalForm(true));
                    log.trace((Object)("resolveAuthSegment - newURI = " + newURI));
                }
                catch (URISyntaxException oEx) {
                    savedException = new InvalidAuthorityURIException("Could not create URI to access based on " + uri + ".  Trying to resolve " + segment, oEx);
                    continue;
                }
                XRDS newXRDS = null;
                try {
                    InputStream in = this.getDataFromURI(segment.toString(), newURI, trustType, state);
                    newXRDS = this.readXRDS(in);
                    log.debug((Object)("Got XRDS = " + newXRDS.toString()));
                }
                catch (Exception e) {
                    log.trace((Object)"resolveAuthSegment - bad URI");
                    savedException = e;
                    continue;
                }
                for (int d = 0; d < newXRDS.getNumChildren() && d < segment.getNumSubSegments(); ++d) {
                    boolean bValid;
                    XRD xrd = newXRDS.getDescriptorAt(d);
                    Status stat = xrd.getStatus();
                    if (stat == null) {
                        xrd = this.createErrorXRD(segment.getSubSegmentAt(d).toString(), "223", "Status code was missing in original XRD");
                    }
                    if (!(bValid = xrd.isValid())) {
                        xrd = this.createErrorXRD(segment.getSubSegmentAt(d).toString(), "223", "Invalid XRD (stale?) received");
                    }
                    xrdsOut.add(xrd);
                    if (xrd.getStatus().getCode().equals("100")) continue;
                    throw new PartialResolutionException(xrdsOut);
                }
                if (newXRDS.getNumChildren() >= segment.getNumSubSegments()) {
                    return xrdsOut;
                }
                XRISegment remainder = segment.getRemainder(newXRDS.getNumChildren());
                XRDS remainderXRDS = null;
                try {
                    remainderXRDS = this.resolveAuthSegment(newXRDS.getDescriptorAt(newXRDS.getNumChildren() - 1), remainder, trustType, followRefs, state);
                }
                catch (PartialResolutionException e) {
                    xrdsOut.addAll(e.getPartialXRDS());
                    throw new PartialResolutionException(xrdsOut);
                }
                xrdsOut.addAll(remainderXRDS);
                return xrdsOut;
            }
        }
        if (savedException != null) {
            savedException.printStackTrace();
            if (savedException instanceof XRIResolutionException) {
                ((XRIResolutionException)savedException).printUnderlyingStackTrace();
            }
            XRD err = this.createErrorXRD(segment.getSubSegmentAt(0).toString(), "220", savedException.getMessage());
            xrdsOut.add(err);
            throw new PartialResolutionException(xrdsOut);
        }
        return xrdsOut;
    }

    public XRDS selectServiceFromXRD(XRD xrd, XRI qxri, TrustType trustType, String sepType, String sepMediaType, boolean followRefs, ResolverState state) throws PartialResolutionException {
        XRDS xrdsOut = new XRDS();
        String path = null;
        XRIAbsolutePath absPath = qxri.getXRIAbsolutePath();
        if (absPath != null) {
            path = absPath.toURINormalForm();
        }
        if (path != null && path.length() > 1 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        xrdsOut.add(xrd);
        ArrayList selectedSvcs = this.selectServices(xrd.getServices(), sepType, path, sepMediaType);
        if (selectedSvcs.size() == 0) {
            ArrayList refs = xrd.getPrioritizedRefs();
            if (refs.size() == 0) {
                Status s = new Status("241", "Requested service endpoint not found.");
                xrdsOut.getFinalXRD().setStatus(s);
                throw new PartialResolutionException(xrdsOut);
            }
            if (this.maxFollowRefs >= 0 && state.getNumRefsFollowed() >= this.maxFollowRefs) {
                Status s = new Status("202", "Maximum number of references exceeded");
                xrdsOut.getFinalXRD().setStatus(s);
                throw new PartialResolutionException(xrdsOut);
            }
            for (int i = 0; i < refs.size(); ++i) {
                Ref r = (Ref)refs.get(i);
                XRI refXRI = null;
                try {
                    refXRI = new XRI(r.getValue());
                }
                catch (XRIParseException e) {
                    log.warn((Object)("resolveAuthSegment - Invalid ref encountered: " + e.getMessage()));
                    if (i != refs.size()) continue;
                    Status s = new Status("241", "Invalid ref encountered: " + e.getMessage());
                    xrdsOut.getFinalXRD().setStatus(s);
                    throw new PartialResolutionException(xrdsOut);
                }
                state.pushFollowingRef(refXRI);
                XRDS refXRDS = null;
                try {
                    refXRDS = this.resolveAuthTop(refXRI, trustType, followRefs, state);
                }
                catch (PartialResolutionException e) {
                    xrdsOut.addAll(e.getPartialXRDS());
                    throw new PartialResolutionException(xrdsOut);
                }
                xrdsOut.add(refXRDS);
                XRDS resultXRDS = null;
                try {
                    resultXRDS = this.selectServiceFromXRD(refXRDS.getFinalXRD(), qxri, trustType, sepType, sepMediaType, followRefs, state);
                }
                catch (PartialResolutionException e) {
                    xrdsOut.replaceFinalXRD(e.getPartialXRDS());
                    throw new PartialResolutionException(xrdsOut);
                }
                xrdsOut.addAll(resultXRDS);
                return xrdsOut;
            }
        }
        xrd.setSelectedServices(selectedSvcs);
        return xrdsOut;
    }

    protected InputStream getDataFromURI(String query, URI uri, TrustType trustType, ResolverState state) throws XRIResolutionException, IOException {
        HttpURLConnection conn = null;
        InputStream in = null;
        try {
            int n;
            LinkedHashMap<String, String> requestProp = new LinkedHashMap<String, String>();
            String sContentType = "application/xrds+xml;trust=" + trustType;
            requestProp.put("Accept", sContentType);
            conn = IO.getConnectionToURI(uri, "GET", requestProp, this.moSocketFactory, this.maxHttpRedirects, false);
            if (conn.getResponseCode() != 200) {
                conn.disconnect();
                throw new XRIResolutionException("Got bad response code from URI: " + uri.toString() + ", code = " + conn.getResponseCode());
            }
            int bufSize = 4096;
            byte[] buf = new byte[bufSize];
            int bufIndex = 0;
            in = conn.getInputStream();
            while ((n = in.read()) != -1) {
                if (this.maxBytesPerRequest >= 0 && bufIndex >= this.maxBytesPerRequest) {
                    throw new XRIResolutionException("202", "Maximum response size exceeded");
                }
                if (this.maxTotalBytes >= 0 && state.getNumBytesReceived() + bufIndex >= this.maxTotalBytes) {
                    throw new XRIResolutionException("202", "Maximum total received bytes exceeded");
                }
                if (bufIndex >= bufSize) {
                    byte[] newBuf = new byte[bufSize * 2];
                    System.arraycopy(buf, 0, newBuf, 0, bufSize);
                    buf = newBuf;
                    bufSize *= 2;
                }
                buf[bufIndex++] = (byte)n;
            }
            String bufString = new String(buf, 0, bufIndex, "iso-8859-1");
            state.pushResolved(query, trustType.toString(), bufString, uri);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buf, 0, bufIndex);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            log.warn((Object)("Failed XRI lookup from " + uri.toString() + ".  IOException " + e));
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected XRDS readXRDS(InputStream in) throws XRIResolutionException {
        XRDS xrds = null;
        if (in == null) {
            return xrds;
        }
        try {
            DOMParser domParser = DOMUtils.getDOMParser();
            domParser.parse(new InputSource(in));
            Document doc = domParser.getDocument();
            Element element = doc.getDocumentElement();
            log.debug((Object)"Successfully read XRI Descriptor into DOM");
            xrds = new XRDS(element, true);
        }
        catch (IOException e) {
            throw new XRIResolutionException("IOException", e);
        }
        catch (SAXException e) {
            throw new XRIResolutionException("SAXException", e);
        }
        catch (URISyntaxException e) {
            throw new XRIResolutionException("URISyntaxException", e);
        }
        catch (ParseException e) {
            throw new XRIResolutionException("ParseException", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
        return xrds;
    }

    protected Service selectService(Vector services, String type, String path, String mediaType) {
        ArrayList res = this.selectServices(services, type, path, mediaType);
        return (Service)res.get(0);
    }

    protected ArrayList selectServicesURIs(Vector services, String type, String path, String mediaType) {
        ArrayList uris = new ArrayList();
        ArrayList selectedServices = this.selectServices(services, type, path, mediaType);
        if (selectedServices == null || selectedServices.size() < 1) {
            return uris;
        }
        for (int i = 0; i < selectedServices.size(); ++i) {
            Service s = (Service)selectedServices.get(i);
            uris.addAll(s.getPrioritizedURIs());
        }
        return uris;
    }

    protected ArrayList selectServices(Vector services, String type, String path, String mediaType) {
        if (services == null || services.size() == 0) {
            return new ArrayList();
        }
        SEPSelector selector = new SEPSelector(new ArrayList(services));
        ArrayList selectedServices = selector.getSelectedSEPs(type, mediaType, path);
        if (selectedServices == null || selectedServices.size() == 0) {
            return new ArrayList();
        }
        PrioritizedList list = new PrioritizedList();
        for (int i = 0; i < selectedServices.size(); ++i) {
            Service s = (Service)selectedServices.get(i);
            String priority = s.getPriority() == null ? "null" : s.getPriority().toString();
            list.addObject(priority, s);
        }
        return list.getList();
    }

    public XRD createErrorXRD(String query, String code, String msg) {
        XRD err = new XRD();
        err.setQuery(query);
        Status stat = new Status(code, msg);
        err.setStatus(stat);
        return err;
    }

    public URI constructAuthResURI(String sepURI, String segment) throws URISyntaxException {
        URI uri = new URI(sepURI);
        StringBuffer path = new StringBuffer(uri.getPath());
        if (path.length() <= 0 || path.charAt(path.length() - 1) != '/') {
            path.append('/');
        }
        path.append(segment);
        URI newURI = new URI(uri.getScheme(), uri.getAuthority(), path.toString(), uri.getQuery(), uri.getFragment());
        return newURI;
    }

    public String constructURI(URI sepURI, String append, XRI qxri) {
        log.trace((Object)("constructURI - sepURI=" + sepURI + ", append=" + append + ", qxri=" + qxri));
        StringBuffer result = new StringBuffer(sepURI.toString());
        if (!append.equals("none")) {
            if (append.equals("local")) {
                XRIQuery query;
                XRIPath path = qxri.getXRIPath();
                if (path != null) {
                    result.append(path.toURINormalForm());
                }
                if ((query = qxri.getQuery()) != null) {
                    result.append('?');
                    result.append(query);
                }
            } else if (append.equals("authority")) {
                AuthorityPath a = qxri.getAuthorityPath();
                if (a != null) {
                    result.append(a.toURINormalForm());
                }
            } else if (append.equals("path")) {
                XRIAbsolutePath p = qxri.getXRIAbsolutePath();
                if (p != null) {
                    result.append(p.toURINormalForm());
                }
            } else if (append.equals("query")) {
                XRIQuery q = qxri.getQuery();
                if (q != null && q.toString().length() > 0) {
                    result.append("?" + q.toString());
                }
            } else if (append.equals("qxri")) {
                String qxriParam = qxri.toURINormalForm();
                if (qxriParam.startsWith("xri://")) {
                    qxriParam = qxriParam.substring(6);
                }
                result.append(qxriParam);
            }
        }
        log.trace((Object)("constructURI - returning '" + result + "'"));
        return result.toString();
    }

    private XRI parseAbsoluteQXRIOrError(String qxri) throws PartialResolutionException {
        try {
            XRI xri = new XRI(qxri);
            if (xri.isRelative()) {
                XRD err = this.createErrorXRD(qxri, "211", "QXRI is not absolute.");
                throw new PartialResolutionException(err);
            }
            return xri;
        }
        catch (XRIParseException e) {
            XRD err = this.createErrorXRD(qxri, "211", "QXRI parse error: " + e.getMessage());
            throw new PartialResolutionException(err);
        }
    }

    protected XRI parseAbsoluteXRI(String qxri) {
        try {
            XRI xri = new XRI(qxri);
            if (xri.isRelative()) {
                log.warn((Object)("parseAbsoluteXRI - '" + qxri + "' is not absolute!"));
                return null;
            }
            return xri;
        }
        catch (XRIParseException e) {
            log.warn((Object)("parseAbsoluteXRI - failed to parse '" + qxri + "' - " + e.getMessage()));
            return null;
        }
    }

    public static void main(String[] args) {
        Resolver resolver = new Resolver();
        XRD eqRoot = new XRD();
        Service eqAuthService = new Service();
        eqAuthService.addMediaType("application/xrds+xml;trust=none", "content", Boolean.FALSE);
        eqAuthService.addType("xri://$res*auth*($v*2.0)");
        eqAuthService.addURI("http://equal.xri.net");
        eqRoot.addService(eqAuthService);
        XRD atRoot = new XRD();
        Service atAuthService = new Service();
        atAuthService.addMediaType("application/xrds+xml;trust=none", "content", Boolean.FALSE);
        atAuthService.addType("xri://$res*auth*($v*2.0)");
        atAuthService.addURI("http://at.xri.net");
        atRoot.addService(atAuthService);
        XRD bangRoot = new XRD();
        Service bangAuthService = new Service();
        bangAuthService.addMediaType("application/xrds+xml;trust=none", "content", Boolean.FALSE);
        bangAuthService.addType("xri://$res*auth*($v*2.0)");
        bangAuthService.addURI("http://bang.beta.xri.net/cgi-bin/xri");
        bangRoot.addService(bangAuthService);
        resolver.setAuthority("=", eqRoot);
        resolver.setAuthority("@", atRoot);
        resolver.setAuthority("!", bangRoot);
        resolver.setProxyURI(URI.create("http://localhost:8080/"));
        ResolverState state = new ResolverState();
        XRDS xrds = null;
        try {
            ArrayList uriList = resolver.resolveSEPToURIList("=iservices.test2/(+%C3%BCer)", new TrustType(), null, null, true, state);
            System.out.println();
            URI u = new URI((String)uriList.get(0));
            System.out.println("URI=" + u);
        }
        catch (PartialResolutionException e) {
            System.err.println("Resolution FAILED! Partial XRDS:");
            xrds = e.getPartialXRDS();
        }
        catch (URISyntaxException e) {
            System.err.println("Resolution FAILED! " + e.getMessage());
        }
        System.out.println(xrds);
        System.out.println("ResolverState = " + state.toString());
    }

    public void setMaxFollowRefs(int maxFollowRefs) {
        this.maxFollowRefs = maxFollowRefs;
    }

    public void setMaxRequests(int maxRequests) {
        this.maxRequests = maxRequests;
    }

    public void setMaxTotalBytes(int maxTotalBytes) {
        this.maxTotalBytes = maxTotalBytes;
    }

    public void setMaxBytesPerRequest(int maxBytesPerRequest) {
        this.maxBytesPerRequest = maxBytesPerRequest;
    }
}

