/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.wotaskd;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOHttpIO;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation._NSCollectionReaderWriterLock;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.MSiteConfig;
import com.webobjects.monitor._private.String_Extensions;
import com.webobjects.monitor.wotaskd.LifebeatRequestHandler;
import com.webobjects.monitor.wotaskd.LocalMonitor;
import com.webobjects.monitor.wotaskd.SiteConfig;
import er.extensions.appserver.ERXApplication;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class Application
extends ERXApplication {
    private LocalMonitor _localMonitor;
    private MSiteConfig _siteConfig;
    private ListenThread listenThread;
    private LifebeatRequestHandler _lifebeatRequestHandler;
    private Number _port;
    private int _intPort;
    private String _multicastAddress;
    private boolean _shouldWriteAdaptorConfig;
    private boolean _shouldRespondToMulticast;
    public _NSCollectionReaderWriterLock _lock = new _NSCollectionReaderWriterLock();
    private MBeanServer _mbeanServer;
    private String _mbsDomain;
    private String _jmxPort = null;
    private String _jmxAccessFile = null;
    private String _jmxPasswordFile = null;

    public static void main(String[] argv) {
        ERXApplication.main((String[])argv, Application.class);
    }

    public String defaultRequestHandlerClassName() {
        return "com.webobjects.appserver._private.WODirectActionRequestHandler";
    }

    public String name() {
        return "wotaskd";
    }

    public Number port() {
        if (this._port == null) {
            this._port = super.port().intValue() > 0 ? (Number)super.port() : (Number)new Integer(1085);
            this._intPort = this._port.intValue();
        }
        return this._port;
    }

    private int intPort() {
        return this._intPort;
    }

    public String multicastAddress() {
        return this._multicastAddress;
    }

    public boolean allowsConcurrentRequestHandling() {
        return true;
    }

    public MSiteConfig siteConfig() {
        return this._siteConfig;
    }

    public void setSiteConfig(MSiteConfig aConfig) {
        this._siteConfig = aConfig;
    }

    public LocalMonitor localMonitor() {
        return this._localMonitor;
    }

    public boolean shouldWriteAdaptorConfig() {
        return this._shouldWriteAdaptorConfig;
    }

    public boolean shouldRespondToMulticast() {
        return this._shouldRespondToMulticast;
    }

    public Application() {
        String shouldMC;
        String dd = System.getProperties().getProperty("_DeploymentDebugging");
        if (dd != null) {
            NSLog.debug.setIsVerbose(true);
            NSLog.out.setIsVerbose(true);
            NSLog.err.setIsVerbose(true);
            NSLog.allowDebugLoggingForGroups((long)0x400000L);
            NSLog.debug.setAllowedDebugLevel(3);
        }
        WOHttpIO._alwaysAppendContentLength = false;
        this._setLifebeatDestinationPort(this.intPort());
        this._multicastAddress = System.getProperties().getProperty("WOMulticastAddress");
        if (this._multicastAddress == null) {
            this._multicastAddress = "239.128.14.2";
        }
        this._lifebeatRequestHandler = new LifebeatRequestHandler();
        this.registerRequestHandler(this._lifebeatRequestHandler, "wlb");
        this.removeRequestHandlerForKey("wo");
        this.removeRequestHandlerForKey("wr");
        this.removeRequestHandlerForKey("womp");
        this._siteConfig = MSiteConfig.unarchiveSiteConfig((boolean)true);
        this._siteConfig.archiveSiteConfig();
        this._localMonitor = new LocalMonitor();
        String WOSavesAdaptorConfig = System.getProperties().getProperty("WOSavesAdaptorConfiguration");
        if (WOSavesAdaptorConfig != null) {
            this._shouldWriteAdaptorConfig = String_Extensions.boolValue((String)WOSavesAdaptorConfig);
            if (this._shouldWriteAdaptorConfig) {
                this._siteConfig.archiveAdaptorConfig();
            }
        } else {
            this._shouldWriteAdaptorConfig = false;
        }
        if ((shouldMC = System.getProperties().getProperty("WORespondsToMulticastQuery")) != null) {
            if (!String_Extensions.boolValue((String)shouldMC)) {
                this._shouldRespondToMulticast = false;
                NSLog.debug.appendln((Object)"Multicast Response Disabled");
            } else {
                this._shouldRespondToMulticast = true;
                NSLog.debug.appendln((Object)"Multicast Response Enabled");
            }
        }
        this._jmxPort = System.getProperty("WOJMXPort");
        this._jmxAccessFile = System.getProperty("WOJMXAccessFile");
        this._jmxPasswordFile = System.getProperty("WOJMXPasswordFile");
        if (this._jmxPort != null) {
            this.registerMBean(SiteConfig.getInstance(), "WotaskdJMXMBean", "SiteConfigMBean");
            this.setupRemoteMonitoring();
        }
        this.createRequestListenerThread();
    }

    public void registerMBean(Object objMBean, String strDomainName, String strMBeanName) throws IllegalArgumentException {
        if (objMBean == null) {
            throw new IllegalArgumentException("Error: Could not register null to PlatformMbeanServer.");
        }
        if (strMBeanName == null) {
            throw new IllegalArgumentException("Error: MBean name could not be null.");
        }
        ObjectName objName = null;
        strDomainName = strDomainName == null ? this.getJMXDomain() : strDomainName;
        try {
            objName = new ObjectName(strDomainName + ": name=" + strMBeanName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        try {
            this.getMBeanServer().registerMBean(objMBean, objName);
        }
        catch (IllegalAccessException e) {
            NSLog.err.appendln((Object)("ERROR: security access problem registering bean: " + objMBean + " with ObjectName: " + objName + " " + e.toString()));
        }
        catch (InstanceAlreadyExistsException e) {
            NSLog.err.appendln((Object)("ERROR: MBean already exists bean: " + objMBean + " with ObjectName: " + objName + " " + e.toString()));
        }
        catch (MBeanRegistrationException e) {
            NSLog.err.appendln((Object)("ERROR: error registering bean: " + objMBean + " with ObjectName: " + objName + " " + e.toString()));
        }
        catch (NotCompliantMBeanException e) {
            NSLog.err.appendln((Object)("ERROR: error registering bean: " + objMBean + " with ObjectName: " + objName + " " + e.toString()));
        }
    }

    public String getJMXDomain() {
        if (this._mbsDomain == null) {
            this._mbsDomain = this.host() + "." + this.name() + "." + this.port();
        }
        return this._mbsDomain;
    }

    public void setupRemoteMonitoring() {
        if (this._jmxPort != null) {
            try {
                int intWotaskdJmxPort = Integer.parseInt(this._jmxPort);
                HashMap<String, String> envPwd = new HashMap<String, String>();
                envPwd.put("jmx.remote.x.password.file", this._jmxPasswordFile);
                envPwd.put("jmx.remote.x.access.file", this._jmxAccessFile);
                LocateRegistry.createRegistry(intWotaskdJmxPort);
                JMXServiceURL jsUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host() + ":" + intWotaskdJmxPort + "/jmxrmi");
                NSLog.debug.appendln((Object)("Setting up monitoring on url : " + jsUrl));
                JMXConnectorServer jmxCS = JMXConnectorServerFactory.newJMXConnectorServer(jsUrl, envPwd, this.getMBeanServer());
                jmxCS.start();
            }
            catch (Exception anException) {
                NSLog.err.appendln((Object)("Error starting remote monitoring: " + anException));
            }
        }
    }

    public MBeanServer getMBeanServer() throws IllegalAccessException {
        if (this._mbeanServer == null) {
            this._mbeanServer = ManagementFactory.getPlatformMBeanServer();
            if (this._mbeanServer == null) {
                throw new IllegalAccessException("Error: PlatformMBeanServer could not be accessed via ManagementFactory.");
            }
        }
        return this._mbeanServer;
    }

    public void readSiteConfigXML() {
        NSLog.debug.appendln((Object)"Inside readSiteConfigXML method of Application.java: Calling unarchiveSiteConfig");
        this._siteConfig = MSiteConfig.unarchiveSiteConfig((boolean)true);
        NSLog.debug.appendln((Object)"Inside readSiteConfigXML method of Application.java: Calling archiveSiteConfig");
        this._siteConfig.archiveSiteConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleep() {
        this._lock.startReading();
        try {
            if (this._siteConfig != null && this._siteConfig.hasChanges()) {
                this._siteConfig.archiveSiteConfig();
                if (this._shouldWriteAdaptorConfig) {
                    this._siteConfig.archiveAdaptorConfig();
                }
                this._siteConfig.resetChanges();
            }
        }
        finally {
            this._lock.endReading();
        }
    }

    public void createRequestListenerThread() {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"Detaching request listen thread");
        }
        this.listenThread = new ListenThread();
        this.listenThread.start();
    }

    public void finalize() throws Throwable {
        this.listenThread.closeRequestSocket();
        this.listenThread.stop();
        super.finalize();
    }

    public WORequest createRequest(String aMethod, String aURL, String anHTTPVersion, NSDictionary someHeaders, NSData aContent, NSDictionary someInfo) {
        if (anHTTPVersion == null && aURL != null && aURL.endsWith(" HTTP/1.0")) {
            anHTTPVersion = MObject._HTTP1;
            aURL = aURL.substring(0, aURL.length() - MObject._HTTP1.length() - 1);
        }
        return super._createRequest(aMethod, aURL, anHTTPVersion, someHeaders, aContent, someInfo);
    }

    public WOResponse dispatchRequest(WORequest aRequest) {
        WORequestHandler aHandler = this.handlerForRequest(aRequest);
        if (aHandler != null && aHandler == this._lifebeatRequestHandler) {
            _TheLastApplicationAccessTime = System.currentTimeMillis();
            return aHandler.handleRequest(aRequest);
        }
        return super.dispatchRequest(aRequest);
    }

    class ListenThread
    extends Thread {
        MulticastSocket socket;
        InetAddress address;

        ListenThread() {
        }

        private void createRequestSocket() {
            try {
                this.socket = new MulticastSocket(Application.this.intPort());
                if (!WOApplication.application()._unsetHost) {
                    this.socket.setInterface(WOApplication.application().hostAddress());
                }
            }
            catch (IOException exception) {
                NSLog.err.appendln((Object)("Unable to create multicast listener socket: " + exception));
                NSLog.err.appendln((Object)("Port " + Application.this.intPort() + " may be in use by another application."));
                NSLog.err.appendln((Object)"Exiting...");
                System.exit(1);
            }
            if (Application.this._shouldRespondToMulticast) {
                try {
                    this.address = InetAddress.getByName(Application.this.multicastAddress());
                }
                catch (UnknownHostException exception) {
                    NSLog.err.appendln((Object)("Error resolving address: " + Application.this.multicastAddress() + " - " + exception));
                    NSLog.err.appendln((Object)"Exiting...");
                    System.exit(1);
                }
                if (!this.address.isMulticastAddress()) {
                    NSLog.err.appendln((Object)(this.address + " is not a valid multicast address"));
                    NSLog.err.appendln((Object)"Exiting...");
                    System.exit(1);
                }
                try {
                    this.socket.joinGroup(this.address);
                }
                catch (IOException exception) {
                    NSLog.err.appendln((Object)("Error joining multicast group: " + exception));
                    NSLog.err.appendln((Object)"Exiting...");
                    System.exit(1);
                }
            }
        }

        public void closeRequestSocket() {
            try {
                this.socket.leaveGroup(this.address);
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
                    NSLog.debug.appendln((Object)"Leaving multicast group");
                }
            }
            catch (IOException exception) {
                if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x400000L)) {
                    NSLog.debug.appendln((Object)("Error leaving multicast group " + exception));
                }
                return;
            }
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
                NSLog.debug.appendln((Object)"Closing request listen socket");
            }
            this.socket.close();
        }

        public void sendReplyWithLengthTo(byte[] aReplyBytes, int aReplyBytesLength, DatagramPacket incomingPacket) {
            DatagramPacket outgoingPacket = new DatagramPacket(aReplyBytes, aReplyBytesLength, incomingPacket.getAddress(), incomingPacket.getPort());
            try {
                this.socket.send(outgoingPacket);
            }
            catch (IOException localException) {
                NSLog.err.appendln((Object)("Error sending reply: " + localException + " (ignored)"));
            }
        }

        private boolean byteArrayStartsWith(byte[] anArray, byte[] anotherArray, int aLength) {
            for (int i = 0; i < aLength; ++i) {
                if (anArray[i] == anotherArray[i]) continue;
                return false;
            }
            return true;
        }

        public void listenForRequests() {
            block9: {
                try {
                    byte[] versionReply;
                    byte[] versionRequest;
                    byte[] multicastReply;
                    byte[] multicastRequest;
                    String myName = WOApplication.application().host().toLowerCase() + ":" + Application.this.intPort();
                    try {
                        multicastRequest = "GET CONFIG-URL".getBytes("UTF-8");
                        multicastReply = ("http://" + myName + '\u0000').getBytes("UTF-8");
                        versionRequest = "womp://queryVersion".getBytes("UTF-8");
                        versionReply = ("womp://replyVersion/" + myName + ":webObjects5.0" + '\u0000').getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException uee) {
                        multicastRequest = "GET CONFIG-URL".getBytes();
                        multicastReply = ("http://" + myName + '\u0000').getBytes();
                        versionRequest = "womp://queryVersion".getBytes();
                        versionReply = ("womp://replyVersion/" + myName + ":webObjects5.0" + '\u0000').getBytes();
                    }
                    int multicastRequestLength = multicastRequest.length;
                    int multicast_reply_len = multicastReply.length;
                    int versionRequestLength = versionRequest.length;
                    int version_reply_len = versionReply.length;
                    byte[] mbuffer = new byte[1000];
                    DatagramPacket incomingPacket = new DatagramPacket(mbuffer, mbuffer.length);
                    while (this.socket != null) {
                        try {
                            incomingPacket.setLength(mbuffer.length);
                            this.socket.receive(incomingPacket);
                            if (this.byteArrayStartsWith(incomingPacket.getData(), multicastRequest, multicastRequestLength)) {
                                this.sendReplyWithLengthTo(multicastReply, multicast_reply_len, incomingPacket);
                                continue;
                            }
                            if (this.byteArrayStartsWith(incomingPacket.getData(), versionRequest, versionRequestLength)) {
                                this.sendReplyWithLengthTo(versionReply, version_reply_len, incomingPacket);
                                continue;
                            }
                            String key = incomingPacket.getAddress() + ":" + incomingPacket.getPort();
                            Application.this.siteConfig().globalErrorDictionary.takeValueForKey((Object)(myName + ": Unrecognized UDP packet: " + new String(incomingPacket.getData()) + " from " + key + ". This may be an Application that conforms to an older protocol."), key);
                            if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x400000L)) continue;
                            NSLog.debug.appendln((Object)(myName + ": Unrecognized UDP packet: " + new String(incomingPacket.getData()) + " from " + key + ". This may be an Application that conforms to an older protocol."));
                        }
                        catch (IOException localException) {
                            NSLog.err.appendln((Object)("Error receiving packet: " + localException + " (ignored)"));
                        }
                    }
                    NSLog.err.appendln((Object)"wotaskd listen thread exiting because of bad socket");
                }
                catch (Throwable t) {
                    NSLog.err.appendln((Object)("Listen thread exiting with exception: " + t));
                    if (!NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x400000L)) break block9;
                    NSLog.debug.appendln(t);
                }
            }
            System.exit(1);
        }

        public void run() {
            this.createRequestSocket();
            NSLog.debug.appendln((Object)"Created UDP socket; listening for requests...");
            this.listenForRequests();
        }
    }
}

