/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.wotaskd;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WOHostUtilities;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor.wotaskd.Application;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class LifebeatRequestHandler
extends WORequestHandler {
    private static final Logger log = Logger.getLogger(LifebeatRequestHandler.class);
    InetAddress myInetAddress;
    String myName;
    Application theApplication = (Application)WOApplication.application();
    WOResponse BadLifebeatResponse;
    WOResponse GoodResponse;
    WOResponse DieResponse;

    public LifebeatRequestHandler() {
        this.myInetAddress = this.theApplication.hostAddress();
        this.myName = this.myInetAddress.getHostName();
        this.GoodResponse = this.theApplication.createResponseInContext(null);
        this.GoodResponse.setStatus(200);
        this.GoodResponse.setHTTPVersion("HTTP/1.1");
        this.BadLifebeatResponse = this.theApplication.createResponseInContext(null);
        this.BadLifebeatResponse.setStatus(400);
        this.BadLifebeatResponse.setHTTPVersion("HTTP/1.0");
        this.DieResponse = this.theApplication.createResponseInContext(null);
        this.DieResponse.setStatus(500);
        this.DieResponse.setHTTPVersion("HTTP/1.0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WOResponse handleRequest(WORequest aRequest) {
        Object aResponse = null;
        if (!aRequest.isUsingWebServer() && WOHostUtilities.isLocalInetAddress((InetAddress)aRequest._originatingAddress(), (boolean)true)) {
            Object lock = WOApplication.application().requestHandlingLock();
            if (lock != null) {
                Object object = lock;
                synchronized (object) {
                    return this._handleRequest(aRequest);
                }
            }
            return this._handleRequest(aRequest);
        }
        return null;
    }

    private WOResponse _handleRequest(WORequest aRequest) {
        WOResponse aResponse = this.BadLifebeatResponse;
        NSArray values = NSArray.componentsSeparatedByString((String)aRequest.queryString(), (String)"&");
        if (values == null || values.count() != 4) {
            this.theApplication.siteConfig().globalErrorDictionary.takeValueForKey((Object)(this.myName + ": Received bad lifebeat: " + aRequest.queryString()), aRequest.queryString());
            log.error((Object)(this.myName + ": Received bad lifebeat: " + aRequest.queryString()));
        } else {
            String notificationType = (String)values.objectAtIndex(0);
            String instanceName = (String)values.objectAtIndex(1);
            String host = (String)values.objectAtIndex(2);
            String port = (String)values.objectAtIndex(3);
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)2, (long)0x400000L)) {
                NSLog.debug.appendln((Object)("@@@@@ Received Lifebeat: " + notificationType + " " + instanceName + " " + host + " " + port));
            }
            if (notificationType.equals("lifebeat")) {
                aResponse = !this.registerLifebeat(instanceName, host, port) ? this.DieResponse : this.GoodResponse;
            } else if (notificationType.equals("hasStarted")) {
                this.registerStart(instanceName, host, port);
                aResponse = this.GoodResponse;
            } else if (notificationType.equals("willStop")) {
                this.registerStop(instanceName, host, port);
                aResponse = null;
            } else if (notificationType.equals("willCrash")) {
                this.registerCrash(instanceName, host, port);
                aResponse = null;
            } else {
                this.theApplication.siteConfig().globalErrorDictionary.takeValueForKey((Object)(this.myName + ": Received bad lifebeat: " + aRequest.queryString()), aRequest.queryString());
                log.error((Object)(this.myName + ": Received bad lifebeat: " + aRequest.queryString()));
            }
        }
        if ("HTTP/1.0".equals(aRequest.httpVersion())) {
            aResponse = null;
        }
        return aResponse;
    }

    private InetAddress addressForName(String name) {
        try {
            return InetAddress.getByName(name);
        }
        catch (UnknownHostException uhe) {
            log.error((Object)("Unknown host: " + name));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerStart(String instanceName, String host, String port) {
        InetAddress hostAddress = this.addressForName(host);
        this.theApplication._lock.startReading();
        try {
            MInstance instance = ((Application)WOApplication.application()).siteConfig().instanceWithHostAndPort(instanceName, hostAddress, port);
            if (instance != null) {
                instance.startRegistration(new NSTimestamp());
                instance.setShouldDie(false);
            } else {
                ((Application)WOApplication.application()).localMonitor().registerUnknownInstance(instanceName, host, port);
            }
        }
        finally {
            this.theApplication._lock.endReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerLifebeat(String instanceName, String host, String port) {
        InetAddress hostAddress = this.addressForName(host);
        this.theApplication._lock.startReading();
        try {
            MInstance instance = ((Application)WOApplication.application()).siteConfig().instanceWithHostAndPort(instanceName, hostAddress, port);
            if (instance != null) {
                instance.updateRegistration(new NSTimestamp());
                boolean bl = !instance.shouldDieAndReset();
                return bl;
            }
            ((Application)WOApplication.application()).localMonitor().registerUnknownInstance(instanceName, host, port);
        }
        finally {
            this.theApplication._lock.endReading();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerStop(String instanceName, String host, String port) {
        InetAddress hostAddress = this.addressForName(host);
        this.theApplication._lock.startReading();
        try {
            MInstance instance = ((Application)WOApplication.application()).siteConfig().instanceWithHostAndPort(instanceName, hostAddress, port);
            if (instance != null) {
                instance.registerStop(new NSTimestamp());
                instance.setShouldDie(false);
                instance.cancelForceQuitTask();
            }
        }
        finally {
            this.theApplication._lock.endReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCrash(String instanceName, String host, String port) {
        InetAddress hostAddress = this.addressForName(host);
        this.theApplication._lock.startReading();
        try {
            MInstance instance = ((Application)WOApplication.application()).siteConfig().instanceWithHostAndPort(instanceName, hostAddress, port);
            if (instance != null) {
                instance.registerCrash(new NSTimestamp());
                instance.setShouldDie(false);
                instance.cancelForceQuitTask();
            }
        }
        finally {
            this.theApplication._lock.endReading();
        }
    }
}

