/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.wotaskd;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WOHTTPConnection;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOTimer;
import com.webobjects.appserver._private.WOHostUtilities;
import com.webobjects.appserver.xml._JavaMonitorCoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLog;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSSocketUtilities;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSCollectionReaderWriterLock;
import com.webobjects.monitor._private.MApplication;
import com.webobjects.monitor._private.MHost;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MObject;
import com.webobjects.monitor._private.MSiteConfig;
import com.webobjects.monitor._private.MonitorException;
import com.webobjects.monitor._private.ProtoLocalMonitor;
import com.webobjects.monitor._private.String_Extensions;
import com.webobjects.monitor.wotaskd.Application;
import com.webobjects.monitor.wotaskd.MInstanceTask;
import er.extensions.foundation.ERXProperties;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.TimerTask;

public class LocalMonitor
extends ProtoLocalMonitor {
    WOTimer aScheduleTimer;
    WOTimer anAutoRecoverTimer;
    WOTimer anAutoRecoverStartupTimer;
    String _hostName;
    boolean _isOnWindows = false;
    boolean _shouldUseSpawn = true;
    String spawningGrounds = null;
    Application theApplication = (Application)WOApplication.application();
    final int _forceQuitDelay = ERXProperties.intForKeyWithDefault((String)"WOTaskd.killTimeout", (int)120000);
    final int _receiveTimeout = ERXProperties.intForKeyWithDefault((String)"WOTaskd.receiveTimeout", (int)5000);
    final boolean _forceQuitTaskEnabled = ERXProperties.booleanForKeyWithDefault((String)"WOTaskd.forceQuitTaskEnabled", (boolean)false);
    NSMutableDictionary _unknownApplications = new NSMutableDictionary();
    _NSCollectionReaderWriterLock _unknownAppLock = new _NSCollectionReaderWriterLock();

    public LocalMonitor() {
        MSiteConfig aConfig = this.theApplication.siteConfig();
        if (System.getProperties().getProperty("os.name").toLowerCase().startsWith("win")) {
            this._isOnWindows = true;
        }
        this._shouldUseSpawn = String_Extensions.boolValue((String)System.getProperty("WOShouldUseSpawn"));
        if (this._shouldUseSpawn) {
            String appDir = System.getProperties().getProperty("user.dir");
            appDir = NSPathUtilities.stringByAppendingPathComponent((String)appDir, (String)"Contents");
            appDir = NSPathUtilities.stringByAppendingPathComponent((String)appDir, (String)"Resources");
            appDir = this._isOnWindows ? NSPathUtilities.stringByAppendingPathComponent((String)appDir, (String)"SpawnOfWotaskd.exe") : NSPathUtilities.stringByAppendingPathComponent((String)appDir, (String)"SpawnOfWotaskd.sh");
            this.spawningGrounds = appDir + " ";
            File theApp = new File(appDir);
            if (!theApp.exists() || !theApp.isFile()) {
                this._shouldUseSpawn = false;
            }
        }
        this.anAutoRecoverStartupTimer = WOTimer.scheduledTimer((long)aConfig.autoRecoverInterval(), (Object)((Object)this), (String)"_checkAutoRecoverStartup", null, null, (boolean)false);
        this._hostName = this.theApplication.host();
    }

    private NSTimestamp calculateNearestHour() {
        NSTimestamp currentTime = new NSTimestamp();
        NSTimeZone currentTimeZone = currentTime.timeZone();
        int currentYear = currentTime.yearOfCommonEra();
        int currentMonth = currentTime.monthOfYear();
        int currentDayOfMonth = currentTime.dayOfMonth();
        int currentHourOfDay = currentTime.hourOfDay();
        return new NSTimestamp(currentYear, currentMonth, currentDayOfMonth, currentHourOfDay + 1, 0, 0, (TimeZone)currentTimeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUnknownInstance(String name, String host, String port) {
        this._unknownAppLock.startWriting();
        try {
            NSTimestamp currentTime = new NSTimestamp();
            if (WOHostUtilities.isLocalInetAddress((InetAddress)InetAddress.getByName(host), (boolean)false)) {
                NSMutableDictionary appDict = (NSMutableDictionary)this._unknownApplications.valueForKey(name);
                if (appDict != null) {
                    appDict.takeValueForKey((Object)currentTime, port);
                } else {
                    this._unknownApplications.takeValueForKey((Object)new NSMutableDictionary((Object)currentTime, (Object)port), name);
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            this._unknownAppLock.endWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String portForUnregisteredAppNamed(String name) {
        this._unknownAppLock.startReading();
        try {
            NSArray keysArray;
            NSDictionary appDict = (NSDictionary)this._unknownApplications.valueForKey(name);
            if (appDict != null && (keysArray = appDict.allKeys()) != null && keysArray.count() > 0) {
                String string = (String)keysArray.objectAtIndex(0);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this._unknownAppLock.endReading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triageUnknownInstances() {
        this._unknownAppLock.startWriting();
        try {
            NSMutableDictionary unknownApps = this._unknownApplications;
            NSTimestamp cutOffDate = new NSTimestamp(System.currentTimeMillis() - 45000L);
            NSArray unknownAppKeys = unknownApps.allKeys();
            Enumeration e = unknownAppKeys.objectEnumerator();
            while (e.hasMoreElements()) {
                String unknownAppKey = (String)e.nextElement();
                NSMutableDictionary appDict = (NSMutableDictionary)unknownApps.valueForKey(unknownAppKey);
                if (appDict == null) continue;
                NSArray appDictKeys = appDict.allKeys();
                Enumeration e2 = appDictKeys.objectEnumerator();
                while (e2.hasMoreElements()) {
                    String appDictKey = (String)e2.nextElement();
                    NSTimestamp lastLifebeat = (NSTimestamp)appDict.valueForKey(appDictKey);
                    if (lastLifebeat == null || !lastLifebeat.before((Timestamp)cutOffDate)) continue;
                    appDict.removeObjectForKey((Object)appDictKey);
                }
                if (appDict.count() != 0) continue;
                unknownApps.removeObjectForKey((Object)unknownAppKey);
            }
        }
        finally {
            this._unknownAppLock.endWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer generateAdaptorConfigXML() {
        StringBuffer sb = null;
        this._unknownAppLock.startReading();
        try {
            NSMutableDictionary unknownApps = this._unknownApplications;
            sb = new StringBuffer();
            if (unknownApps.count() == 0) {
                StringBuffer stringBuffer = sb;
                return stringBuffer;
            }
            Enumeration e = unknownApps.keyEnumerator();
            while (e.hasMoreElements()) {
                String appName = (String)e.nextElement();
                NSMutableDictionary appDict = (NSMutableDictionary)unknownApps.valueForKey(appName);
                sb.append("  <application name=\"");
                sb.append(appName);
                sb.append("\">\n");
                Enumeration e2 = appDict.keyEnumerator();
                while (e2.hasMoreElements()) {
                    String port = (String)e2.nextElement();
                    sb.append("    <instance");
                    sb.append(" id=\"-");
                    sb.append(port);
                    sb.append("\" port=\"");
                    sb.append(port);
                    sb.append("\" host=\"");
                    sb.append(this._hostName);
                    sb.append("\"/>\n");
                }
                sb.append("  </application>\n");
            }
        }
        finally {
            this._unknownAppLock.endReading();
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _checkAutoRecover() {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"_checkAutoRecover START");
        }
        this.theApplication._lock.startReading();
        try {
            MHost theHost = this.theApplication.siteConfig().localHost();
            if (theHost != null) {
                NSMutableArray instArray = theHost.instanceArray();
                int instArrayCount = instArray.count();
                for (int i = 0; i < instArrayCount; ++i) {
                    MInstance anInst = (MInstance)instArray.objectAtIndex(i);
                    if (anInst.isRunning_W() || anInst.state == MObject.STARTING || !anInst.isAutoRecovering() && !anInst.isScheduled()) continue;
                    anInst.setRefusingNewSessions(false);
                    this.startInstance(anInst);
                }
            }
            this.triageUnknownInstances();
        }
        finally {
            this.theApplication._lock.endReading();
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"_checkAutoRecover STOP");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _checkAutoRecoverStartup() {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"_checkAutoRecoverStartup START");
        }
        this.theApplication._lock.startReading();
        try {
            MSiteConfig aConfig = this.theApplication.siteConfig();
            NSMutableArray appArray = aConfig.applicationArray();
            int appArrayCount = appArray.count();
            final LocalMonitor localMonitor = this;
            Thread[] workers = new Thread[appArrayCount];
            int i = 0;
            while (i < workers.length) {
                int j = i++;
                Runnable work = new Runnable((NSArray)appArray, j){
                    final /* synthetic */ NSArray val$appArray;
                    final /* synthetic */ int val$j;
                    {
                        this.val$appArray = nSArray;
                        this.val$j = n;
                    }

                    public void run() {
                        localMonitor._autoRecoverApplication((MApplication)this.val$appArray.objectAtIndex(this.val$j));
                    }
                };
                workers[j] = new Thread(work);
                workers[j].start();
            }
            try {
                for (i = 0; i < workers.length; ++i) {
                    workers[i].join();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            NSTimestamp fireDate = this.calculateNearestHour();
            this.aScheduleTimer = new WOTimer(fireDate, 3600000L, (Object)this, "_checkSchedules", null, null, true);
            this.aScheduleTimer.schedule();
            this.anAutoRecoverTimer = WOTimer.scheduledTimer((long)aConfig.autoRecoverInterval(), (Object)((Object)this), (String)"_checkAutoRecover", null, null, (boolean)true);
        }
        finally {
            this.theApplication._lock.endReading();
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"_checkAutoRecoverStartup STOP");
        }
    }

    private void _autoRecoverApplication(MApplication anApplication) {
        NSArray instArray = anApplication.instanceArray();
        int instArrayCount = instArray.count();
        Integer tfs = anApplication.timeForStartup();
        long timeForStartup = tfs != null ? (long)tfs.intValue() : MInstance.TIME_FOR_STARTUP;
        timeForStartup *= 1000L;
        boolean phasedStartup = false;
        Boolean pS = anApplication.phasedStartup();
        if (pS != null) {
            phasedStartup = pS;
        }
        for (int i = 0; i < instArrayCount; ++i) {
            MInstance anInst = (MInstance)instArray.objectAtIndex(i);
            if (!anInst.isLocal_W() || anInst.isRunning_W() || anInst.state == MObject.STARTING || !anInst.isAutoRecovering() && !anInst.isScheduled()) continue;
            anInst.setRefusingNewSessions(false);
            this.startInstance(anInst);
            if (!phasedStartup || i >= instArrayCount - 1) continue;
            try {
                Thread.sleep(timeForStartup);
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _checkSchedules() {
        block11: {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
                NSLog.debug.appendln((Object)"_checkSchedules START");
            }
            this.theApplication._lock.startReading();
            try {
                MHost theHost = this.theApplication.siteConfig().localHost();
                if (theHost == null) break block11;
                NSMutableArray instArray = theHost.instanceArray();
                int instArrayCount = instArray.count();
                if (instArrayCount == 0) {
                    return;
                }
                NSTimestamp rightNow = new NSTimestamp(System.currentTimeMillis(), TimeZone.getDefault());
                Thread[] workers = new Thread[instArrayCount];
                LocalMonitor localMonitor = this;
                int i = 0;
                while (i < instArrayCount) {
                    int j = i++;
                    Runnable work = new Runnable((NSArray)instArray, j, rightNow, localMonitor){
                        final /* synthetic */ NSArray val$instArray;
                        final /* synthetic */ int val$j;
                        final /* synthetic */ NSTimestamp val$rightNow;
                        final /* synthetic */ LocalMonitor val$localMonitor;
                        {
                            this.val$instArray = nSArray;
                            this.val$j = n;
                            this.val$rightNow = nSTimestamp;
                            this.val$localMonitor = localMonitor2;
                        }

                        public void run() {
                            try {
                                MInstance anInst = (MInstance)this.val$instArray.objectAtIndex(this.val$j);
                                if (anInst.isScheduled() && anInst.nearNextScheduledShutdown(this.val$rightNow)) {
                                    if (anInst.isGracefullyScheduled()) {
                                        this.val$localMonitor.stopInstance(anInst);
                                    } else {
                                        this.val$localMonitor.terminateInstance(anInst);
                                    }
                                    anInst.calculateNextScheduledShutdown();
                                }
                            }
                            catch (MonitorException me) {
                                NSLog.err.appendln((Object)("Exception while scheduling: " + me.getMessage()));
                            }
                        }
                    };
                    workers[j] = new Thread(work);
                    workers[j].start();
                }
                try {
                    for (i = 0; i < workers.length; ++i) {
                        workers[i].join();
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            finally {
                this.theApplication._lock.endReading();
            }
        }
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"_checkSchedules STOP");
        }
    }

    public String startInstance(MInstance anInstance) {
        MSiteConfig aConfig = this.theApplication.siteConfig();
        if (anInstance == null) {
            return "Attempt to start null instance on " + this._hostName;
        }
        if (anInstance.host() != aConfig.localHost()) {
            return anInstance.displayName() + " does not exist on " + this._hostName + "; START instance failed";
        }
        if (anInstance.isRunning_W()) {
            return null;
        }
        if (anInstance.state == MObject.STARTING) {
            return null;
        }
        if (this._testConnection(anInstance)) {
            return this._hostName + ": " + anInstance.displayName() + " cannot be started because port " + anInstance.port() + " is still in use";
        }
        String aFullPath = anInstance.path();
        if (aFullPath == null) {
            return this._hostName + ": Path for " + anInstance.displayName() + " does not exist";
        }
        aFullPath = anInstance.path().trim();
        String arguments = anInstance.commandLineArguments();
        String aLaunchPath = aFullPath + " " + arguments;
        anInstance.willAttemptToStart();
        File aFile = new File(aFullPath);
        if (!aFile.exists()) {
            return this._hostName + ": Path '" + aFullPath + "' for " + anInstance.displayName() + " does not exist";
        }
        if (!aFile.isFile()) {
            return this._hostName + ": Path '" + aFullPath + "' for " + anInstance.displayName() + " is not a file";
        }
        if (this._shouldUseSpawn) {
            aLaunchPath = this._isOnWindows ? this.spawningGrounds + aLaunchPath : this.spawningGrounds + aLaunchPath;
        }
        try {
            if (NSLog.debugLoggingAllowedForLevelAndGroups((int)1, (long)0x400000L)) {
                NSLog.debug.appendln((Object)("Starting Instance: " + aLaunchPath));
            }
            Runtime.getRuntime().exec(aLaunchPath);
        }
        catch (IOException ioe) {
            NSLog.err.appendln((Object)("Failed to start " + anInstance.displayName() + ": " + ioe));
            return this._hostName + ": Failed to start " + anInstance.displayName() + ": " + ioe;
        }
        return null;
    }

    public WOResponse terminateInstance(MInstance anInstance) throws MonitorException {
        if (!anInstance.isRunning_W()) {
            return null;
        }
        if (this._forceQuitTaskEnabled) {
            if (this._forceQuitDelay >= 60000) {
                anInstance.scheduleForceQuit((TimerTask)new MInstanceTask.ForceQuit(anInstance), this._forceQuitDelay);
            } else {
                NSLog.err.appendln((Object)("WOtaskd.killTimeout: " + this._forceQuitDelay + " is too small. 60000 milliseconds is the minimum"));
            }
        }
        this.catchInstanceErrors(anInstance);
        NSMutableDictionary xmlDict = this.createInstanceRequestDictionary("TERMINATE", null, anInstance);
        return this.sendInstanceRequest(anInstance, (NSDictionary)xmlDict);
    }

    public WOResponse stopInstance(MInstance anInstance) throws MonitorException {
        if (!anInstance.isRunning_W()) {
            return null;
        }
        if (this._forceQuitTaskEnabled) {
            if (this._forceQuitDelay >= 60000) {
                anInstance.scheduleRefuseTask((TimerTask)new MInstanceTask.Refuse(anInstance, ERXProperties.intForKeyWithDefault((String)"WOTaskd.refuseNumRetries", (int)3)), this._forceQuitDelay, this._forceQuitDelay);
            } else {
                NSLog.err.appendln((Object)("WOtaskd.killTimeout: " + this._forceQuitDelay + " is too small. 60000 milliseconds is the minimum"));
            }
        }
        this.catchInstanceErrors(anInstance);
        NSMutableDictionary xmlDict = this.createInstanceRequestDictionary("REFUSE", null, anInstance);
        return this.sendInstanceRequest(anInstance, (NSDictionary)xmlDict);
    }

    public WOResponse setAcceptInstance(MInstance anInstance) throws MonitorException {
        this.catchInstanceErrors(anInstance);
        NSMutableDictionary xmlDict = this.createInstanceRequestDictionary("ACCEPT", null, anInstance);
        return this.sendInstanceRequest(anInstance, (NSDictionary)xmlDict);
    }

    public WOResponse queryInstance(MInstance anInstance) throws MonitorException {
        this.catchInstanceErrors(anInstance);
        NSMutableDictionary xmlDict = this.createInstanceRequestDictionary(null, "STATISTICS", anInstance);
        return this.sendInstanceRequest(anInstance, (NSDictionary)xmlDict);
    }

    protected void catchInstanceErrors(MInstance anInstance) throws MonitorException {
        MSiteConfig aConfig = this.theApplication.siteConfig();
        if (anInstance == null) {
            throw new MonitorException("Attempt to command null instance on " + this._hostName);
        }
        if (anInstance.host() != aConfig.localHost()) {
            throw new MonitorException(anInstance.displayName() + " does not exist on " + this._hostName + "; command failed");
        }
        if (!anInstance.isRunning_W()) {
            throw new MonitorException(this._hostName + ": " + anInstance.displayName() + " is not running");
        }
    }

    protected WOResponse sendInstanceRequest(MInstance anInstance, NSDictionary xmlDict) throws MonitorException {
        if (NSLog.debugLoggingAllowedForLevelAndGroups((int)3, (long)0x400000L)) {
            NSLog.debug.appendln((Object)"!@#$!@#$ sendInstanceRequest creates a WOHTTPConnection");
        }
        String contentXML = new _JavaMonitorCoder().encodeRootObjectForKey((Object)xmlDict, "instanceRequest");
        NSData content = new NSData(contentXML);
        String urlString = MObject.adminActionStringPrefix + anInstance.applicationName() + MObject.adminActionStringPostfix;
        WORequest aRequest = new WORequest(MObject._POST, urlString, MObject._HTTP1, null, content, null);
        WOResponse aResponse = null;
        try {
            WOHTTPConnection anHTTPConnection = new WOHTTPConnection(anInstance.host().name(), anInstance.port().intValue());
            anHTTPConnection.setReceiveTimeout(this._receiveTimeout);
            boolean requestSucceeded = anHTTPConnection.sendRequest(aRequest);
            if (!requestSucceeded) {
                throw new MonitorException(this._hostName + ": Failed to receive response from " + anInstance.displayName());
            }
            aResponse = anHTTPConnection.readResponse();
            anInstance.succeededInConnection();
        }
        catch (NSForwardException ne) {
            if (ne.originalException() instanceof IOException) {
                anInstance.failedToConnect();
                throw new MonitorException(this._hostName + ": Timeout while connecting to " + anInstance.displayName());
            }
            throw ne;
        }
        catch (MonitorException me) {
            anInstance.failedToConnect();
            throw me;
        }
        catch (Exception e) {
            anInstance.failedToConnect();
            throw new MonitorException(this._hostName + ": Error while communicating with " + anInstance.displayName() + ": " + e);
        }
        return aResponse;
    }

    protected NSMutableDictionary createInstanceRequestDictionary(String commandString, String queryString, MInstance anInstance) {
        NSMutableDictionary instanceRequest = new NSMutableDictionary(2);
        if (commandString != null) {
            NSMutableDictionary commandInstance = new NSMutableDictionary(2);
            commandInstance.takeValueForKey((Object)commandString, "command");
            if (commandString.equals("REFUSE")) {
                commandInstance.takeValueForKey((Object)anInstance.minimumActiveSessionsCount(), "minimumActiveSessionsCount");
            }
            instanceRequest.takeValueForKey((Object)commandInstance, "commandInstance");
        }
        if (queryString != null) {
            String queryInstance = queryString;
            instanceRequest.takeValueForKey((Object)queryInstance, "queryInstance");
        }
        return instanceRequest;
    }

    private boolean _testConnection(MInstance anInstance) {
        try {
            Socket aSocket = NSSocketUtilities.getSocketWithTimeout((String)anInstance.host().name(), (int)anInstance.port(), (int)1000);
            aSocket.close();
            aSocket = null;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

