/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.wotaskd;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSLog;
import com.webobjects.monitor._private.MInstance;
import com.webobjects.monitor._private.MonitorException;
import com.webobjects.monitor.wotaskd.Application;
import com.webobjects.monitor.wotaskd.LocalMonitor;
import java.util.TimerTask;

public abstract class MInstanceTask
extends TimerTask {
    MInstance _instance;

    public MInstanceTask(MInstance instance) {
        this._instance = instance;
    }

    public static class Refuse
    extends MInstanceTask {
        private int _numberOfRetriesBeforeForceQuit;
        private int retries = 0;

        public Refuse(MInstance instance, int numberOfRetriesBeforeForceQuit) {
            super(instance);
            this._numberOfRetriesBeforeForceQuit = numberOfRetriesBeforeForceQuit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Application app = (Application)WOApplication.application();
            app._lock.startReading();
            LocalMonitor localMonitor = app.localMonitor();
            try {
                if (this.retries >= this._numberOfRetriesBeforeForceQuit) {
                    if (this._instance.isRunning_W()) {
                        this._instance.setShouldDie(true);
                    }
                    this._instance.setForceQuitTask(null);
                    this.cancel();
                } else if (!this._instance.isRefusingNewSessions() && localMonitor.stopInstance(this._instance) != null) {
                    this.retries = 0;
                }
            }
            catch (MonitorException e) {
                NSLog.err.appendln((Object)("Exception while scheduling forceQuit: " + e.getMessage()));
            }
            finally {
                ++this.retries;
                app._lock.endReading();
            }
        }
    }

    public static class ForceQuit
    extends MInstanceTask {
        public ForceQuit(MInstance instance) {
            super(instance);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Application app = (Application)WOApplication.application();
            app._lock.startReading();
            try {
                this._instance.setShouldDie(true);
                this._instance.setForceQuitTask(null);
                this.cancel();
            }
            finally {
                app._lock.endReading();
            }
        }
    }
}

