/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.monitor.wotaskd;

import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.xml._JavaMonitorCoder;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPathUtilities;
import java.io.File;

public class RemoteBrowse
extends WODirectAction {
    private Object[] fileKeys = new Object[]{"file", "fileType", "fileSize"};
    private File[] roots;
    private String[] rootStrings;
    private boolean singleRoot = false;
    private String xmlRoots;

    public RemoteBrowse(WORequest aRequest) {
        super(aRequest);
        File[] roots = File.listRoots();
        if (roots.length <= 1) {
            this.singleRoot = true;
        }
        this.rootStrings = new String[roots.length];
        for (int i = 0; i < roots.length; ++i) {
            this.rootStrings[i] = NSPathUtilities._standardizedPath((String)roots[i].getAbsolutePath());
        }
        int anArrayCount = this.rootStrings.length;
        NSMutableArray rootArray = new NSMutableArray(anArrayCount);
        for (int i = 0; i < anArrayCount; ++i) {
            NSDictionary aFileDict = new NSDictionary(new Object[]{this.rootStrings[i], "NSFileTypeDirectory", new Long(0L)}, this.fileKeys);
            rootArray.addObject((Object)aFileDict);
        }
        this.xmlRoots = new _JavaMonitorCoder().encodeRootObjectForKey((Object)rootArray, "pathArray") + " \r\n";
    }

    public NSArray fileListForStartingPath(String aStartingPath, boolean showFiles) {
        File startingPathAsFile = new File(aStartingPath);
        NSMutableArray aDirectoryArray = new NSMutableArray();
        NSMutableArray aFileArray = new NSMutableArray();
        NSArray tempArray = null;
        Object[] contentsOfStartingPath = null;
        if (!startingPathAsFile.exists()) {
            return null;
        }
        contentsOfStartingPath = startingPathAsFile.list();
        tempArray = new NSArray(contentsOfStartingPath);
        try {
            tempArray = tempArray.sortedArrayUsingComparator(NSComparator.AscendingStringComparator);
            contentsOfStartingPath = tempArray.objects();
        }
        catch (NSComparator.ComparisonException e) {
            // empty catch block
        }
        int anArrayCount = contentsOfStartingPath.length;
        for (int i = 0; i < anArrayCount; ++i) {
            Long aFileSize;
            String aFileType;
            String aFile = (String)contentsOfStartingPath[i];
            String fullPath = NSPathUtilities.stringByAppendingPathComponent((String)aStartingPath, (String)aFile);
            File subfile = new File(fullPath = NSPathUtilities._standardizedPath((String)fullPath));
            if (subfile.isDirectory()) {
                aFileType = "NSFileTypeDirectory";
                aFileSize = new Long(0L);
            } else {
                aFileType = "NSFileTypeRegular";
                aFileSize = new Long(subfile.length());
            }
            NSDictionary aFileDict = new NSDictionary(new Object[]{aFile, aFileType, aFileSize}, this.fileKeys);
            if (aFileType.equals("NSFileTypeDirectory")) {
                aDirectoryArray.addObject((Object)aFileDict);
                continue;
            }
            aFileArray.addObject((Object)aFileDict);
        }
        if (showFiles) {
            aDirectoryArray.addObjectsFromArray((NSArray)aFileArray);
        }
        return aDirectoryArray;
    }

    public WOResponse getPathAction() {
        boolean showFiles;
        WORequest aRequest = this.request();
        WOResponse aResponse = new WOResponse();
        if (aRequest.isUsingWebServer()) {
            aResponse.setStatus(403);
            aResponse.appendContentString("Access Denied");
            return aResponse;
        }
        String aPath = aRequest.headerForKey((Object)"filepath");
        boolean bl = showFiles = aRequest.headerForKey((Object)"showFiles") != null;
        if (aPath == null && !this.singleRoot) {
            aResponse.appendContentString(this.xmlRoots);
            aResponse.setHeader("YES", "isRoots");
        } else {
            NSArray anArray;
            if (aPath == null) {
                aPath = this.rootStrings[0];
            }
            if ((anArray = this.fileListForStartingPath(aPath, showFiles)) == null) {
                aResponse.appendContentString("ERROR");
            } else {
                _JavaMonitorCoder aCoder = new _JavaMonitorCoder();
                String anXMLString = null;
                anXMLString = aCoder.encodeRootObjectForKey((Object)anArray, "pathArray");
                anXMLString = anXMLString + " \r\n";
                aResponse.appendContentString(anXMLString);
                aResponse.setHeader(aPath, "filepath");
            }
        }
        return aResponse;
    }
}

