/*
 * Decompiled with CFR 0.152.
 */
package er.indexing;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOJoin;
import com.webobjects.eoaccess.EORelationship;
import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSSet;
import er.extensions.concurrency.ERXAsyncQueue;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.eof.ERXFetchSpecificationBatchIterator;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXStringUtilities;
import er.indexing.ERIndex;
import java.util.Enumeration;
import org.apache.lucene.document.Document;

public class ERAutoIndex
extends ERIndex {
    private static ERXAsyncQueue<ERIndex.Transaction> _queue;
    private NSSet<String> _entities = NSSet.EmptySet;
    private final Configuration _configuration = new Configuration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ERAutoIndex(String name, NSDictionary indexDef) {
        super(name);
        Class<ERIndex> clazz = ERIndex.class;
        synchronized (ERIndex.class) {
            if (_queue == null) {
                _queue = new ERXAsyncQueue<ERIndex.Transaction>(){

                    public void process(ERIndex.Transaction transaction) {
                        transaction.handler().index(transaction);
                    }
                };
                _queue.setName("ERIndexing");
                _queue.start();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this._configuration.initFromDictionary(indexDef);
            this.setTransactionHandler(new AutoTransactionHandler());
            return;
        }
    }

    protected NSSet entities() {
        return this._entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindexAllObjects() {
        this.clear();
        Enumeration names = this.entities().objectEnumerator();
        while (names.hasMoreElements()) {
            String entityName = (String)names.nextElement();
            long start = System.currentTimeMillis();
            int treshhold = 10;
            EOEditingContext ec = ERXEC.newEditingContext();
            ec.lock();
            try {
                EOFetchSpecification fs = new EOFetchSpecification(entityName, null, null);
                ERXFetchSpecificationBatchIterator iterator = new ERXFetchSpecificationBatchIterator(fs);
                iterator.setEditingContext(ec);
                while (iterator.hasNextBatch()) {
                    NSArray objects = iterator.nextBatch();
                    if (iterator.currentBatchIndex() % treshhold == 0) {
                        ec.unlock();
                        ec = ERXEC.newEditingContext();
                        ec.lock();
                        iterator.setEditingContext(ec);
                    }
                    NSArray<Document> documents = this.addedDocumentsForObjects((NSArray<? extends EOEnterpriseObject>)objects);
                    ERIndex.Transaction transaction = new ERIndex.Transaction(this, ec);
                    this.handler().addObjectsToIndex(transaction, (NSArray<? extends EOEnterpriseObject>)objects);
                }
            }
            finally {
                ec.unlock();
            }
            this.log.info((Object)("Indexing " + entityName + " took: " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    protected boolean handlesEntity(String name) {
        ConfigurationEntry config = this._configuration.entryForKey(name);
        return config != null && config.active;
    }

    protected boolean handlesObject(EOEnterpriseObject eo) {
        return this.handlesEntity(eo.entityName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AutoTransactionHandler
    extends ERIndex.TransactionHandler {
        private final NSMutableSet<String> _warned;

        protected AutoTransactionHandler() {
            super(ERAutoIndex.this);
            this._warned = new NSMutableSet();
        }

        @Override
        public void submit(ERIndex.Transaction transaction) {
            this.index(transaction);
        }

        @Override
        public void _handleChanges(NSNotification n) {
            EOEditingContext ec = (EOEditingContext)n.object();
            if (ec.parentObjectStore() == ec.rootObjectStore()) {
                String notificationName = n.name();
                if (notificationName.equals("EOEditingContextWillSaveChanges")) {
                    ec.processRecentChanges();
                    NSArray inserted = ec.insertedObjects();
                    NSArray updated = ec.updatedObjects();
                    updated = ERXArrayUtilities.arrayMinusArray((NSArray)updated, (NSArray)inserted);
                    NSArray deleted = ec.deletedObjects();
                    ERIndex.Transaction transaction = new ERIndex.Transaction(ERAutoIndex.this, ec);
                    NSMutableSet deletedHandledObjects = new NSMutableSet();
                    NSMutableSet addedHandledObjects = new NSMutableSet();
                    NSArray<EOEnterpriseObject> directObjects = this.handledObjects((NSArray<EOEnterpriseObject>)deleted);
                    deleted = ERXArrayUtilities.arrayMinusArray((NSArray)deleted, directObjects);
                    deletedHandledObjects.addObjectsFromArray(directObjects);
                    directObjects = this.handledObjects((NSArray<EOEnterpriseObject>)updated);
                    updated = ERXArrayUtilities.arrayMinusArray((NSArray)updated, directObjects);
                    addedHandledObjects.addObjectsFromArray(directObjects);
                    deletedHandledObjects.addObjectsFromArray(directObjects);
                    directObjects = this.handledObjects((NSArray<EOEnterpriseObject>)inserted);
                    inserted = ERXArrayUtilities.arrayMinusArray((NSArray)inserted, directObjects);
                    addedHandledObjects.addObjectsFromArray(directObjects);
                    NSArray indirectObjects = this.indexableObjectsForObjects("updated", (NSArray<EOEnterpriseObject>)updated);
                    deletedHandledObjects.addObjectsFromArray(indirectObjects);
                    addedHandledObjects.addObjectsFromArray(indirectObjects);
                    indirectObjects = this.indexableObjectsForObjects("inserted", (NSArray<EOEnterpriseObject>)inserted);
                    deletedHandledObjects.addObjectsFromArray(indirectObjects);
                    addedHandledObjects.addObjectsFromArray(indirectObjects);
                    indirectObjects = this.indexableObjectsForObjects("deleted", (NSArray<EOEnterpriseObject>)deleted);
                    deletedHandledObjects.addObjectsFromArray(indirectObjects);
                    addedHandledObjects.addObjectsFromArray(indirectObjects);
                    this.deleteObjectsFromIndex(transaction, (NSArray<? extends EOEnterpriseObject>)deletedHandledObjects.allObjects());
                    this.addObjectsToIndex(transaction, (NSArray<? extends EOEnterpriseObject>)addedHandledObjects.allObjects());
                    this.activeChanges.put(ec, transaction);
                } else if (notificationName.equals("EOEditingContextDidSaveChangesNotification")) {
                    ERIndex.Transaction transaction = (ERIndex.Transaction)this.activeChanges.get(ec);
                    if (transaction != null) {
                        this.activeChanges.remove(ec);
                    }
                    this.submit(transaction);
                } else if (notificationName.equals("EOEditingContextDidRevertChanges") || notificationName.equals("EOEditingContextFailedToSaveChanges")) {
                    this.activeChanges.remove(ec);
                }
            }
        }

        private NSArray<EOEnterpriseObject> handledObjects(NSArray<EOEnterpriseObject> objects) {
            NSMutableArray result = new NSMutableArray(objects.count());
            for (EOEnterpriseObject eo : objects) {
                if (!ERAutoIndex.this.handlesEntity(eo.entityName())) continue;
                result.addObject((Object)eo);
            }
            return result;
        }

        protected NSArray indexableObjectsForObjects(String type, NSArray<EOEnterpriseObject> objects) {
            NSMutableSet result = new NSMutableSet();
            for (EOEnterpriseObject eo : objects) {
                NSArray targetObjects = this.indexableObjectsForObject(type, eo);
                result.addObjectsFromArray(targetObjects);
            }
            return result.allObjects();
        }

        protected NSArray indexableObjectsForObject(String type, EOEnterpriseObject object) {
            ERXGenericRecord eo = (ERXGenericRecord)object;
            EOEditingContext ec = eo.editingContext();
            NSMutableSet result = new NSMutableSet();
            String entityName = eo.entityName();
            ConfigurationEntry config = ERAutoIndex.this._configuration.entryForKey(entityName);
            if (config != null) {
                if (!config.active) {
                    Enumeration e1 = config.notificationKeys.objectEnumerator();
                    while (e1.hasMoreElements()) {
                        EOEntity source;
                        String key = (String)e1.nextElement();
                        Object value = null;
                        if (type.equals("deleted")) {
                            value = ec.committedSnapshotForObject((EOEnterpriseObject)eo);
                        }
                        if ((source = ERXEOAccessUtilities.entityForEo((EOEnterpriseObject)eo)).classPropertyNames().containsObject((Object)key)) {
                            value = eo.valueForKey(key);
                        } else if (eo.isNewObject()) {
                            if (!this._warned.containsObject((Object)entityName)) {
                                ERAutoIndex.this.log.error((Object)("We currently don't support unsaved related objects for this entity: " + entityName));
                                this._warned.addObject((Object)entityName);
                            }
                        } else {
                            EORelationship rel = source.anyRelationshipNamed(key);
                            EOKeyGlobalID sourceGlobalID = (EOKeyGlobalID)ec.globalIDForObject((EOEnterpriseObject)eo);
                            EOFetchSpecification fs = new EOFetchSpecification(rel.destinationEntity().name(), null, null);
                            NSMutableArray qualifiers = new NSMutableArray(rel.joins().count());
                            NSDictionary pk = source.primaryKeyForGlobalID((EOGlobalID)sourceGlobalID);
                            for (EOJoin join : rel.joins()) {
                                Object pkValue = pk.objectForKey((Object)join.sourceAttribute().name());
                                EOKeyValueQualifier qualifier = new EOKeyValueQualifier(join.destinationAttribute().name(), EOQualifier.QualifierOperatorEqual, pkValue);
                                qualifiers.addObject((Object)qualifier);
                            }
                            fs.setQualifier((EOQualifier)(qualifiers.count() == 1 ? (EOQualifier)qualifiers.lastObject() : new EOAndQualifier((NSArray)qualifiers)));
                            value = ec.objectsWithFetchSpecification(fs);
                        }
                        if (value != null) {
                            NSArray eos = value instanceof EOEnterpriseObject ? new NSArray(value) : (NSArray)value;
                            for (EOEnterpriseObject target : eos) {
                                NSArray targetObjects = this.indexableObjectsForObject("updated", target);
                                result.addObjectsFromArray(targetObjects);
                            }
                        }
                        if (result.isEmpty() || !ERAutoIndex.this.log.isDebugEnabled()) continue;
                        ERAutoIndex.this.log.debug((Object)("re-index: " + eo + "->" + result));
                    }
                } else {
                    result.addObject((Object)eo);
                }
            }
            return result.allObjects();
        }
    }

    protected class Configuration {
        private final NSMutableDictionary<String, ConfigurationEntry> configuration = new NSMutableDictionary();

        protected Configuration() {
        }

        protected void initFromDictionary(NSDictionary indexDef) {
            String store = (String)indexDef.objectForKey((Object)"store");
            ERAutoIndex.this.setStore(store);
            this.configuration.clear();
            NSArray entities = (NSArray)indexDef.objectForKey((Object)"entities");
            this.createAttributes(indexDef);
            for (String entityName : entities) {
                ConfigurationEntry config = this.configureEntity(entityName, ERAutoIndex.this.attributeNames());
                config.active = true;
            }
            ERAutoIndex.this.log.info(this.configuration);
        }

        protected void createAttributes(NSDictionary indexDef) {
            NSDictionary properties = (NSDictionary)indexDef.objectForKey((Object)"properties");
            Enumeration names = properties.keyEnumerator();
            while (names.hasMoreElements()) {
                String propertyName = (String)names.nextElement();
                NSDictionary propertyDefinition = (NSDictionary)properties.objectForKey((Object)propertyName);
                ERAutoIndex.this.createAttribute(propertyName, propertyDefinition);
            }
        }

        protected ConfigurationEntry configureEntity(String entityName, NSArray keys) {
            ERAutoIndex.this._entities = (NSSet)new NSMutableSet();
            ConfigurationEntry config = (ConfigurationEntry)this.configuration.objectForKey((Object)entityName);
            if (config == null) {
                config = new ConfigurationEntry();
                this.configuration.setObjectForKey((Object)config, (Object)entityName);
            }
            EOEntity source = ERXEOAccessUtilities.entityNamed(null, (String)entityName);
            Enumeration e = keys.objectEnumerator();
            while (e.hasMoreElements()) {
                String keyPath = (String)e.nextElement();
                this.configureKeyPath(config, keyPath, source);
            }
            return config;
        }

        private ConfigurationEntry configureKeyPath(ConfigurationEntry config, String keyPath, EOEntity source) {
            String key = ERXStringUtilities.firstPropertyKeyInKeyPath((String)keyPath);
            String rest = ERXStringUtilities.keyPathWithoutFirstProperty((String)keyPath);
            EORelationship rel = source._relationshipForPath(key);
            if (rel != null) {
                if (rel.isFlattened()) {
                    ConfigurationEntry c = this.configureKeyPath(config, rel.definition() + (rest != null ? "." + rest : ""), source);
                    return c;
                }
                EOEntity destinationEntity = rel.destinationEntity();
                ConfigurationEntry destinationConfiguration = rest != null ? this.configureEntity(destinationEntity.name(), new NSArray((Object)rest)) : this.configureEntity(destinationEntity.name(), new NSArray());
                String inverseName = rel.anyInverseRelationship().name();
                destinationConfiguration.notificationKeys.addObject((Object)inverseName);
            } else {
                config.keys.addObject((Object)key);
            }
            return config;
        }

        public ConfigurationEntry entryForKey(String key) {
            return (ConfigurationEntry)this.configuration.objectForKey((Object)key);
        }

        public void setEntryForKey(ConfigurationEntry entry, String key) {
            this.configuration.setObjectForKey((Object)entry, (Object)key);
        }

        public void clear() {
            this.configuration.clear();
        }
    }

    protected class ConfigurationEntry {
        public boolean active = false;
        public NSMutableArray<String> keys = new NSMutableArray();
        public NSMutableArray<String> notificationKeys = new NSMutableArray();

        protected ConfigurationEntry() {
        }

        public String toString() {
            return "{ active = " + this.active + "; keys = " + this.keys + "; notificationKeys = " + this.notificationKeys + ";}";
        }
    }
}

