/*
 * Decompiled with CFR 0.152.
 */
package er.indexing.attributes;

import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import er.indexing.ERIndex;
import er.indexing.attributes.ERIAttribute;
import er.indexing.attributes.ERIAttributeGroup;

public class ERIDocument
implements NSKeyValueCoding {
    private final ERIAttributeGroup _attributeGroup;
    private ERIndex.IndexDocument _document;
    private EOKeyGlobalID _globalID;
    private NSArray<ERIAttribute> _attributes;

    public ERIDocument(ERIAttributeGroup attributeGroup, EOKeyGlobalID globalID) {
        this._attributeGroup = attributeGroup;
        this._attributes = attributeGroup.allAttributes();
        this._globalID = globalID;
    }

    private ERIAttribute attributeForName(String key) {
        for (ERIAttribute attribute : this._attributes) {
            if (!key.equals(attribute.name())) continue;
            return attribute;
        }
        return null;
    }

    public void takeValueForKey(Object value, String key) {
        this.willRead();
        String stringValue = this.attributeForName(key).formatValue(value);
        this.document().takeValueForKey(stringValue, key);
    }

    public Object valueForKey(String key) {
        this.willRead();
        if (this.isRead()) {
            Object value = this.document().valueForKey(key);
            return this.attributeForName(key).parseValue((String)value);
        }
        return null;
    }

    public void willRead() {
        if (this._document == null) {
            this._document = this.index().documentForGlobalID(this.globalID());
            if (this._document == null) {
                this._document = this.index().createDocumentForGlobalID(this.globalID());
            }
        }
    }

    private ERIndex index() {
        return this._attributeGroup.index();
    }

    public boolean isRead() {
        return this._document != null;
    }

    private EOKeyGlobalID globalID() {
        return this._globalID;
    }

    private ERIndex.IndexDocument document() {
        return this._document;
    }

    public ERIAttributeGroup attributeGroup() {
        return this._attributeGroup;
    }

    public void save() {
        this.willRead();
        this.document().save();
    }

    public void revert() {
        this.willRead();
        this.document().revert();
    }

    public void delete() {
        this.willRead();
        this.document().delete();
    }
}

