/*
 * Decompiled with CFR 0.152.
 */
package er.indexing.storage;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.eof.ERXEOControlUtilities;
import er.indexing.storage.ERIFile;
import er.indexing.storage._ERIDirectory;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;

public class ERIDirectory
extends _ERIDirectory {
    private static final Logger log = Logger.getLogger(ERIDirectory.class);
    public static final ERIDirectoryClazz clazz = new ERIDirectoryClazz();
    private Directory _directory;

    public void init(EOEditingContext ec) {
        super.init(ec);
    }

    public ERIFile fileForName(String name) {
        for (ERIFile file : this.files()) {
            if (!file.name().equals(name)) continue;
            return file;
        }
        return null;
    }

    public Directory directory() {
        if (this._directory == null) {
            this._directory = new LockingDirectory(new EOFDirectory());
        }
        return this._directory;
    }

    public static interface Key
    extends _ERIDirectory.Key {
    }

    public static class ERIDirectoryClazz
    extends _ERIDirectory._ERIDirectoryClazz {
        public Directory directoryForName(EOEditingContext ec, String store) {
            ERIDirectory directory = (ERIDirectory)this.objectMatchingKeyAndValue(ec, "name", store);
            if (directory == null) {
                directory = (ERIDirectory)this.createAndInsertObject(ec);
                directory.setName(store);
                ec.saveChanges();
            }
            return directory.directory();
        }
    }

    private class EOFDirectory
    extends Directory {
        public EOFDirectory() {
            this.setLockFactory(new EOFLockFactory());
        }

        public void close() throws IOException {
            ERIDirectory.this.editingContext().saveChanges();
        }

        public IndexOutput createOutput(String s) throws IOException {
            log.debug((Object)("createOutput: " + s));
            ERIFile file = ERIDirectory.this.fileForName(s);
            if (file == null) {
                file = this.createFile(s);
            }
            return ERIDirectory.this.fileForName(s).createOutput();
        }

        public ERIFile createFile(String s) {
            ERIFile file = (ERIFile)ERIFile.clazz.createAndInsertObject(ERIDirectory.this.editingContext());
            file.setName(s);
            file.setDirectory(ERIDirectory.this);
            ERIDirectory.this.addToFiles(file);
            ERIDirectory.this.editingContext().saveChanges();
            return file;
        }

        public void deleteFile(String s) throws IOException {
            log.debug((Object)("deleteFile: " + s));
            ERIFile file = ERIDirectory.this.fileForName(s);
            if (file != null) {
                file.delete();
                ERIDirectory.this.editingContext().saveChanges();
            }
        }

        public boolean fileExists(String s) throws IOException {
            return ERIDirectory.this.fileForName(s) != null;
        }

        public long fileLength(String s) throws IOException {
            return ERIDirectory.this.fileForName(s).length();
        }

        public long fileModified(String s) throws IOException {
            return ERIDirectory.this.fileForName(s).timestamp();
        }

        public String[] list() throws IOException {
            return (String[])((NSArray)ERIDirectory.this.files().valueForKeyPath("name")).toArray((Object[])new String[0]);
        }

        public IndexInput openInput(String s) throws IOException {
            ERIFile file = ERIDirectory.this.fileForName(s);
            if (file == null) {
                throw new IOException("File not found: " + s);
            }
            try {
                return file.openInput();
            }
            catch (Exception ex) {
                ERXEOControlUtilities.refaultObject((EOEnterpriseObject)ERIDirectory.this);
                ERXEOControlUtilities.clearSnapshotForRelationshipNamed((EOEnterpriseObject)ERIDirectory.this, (String)"files");
                throw new IOException("File not found: " + s);
            }
        }

        public void renameFile(String s, String s1) throws IOException {
            ERIDirectory.this.fileForName(s).setName(s1);
            ERIDirectory.this.editingContext().saveChanges();
        }

        public void touchFile(String s) throws IOException {
            ERIFile file = ERIDirectory.this.fileForName(s);
            if (file == null) {
                file = this.createFile(s);
            }
            file.touch();
            ERIDirectory.this.editingContext().saveChanges();
        }

        private class EOFLockFactory
        extends LockFactory {
            private NSMutableDictionary<String, EOFLock> locks = new NSMutableDictionary();

            private EOFLockFactory() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void clearLock(String s) throws IOException {
                NSMutableDictionary<String, EOFLock> nSMutableDictionary = this.locks;
                synchronized (nSMutableDictionary) {
                    this.locks.removeObjectForKey((Object)s);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Lock makeLock(String s) {
                NSMutableDictionary<String, EOFLock> nSMutableDictionary = this.locks;
                synchronized (nSMutableDictionary) {
                    EOFLock lock = new EOFLock(s);
                    this.locks.setObjectForKey((Object)lock, (Object)s);
                    return lock;
                }
            }

            private class EOFLock
            extends Lock {
                private String _name;

                private EOFLock(String name) {
                    this._name = name;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean isLocked() {
                    ERIDirectory.this.editingContext().lock();
                    try {
                        boolean bl = ERIDirectory.this.fileForName(this.name()) != null;
                        return bl;
                    }
                    finally {
                        ERIDirectory.this.editingContext().unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean obtain() throws IOException {
                    ERIDirectory.this.editingContext().lock();
                    try {
                        boolean bl = EOFDirectory.this.createFile(this.name()) != null;
                        return bl;
                    }
                    finally {
                        ERIDirectory.this.editingContext().unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void release() throws IOException {
                    ERIDirectory.this.editingContext().lock();
                    try {
                        EOFDirectory.this.deleteFile(this.name());
                    }
                    finally {
                        ERIDirectory.this.editingContext().unlock();
                    }
                }

                public String name() {
                    return this._name;
                }
            }
        }
    }

    private class LockingDirectory
    extends Directory {
        private Directory _wrapped;

        LockingDirectory(Directory wrapped) {
            this._wrapped = wrapped;
            this.setLockFactory(this._wrapped.getLockFactory());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                this._wrapped.close();
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexOutput createOutput(String name) throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                IndexOutput indexOutput = this._wrapped.createOutput(name);
                return indexOutput;
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteFile(String name) throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                this._wrapped.deleteFile(name);
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fileExists(String name) throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                boolean bl = this._wrapped.fileExists(name);
                return bl;
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long fileLength(String name) throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                long l = this._wrapped.fileLength(name);
                return l;
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long fileModified(String name) throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                long l = this._wrapped.fileModified(name);
                return l;
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] list() throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                String[] stringArray = this._wrapped.list();
                return stringArray;
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexInput openInput(String name) throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                IndexInput indexInput = this._wrapped.openInput(name);
                return indexInput;
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renameFile(String from, String to) throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                this._wrapped.renameFile(from, to);
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void touchFile(String name) throws IOException {
            ERIDirectory.this.editingContext().lock();
            try {
                this._wrapped.touchFile(name);
            }
            finally {
                ERIDirectory.this.editingContext().unlock();
            }
        }
    }
}

