/*
 * Decompiled with CFR 0.152.
 */
package er.indexing;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSNotification;
import er.extensions.foundation.ERXArrayUtilities;
import er.indexing.ERIndex;
import java.io.File;
import java.net.MalformedURLException;

public class ERAttributeIndex
extends ERIndex {
    public ERAttributeIndex(String name, String store) {
        super(name);
        this.setStore(store);
        this.setTransactionHandler(new AttributeTransactionHandler());
    }

    public ERAttributeIndex(String name, File store) {
        this(name, ERAttributeIndex.toUrl(store));
    }

    private static String toUrl(File store) {
        try {
            return store.toURL().toString();
        }
        catch (MalformedURLException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public static synchronized ERAttributeIndex indexNamed(String key) {
        ERAttributeIndex index = (ERAttributeIndex)ERIndex.indexNamed(key);
        if (index == null) {
            index = new ERAttributeIndex(key, key);
        }
        return index;
    }

    protected class AttributeTransactionHandler
    extends ERIndex.TransactionHandler {
        protected AttributeTransactionHandler() {
            super(ERAttributeIndex.this);
        }

        public void _handleChanges(NSNotification n) {
            EOEditingContext ec = (EOEditingContext)n.object();
            if (ec.parentObjectStore() == ec.rootObjectStore()) {
                String notificationName = n.name();
                if (notificationName.equals("EOEditingContextWillSaveChanges")) {
                    ec.processRecentChanges();
                    NSArray inserted = ec.insertedObjects();
                    NSArray updated = ec.updatedObjects();
                    updated = ERXArrayUtilities.arrayMinusArray((NSArray)updated, (NSArray)inserted);
                    NSArray deleted = ec.deletedObjects();
                    ERIndex.Transaction transaction = new ERIndex.Transaction(ERAttributeIndex.this, ec);
                    this.activeChanges.put(ec, transaction);
                } else if (notificationName.equals("EOEditingContextDidSaveChangesNotification")) {
                    ERIndex.Transaction transaction = (ERIndex.Transaction)this.activeChanges.get(ec);
                    if (transaction != null) {
                        this.activeChanges.remove(ec);
                    }
                    this.submit(transaction);
                } else if (notificationName.equals("EOEditingContextDidRevertChanges") || notificationName.equals("EOEditingContextFailedToSaveChanges")) {
                    this.activeChanges.remove(ec);
                }
            }
        }
    }
}

