/*
 * Decompiled with CFR 0.152.
 */
package er.indexing;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.eocontrol.EOKeyGlobalID;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSNumberFormatter;
import com.webobjects.foundation.NSTimestampFormatter;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOControlUtilities;
import er.extensions.eof.ERXGenericRecord;
import er.extensions.eof.ERXKeyGlobalID;
import er.extensions.foundation.ERXKeyValueCodingUtilities;
import er.extensions.foundation.ERXMutableDictionary;
import er.extensions.foundation.ERXPatcher;
import er.extensions.foundation.ERXSelectorUtilities;
import er.indexing.ERDocument;
import er.indexing.storage.ERIDirectory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.Format;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumberTools;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hit;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixTermEnum;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Parameter;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERIndex {
    protected Logger log;
    public static String IndexingStartedNotification = "ERIndexingStartedNotification";
    public static String IndexingEndedNotification = "ERIndexingEndedNotification";
    public static String IndexingFailedNotification = "ERIndexingFailedNotification";
    private static final String GID = "EOGlobalID";
    protected static final String KEY = "ERIndexing";
    private static NSMutableDictionary<String, ERIndex> indices = ERXMutableDictionary.synchronizedDictionary();
    private TransactionHandler _handler;
    private Directory _indexDirectory;
    private NSDictionary<String, IndexAttribute> _attributes = NSDictionary.EmptyDictionary;
    private final String _name;
    private String _store;
    private IndexReader _reader;
    private IndexSearcher _searcher;

    protected ERIndex(String name) {
        this.log = Logger.getLogger((String)(ERIndex.class.getName() + "." + name));
        this._name = name;
        indices.setObjectForKey((Object)this, (Object)name);
    }

    public void addObjectsToIndex(EOEditingContext ec, NSArray<? extends EOEnterpriseObject> objects) {
        Transaction transaction = new Transaction(ec);
        this._handler.addObjectsToIndex(transaction, objects);
        this._handler.submit(transaction);
    }

    public void deleteObjectsFromIndex(EOEditingContext ec, NSArray<? extends EOEnterpriseObject> objects) {
        Transaction transaction = new Transaction(ec);
        this._handler.deleteObjectsFromIndex(transaction, objects);
        this._handler.submit(transaction);
    }

    protected TransactionHandler handler() {
        return this._handler;
    }

    protected void setTransactionHandler(TransactionHandler handler) {
        this._handler = handler;
    }

    protected void setStore(String store) {
        this._store = store;
    }

    protected Analyzer analyzer() {
        PerFieldAnalyzerWrapper wrapper = new PerFieldAnalyzerWrapper((Analyzer)new StandardAnalyzer());
        for (IndexAttribute attribute : this.attributes()) {
            wrapper.addAnalyzer(attribute.name(), attribute.analyzer());
        }
        return wrapper;
    }

    public void addAttribute(String propertyName, NSDictionary propertyDefinition) {
        this.createAttribute(propertyName, propertyDefinition);
    }

    protected IndexAttribute createAttribute(String propertyName, NSDictionary propertyDefinition) {
        IndexAttribute attribute = new IndexAttribute(this, propertyName, propertyDefinition);
        NSMutableDictionary attributes = this._attributes.mutableClone();
        attributes.setObjectForKey((Object)attribute, (Object)propertyName);
        this._attributes = attributes.immutableClone();
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Directory indexDirectory() {
        block7: {
            if (this._indexDirectory == null) {
                try {
                    if (this._store.startsWith("file://")) {
                        File indexDirectory = new File(new URL(this._store).getFile());
                        this._indexDirectory = FSDirectory.open((File)indexDirectory);
                        break block7;
                    }
                    EOEditingContext ec = ERXEC.newEditingContext();
                    ec.lock();
                    try {
                        this._indexDirectory = ERIDirectory.clazz.directoryForName(ec, this._store);
                    }
                    finally {
                        ec.unlock();
                    }
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            }
        }
        return this._indexDirectory;
    }

    private IndexReader indexReader() throws CorruptIndexException, IOException {
        if (this._reader == null) {
            this._reader = IndexReader.open((Directory)this.indexDirectory(), (boolean)true);
            this._searcher = new IndexSearcher(this._reader);
        }
        if (!this._reader.isCurrent()) {
            this._reader = this._reader.reopen();
            this._searcher = new IndexSearcher(this._reader);
        }
        return this._reader;
    }

    public IndexSearcher indexSearcher() throws CorruptIndexException, IOException {
        IndexReader indexReader = this.indexReader();
        return this._searcher;
    }

    private NSArray<IndexAttribute> attributes() {
        return this._attributes.allValues();
    }

    public String name() {
        return this._name;
    }

    public NSArray<String> attributeNames() {
        return this._attributes.allKeys();
    }

    public void clear() {
        this._handler.clear();
    }

    protected IndexAttribute attributeNamed(String fieldName) {
        return (IndexAttribute)this._attributes.objectForKey((Object)fieldName);
    }

    protected boolean handlesObject(EOEnterpriseObject eo) {
        return true;
    }

    protected NSArray<Document> addedDocumentsForObjects(NSArray<? extends EOEnterpriseObject> objects) {
        NSMutableArray documents = new NSMutableArray();
        Enumeration e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            Document doc;
            EOEnterpriseObject eo = (EOEnterpriseObject)e.nextElement();
            if (!this.handlesObject(eo) || (doc = this.createDocumentForObject(eo)) == null) continue;
            documents.addObject((Object)doc);
        }
        return documents;
    }

    protected Document createDocumentForObject(EOEnterpriseObject eo) {
        EOKeyGlobalID gid = ((ERXGenericRecord)eo).permanentGlobalID();
        IndexDocument document = this.createDocumentForGlobalID(gid);
        Document doc = document.document();
        for (IndexAttribute info : this.attributes()) {
            String stringValue;
            String key = info.name();
            Object value = eo.valueForKeyPath(key);
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)(key + "->" + value));
            }
            if ((stringValue = info.formatValue(value)) == null) continue;
            Field field = new Field(key, stringValue, info.store(), info.index(), info.termVector());
            document.document().add((Fieldable)field);
        }
        return doc;
    }

    protected NSArray<Term> deletedTermsForObjects(NSArray<? extends EOEnterpriseObject> objects) {
        NSMutableArray terms = new NSMutableArray();
        Enumeration e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            Term term;
            EOEnterpriseObject eo = (EOEnterpriseObject)e.nextElement();
            if (!this.handlesObject(eo) || (term = this.createTerm(eo)) == null) continue;
            terms.addObject((Object)term);
        }
        return terms;
    }

    protected Term createTerm(EOEnterpriseObject eo) {
        Term term = null;
        String pk = this.gidStringForObject(eo);
        term = new Term(GID, pk);
        return term;
    }

    private String gidStringForObject(EOEnterpriseObject eo) {
        EOKeyGlobalID gid = ((ERXGenericRecord)eo).permanentGlobalID();
        String pk = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)gid).asString();
        return pk;
    }

    private EOEnterpriseObject objectForGidString(EOEditingContext ec, String gidString) {
        EOKeyGlobalID gid = ERXKeyGlobalID.fromString((String)gidString).globalID();
        return ec.faultForGlobalID((EOGlobalID)gid, ec);
    }

    private Query queryForQualifier(EOQualifier qualifier) throws ParseException {
        EOKeyValueQualifier q = (EOKeyValueQualifier)qualifier;
        return this.queryForString(q.key(), (String)q.value());
    }

    private Query queryForString(String fieldName, String queryString) throws ParseException {
        Analyzer analyzer = this.attributeNamed(fieldName).analyzer();
        QueryParser parser = new QueryParser(Version.LUCENE_29, fieldName, analyzer);
        Query query = parser.parse(queryString);
        return query;
    }

    private Query queryForString(String queryString) throws ParseException {
        return null;
    }

    public NSArray<? extends EOEnterpriseObject> findObjects(EOEditingContext ec, Query query, Filter filter, Sort sort, int start, int end) {
        return ERXEOControlUtilities.faultsForGlobalIDs((EOEditingContext)ec, this.findGlobalIDs(query, filter, sort, start, end));
    }

    private NSArray<EOKeyGlobalID> findGlobalIDs(Query query, Filter filter, Sort sort, int start, int end) {
        NSMutableArray result = new NSMutableArray();
        try {
            IndexSearcher searcher = this.indexSearcher();
            long startTime = System.currentTimeMillis();
            sort = sort == null ? new Sort() : sort;
            TopFieldDocs topFielsDocs = searcher.search(query, filter, end, sort);
            this.log.info((Object)("Searched for: " + query + " in  " + (System.currentTimeMillis() - startTime) + " ms"));
            for (int i = start; i < topFielsDocs.scoreDocs.length; ++i) {
                String gidString = searcher.doc(topFielsDocs.scoreDocs[i].doc).getField(GID).stringValue();
                EOKeyGlobalID gid = ERXKeyGlobalID.fromString((String)gidString).globalID();
                result.addObject((Object)gid);
            }
            this.log.info((Object)("Returning " + result.count() + " after " + (System.currentTimeMillis() - startTime) + " ms"));
            return result;
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    private NSArray<EOKeyGlobalID> findGlobalIDs(Query query) {
        NSMutableArray result = new NSMutableArray();
        long start = System.currentTimeMillis();
        try {
            IndexSearcher searcher = this.indexSearcher();
            Hits hits = searcher.search(query);
            this.log.info((Object)("Searched for: " + query + " in  " + (System.currentTimeMillis() - start) + " ms"));
            for (Hit hit : hits) {
                String gidString = hit.getDocument().getField(GID).stringValue();
                EOKeyGlobalID gid = ERXKeyGlobalID.fromString((String)gidString).globalID();
                result.addObject((Object)gid);
            }
            this.log.info((Object)("Returning " + result.count() + " after " + (System.currentTimeMillis() - start) + " ms"));
            return result;
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public NSArray<? extends EOEnterpriseObject> findObjects(EOEditingContext ec, Query query) {
        return ERXEOControlUtilities.faultsForGlobalIDs((EOEditingContext)ec, this.findGlobalIDs(query));
    }

    public NSArray<EOKeyGlobalID> findGlobalIDs(String queryString) {
        try {
            Query query = this.queryForString(queryString);
            return this.findGlobalIDs(query);
        }
        catch (ParseException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public NSArray<EOKeyGlobalID> findGlobalIDs(EOQualifier qualifier) {
        try {
            Query query = this.queryForQualifier(qualifier);
            return this.findGlobalIDs(query);
        }
        catch (ParseException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public ScoreDoc[] findScoreDocs(Query query, int hitsPerPage) {
        ScoreDoc[] hits = null;
        long start = System.currentTimeMillis();
        try {
            IndexSearcher searcher = this.indexSearcher();
            TopScoreDocCollector collector = TopScoreDocCollector.create((int)hitsPerPage, (boolean)true);
            searcher.search(query, (Collector)collector);
            hits = collector.topDocs().scoreDocs;
            this.log.debug((Object)("Returning " + hits.length + " after " + (System.currentTimeMillis() - start) + " ms"));
            return hits;
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    @Deprecated
    public Hits findHits(Query query) {
        Hits hits = null;
        long start = System.currentTimeMillis();
        try {
            IndexSearcher searcher = this.indexSearcher();
            hits = searcher.search(query);
            this.log.debug((Object)("Returning " + hits.length() + " after " + (System.currentTimeMillis() - start) + " ms"));
            return hits;
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public NSArray<String> findTermStringsForPrefix(String field, String prefix) {
        NSMutableArray terms = new NSMutableArray();
        try {
            IndexReader reader = this.indexReader();
            PrefixTermEnum tenum = new PrefixTermEnum(reader, new Term(field, prefix));
            while (tenum.term() != null) {
                String termText = tenum.term().text();
                terms.addObject((Object)termText);
                if (tenum.next()) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return terms;
    }

    @Deprecated
    public NSArray<Term> findTerms(Query q) {
        NSMutableArray terms = new NSMutableArray();
        try {
            IndexReader reader = this.indexReader();
            HashSet suggestedTerms = new HashSet();
            q.rewrite(reader).extractTerms(suggestedTerms);
            for (Term term : suggestedTerms) {
                terms.addObject((Object)term);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return terms.immutableClone();
    }

    @Deprecated
    public NSArray<String> findTermStrings(Query q) {
        NSMutableArray terms = new NSMutableArray();
        try {
            IndexReader reader = this.indexReader();
            HashSet suggestedTerms = new HashSet();
            q.rewrite(reader).extractTerms(suggestedTerms);
            for (Term term : suggestedTerms) {
                terms.addObject((Object)term.text());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return terms.immutableClone();
    }

    public IndexDocument findDocument(EOKeyGlobalID globalID) {
        NSMutableArray result = new NSMutableArray();
        long start = System.currentTimeMillis();
        try {
            IndexSearcher searcher = this.indexSearcher();
            String pk = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)globalID).asString();
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term(GID, pk)), BooleanClause.Occur.MUST);
            Hits hits = searcher.search((Query)query);
            this.log.info((Object)("Searched for: " + query.toString(GID) + " in  " + (System.currentTimeMillis() - start) + " ms"));
            for (Hit hit : hits) {
                result.addObject((Object)hit.getDocument());
            }
            this.log.info((Object)("Returning " + result.count() + " after " + (System.currentTimeMillis() - start) + " ms"));
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        return new IndexDocument((Document)result.lastObject());
    }

    public ERDocument documentForId(int docId, float score) {
        ERDocument doc = null;
        try {
            Document _doc = this.indexSearcher().doc(docId);
            doc = new ERDocument(_doc, score);
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        return doc;
    }

    public NSArray<? extends EOEnterpriseObject> findObjects(EOEditingContext ec, EOQualifier qualifier) {
        try {
            Query query = this.queryForQualifier(qualifier);
            return this.findObjects(ec, query);
        }
        catch (ParseException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public NSArray<? extends EOEnterpriseObject> findObjects(EOEditingContext ec, String queryString) {
        try {
            Query query = this.queryForString(queryString);
            NSArray<EOKeyGlobalID> gids = this.findGlobalIDs(query);
            return ERXEOControlUtilities.faultsForGlobalIDs((EOEditingContext)ec, gids);
        }
        catch (ParseException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
    }

    public NSArray<String> terms(String fieldName) {
        NSMutableSet result = new NSMutableSet();
        TermEnum terms = null;
        try {
            IndexReader reader = this.indexReader();
            terms = reader.terms(new Term(fieldName, ""));
            while (fieldName.equals(terms.term().field())) {
                result.addObject((Object)terms.term().text());
                if (terms.next()) continue;
                break;
            }
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
        }
        finally {
            if (terms != null) {
                try {
                    terms.close();
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            }
        }
        return result.allObjects();
    }

    public IndexDocument documentForGlobalID(EOKeyGlobalID globalID) {
        return this.findDocument(globalID);
    }

    public IndexDocument createDocumentForGlobalID(EOKeyGlobalID globalID) {
        Document doc = new Document();
        String pk = ERXKeyGlobalID.globalIDForGID((EOKeyGlobalID)globalID).asString();
        doc.add((Fieldable)new Field(GID, pk, Field.Store.YES, Field.Index.NOT_ANALYZED));
        return new IndexDocument(doc);
    }

    public static ERIndex indexNamed(String key) {
        return (ERIndex)indices.objectForKey((Object)key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class TransactionHandler {
        protected Map<EOEditingContext, Transaction> activeChanges = new WeakHashMap<EOEditingContext, Transaction>();

        TransactionHandler() {
            this.registerNotifications();
        }

        public void clear() {
            Transaction transaction = new Transaction(null);
            transaction.clear();
            this.submit(transaction);
        }

        private void registerNotification(String notificationName, String selectorName) {
            NSNotificationCenter.defaultCenter().addObserver((Object)this, ERXSelectorUtilities.notificationSelector((String)selectorName), notificationName, null);
        }

        protected void registerNotifications() {
            this.registerNotification("EOEditingContextWillSaveChanges", "_handleChanges");
            this.registerNotification("EOEditingContextDidSaveChangesNotification", "_handleChanges");
            this.registerNotification("EOEditingContextDidRevertChanges", "_handleChanges");
            this.registerNotification("EOEditingContextFailedToSaveChanges", "_handleChanges");
        }

        protected void addObjectsToIndex(Transaction transaction, NSArray<? extends EOEnterpriseObject> objects) {
            NSArray<Document> added = ERIndex.this.addedDocumentsForObjects(objects);
            transaction.addJob(Command.ADD, added);
        }

        protected void deleteObjectsFromIndex(Transaction transaction, NSArray<? extends EOEnterpriseObject> objects) {
            NSArray<Term> deleted = ERIndex.this.deletedTermsForObjects(objects);
            transaction.addJob(Command.DELETE, deleted);
        }

        public void submit(Transaction transaction) {
            this.index(transaction);
        }

        synchronized void index(Transaction transaction) {
            try {
                NSNotificationCenter.defaultCenter().postNotification(IndexingStartedNotification, (Object)transaction);
                boolean create = transaction.hasClear();
                if (create) {
                    ERIndex.this.log.warn((Object)"Clearing index");
                } else if (transaction.jobs().count() == 0) {
                    NSNotificationCenter.defaultCenter().postNotification(IndexingEndedNotification, (Object)transaction);
                    return;
                }
                long start = System.currentTimeMillis();
                ERIndex.this.log.info((Object)("Running " + transaction));
                if (!create && !ERIndex.this.indexDirectory().fileExists("segments.gen")) {
                    ERIndex.this.log.error((Object)"segments did not exist but create wasn't called");
                    create = true;
                }
                IndexWriter writer = new IndexWriter(ERIndex.this.indexDirectory(), ERIndex.this.analyzer(), create, IndexWriter.MaxFieldLength.UNLIMITED);
                for (Job job : transaction.jobs()) {
                    Enumeration iter;
                    ERIndex.this.log.info((Object)("Indexing: " + (Object)((Object)job.command()) + " " + job.objects().count()));
                    if (job.command() == Command.DELETE) {
                        iter = job.objects().objectEnumerator();
                        while (iter.hasMoreElements()) {
                            Term term = (Term)iter.nextElement();
                            writer.deleteDocuments(term);
                        }
                    } else if (job.command() == Command.ADD) {
                        iter = job.objects().objectEnumerator();
                        while (iter.hasMoreElements()) {
                            Document document = (Document)iter.nextElement();
                            writer.addDocument(document, ERIndex.this.analyzer());
                        }
                    }
                    ERIndex.this.log.info((Object)("Done: " + (Object)((Object)job.command()) + " " + job.objects().count()));
                }
                writer.flush();
                writer.close();
                NSNotificationCenter.defaultCenter().postNotification(IndexingEndedNotification, (Object)transaction);
                ERIndex.this.log.info((Object)("Finished in " + (System.currentTimeMillis() - start) / 1000L + "s: " + transaction));
            }
            catch (IOException e) {
                NSNotificationCenter.defaultCenter().postNotification(IndexingFailedNotification, (Object)transaction);
                throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
            }
        }

        public abstract void _handleChanges(NSNotification var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Transaction {
        private final NSMutableArray<Job> _jobs = new NSMutableArray();
        private final EOEditingContext _editingContext;
        private boolean _clear = false;
        private int _objectCount = 0;

        Transaction(EOEditingContext ec) {
            this._editingContext = ec;
        }

        public void clear() {
            this._clear = true;
        }

        public void addJob(Command command, NSArray objects) {
            if (objects.count() > 0) {
                this._objectCount += objects.count();
                this._jobs.addObject((Object)new Job(command, objects));
            }
        }

        public EOEditingContext editingContext() {
            return this._editingContext;
        }

        public NSArray<Job> jobs() {
            return this._jobs;
        }

        public String toString() {
            if (this.hasClear()) {
                return "Transaction@" + this.hashCode() + " clear";
            }
            return "Transaction@" + (this.editingContext() != null ? Integer.valueOf(this.editingContext().hashCode()) : null) + "@" + this.hashCode() + " jobs: " + this.jobs().count() + " objects: " + this._objectCount;
        }

        public boolean hasClear() {
            return this._clear;
        }

        TransactionHandler handler() {
            return ERIndex.this._handler;
        }
    }

    protected class Job {
        private final Command _command;
        private final NSArray _objects;

        public Job(Command command, NSArray objects) {
            this._command = command;
            this._objects = objects;
        }

        public NSArray objects() {
            return this._objects;
        }

        public Command command() {
            return this._command;
        }
    }

    protected static class Command
    extends Parameter {
        protected static Command ADD = new Command("ADD");
        protected static Command DELETE = new Command("DELETE");

        protected Command(String name) {
            super(name);
        }
    }

    protected class IndexAttribute {
        String _name;
        Field.TermVector _termVector;
        Field.Store _store;
        Field.Index _index;
        Analyzer _analyzer;
        Format _format;
        ERIndex _model;

        IndexAttribute(ERIndex index, String name, NSDictionary dict) {
            String dateformat;
            this._name = name;
            this._termVector = (Field.TermVector)this.classValue(dict, "termVector", Field.TermVector.class, "YES");
            this._store = (Field.Store)this.classValue(dict, "store", Field.Store.class, "NO");
            this._index = (Field.Index)this.classValue(dict, "index", Field.Index.class, "ANALYZED");
            String analyzerClass = (String)dict.objectForKey((Object)"analyzer");
            if (analyzerClass == null) {
                analyzerClass = StandardAnalyzer.class.getName();
            }
            this._analyzer = (Analyzer)this.create(analyzerClass);
            if (this._analyzer != null || name.matches("\\w+_(\\w+)")) {
                // empty if block
            }
            this._format = (Format)this.create((String)dict.objectForKey((Object)"format"));
            String numberFormat = (String)dict.objectForKey((Object)"numberformat");
            if (numberFormat != null) {
                this._format = new NSNumberFormatter(numberFormat);
            }
            if ((dateformat = (String)dict.objectForKey((Object)"dateformat")) != null) {
                this._format = new NSTimestampFormatter(dateformat);
            }
        }

        private Object create(String className) {
            if (className != null) {
                try {
                    Class c = ERXPatcher.classForName((String)className);
                    return c.newInstance();
                }
                catch (InstantiationException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw NSForwardException._runtimeExceptionForThrowable((Throwable)e);
                }
            }
            return null;
        }

        private Object classValue(NSDictionary dict, String key, Class c, String defaultValue) {
            String code = (String)dict.objectForKey((Object)key);
            if (code == null) {
                code = defaultValue;
            }
            Object result = ERXKeyValueCodingUtilities.classValueForKey((Class)c, (String)code);
            return result;
        }

        public Field.TermVector termVector() {
            return this._termVector;
        }

        public Field.Index index() {
            return this._index;
        }

        public Field.Store store() {
            return this._store;
        }

        public String name() {
            return this._name;
        }

        public Analyzer analyzer() {
            return this._analyzer;
        }

        public String formatValue(Object value) {
            if (this._format != null) {
                return this._format.format(value);
            }
            if (value instanceof Number) {
                return NumberTools.longToString((long)((Number)value).longValue());
            }
            if (value instanceof Date) {
                return DateTools.dateToString((Date)((Date)value), (DateTools.Resolution)DateTools.Resolution.MILLISECOND);
            }
            if (value instanceof NSArray) {
                return ((NSArray)value).componentsJoinedByString(" ");
            }
            return value != null ? value.toString() : null;
        }
    }

    public class IndexDocument
    implements NSKeyValueCoding {
        private final Document _document;
        private final NSMutableDictionary<String, String> _values = new NSMutableDictionary();

        public IndexDocument(Document document) {
            this._document = document;
        }

        public void takeValueForKey(Object value, String key) {
            this._document.getField(key).setValue(key);
        }

        public Object valueForKey(String key) {
            return this._document.get(key);
        }

        public Document document() {
            return this._document;
        }

        public void save() {
        }

        public void revert() {
        }

        public void delete() {
        }
    }
}

