/*
 * Decompiled with CFR 0.152.
 */
package er.indexing;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXFetchSpecificationBatchIterator;
import er.indexing.ERAutoIndex;
import er.indexing.ERIndex;
import java.util.Enumeration;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERIndexer {
    private NSArray<ERAutoIndex> _indices;
    private Logger log = Logger.getLogger(ERIndexer.class);

    public ERIndexer(NSArray<ERAutoIndex> indices) {
        this._indices = indices;
    }

    public void clear() {
        Enumeration i = this._indices.objectEnumerator();
        while (i.hasMoreElements()) {
            ERIndex index = (ERIndex)i.nextElement();
            index.clear();
        }
    }

    public NSArray indicesForEntity(String entityName) {
        NSMutableArray result = new NSMutableArray();
        Enumeration i = this._indices.objectEnumerator();
        while (i.hasMoreElements()) {
            ERAutoIndex index = (ERAutoIndex)i.nextElement();
            if (!index.handlesEntity(entityName)) continue;
            result.addObject((Object)index);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexAllObjects(EOEntity entity) {
        NSArray incides = this.indicesForEntity(entity.name());
        if (incides.count() > 0) {
            long start = System.currentTimeMillis();
            int treshhold = 10;
            EOEditingContext ec = ERXEC.newEditingContext();
            ec.lock();
            try {
                EOFetchSpecification fs = new EOFetchSpecification(entity.name(), null, null);
                ERXFetchSpecificationBatchIterator iterator = new ERXFetchSpecificationBatchIterator(fs);
                iterator.setEditingContext(ec);
                while (iterator.hasNextBatch()) {
                    NSArray objects = iterator.nextBatch();
                    if (iterator.currentBatchIndex() % treshhold == 0) {
                        ec.unlock();
                        ec = ERXEC.newEditingContext();
                        ec.lock();
                        iterator.setEditingContext(ec);
                    }
                    Enumeration i = incides.objectEnumerator();
                    while (i.hasMoreElements()) {
                        ERIndex index = (ERIndex)i.nextElement();
                        index.addObjectsToIndex(ec, (NSArray<? extends EOEnterpriseObject>)objects);
                    }
                }
            }
            finally {
                ec.unlock();
            }
            this.log.info((Object)("Indexing " + entity.name() + " took: " + (System.currentTimeMillis() - start) + " ms"));
        }
    }

    public void indexAllObjects(EOModel model) {
        Enumeration entities = model.entities().objectEnumerator();
        while (entities.hasMoreElements()) {
            EOEntity entity = (EOEntity)entities.nextElement();
            this.indexAllObjects(entity);
        }
    }

    public void indexAllObjects(EOModelGroup group) {
        Enumeration models = group.models().objectEnumerator();
        while (models.hasMoreElements()) {
            EOModel model = (EOModel)models.nextElement();
            this.indexAllObjects(model);
        }
    }
}

