/*
 * Decompiled with CFR 0.152.
 */
package er.javamail;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import er.javamail.ERJavaMail;
import er.javamail.ERMessage;
import javax.mail.AuthenticationFailedException;
import javax.mail.FolderNotFoundException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERIMAP {
    private IMAPStore imapStore;

    public void openConnection(String imapUser, String imapPassword) throws AuthenticationFailedException, MessagingException, IllegalStateException {
        this.imapStore = (IMAPStore)ERJavaMail.sharedInstance().defaultSession().getStore("imap");
        this.imapStore.connect(this.imapHost(), imapUser, imapPassword);
    }

    public void closeConnection() throws MessagingException {
        this.imapStore.close();
    }

    public IMAPFolder openFolder(String folderName, int mode) throws MessagingException, FolderNotFoundException {
        IMAPFolder folder = (IMAPFolder)this.imapStore.getFolder(folderName);
        folder.open(mode);
        return folder;
    }

    public void closeFolder(IMAPFolder folder, boolean expunge) throws MessagingException {
        folder.close(expunge);
    }

    public NSArray<ERMessage> getMessages(IMAPFolder folder) throws MessagingException {
        return this.getMessages(folder, 1, folder.getMessageCount());
    }

    public NSArray<ERMessage> getMessages(IMAPFolder folder, int firstMsg, int lastMsg) throws MessagingException {
        NSMutableArray emails = new NSMutableArray();
        if (folder.isOpen()) {
            MimeMessage[] messages = (MimeMessage[])folder.getMessages(firstMsg, lastMsg);
            for (int index = 0; index < messages.length; ++index) {
                MimeMessage mimeMessage = messages[index];
                ERMessage message = new ERMessage();
                message.setMimeMessage(mimeMessage);
                emails.add((Object)message);
            }
        }
        return emails;
    }

    public void setImapHost(String _imapHost) {
        System.setProperty("er.javamail.imapHost", _imapHost);
    }

    public String imapHost() {
        return System.getProperty("er.javamail.imapHost");
    }
}

