/*
 * Decompiled with CFR 0.152.
 */
package com.gammastream.validity;

import com.gammastream.validity.GSVAttribute;
import com.gammastream.validity.GSVEntity;
import com.gammastream.validity.GSVModel;
import com.gammastream.validity.GSVRule;
import com.webobjects.appserver.xml.WOXMLDecoder;
import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModel;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSValidation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class GSVEngine {
    public static String ERROR_DICTIONARY_KEY = "GSVExceptions";
    private static int ON_SAVE = 1;
    private static int ON_INSERT = 2;
    private static int ON_UPDATE = 3;
    private static int ON_DELETE = 4;
    private static int ON_DEMAND = 5;
    private static GSVEngine _sharedValidationEngine = null;
    private NSMutableDictionary _modelCache = null;
    private NSMutableDictionary _classCache = null;
    private NSMutableDictionary _methodCache = null;
    private Class[] _gsvRuleSignature = new Class[4];
    private EOModelGroup _defaultModelGroup = null;
    private boolean _expired = false;

    public static GSVEngine sharedValidationEngine() {
        if (_sharedValidationEngine == null) {
            _sharedValidationEngine = new GSVEngine();
        }
        return _sharedValidationEngine;
    }

    public static NSValidation.ValidationException exceptionByAppendingErrorToException(String errorMessage, String key, NSValidation.ValidationException ex) {
        NSMutableDictionary userInfo = null;
        NSMutableDictionary errorDict = null;
        NSMutableArray errorList = null;
        NSValidation.ValidationException returnException = ex;
        userInfo = returnException == null || returnException.userInfo() == null ? new NSMutableDictionary((Object)new NSMutableDictionary(), (Object)ERROR_DICTIONARY_KEY) : new NSMutableDictionary(returnException.userInfo());
        errorDict = (NSMutableDictionary)userInfo.objectForKey((Object)ERROR_DICTIONARY_KEY);
        if (errorDict == null) {
            errorDict = new NSMutableDictionary();
            userInfo.setObjectForKey((Object)errorDict, (Object)ERROR_DICTIONARY_KEY);
        }
        if ((errorList = (NSMutableArray)errorDict.objectForKey((Object)key)) == null) {
            errorList = new NSMutableArray();
            errorDict.setObjectForKey((Object)errorList, (Object)key);
        }
        errorList.addObject((Object)errorMessage);
        return new NSValidation.ValidationException("Validity Exception", (NSDictionary)userInfo);
    }

    private GSVEngine() {
        this.checkExpirationDate();
        this.generateGSVRuleSignature();
        this._defaultModelGroup = EOModelGroup.defaultGroup();
        this._modelCache = new NSMutableDictionary();
        this._classCache = new NSMutableDictionary();
        this._methodCache = new NSMutableDictionary();
    }

    public boolean validateEOObjectOnSave(EOEnterpriseObject eoObject) {
        return this.validateEOObject(eoObject, ON_SAVE);
    }

    public boolean validateEOObjectOnInsert(EOEnterpriseObject eoObject) {
        return this.validateEOObject(eoObject, ON_INSERT);
    }

    public boolean validateEOObjectOnUpdate(EOEnterpriseObject eoObject) {
        return this.validateEOObject(eoObject, ON_UPDATE);
    }

    public boolean validateEOObjectOnDelete(EOEnterpriseObject eoObject) {
        return this.validateEOObject(eoObject, ON_DELETE);
    }

    public NSDictionary validateKeyAndValueInEntity(String key, String value, String entity) {
        NSArray rules;
        GSVEntity gsvEntity = null;
        GSVAttribute currentAttribute = null;
        GSVRule currentRule = null;
        NSMutableDictionary errorDict = new NSMutableDictionary();
        boolean rulePassed = false;
        gsvEntity = this.entityWithName(entity);
        if (gsvEntity != null && (currentAttribute = gsvEntity.attributeNamed(key)) != null && (rules = currentAttribute.rules()) != null) {
            for (int r = 0; r < currentAttribute.rules().count(); ++r) {
                currentRule = (GSVRule)currentAttribute.rules().objectAtIndex(r);
                rulePassed = this.checkRule(currentRule, key, errorDict, value, ON_SAVE);
                if (currentRule.stopIfFails() && !rulePassed) break;
            }
        }
        if (errorDict.allKeys().count() > 0) {
            return errorDict;
        }
        return null;
    }

    public boolean validateEOObject(EOEnterpriseObject eoObject, int when) {
        GSVEntity gsvEntity = null;
        GSVAttribute currentAttribute = null;
        GSVRule currentRule = null;
        NSMutableDictionary errorDict = new NSMutableDictionary();
        boolean rulePassed = false;
        if (!this._expired) {
            gsvEntity = this.entityForObject(eoObject);
            if (gsvEntity != null) {
                block0: for (int i = 0; i < gsvEntity.attributes().count(); ++i) {
                    currentAttribute = (GSVAttribute)gsvEntity.attributes().objectAtIndex(i);
                    for (int r = 0; r < currentAttribute.rules().count(); ++r) {
                        currentRule = (GSVRule)currentAttribute.rules().objectAtIndex(r);
                        rulePassed = this.checkRule(currentRule, currentAttribute.name(), errorDict, eoObject, when);
                        if (currentRule.stopIfFails() && !rulePassed) continue block0;
                    }
                }
            }
            if (errorDict.allKeys().count() > 0) {
                NSDictionary userInfo = new NSDictionary((Object)errorDict, (Object)ERROR_DICTIONARY_KEY);
                System.out.println("eo=" + eoObject);
                throw new NSValidation.ValidationException("Validity Exception", userInfo);
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean validateAttribute(Object object, String attributeName, GSVRule rule) {
        NSMutableDictionary errorDict = new NSMutableDictionary();
        if (!this._expired) {
            if (object != null) {
                this.checkRule(rule, attributeName, errorDict, object, ON_DEMAND);
            }
            if (errorDict.allKeys().count() > 0) {
                NSDictionary userInfo = new NSDictionary((Object)errorDict, (Object)ERROR_DICTIONARY_KEY);
                throw new NSValidation.ValidationException("Validity Exception", userInfo);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean checkRule(GSVRule rule, String attributeName, NSMutableDictionary errorDict, String value, Object eoObject, int when) {
        if (when == ON_SAVE && rule.onSave() || when == ON_INSERT && rule.onInsert() || when == ON_UPDATE && rule.onUpdate() || when == ON_DELETE && rule.onDelete() || when == ON_DEMAND) {
            try {
                String attributeValue;
                String string = attributeValue = eoObject == null ? value : NSKeyValueCoding.Utility.valueForKey((Object)eoObject, (String)attributeName);
                if (attributeValue == null && !rule.continueIfNULL()) {
                    if (rule.failIfNULL()) {
                        NSMutableArray errorArray = (NSMutableArray)errorDict.objectForKey((Object)attributeName);
                        if (errorArray == null) {
                            errorArray = new NSMutableArray();
                            errorDict.setObjectForKey((Object)errorArray, (Object)attributeName);
                        }
                        if (rule.errorMessage() != null) {
                            errorArray.addObject((Object)rule.errorMessage());
                        } else {
                            errorArray.addObject((Object)(attributeName + ": Error - No message provided."));
                        }
                        return false;
                    }
                    return true;
                }
                String classKey = rule.cName();
                String ruleKey = rule.cName() + "." + rule.mName();
                Class<?> clss = (Class<?>)this._classCache.objectForKey((Object)classKey);
                Method method = (Method)this._methodCache.objectForKey((Object)ruleKey);
                Class<?> methodReturnType = null;
                boolean rulePassed = false;
                if (method == null) {
                    if (clss == null && (clss = Class.forName(classKey)) != null) {
                        this._classCache.setObjectForKey(clss, (Object)classKey);
                    }
                    if (clss != null && (method = clss.getMethod(rule.mName(), this._gsvRuleSignature)) != null) {
                        this._methodCache.setObjectForKey((Object)method, (Object)ruleKey);
                    }
                }
                if (method != null && (methodReturnType = method.getReturnType()).toString().equals("boolean")) {
                    Object[] params = new Object[]{eoObject, attributeValue, attributeName, rule.parameters()};
                    rulePassed = (Boolean)method.invoke(null, params);
                    if (!rule.negate() && !rulePassed || rule.negate() && rulePassed) {
                        NSMutableArray errorArray = (NSMutableArray)errorDict.objectForKey((Object)attributeName);
                        if (errorArray == null) {
                            errorArray = new NSMutableArray();
                            errorDict.setObjectForKey((Object)errorArray, (Object)attributeName);
                        }
                        if (rule.errorMessage() != null) {
                            errorArray.addObject((Object)rule.errorMessage());
                        } else {
                            errorArray.addObject((Object)(attributeName + ": Error - No message provided."));
                        }
                    }
                }
            }
            catch (InvocationTargetException e) {
                System.out.println(e);
                return false;
            }
            catch (IllegalAccessException e) {
                System.out.println(e);
                return false;
            }
            catch (ClassNotFoundException e) {
                System.out.println(e);
                return false;
            }
            catch (NoSuchMethodException e) {
                System.out.println(e);
                return false;
            }
        }
        return true;
    }

    public boolean checkRule(GSVRule rule, String attributeName, NSMutableDictionary errorDict, String value, int when) {
        return this.checkRule(rule, attributeName, errorDict, value, null, when);
    }

    public boolean checkRule(GSVRule rule, String attributeName, NSMutableDictionary errorDict, Object eoObject, int when) {
        return this.checkRule(rule, attributeName, errorDict, null, eoObject, when);
    }

    private GSVEntity entityWithName(String name) {
        EOEntity eoentity = this._defaultModelGroup.entityNamed(name);
        return this.entityForEntity(eoentity);
    }

    private GSVEntity entityForEntity(EOEntity eoentity) {
        if (eoentity != null) {
            String modelName = eoentity.model().name();
            GSVModel model = (GSVModel)this._modelCache.objectForKey((Object)modelName);
            if (model == null) {
                EOModel eomodel = eoentity.model();
                String eoModelPath = NSPathUtilities.stringByDeletingLastPathComponent((String)eomodel.path());
                eoModelPath = NSPathUtilities.stringByAppendingPathComponent((String)eoModelPath, (String)eomodel.name());
                eoModelPath = NSPathUtilities.stringByAppendingPathExtension((String)eoModelPath, (String)"eomodeld");
                String gsvModelPath = NSPathUtilities.stringByAppendingPathComponent((String)eoModelPath, (String)"Validity");
                gsvModelPath = NSPathUtilities.stringByAppendingPathExtension((String)gsvModelPath, (String)"model");
                WOXMLDecoder decoder = WOXMLDecoder.decoder();
                decoder.setEncoding("UTF-8");
                model = (GSVModel)decoder.decodeRootObject(gsvModelPath);
                model.setEomodelPath(eoModelPath);
                model.init(eomodel);
                model.saveModel();
                this._modelCache.setObjectForKey((Object)model, (Object)modelName);
            }
            return model.entityNamed(eoentity.name());
        }
        return null;
    }

    private GSVEntity entityForObject(EOEnterpriseObject eoObject) {
        EOEntity eoentity = this._defaultModelGroup.entityNamed(eoObject.entityName());
        return this.entityForEntity(eoentity);
    }

    private void checkExpirationDate() {
        this._expired = false;
    }

    private void generateGSVRuleSignature() {
        try {
            Class[] temp = new Class[]{Class.forName("java.lang.Object"), Class.forName("java.lang.Object"), Class.forName("java.lang.String"), Class.forName("com.webobjects.foundation.NSDictionary")};
            this._gsvRuleSignature = temp;
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

