/*
 * Decompiled with CFR 0.152.
 */
package com.gammastream.validity;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSLog;
import java.math.BigDecimal;

public class GSVNumberMethods {
    public static final String EQUAL = "==";
    public static final String NOT_EQUAL = "!=";
    public static final String GREATER_THAN = ">";
    public static final String GREATER_EQUAL = ">=";
    public static final String LESS_THAN = "<";
    public static final String LESS_EQUAL = "<=";

    public static final boolean compareTo(Object object, Object attribute, String key, NSDictionary params) {
        if (attribute instanceof Number) {
            String sign = (String)params.objectForKey((Object)"Operator");
            String number = (String)params.objectForKey((Object)"RightOperand");
            BigDecimal left = new BigDecimal(((Number)attribute).doubleValue());
            BigDecimal right = new BigDecimal(number);
            int comparisonValue = left.compareTo(right);
            if (sign.equals(EQUAL)) {
                return comparisonValue == 0;
            }
            if (sign.equals(NOT_EQUAL)) {
                return comparisonValue != 0;
            }
            if (sign.equals(GREATER_THAN)) {
                return comparisonValue == 1;
            }
            if (sign.equals(GREATER_EQUAL)) {
                return comparisonValue == 1 || comparisonValue == 0;
            }
            if (sign.equals(LESS_THAN)) {
                return comparisonValue == -1;
            }
            if (sign.equals(LESS_EQUAL)) {
                return comparisonValue == -1 || comparisonValue == 0;
            }
        }
        return false;
    }

    public static final boolean isInRange(Object object, Object attribute, String key, NSDictionary params) {
        if (attribute instanceof Number) {
            try {
                BigDecimal low = new BigDecimal((String)params.objectForKey((Object)"Low"));
                BigDecimal high = new BigDecimal((String)params.objectForKey((Object)"High"));
                BigDecimal number = new BigDecimal(((Number)attribute).doubleValue());
                int comparisonValueLow = low.compareTo(number);
                int comparisonValueHigh = high.compareTo(number);
                if (!(comparisonValueLow != -1 && comparisonValueLow != 0 || comparisonValueHigh != 1 && comparisonValueHigh != 0)) {
                    return true;
                }
            }
            catch (Exception e) {
                NSLog.err.appendln((Object)e.getMessage());
            }
        }
        return false;
    }

    public static final boolean isPositiveNumber(Object object, Object attribute, String key, NSDictionary params) {
        if (attribute instanceof Number) {
            return ((Number)attribute).intValue() >= 0;
        }
        return false;
    }

    public static final boolean isNegativeNumber(Object object, Object attribute, String key, NSDictionary params) {
        if (attribute instanceof Number) {
            return ((Number)attribute).intValue() < 0;
        }
        return false;
    }
}

