/*
 * Decompiled with CFR 0.152.
 */
package er.fsadaptor;

import com.webobjects.eocontrol.EOAndQualifier;
import com.webobjects.eocontrol.EOKeyValueQualifier;
import com.webobjects.eocontrol.EONotQualifier;
import com.webobjects.eocontrol.EOOrQualifier;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableSet;
import java.io.File;

public abstract class FSQualifierHandler {
    public static boolean debug = "YES".equals(System.getProperty("FSAdaptorDebuggingEnabled"));
    private static final String[] HandlerNames = new String[]{"er.fsadaptor.FSQualifierHandler$And", "er.fsadaptor.FSQualifierHandler$Or", "er.fsadaptor.FSQualifierHandler$Not", "er.fsadaptor.FSQualifierHandler$KeyValue"};
    private static FSQualifierHandler[] _handlers = null;
    private static String rootDirectory = "";

    private static File fileWithPath(String path) {
        if (rootDirectory != null && rootDirectory.length() > 0) {
            path = rootDirectory + File.separator + path;
        }
        if (debug) {
            System.out.println("FSQualifierHandler.fileWithPath: " + path);
        }
        return new File(path);
    }

    protected FSQualifierHandler() {
    }

    private static FSQualifierHandler[] handlers() {
        return _handlers;
    }

    static NSArray filesWithQualifier(EOQualifier aQualifier, String root) {
        if (aQualifier != null) {
            NSArray anArray;
            rootDirectory = root;
            if (debug) {
                System.out.println("FSQualifierHandler.rootDirectory: " + rootDirectory);
            }
            NSMutableSet aSet = new NSMutableSet();
            FSQualifierHandler.addFilesWithQualifierToSet(aQualifier, aSet);
            if (aSet.count() > 0 && (anArray = EOQualifier.filteredArrayWithQualifier((NSArray)aSet.allObjects(), (EOQualifier)aQualifier)) != null && anArray.count() > 0) {
                if (debug) {
                    System.out.println("FSQualifierHandler.filesWithQualifier: " + anArray);
                }
                return anArray;
            }
            return null;
        }
        if (root != null) {
            File aFile = FSQualifierHandler.fileWithPath("");
            if (aFile.exists() && aFile.isDirectory()) {
                return new NSArray((Object[])aFile.listFiles());
            }
            return null;
        }
        throw new IllegalArgumentException("FSQualifierHandler.filesWithQualifier: null qualifier.");
    }

    private static void addFilesWithQualifierToSet(EOQualifier aQualifier, NSMutableSet aSet) {
        if (aQualifier != null) {
            if (aSet != null) {
                for (FSQualifierHandler anHandler : FSQualifierHandler.handlers()) {
                    if (!anHandler.canHandleQualifier(aQualifier)) continue;
                    anHandler.addFilesMatchingQualifierToSet(aQualifier, aSet);
                    break;
                }
                return;
            }
            throw new IllegalArgumentException("FSQualifierHandler.addFilesWithQualifierToSet: null set.");
        }
        throw new IllegalArgumentException("FSQualifierHandler.addFilesWithQualifierToSet: null qualifier.");
    }

    boolean canHandleQualifier(EOQualifier aQualifier) {
        if (aQualifier != null) {
            Class aType = this.type();
            if (aType != null) {
                return aType.isAssignableFrom(aQualifier.getClass());
            }
            throw new IllegalStateException("FSQualifierHandler.canHandleQualifier: null type.");
        }
        throw new IllegalArgumentException("FSQualifierHandler.canHandleQualifier: null qualifier.");
    }

    protected abstract Class type();

    protected abstract void addFilesMatchingQualifierToSet(EOQualifier var1, NSMutableSet var2);

    static {
        String[] someHandlerNames = HandlerNames;
        int count = someHandlerNames.length;
        _handlers = new FSQualifierHandler[count];
        for (int index = 0; index < count; ++index) {
            String aClassName = someHandlerNames[index];
            try {
                FSQualifierHandler anHandler;
                Class<?> aClass = Class.forName(aClassName);
                FSQualifierHandler._handlers[index] = anHandler = (FSQualifierHandler)aClass.newInstance();
                continue;
            }
            catch (Exception anException) {
                throw new RuntimeException("SZDocumentDecoder.handlers: " + anException);
            }
        }
    }

    private static final class And
    extends FSQualifierHandler {
        protected And() {
        }

        protected Class type() {
            return EOAndQualifier.class;
        }

        protected void addFilesMatchingQualifierToSet(EOQualifier aQualifier, NSMutableSet aSet) {
            if (aQualifier != null) {
                if (aSet != null) {
                    NSArray someQualifiers = ((EOAndQualifier)aQualifier).qualifiers();
                    if (someQualifiers != null) {
                        int count = someQualifiers.count();
                        for (int index = 0; index < count; ++index) {
                            EOQualifier anotherQualifier = (EOQualifier)someQualifiers.objectAtIndex(index);
                            FSQualifierHandler.addFilesWithQualifierToSet(anotherQualifier, aSet);
                        }
                    }
                    return;
                }
                throw new IllegalArgumentException("FSQualifierHandler.And.addFilesMatchingQualifierToSet: null set.");
            }
            throw new IllegalArgumentException("FSQualifierHandler.And.addFilesMatchingQualifierToSet: null qualifier.");
        }
    }

    private static final class Or
    extends FSQualifierHandler {
        protected Or() {
        }

        protected Class type() {
            return EOOrQualifier.class;
        }

        protected void addFilesMatchingQualifierToSet(EOQualifier aQualifier, NSMutableSet aSet) {
            if (aQualifier != null) {
                if (aSet != null) {
                    NSArray someQualifiers = ((EOOrQualifier)aQualifier).qualifiers();
                    if (someQualifiers != null) {
                        int count = someQualifiers.count();
                        for (int index = 0; index < count; ++index) {
                            EOQualifier anotherQualifier = (EOQualifier)someQualifiers.objectAtIndex(index);
                            FSQualifierHandler.addFilesWithQualifierToSet(anotherQualifier, aSet);
                        }
                    }
                    return;
                }
                throw new IllegalArgumentException("FSQualifierHandler.Or.addFilesMatchingQualifierToSet: null set.");
            }
            throw new IllegalArgumentException("FSQualifierHandler.Or.addFilesMatchingQualifierToSet: null qualifier.");
        }
    }

    private static final class Not
    extends FSQualifierHandler {
        protected Not() {
        }

        protected Class type() {
            return EONotQualifier.class;
        }

        protected void addFilesMatchingQualifierToSet(EOQualifier aQualifier, NSMutableSet aSet) {
            if (aQualifier != null) {
                if (aSet != null) {
                    FSQualifierHandler.addFilesWithQualifierToSet(((EONotQualifier)aQualifier).qualifier(), aSet);
                    return;
                }
                throw new IllegalArgumentException("FSQualifierHandler.Not.addFilesMatchingQualifierToSet: null set.");
            }
            throw new IllegalArgumentException("FSQualifierHandler.Not.addFilesMatchingQualifierToSet: null qualifier.");
        }
    }

    private static final class KeyValue
    extends FSQualifierHandler {
        private static final String[] PathKeys = new String[]{"absolutePath", "canonicalPath", "path"};
        private static final int PathKeysCount = PathKeys.length;
        private static final String ParentPathKey = "parent";

        protected KeyValue() {
        }

        protected Class type() {
            return EOKeyValueQualifier.class;
        }

        private void addFileWithQualifierToSet(EOKeyValueQualifier aQualifier, NSMutableSet aSet) {
            if (aQualifier != null) {
                if (aSet != null) {
                    String aKey = aQualifier.key();
                    for (int index = 0; index < PathKeysCount; ++index) {
                        if (!aKey.equals(PathKeys[index])) continue;
                        String aPath = aQualifier.value().toString();
                        File aFile = FSQualifierHandler.fileWithPath(aPath);
                        if (aFile.exists()) {
                            aSet.addObject((Object)aFile);
                        }
                        if (!debug) break;
                        System.out.println("EOKeyValueQualifier.addFileWithQualifierToSet: " + aFile);
                        break;
                    }
                    return;
                }
                throw new IllegalArgumentException("FSQualifierHandler.KeyValue.addFileWithQualifierToSet: null set.");
            }
            throw new IllegalArgumentException("FSQualifierHandler.KeyValue.addFileWithQualifierToSet: null qualifier.");
        }

        private void addParentFilesWithQualifierToSet(EOKeyValueQualifier aQualifier, NSMutableSet aSet) {
            if (aQualifier != null) {
                if (aSet != null) {
                    Object[] someFiles;
                    String aPath;
                    File aFile;
                    String aKey = aQualifier.key();
                    if (aKey.equals(ParentPathKey) && (aFile = FSQualifierHandler.fileWithPath(aPath = aQualifier.value().toString())).exists() && aFile.isDirectory() && (someFiles = aFile.listFiles()) != null && someFiles.length > 0) {
                        NSArray files = new NSArray(someFiles);
                        aSet.addObjectsFromArray(files);
                        if (debug) {
                            System.out.println("EOKeyValueQualifier.addParentFilesWithQualifierToSet: " + files);
                        }
                    }
                    return;
                }
                throw new IllegalArgumentException("FSQualifierHandler.KeyValue.addParentFilesWithQualifierToSet: null set.");
            }
            throw new IllegalArgumentException("FSQualifierHandler.KeyValue.addParentFilesWithQualifierToSet: null qualifier.");
        }

        protected void addFilesMatchingQualifierToSet(EOQualifier aQualifier, NSMutableSet aSet) {
            if (aQualifier != null) {
                if (aSet != null) {
                    this.addFileWithQualifierToSet((EOKeyValueQualifier)aQualifier, aSet);
                    this.addParentFilesWithQualifierToSet((EOKeyValueQualifier)aQualifier, aSet);
                    return;
                }
                throw new IllegalArgumentException("FSQualifierHandler.KeyValue.addFilesMatchingQualifierToSet: null set.");
            }
            throw new IllegalArgumentException("FSQualifierHandler.KeyValue.addFilesMatchingQualifierToSet: null qualifier.");
        }
    }

    public static class FileProxy
    extends File {
        public FileProxy(String path) {
            super(path);
        }

        public String getParent() {
            return this.getRealParent().substring(rootDirectory.length());
        }

        public String getRealParent() {
            return super.getParent();
        }
    }
}

