/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver;

import com.webobjects.appserver.WOApplication;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WORequestHandler;
import com.webobjects.appserver.WOResourceManager;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODeployedBundle;
import com.webobjects.appserver._private.WODynamicURL;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSNotificationCenter;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import org.apache.log4j.Logger;

public class ERXStaticResourceRequestHandler
extends WORequestHandler {
    private static Logger log = Logger.getLogger(ERXStaticResourceRequestHandler.class);
    private static WOApplication application = WOApplication.application();
    private String _documentRoot;
    private boolean _useRequestHandlerPath;

    public ERXStaticResourceRequestHandler() {
        this._documentRoot = null;
    }

    public ERXStaticResourceRequestHandler(String frameworkName) {
        if ("app".equals(frameworkName)) {
            frameworkName = null;
        }
        WODeployedBundle bundle = WOApplication.application().resourceManager()._cachedBundleForFrameworkNamed(frameworkName);
        File bundleFile = new File(bundle.bundlePath());
        bundleFile = bundle.isFramework() ? new File(bundleFile, "WebServerResources") : new File(new File(bundleFile, "Contents"), "WebServerResources");
        this._documentRoot = bundleFile.getAbsolutePath();
        this._useRequestHandlerPath = true;
    }

    protected WOResponse _generateResponseForInputStream(InputStream is, int length, String type) {
        WOResponse response = application.createResponseInContext(null);
        if (is != null) {
            if (length != 0) {
                response.setContentStream(is, 51200, length);
            }
        } else {
            response.setStatus(404);
        }
        if (type != null) {
            response.setHeader(type, "content-type");
        }
        if (length != 0) {
            response.setHeader("" + length, "content-length");
        }
        return response;
    }

    private String documentRoot() {
        if (this._documentRoot == null) {
            this._documentRoot = ERXProperties.stringForKey("WODocumentRoot");
            if (this._documentRoot == null) {
                NSBundle bundle = NSBundle.bundleForName((String)"JavaWebObjects");
                NSDictionary dict = ERXDictionaryUtilities.dictionaryFromPropertyList("WebServerConfig", bundle);
                this._documentRoot = (String)dict.objectForKey("DocumentRoot");
            }
        }
        return this._documentRoot;
    }

    public WOResponse handleRequest(WORequest request) {
        WOResponse response = null;
        FileInputStream is = null;
        int length = 0;
        String contentType = null;
        String uri = request.uri();
        if (uri.charAt(0) == '/') {
            WOResourceManager rm = application.resourceManager();
            String documentRoot = this.documentRoot();
            File file = null;
            StringBuffer sb = new StringBuffer(documentRoot.length() + uri.length());
            String wodataKey = request.stringFormValueForKey("wodata");
            if (uri.startsWith("/cgi-bin") && wodataKey != null) {
                uri = wodataKey;
                if (uri.startsWith("file:")) {
                    uri = uri.substring(5);
                }
            } else {
                int index = uri.indexOf("/wodata=");
                if (index >= 0) {
                    uri = uri.substring(index + "/wodata=".length());
                } else {
                    sb.append(documentRoot);
                }
            }
            if (this._useRequestHandlerPath) {
                try {
                    WODynamicURL dynamicURL = new WODynamicURL(uri);
                    String requestHandlerPath = dynamicURL.requestHandlerPath();
                    if (requestHandlerPath == null || requestHandlerPath.length() == 0) {
                        sb.append(uri);
                    }
                    sb.append("/");
                    sb.append(requestHandlerPath);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to parse URL '" + uri + "'.", e);
                }
            } else {
                sb.append(uri);
            }
            String path = sb.toString();
            try {
                path = path.replaceAll("\\?.*", "");
                if (request.userInfo() != null && !request.userInfo().containsKey("HttpServletRequest")) {
                    path = path.replace('+', ' ');
                    path = URLDecoder.decode(path, "UTF-8");
                }
                file = new File(path);
                length = (int)file.length();
                is = new FileInputStream(file);
                contentType = rm.contentTypeForResourceNamed(path);
                log.debug((Object)("Reading file '" + file + "' for uri: " + uri));
            }
            catch (IOException ex) {
                if (!uri.toLowerCase().endsWith("/favicon.ico")) {
                    log.info((Object)("Unable to get contents of file '" + file + "' for uri: " + uri));
                }
            }
        } else {
            log.error((Object)("Can't fetch relative path: " + uri));
        }
        response = this._generateResponseForInputStream(is, length, contentType);
        NSNotificationCenter.defaultCenter().postNotification(WORequestHandler.DidHandleRequestNotification, (Object)response);
        response._finalizeInContext(null);
        return response;
    }
}

