/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.appserver.navigation;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import er.extensions.appserver.ERXSession;
import er.extensions.appserver.navigation.ERXNavigationItem;
import er.extensions.appserver.navigation.ERXNavigationManager;
import er.extensions.appserver.navigation.ERXNavigationState;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXValueUtilities;
import org.apache.log4j.Logger;

public class ERXNavigationMenu
extends ERXStatelessComponent {
    public static final Logger log = Logger.getLogger(ERXNavigationMenu.class);
    public ERXNavigationItem aNavigationItem;
    protected ERXNavigationState _navigationState;
    protected NSKeyValueCoding _navigationContext;
    protected NSArray _level1Items;
    protected NSArray _level2Items;
    protected NSArray _level3Items;
    public int _level1SpacerWidth = 0;
    public int _level2SpacerWidth = 0;
    public int _level3SpacerWidth = 0;
    public int _renderLevelCount;
    protected int l2Colspan;
    protected boolean _menuIsSetUp = false;

    public ERXNavigationMenu(WOContext context) {
        super(context);
    }

    public void reset() {
        this._level1Items = null;
        this._level2Items = null;
        this._level3Items = null;
        this._menuIsSetUp = false;
        this._renderLevelCount = 0;
        this.aNavigationItem = null;
        this._navigationState = null;
        this._navigationContext = null;
        super.reset();
    }

    protected NSKeyValueCoding navigationContext() {
        if (this._navigationContext == null) {
            this._navigationContext = (NSKeyValueCoding)this.valueForBinding("navigationContext");
        }
        return this._navigationContext;
    }

    public void setUpMenu() {
        if (!this._menuIsSetUp) {
            Object o;
            if (this.navigationContext() != null && (o = this.navigationContext().valueForKey("navigationState")) != null) {
                NSArray<String> navigationState;
                NSArray<String> nSArray = navigationState = o instanceof NSArray ? (NSArray<String>)o : NSArray.componentsSeparatedByString(o.toString(), ".");
                if (navigationState != null && navigationState.count() > 0) {
                    this.navigationState().setState(navigationState);
                } else {
                    NSArray<String> additionalNavigationState;
                    o = (NSArray)this.navigationContext().valueForKey("additionalNavigationState");
                    o = o == null ? NSArray.EmptyArray : o;
                    NSArray<String> nSArray2 = additionalNavigationState = o instanceof NSArray ? (NSArray<String>)o : NSArray.componentsSeparatedByString(o.toString(), ".");
                    if (additionalNavigationState != null && additionalNavigationState.count() > 0) {
                        if (additionalNavigationState != null && additionalNavigationState.count() > 0) {
                            this.navigationState().setAdditionalState(additionalNavigationState);
                        } else {
                            this.navigationState().setAdditionalState(null);
                        }
                    } else if (ERXValueUtilities.booleanValue(this.navigationContext().valueForKey("shouldResetNavigationState"))) {
                        this.navigationState().setState(NSArray.EmptyArray);
                    }
                }
            }
            int numOfLevels = this.menuLevelsToShow();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of levels: " + numOfLevels));
            }
            this.setLevel1Items(this.itemsForLevel(1));
            this.setLevel1SpacerWidth(this.setupLevel1SpacerWidth());
            if (numOfLevels >= 2) {
                this.setLevel2Items(this.itemsForLevel(2));
                this.setLevel2SpacerWidth(this.setupLevel2SpacerWidth());
                if (numOfLevels >= 3) {
                    this.setLevel3Items(this.itemsForLevel(3));
                    this.setLevel3SpacerWidth(this.setupLevel3SpacerWidth());
                }
            }
            this._menuIsSetUp = true;
        }
    }

    public ERXNavigationState navigationState() {
        if (this._navigationState == null) {
            this._navigationState = ERXNavigationManager.manager().navigationStateForSession(this.session());
        }
        return this._navigationState;
    }

    public NSArray itemsForLevel(int level) {
        NSArray children = this.navigationState().navigationItemsForLevel(level, (NSKeyValueCodingAdditions)this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Children: " + children.count() + " for level: " + level));
        }
        if (children.count() > 0) {
            ++this._renderLevelCount;
        }
        return children;
    }

    public void takeValuesFromRequest(WORequest r, WOContext c) {
        this.setUpMenu();
        super.takeValuesFromRequest(r, c);
    }

    public void appendToResponse(WOResponse r, WOContext c) {
        this.setUpMenu();
        super.appendToResponse(r, c);
    }

    public WOActionResults invokeAction(WORequest r, WOContext c) {
        WOActionResults results = null;
        this.setUpMenu();
        results = super.invokeAction(r, c);
        return results;
    }

    public int setupLevel2SpacerWidth() {
        int totalWidth = 0;
        int lev1Width = this.level1Width();
        int lev2Width = this.level2Width();
        int i = 0;
        for (i = 0; i < this.level1Items().count(); ++i) {
            ERXNavigationItem anObject = (ERXNavigationItem)this.level1Items().objectAtIndex(i);
            int tmpInt = anObject.width();
            totalWidth += tmpInt;
            if (!this.navigationState().state().containsObject(anObject.name())) continue;
            if (lev2Width <= totalWidth + this.level1SpacerWidth()) {
                if (i + 1 == this.level1Items().count()) {
                    return 0;
                }
                return lev1Width - totalWidth;
            }
            if (lev2Width >= lev1Width - (totalWidth - tmpInt)) continue;
            return lev1Width - (totalWidth -= tmpInt) - lev2Width;
        }
        return lev1Width - lev2Width;
    }

    public int setupLevel3SpacerWidth() {
        int totalWidth = 0;
        int lev2Width = this.level2SpacerWidth() + this.level2Width();
        int lev3Width = this.level3Width();
        int i = 0;
        for (i = 0; i < this._level2Items.count(); ++i) {
            ERXNavigationItem anObject = (ERXNavigationItem)this._level2Items.objectAtIndex(i);
            int tmpInt = anObject.width();
            totalWidth += tmpInt;
            if (!this.navigationState().state().containsObject(anObject.name())) continue;
            if (lev3Width <= lev2Width - (totalWidth -= tmpInt)) {
                return lev2Width - totalWidth - lev3Width;
            }
            if (lev3Width >= this.level1Width() - (totalWidth + tmpInt)) continue;
            return lev2Width - (totalWidth += tmpInt);
        }
        return 0;
    }

    public boolean showLevel2() {
        return this.navigationState().stateAsString() != null ? this.navigationState().state().count() >= 1 && this._level2Items != null && this._level2Items.count() > 0 : false;
    }

    public boolean showLevel3() {
        return this.navigationState().stateAsString() != null && this.navigationState().state().count() >= 2 && this._level3Items != null && this._level3Items.count() > 0;
    }

    public int menuLevelsToShow() {
        int result = 1;
        NSArray tmpArray = this.navigationState().state();
        result = tmpArray.count() + (tmpArray.count() <= 2 ? 1 : 0);
        return result;
    }

    public NSArray level1Items() {
        return this._level1Items;
    }

    public int level1SpacerWidth() {
        return this._level1SpacerWidth;
    }

    public int level1Width() {
        int totalWidth = 0;
        if (this._level1Items != null) {
            for (int i = 0; i < this._level1Items.count(); ++i) {
                totalWidth += ((ERXNavigationItem)this._level1Items.objectAtIndex(i)).width();
            }
        }
        return totalWidth;
    }

    public NSArray level2Items() {
        return this._level2Items;
    }

    public int level2SpacerWidth() {
        return this._level2SpacerWidth;
    }

    public int level2Width() {
        int totalWidth = 0;
        if (this._level2Items != null) {
            for (int i = 0; i < this._level2Items.count(); ++i) {
                totalWidth += ((ERXNavigationItem)this._level2Items.objectAtIndex(i)).width();
            }
        }
        return totalWidth;
    }

    public NSArray level3Items() {
        return this._level3Items;
    }

    public int level3SpacerWidth() {
        return this._level3SpacerWidth;
    }

    public int level3Width() {
        int totalWidth = 0;
        if (this._level3Items != null) {
            for (int i = 0; i < this._level3Items.count(); ++i) {
                totalWidth += ((ERXNavigationItem)this._level3Items.objectAtIndex(i)).width();
            }
        }
        return totalWidth;
    }

    public int setupLevel1SpacerWidth() {
        return this.navItemsTableWidth() - this.level1Width();
    }

    public void setLevel1Items(NSArray newLevel1Items) {
        this._level1Items = newLevel1Items;
    }

    public void setLevel1SpacerWidth(int newLevel1SpacerWidth) {
        this._level1SpacerWidth = newLevel1SpacerWidth;
    }

    public void setLevel2Items(NSArray newLevel2Items) {
        this._level2Items = newLevel2Items;
    }

    public void setLevel2SpacerWidth(int newLevel2SpacerWidth) {
        this._level2SpacerWidth = newLevel2SpacerWidth;
    }

    public void setLevel3Items(NSArray newLevel3Items) {
        this._level3Items = newLevel3Items;
    }

    public void setLevel3SpacerWidth(int newLevel3SpacerWidth) {
        this._level3SpacerWidth = newLevel3SpacerWidth;
    }

    public int navItemsTableWidth() {
        int level1Width = this.level1Width();
        return level1Width < 200 ? 200 : level1Width;
    }

    public String paddingWidth() {
        return ((ERXSession)this.session()).browser().isNetscape() ? "width=\"100%\"" : "";
    }

    public String level1itemsClass() {
        String classString = this.showLevel2() ? " L1WithChildren" : "";
        return "Level1Items" + classString;
    }

    public String level2itemsClass() {
        String classString = this.showLevel3() ? " L2WithChildren" : "";
        return "Level2Items" + classString;
    }
}

