/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOResponse;
import er.extensions.appserver.ERXApplication;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ERXClickToOpenSupport {
    private static Boolean _enabled;
    private static Pattern _tagPattern;
    private static final String _marker = "<<CLICK_TO_OPEN_MARKER>>";

    public static boolean isEnabled() {
        if (_enabled == null) {
            _enabled = !ERXApplication.isDevelopmentModeSafe() ? Boolean.FALSE : Boolean.valueOf(ERXProperties.booleanForKeyWithDefault("er.component.clickToOpen", false));
        }
        return _enabled;
    }

    public static void preProcessResponse(WOResponse response, WOContext context, boolean clickToOpenEnabled) {
        if (clickToOpenEnabled) {
            response.appendContentString(_marker);
        }
    }

    public static void postProcessResponse(Class component, WOResponse response, WOContext context, boolean clickToOpenEnabled) {
        StringBuffer contentStringBuffer;
        int markerIndex;
        String contentStr;
        if (clickToOpenEnabled && (contentStr = response.contentString()) != null && (markerIndex = (contentStringBuffer = new StringBuffer(contentStr)).lastIndexOf(_marker)) != -1) {
            contentStringBuffer.delete(markerIndex, markerIndex + _marker.length());
            Matcher tagMatcher = _tagPattern.matcher(contentStringBuffer);
            if (tagMatcher.find(markerIndex)) {
                int attributeOffset = tagMatcher.end();
                String componentName = component.getName();
                String componentNameTag = "_componentName";
                if (ERXStringUtilities.regionMatches(contentStringBuffer, attributeOffset, componentNameTag, 0, componentNameTag.length())) {
                    int openQuoteIndex = contentStringBuffer.indexOf("\"", attributeOffset);
                    contentStringBuffer.insert(openQuoteIndex + 1, componentName + ",");
                } else {
                    contentStringBuffer.insert(attributeOffset, " " + componentNameTag + " = \"" + componentName + "\" ");
                }
            }
            response.setContent(contentStringBuffer.toString());
        }
    }

    static {
        _tagPattern = Pattern.compile("<([a-z][a-z0-9]*:)?[a-z][a-z0-9]*\\s*", 10);
    }
}

