/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOApplication;
import com.webobjects.foundation.NSArray;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXUtilities;
import java.util.Enumeration;
import org.apache.log4j.Logger;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class ERXGracefulShutdown
implements SignalHandler {
    public static final Logger log = Logger.getLogger(ERXGracefulShutdown.class);
    protected SignalHandler defaultHandler;

    public static boolean isEnabled() {
        return ERXProperties.booleanForKeyWithDefault("er.extensions.ERXGracefulShutdown.Enabled", false);
    }

    public static void installHandler() {
        NSArray signals;
        if (ERXGracefulShutdown.isEnabled() && (signals = ERXProperties.arrayForKey("er.extensions.ERXGracefulShutdown.SignalsToHandle")) != null && signals.count() > 0) {
            Enumeration signalsEnumerator = signals.objectEnumerator();
            while (signalsEnumerator.hasMoreElements()) {
                Signal signal = new Signal((String)signalsEnumerator.nextElement());
                ERXGracefulShutdown handler = new ERXGracefulShutdown();
                handler.setDefaultHandler(Signal.handle(signal, handler));
            }
        }
    }

    public void handle(Signal signal) {
        log.info((Object)("Received " + signal + ", starting graceful shutdown."));
        try {
            if (WOApplication.application() instanceof GracefulApplication) {
                ((GracefulApplication)WOApplication.application()).gracefulTerminate();
            }
        }
        catch (RuntimeException e) {
            log.warn((Object)("Caught exception when attempting to gracefully shutdown! " + e.getClass().getName() + " stack: " + ERXUtilities.stackTrace(e)));
        }
        this.defaultHandler().handle(signal);
    }

    public SignalHandler defaultHandler() {
        return this.defaultHandler;
    }

    public void setDefaultHandler(SignalHandler value) {
        this.defaultHandler = value;
    }

    public static interface GracefulApplication {
        public void gracefulTerminate();
    }
}

