/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WOResponse;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.components.ERXNonSynchronizingComponent;
import er.extensions.foundation.ERXExceptionUtilities;
import er.extensions.foundation.ERXMutableDictionary;
import er.extensions.foundation.ERXSimpleTemplateParser;
import org.apache.log4j.Logger;

public class ERXInlineTemplate
extends ERXNonSynchronizingComponent {
    private static Logger log = Logger.getLogger(ERXInlineTemplate.class);
    private static final String ERROR_TEMPLATE_DEFAULT = "<div class=\"ERXInlineTemplateError\" style=\"background-color: #faa; border: 2px dotted red;\">@@message@@</div>";
    private static final String ERROR_TEMPLATE_BINDING = "errorTemplate";
    private static final String CACHE_KEY_BINDING = "cacheKey";
    private static final String CACHE_VERSION_BINDING = "cacheVersion";
    private static final String TEMPLATE_HTML_BINDING = "html";
    private static final String TEMPLATE_WOD_BINDING = "wod";
    private static final String PROXY_PARENT_BINDING = "proxyParent";
    private static final String DEFAULT_TO_DYNAMIC_BINDINGS_BINDING = "defaultToDynamicBindings";
    private static NSMutableDictionary<String, CacheEntry> _cache = ERXMutableDictionary.synchronizedDictionary();
    protected Error _deferredError = null;

    public ERXInlineTemplate(WOContext context) {
        super(context);
    }

    public void appendToResponse(WOResponse woresponse, WOContext wocontext) {
        if (this._deferredError != null) {
            woresponse.appendContentString(this._deferredError.formatWithTemplate(this.errorTemplate()));
        } else {
            try {
                super.appendToResponse(woresponse, wocontext);
            }
            catch (Throwable t) {
                woresponse.appendContentString(new Error("appendToResponse", t).formatWithTemplate(this.errorTemplate()));
            }
        }
        this._deferredError = null;
    }

    public String errorTemplate() {
        return this.stringValueForBinding(ERROR_TEMPLATE_BINDING, ERROR_TEMPLATE_DEFAULT);
    }

    public boolean proxyParent() {
        return this.booleanValueForBinding(PROXY_PARENT_BINDING);
    }

    public boolean defaultToDynamicBindings() {
        return this.booleanValueForBinding(DEFAULT_TO_DYNAMIC_BINDINGS_BINDING, true);
    }

    public void takeValueForKeyPath(Object value, String keyPath) {
        try {
            NSMutableArray<String> keyPathComponents = NSArray.componentsSeparatedByString(keyPath, ".").mutableClone();
            String firstKey = keyPathComponents.removeObjectAtIndex(0);
            if (this.bindingKeys().contains(firstKey)) {
                if (keyPathComponents.count() > 0) {
                    Object o = this.valueForBinding(firstKey);
                    String remainingKeyPath = keyPathComponents.componentsJoinedByString(".");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("set binding using keypath " + firstKey + " / " + remainingKeyPath));
                    }
                    NSKeyValueCodingAdditions.Utility.takeValueForKeyPath((Object)o, (Object)value, (String)remainingKeyPath);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("set binding value " + firstKey));
                    }
                    this.setValueForBinding(value, firstKey);
                }
            } else if (this.proxyParent()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("set parent binding " + keyPath));
                }
                this.parent().takeValueForKeyPath(value, keyPath);
            } else if (this.defaultToDynamicBindings()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("set dynamic binding " + keyPath));
                }
                this.dynamicBindings().takeValueForKeyPath(value, keyPath);
            } else {
                log.warn((Object)("Unknown keyPath: " + keyPath));
            }
        }
        catch (Throwable t) {
            this._deferredError = new Error("takeValueForKeyPath", t);
        }
    }

    public Object valueForKeyPath(String keyPath) {
        try {
            NSMutableArray<String> keyPathComponents = NSArray.componentsSeparatedByString(keyPath, ".").mutableClone();
            String firstKey = keyPathComponents.removeObjectAtIndex(0);
            Object value = null;
            if (this.bindingKeys().contains(firstKey)) {
                Object o = this.valueForBinding(firstKey);
                if (keyPathComponents.count() > 0) {
                    String remainingKeyPath = keyPathComponents.componentsJoinedByString(".");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("get binding using keypath " + firstKey + " / " + remainingKeyPath));
                    }
                    value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)o, (String)remainingKeyPath);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("get binding value " + firstKey));
                    }
                    value = o;
                }
            } else if (this.proxyParent()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("get parent binding " + keyPath));
                }
                value = this.parent().valueForKeyPath(keyPath);
            } else if (this.defaultToDynamicBindings()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("get dynamic binding " + keyPath));
                }
                value = this.dynamicBindings().valueForKeyPath(keyPath);
            } else {
                log.warn((Object)("Unknown keyPath: " + keyPath));
            }
            return value;
        }
        catch (Throwable t) {
            this._deferredError = new Error("takeValueForKeyPath", t);
            return null;
        }
    }

    public void takeValueForKey(Object obj, String s) {
        this.takeValueForKeyPath(obj, s);
    }

    public Object valueForKey(String s) {
        return this.valueForKeyPath(s);
    }

    public WOElement template() {
        try {
            WOElement element = null;
            String cacheKey = (String)this.valueForBinding(CACHE_KEY_BINDING);
            if (cacheKey != null) {
                CacheEntry cacheEntry = (CacheEntry)_cache.objectForKey(cacheKey);
                Object requestedVersion = this.valueForBinding(CACHE_VERSION_BINDING);
                if (cacheEntry != null && (requestedVersion == null || requestedVersion.equals(cacheEntry.version()))) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("using cache: " + cacheKey + " / " + cacheEntry.version()));
                    }
                    element = cacheEntry.element();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("updating cache: " + cacheKey + " / " + (cacheEntry == null ? null : cacheEntry.version()) + " -> " + requestedVersion));
                    }
                    element = this._template();
                    cacheEntry = new CacheEntry(requestedVersion, element);
                    _cache.takeValueForKey(cacheEntry, cacheKey);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"caching disabled");
                }
                element = this._template();
            }
            return element;
        }
        catch (Throwable t) {
            String html = new Error("template", t).formatWithTemplate(this.errorTemplate());
            return WOComponent.templateWithHTMLString((String)html, (String)"", null);
        }
    }

    private WOElement _template() {
        String html = this.stringValueForBinding(TEMPLATE_HTML_BINDING, "");
        String wod = this.stringValueForBinding(TEMPLATE_WOD_BINDING, "");
        WOElement element = WOComponent.templateWithHTMLString((String)html, (String)wod, null);
        return element;
    }

    public static class Error {
        private Throwable _t;
        private String _method;

        public Error(String method, Throwable t) {
            log.error((Object)(method + ": " + t), t);
            this._t = t;
            this._method = method;
        }

        public String message() {
            String s = ERXExceptionUtilities.toParagraph(this._t);
            if (s != null) {
                s = s.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br />");
            }
            return s;
        }

        public String method() {
            return this._method;
        }

        public String formatWithTemplate(String template) {
            return ERXSimpleTemplateParser.sharedInstance().parseTemplateWithObject(template, "@@", this);
        }
    }

    class CacheEntry {
        private WOElement _element;
        private Object _version;

        public CacheEntry(Object version, WOElement element) {
            this._version = version;
            this._element = element;
        }

        public WOElement element() {
            return this._element;
        }

        public Object version() {
            return this._version;
        }
    }
}

