/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicGroup;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;

public class ERXKeyValueSetter
extends WODynamicGroup {
    WOAssociation source;
    WOAssociation destination;
    WOAssociation sourceKeypath;
    WOAssociation destinationKeypath;

    public ERXKeyValueSetter(String arg0, NSDictionary arg1, NSMutableArray arg2) {
        super(arg0, arg1, arg2);
        this.source = (WOAssociation)arg1.objectForKey("source");
        this.destination = (WOAssociation)arg1.objectForKey("destination");
        this.sourceKeypath = (WOAssociation)arg1.objectForKey("sourceKeypath");
        this.destinationKeypath = (WOAssociation)arg1.objectForKey("destinationKeypath");
        if (this.source == null || this.destination == null) {
            throw new IllegalStateException("source and destination must be bound");
        }
    }

    private Object setup(WOComponent component) {
        Object newValue = this.source.valueInComponent(component);
        String sourceKey = null;
        if (this.sourceKeypath != null) {
            sourceKey = (String)this.sourceKeypath.valueInComponent(component);
        }
        if (sourceKey != null) {
            newValue = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)newValue, sourceKey);
        }
        String destinationKey = null;
        Object oldValue = this.destination.valueInComponent(component);
        if (this.destinationKeypath != null) {
            destinationKey = (String)this.destinationKeypath.valueInComponent(component);
        }
        if (destinationKey != null) {
            Object destinationTarget = oldValue;
            oldValue = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)destinationTarget, (String)destinationKey);
            NSKeyValueCodingAdditions.Utility.takeValueForKeyPath((Object)destinationTarget, (Object)newValue, (String)destinationKey);
        } else {
            this.destination.setValue(newValue, component);
        }
        return oldValue;
    }

    private void cleanup(Object oldValue, WOComponent component) {
        String destinationKey = null;
        if (this.destinationKeypath != null) {
            destinationKey = (String)this.destinationKeypath.valueInComponent(component);
        }
        if (destinationKey != null) {
            Object destinationTarget = oldValue;
            oldValue = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)destinationTarget, (String)destinationKey);
            NSKeyValueCodingAdditions.Utility.takeValueForKeyPath((Object)destinationTarget, (Object)oldValue, (String)destinationKey);
        } else {
            this.destination.setValue(oldValue, component);
        }
    }

    public void takeValuesFromRequest(WORequest request, WOContext context) {
        WOComponent component = context.component();
        Object old = this.setup(component);
        super.takeValuesFromRequest(request, context);
        this.cleanup(old, component);
    }

    public WOActionResults invokeAction(WORequest request, WOContext context) {
        WOComponent component = context.component();
        Object old = this.setup(component);
        WOActionResults result = super.invokeAction(request, context);
        this.cleanup(old, component);
        return result;
    }

    public void appendToResponse(WOResponse response, WOContext context) {
        WOComponent component = context.component();
        Object old = this.setup(component);
        super.appendToResponse(response, context);
        this.cleanup(old, component);
    }
}

