/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.foundation.NSArray;
import er.extensions.foundation.ERXArrayUtilities;
import er.extensions.foundation.ERXValueUtilities;
import er.extensions.localization.ERXLocalizer;

public class ERXListDisplay
extends WOComponent {
    public int index;
    protected NSArray list;
    protected String finalSeparator;
    protected String separator;
    private Boolean isEmptyList;
    private String emptyArrayDisplay;

    public ERXListDisplay(WOContext aContext) {
        super(aContext);
    }

    public boolean synchronizesVariablesWithBindings() {
        return false;
    }

    public boolean isStateless() {
        return true;
    }

    public boolean escapeHTML() {
        return ERXValueUtilities.booleanValueWithDefault(this.valueForBinding("escapeHTML"), true);
    }

    public boolean useContent() {
        return this.hasBinding("item");
    }

    public NSArray list() {
        if (this.list == null) {
            this.list = (NSArray)this.valueForBinding("list");
        }
        return this.list;
    }

    public boolean isEmptyList() {
        if (this.isEmptyList == null) {
            this.isEmptyList = this.list() == null || this.list().isEmpty();
        }
        return this.isEmptyList;
    }

    public Object item() {
        return this.valueForBinding("item");
    }

    public void setItem(Object item) {
        this.setValueForBinding(item, "item");
    }

    public String currentSeparator() {
        int count = this.list().count();
        if (this.index < count - 2) {
            return this.separator();
        }
        if (this.index == count - 2) {
            return this.finalSeparator();
        }
        return "";
    }

    public String finalSeparator() {
        if (this.finalSeparator == null) {
            this.finalSeparator = (String)this.valueForBinding("finalSeparator");
            this.finalSeparator = this.finalSeparator != null ? this.finalSeparator : ERXLocalizer.currentLocalizer().localizedStringForKeyWithDefault(" and ");
        }
        return this.finalSeparator;
    }

    public String separator() {
        if (this.separator == null) {
            this.separator = (String)this.valueForBinding("separator");
            this.separator = this.separator != null ? this.separator : ", ";
        }
        return this.separator;
    }

    public void reset() {
        super.reset();
        this.list = null;
        this.separator = null;
        this.finalSeparator = null;
        this.isEmptyList = null;
        this.emptyArrayDisplay = null;
    }

    public String displayString() {
        String attribute = (String)this.valueForBinding("attribute");
        attribute = attribute != null ? attribute : "toString";
        String empty = (String)this.valueForBinding("nullArrayDisplay");
        return ERXArrayUtilities.friendlyDisplayForKeyPath(this.list(), attribute, empty, this.separator(), this.finalSeparator());
    }

    public String emptyArrayDisplay() {
        if (this.emptyArrayDisplay == null) {
            this.emptyArrayDisplay = (String)this.valueForBinding("emptyArrayDisplay");
            if (this.emptyArrayDisplay == null) {
                this.emptyArrayDisplay = (String)this.valueForBinding("nullArrayDisplay");
            }
        }
        return this.emptyArrayDisplay;
    }
}

