/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WODirectAction;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver.WOSession;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import er.extensions.ERXExtensions;
import er.extensions.appserver.ERXApplication;
import er.extensions.appserver.ERXResourceManager;
import er.extensions.appserver.ERXResponseRewriter;
import er.extensions.appserver.ajax.ERXAjaxApplication;
import er.extensions.components.ERXStatelessComponent;
import er.extensions.foundation.ERXExpiringCache;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXStyleSheet
extends ERXStatelessComponent {
    public static final Logger log = Logger.getLogger(ERXStyleSheet.class);

    public ERXStyleSheet(WOContext aContext) {
        super(aContext);
    }

    private static ERXExpiringCache<String, WOResponse> cache(WOSession session) {
        ERXExpiringCache cache = (ERXExpiringCache)session.objectForKey("ERXStylesheet.cache");
        if (cache == null) {
            cache = new ERXExpiringCache(60L);
            cache.startBackgroundExpiration();
            session.setObjectForKey(cache, "ERXStylesheet.cache");
        }
        return cache;
    }

    public String styleSheetUrl() {
        String name;
        String url = (String)this.valueForBinding("styleSheetUrl");
        String string = url = url == null ? (String)this.valueForBinding("href") : url;
        if (url == null && (name = this.styleSheetName()) != null) {
            url = this.application().resourceManager().urlForResourceNamed(this.styleSheetName(), this.styleSheetFrameworkName(), this.languages(), this.context().request());
            if (ERXResourceManager._shouldGenerateCompleteResourceURL(this.context())) {
                url = ERXResourceManager._completeURLForResource(url, null, this.context());
            }
        }
        return url;
    }

    public String styleSheetFrameworkName() {
        String result = (String)this.valueForBinding("styleSheetFrameworkName");
        result = result == null ? (String)this.valueForBinding("framework") : result;
        return result;
    }

    public String styleSheetName() {
        String result = (String)this.valueForBinding("styleSheetName");
        result = result == null ? (String)this.valueForBinding("filename") : result;
        return result;
    }

    public String styleSheetKey() {
        String result = (String)this.valueForBinding("key");
        if (result == null) {
            result = this.context().session().sessionID();
        }
        return result;
    }

    public String rel() {
        return this.stringValueForBinding("rel");
    }

    public String title() {
        return this.stringValueForBinding("title");
    }

    public String mediaType() {
        return this.stringValueForBinding("media");
    }

    private NSArray<String> languages() {
        if (this.hasSession()) {
            return this.session().languages();
        }
        WORequest request = this.context().request();
        if (request != null) {
            return request.browserLanguages();
        }
        return null;
    }

    @Override
    public void appendToResponse(WOResponse originalResponse, WOContext wocontext) {
        boolean isResourceStyleSheet;
        String styleSheetFrameworkName = this.styleSheetFrameworkName();
        String styleSheetName = this.styleSheetName();
        boolean bl = isResourceStyleSheet = styleSheetName != null;
        if (!isResourceStyleSheet || !ERXResponseRewriter.isResourceAddedToHead(wocontext, styleSheetFrameworkName, styleSheetName)) {
            String title;
            boolean inline = this.booleanValueForBinding("inline", ERXAjaxApplication.isAjaxRequest(wocontext.request()));
            WOResponse response = inline ? originalResponse : new WOResponse();
            String href = this.styleSheetUrl();
            if (href == null) {
                String md5;
                String key = this.styleSheetKey();
                ERXExpiringCache<String, WOResponse> cache = ERXStyleSheet.cache(this.session());
                WOResponse cachedResponse = cache.objectForKey(key);
                if (cache.isStale(key) || ERXApplication.isDevelopmentModeSafe()) {
                    cachedResponse = new WOResponse();
                    super.appendToResponse(cachedResponse, wocontext);
                    wocontext._setResponse(originalResponse);
                    cachedResponse.setHeader("text/css", "content-type");
                    cache.setObjectForKey(cachedResponse, key);
                    md5 = ERXStringUtilities.md5Hex(cachedResponse.contentString(), null);
                    cachedResponse.setHeader(md5, "checksum");
                }
                md5 = cachedResponse.headerForKey((Object)"checksum");
                NSDictionary<String, String> query = new NSDictionary<String, String>(md5, "checksum");
                href = wocontext.directActionURLForActionNamed(Sheet.class.getName() + "/" + key, query);
            }
            response._appendContentAsciiString("<link ");
            String rel = this.rel();
            if (rel == null) {
                rel = "stylesheet";
            }
            response._appendTagAttributeAndValue("rel", rel, false);
            response._appendTagAttributeAndValue("type", "text/css", false);
            response._appendTagAttributeAndValue("href", href, false);
            String media = this.mediaType();
            if (media != null) {
                response._appendTagAttributeAndValue("media", media, false);
            }
            if ((title = this.title()) != null) {
                response._appendTagAttributeAndValue("title", title, false);
            }
            if (ERXStyleSheet.shouldCloseLinkTags()) {
                response._appendContentAsciiString("/>");
            } else {
                response._appendContentAsciiString(">");
            }
            response.appendContentString("\n");
            boolean inserted = true;
            if (!inline) {
                String stylesheetLink = response.contentString();
                inserted = ERXResponseRewriter.insertInResponseBeforeHead(originalResponse, wocontext, stylesheetLink, ERXResponseRewriter.TagMissingBehavior.Inline);
            }
            if (inserted) {
                if (isResourceStyleSheet) {
                    ERXResponseRewriter.resourceAddedToHead(wocontext, styleSheetFrameworkName, styleSheetName);
                } else if (href != null) {
                    ERXResponseRewriter.resourceAddedToHead(wocontext, null, href);
                }
            }
        }
    }

    public static boolean shouldCloseLinkTags() {
        return ERXProperties.booleanForKeyWithDefault("er.extensions.ERXStyleSheet.xhtml", true);
    }

    public static class Sheet
    extends WODirectAction {
        public Sheet(WORequest worequest) {
            super(worequest);
        }

        public WOActionResults performActionNamed(String name) {
            String queryMd5;
            WOResponse response = (WOResponse)ERXStyleSheet.cache(this.session()).objectForKey(name);
            String md5 = ERXStringUtilities.md5Hex(response.contentString(), null);
            if (ERXExtensions.safeEquals(md5, queryMd5 = response.headerForKey((Object)"checksum"))) {
                // empty if block
            }
            return response;
        }
    }
}

