/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.components._private;

import com.webobjects.appserver.WOActionResults;
import com.webobjects.appserver.WOAssociation;
import com.webobjects.appserver.WOComponent;
import com.webobjects.appserver.WOContext;
import com.webobjects.appserver.WOElement;
import com.webobjects.appserver.WORequest;
import com.webobjects.appserver.WOResponse;
import com.webobjects.appserver._private.WODynamicElementCreationException;
import com.webobjects.appserver._private.WODynamicGroup;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import er.extensions.eof.ERXBatchFetchUtilities;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXDatabaseContextDelegate;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.util.List;
import org.apache.log4j.Logger;

public class ERXWORepetition
extends WODynamicGroup {
    private static final Logger log = Logger.getLogger(ERXWORepetition.class);
    protected WOAssociation _list;
    protected WOAssociation _item;
    protected WOAssociation _count;
    protected WOAssociation _index;
    protected WOAssociation _uniqueKey;
    protected WOAssociation _checkHashCodes;
    protected WOAssociation _raiseOnUnmatchedObject;
    protected WOAssociation _eoSupport;
    protected WOAssociation _debugHashCodes;
    protected WOAssociation _batchFetch;
    protected WOAssociation _notFoundMarker;
    private static boolean _checkHashCodesDefault = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXWORepetition.checkHashCodes", ERXProperties.booleanForKey(ERXWORepetition.class.getName() + ".checkHashCodes"));
    private static boolean _raiseOnUnmatchedObjectDefault = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXWORepetition.raiseOnUnmatchedObject", ERXProperties.booleanForKey(ERXWORepetition.class.getName() + ".raiseOnUnmatchedObject"));
    private static boolean _eoSupportDefault = ERXProperties.booleanForKeyWithDefault("er.extensions.ERXWORepetition.eoSupport", ERXProperties.booleanForKey(ERXWORepetition.class.getName() + ".eoSupport"));

    public ERXWORepetition(String string, NSDictionary associations, WOElement woelement) {
        super(null, null, woelement);
        this._list = (WOAssociation)associations.objectForKey("list");
        this._item = (WOAssociation)associations.objectForKey("item");
        this._count = (WOAssociation)associations.objectForKey("count");
        this._index = (WOAssociation)associations.objectForKey("index");
        this._uniqueKey = (WOAssociation)associations.objectForKey("uniqueKey");
        this._checkHashCodes = (WOAssociation)associations.objectForKey("checkHashCodes");
        this._raiseOnUnmatchedObject = (WOAssociation)associations.objectForKey("raiseOnUnmatchedObject");
        this._debugHashCodes = (WOAssociation)associations.objectForKey("debugHashCodes");
        this._eoSupport = (WOAssociation)associations.objectForKey("eoSupport");
        this._batchFetch = (WOAssociation)associations.objectForKey("batchFetch");
        this._notFoundMarker = (WOAssociation)associations.objectForKey("notFoundMarker");
        if (this._list == null && this._count == null) {
            this._failCreation("Missing 'list' or 'count' attribute.");
        }
        if (this._list != null && this._item == null) {
            this._failCreation("Missing 'item' attribute with 'list' attribute.");
        }
        if (this._list != null && this._count != null) {
            this._failCreation("Illegal use of 'count' attribute with 'list' attribute.");
        }
        if (this._count != null && (this._list != null || this._item != null)) {
            this._failCreation("Illegal use of 'list', or 'item'attributes with 'count' attribute.");
        }
        if (this._item != null && !this._item.isValueSettable()) {
            this._failCreation("Illegal read-only 'item' attribute.");
        }
        if (this._index != null && !this._index.isValueSettable()) {
            this._failCreation("Illegal read-only 'index' attribute.");
        }
    }

    protected void _failCreation(String message) {
        throw new WODynamicElementCreationException("<" + ((Object)((Object)this)).getClass().getName() + "> " + message);
    }

    public String toString() {
        return "<" + ((Object)((Object)this)).getClass().getName() + " list: " + (this._list != null ? this._list.toString() : "null") + " item: " + (this._item != null ? this._item.toString() : "null") + " count: " + (this._count != null ? this._count.toString() : "null") + " index: " + (this._index != null ? this._index.toString() : "null") + ">";
    }

    private int hashCodeForObject(WOComponent component, Object object) {
        int hashCode;
        if (object == null) {
            hashCode = 0;
        } else if (this.eoSupport(component) && object instanceof EOEnterpriseObject) {
            EOEnterpriseObject eo = (EOEnterpriseObject)object;
            EOEditingContext editingContext = eo.editingContext();
            EOGlobalID gid = null;
            if (editingContext != null) {
                gid = editingContext.globalIDForObject(eo);
            }
            hashCode = gid == null ? System.identityHashCode(object) : gid.hashCode();
        } else {
            hashCode = System.identityHashCode(object);
        }
        if (hashCode == Integer.MIN_VALUE) {
            hashCode = 37;
        }
        hashCode = Math.abs(hashCode);
        if (this._debugHashCodes != null && this._debugHashCodes.booleanValueInComponent(component)) {
            log.info((Object)("debugHashCodes for '" + this._list.keyPath() + "', " + object + " = " + hashCode));
        }
        return hashCode;
    }

    private String keyForObject(WOComponent component, Object object) {
        String uniqueKeyPath = (String)this._uniqueKey.valueInComponent(component);
        Object uniqueKey = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)object, (String)uniqueKeyPath);
        if (uniqueKey == null) {
            throw new IllegalArgumentException("Can't use null as uniqueKey for " + object);
        }
        String key = ERXStringUtilities.safeIdentifierName(uniqueKey.toString());
        if (this._debugHashCodes != null && this._debugHashCodes.booleanValueInComponent(component)) {
            log.info((Object)("debugHashCodes for '" + this._list.keyPath() + "', " + object + " = " + key));
        }
        return key;
    }

    protected void _prepareForIterationWithIndex(Context context, int index, WOContext wocontext, WOComponent wocomponent, boolean checkHashCodes) {
        Object object = null;
        if (this._item != null) {
            object = context.objectAtIndex(index);
            this._item._setValueNoValidation(object, wocomponent);
        }
        if (this._index != null) {
            Integer integer = ERXConstant.integerForInt(index);
            this._index._setValueNoValidation((Object)integer, wocomponent);
        }
        boolean didAppend = false;
        if (checkHashCodes && object != null) {
            String elementID = null;
            if (this._uniqueKey == null) {
                int hashCode = this.hashCodeForObject(wocomponent, object);
                if (hashCode != 0) {
                    elementID = String.valueOf(hashCode);
                }
            } else {
                elementID = this.keyForObject(wocomponent, object);
            }
            if (elementID != null) {
                if (index != 0) {
                    wocontext.deleteLastElementIDComponent();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("prepare " + elementID + "->" + object));
                }
                wocontext.appendElementIDComponent(elementID);
                didAppend = true;
            }
        }
        if (!didAppend) {
            if (index != 0) {
                wocontext.incrementLastElementIDComponent();
            } else {
                wocontext.appendZeroElementIDComponent();
            }
        }
    }

    protected void _cleanupAfterIteration(int i, WOContext wocontext, WOComponent wocomponent) {
        if (this._item != null) {
            this._item._setValueNoValidation(null, wocomponent);
        }
        if (this._index != null) {
            Integer integer = ERXConstant.integerForInt(i);
            this._index._setValueNoValidation((Object)integer, wocomponent);
        }
        wocontext.deleteLastElementIDComponent();
    }

    protected String _indexStringForSenderAndElement(String senderID, String elementID) {
        int dotOffset = elementID.length() + 1;
        int nextDotOffset = senderID.indexOf(46, dotOffset);
        String indexString = nextDotOffset < 0 ? senderID.substring(dotOffset) : senderID.substring(dotOffset, nextDotOffset);
        return indexString;
    }

    protected String _indexOfChosenItem(WORequest worequest, WOContext wocontext) {
        String elementID;
        String indexString = null;
        String senderID = wocontext.senderID();
        if (senderID.startsWith(elementID = wocontext.elementID())) {
            int i = elementID.length();
            if (senderID.length() > i && senderID.charAt(i) == '.') {
                indexString = this._indexStringForSenderAndElement(senderID, elementID);
            }
        }
        return indexString;
    }

    protected int _count(Context context, WOComponent wocomponent) {
        int count;
        if (this._list != null) {
            count = context.count();
        } else {
            Object object = this._count.valueInComponent(wocomponent);
            if (object != null) {
                count = ERXValueUtilities.intValue(object);
            } else {
                log.error((Object)(this.toString() + " 'count' evaluated to null in component " + wocomponent.toString() + ".\nRepetition  count reset to 0."));
                count = 0;
            }
        }
        return count;
    }

    protected Context createContext(WOComponent wocomponent) {
        Object list;
        Object object = list = this._list != null ? this._list.valueInComponent(wocomponent) : null;
        if (list instanceof NSArray) {
            NSArray<String> keyPaths;
            String batchFetchKeyPaths;
            if (this._batchFetch != null && (batchFetchKeyPaths = (String)this._batchFetch.valueInComponent(wocomponent)) != null && (keyPaths = NSArray.componentsSeparatedByString(batchFetchKeyPaths, ",")).count() > 0) {
                ERXBatchFetchUtilities.batchFetch((NSArray)list, keyPaths, true);
            }
            ERXDatabaseContextDelegate.setCurrentBatchObjects((NSArray)list);
        }
        return new Context(list);
    }

    public void takeValuesFromRequest(WORequest worequest, WOContext wocontext) {
        WOComponent wocomponent = wocontext.component();
        Context context = this.createContext(wocomponent);
        int count = this._count(context, wocomponent);
        boolean checkHashCodes = this.checkHashCodes(wocomponent);
        if (log.isDebugEnabled()) {
            log.debug((Object)("takeValuesFromRequest: " + wocontext.elementID() + " - " + wocontext.request().formValueKeys()));
        }
        for (int index = 0; index < count; ++index) {
            this._prepareForIterationWithIndex(context, index, wocontext, wocomponent, checkHashCodes);
            super.takeValuesFromRequest(worequest, wocontext);
        }
        if (count > 0) {
            this._cleanupAfterIteration(count, wocontext, wocomponent);
        }
    }

    public WOActionResults invokeAction(WORequest worequest, WOContext wocontext) {
        WOComponent wocomponent = wocontext.component();
        Context repetitionContext = this.createContext(wocomponent);
        int count = this._count(repetitionContext, wocomponent);
        WOActionResults woactionresults = null;
        String indexString = this._indexOfChosenItem(worequest, wocontext);
        int index = 0;
        boolean checkHashCodes = this.checkHashCodes(wocomponent);
        if (indexString != null && !checkHashCodes) {
            index = Integer.parseInt(indexString);
        }
        if (indexString != null) {
            if (this._item != null) {
                Object object = null;
                if (checkHashCodes) {
                    boolean found = false;
                    if (this._uniqueKey == null) {
                        int hashCode = Integer.parseInt(indexString);
                        int otherHashCode = 0;
                        for (int i = 0; i < repetitionContext.count() && !found; ++i) {
                            Object o = repetitionContext.objectAtIndex(i);
                            otherHashCode = this.hashCodeForObject(wocomponent, o);
                            if (otherHashCode != hashCode) continue;
                            object = o;
                            index = i;
                            found = true;
                        }
                        if (!found) {
                            log.warn((Object)("Wrong object: " + otherHashCode + " vs " + hashCode + " (array = " + repetitionContext.nsarray + ")"));
                        }
                        if (found && log.isDebugEnabled()) {
                            log.debug((Object)("Found object: " + otherHashCode + " vs " + hashCode));
                        }
                    } else {
                        String key = indexString;
                        String otherKey = null;
                        for (int i = 0; i < repetitionContext.count() && !found; ++i) {
                            Object o = repetitionContext.objectAtIndex(i);
                            otherKey = this.keyForObject(wocomponent, o);
                            if (!otherKey.equals(key)) continue;
                            object = o;
                            index = i;
                            found = true;
                        }
                        if (!found) {
                            log.warn((Object)("Wrong object: " + otherKey + " vs " + key + " (array = " + repetitionContext.nsarray + ")"));
                        }
                        if (found && log.isDebugEnabled()) {
                            log.debug((Object)("Found object: " + otherKey + " vs " + key));
                        }
                    }
                    if (!found) {
                        if (this.raiseOnUnmatchedObject(wocomponent)) {
                            throw new UnmatchedObjectException();
                        }
                        if (this._notFoundMarker == null) {
                            return wocontext.page();
                        }
                        object = this._notFoundMarker.valueInComponent(wocomponent);
                    }
                } else {
                    if (index >= repetitionContext.count()) {
                        if (this.raiseOnUnmatchedObject(wocomponent)) {
                            throw new UnmatchedObjectException();
                        }
                        return wocontext.page();
                    }
                    object = repetitionContext.objectAtIndex(index);
                }
                this._item._setValueNoValidation(object, wocomponent);
            }
            if (this._index != null) {
                Integer integer = ERXConstant.integerForInt(index);
                this._index._setValueNoValidation((Object)integer, wocomponent);
            }
            wocontext.appendElementIDComponent(indexString);
            if (log.isDebugEnabled()) {
                log.debug((Object)("invokeAction:" + wocontext.elementID()));
            }
            woactionresults = super.invokeAction(worequest, wocontext);
            wocontext.deleteLastElementIDComponent();
        } else {
            int start = indexString == null ? 0 : index;
            int end = indexString == null ? count : index + 1;
            for (int i = start; i < end && woactionresults == null; ++i) {
                this._prepareForIterationWithIndex(repetitionContext, i, wocontext, wocomponent, checkHashCodes);
                woactionresults = super.invokeAction(worequest, wocontext);
            }
            if (count > 0) {
                this._cleanupAfterIteration(count, wocontext, wocomponent);
            }
        }
        return woactionresults;
    }

    private boolean checkHashCodes(WOComponent wocomponent) {
        if (this._checkHashCodes != null) {
            return this._checkHashCodes.booleanValueInComponent(wocomponent);
        }
        return _checkHashCodesDefault;
    }

    private boolean raiseOnUnmatchedObject(WOComponent wocomponent) {
        if (this._raiseOnUnmatchedObject != null) {
            return this._raiseOnUnmatchedObject.booleanValueInComponent(wocomponent);
        }
        return _raiseOnUnmatchedObjectDefault;
    }

    private boolean eoSupport(WOComponent wocomponent) {
        if (this._eoSupport != null) {
            return this._eoSupport.booleanValueInComponent(wocomponent);
        }
        return _eoSupportDefault;
    }

    public void appendToResponse(WOResponse woresponse, WOContext wocontext) {
        WOComponent wocomponent = wocontext.component();
        Context context = this.createContext(wocomponent);
        int count = this._count(context, wocomponent);
        boolean checkHashCodes = this.checkHashCodes(wocomponent);
        if (log.isDebugEnabled()) {
            log.debug((Object)("appendToResponse:" + wocontext.elementID()));
        }
        for (int index = 0; index < count; ++index) {
            this._prepareForIterationWithIndex(context, index, wocontext, wocomponent, checkHashCodes);
            super.appendChildrenToResponse(woresponse, wocontext);
        }
        if (count > 0) {
            this._cleanupAfterIteration(count, wocontext, wocomponent);
        }
    }

    protected class Context {
        protected NSArray nsarray;
        protected List list;
        protected Object[] array;

        public Context(Object object) {
            if (object != null) {
                if (object instanceof NSArray) {
                    this.nsarray = (NSArray)object;
                } else if (object instanceof List) {
                    this.list = (List)object;
                } else if (object instanceof Object[]) {
                    this.array = (Object[])object;
                } else {
                    throw new IllegalArgumentException("Evaluating 'list' binding returned a " + object.getClass().getName() + " when it should return either a NSArray, an Object[] array or a java.util.List .");
                }
            }
        }

        protected int count() {
            if (this.nsarray != null) {
                return this.nsarray.count();
            }
            if (this.list != null) {
                return this.list.size();
            }
            if (this.array != null) {
                return this.array.length;
            }
            return 0;
        }

        protected Object objectAtIndex(int i) {
            if (this.nsarray != null) {
                return this.nsarray.objectAtIndex(i);
            }
            if (this.list != null) {
                return this.list.get(i);
            }
            if (this.array != null) {
                return this.array[i];
            }
            return null;
        }
    }

    public static class UnmatchedObjectException
    extends RuntimeException {
    }
}

