/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.crypting;

import com.webobjects.foundation.NSForwardException;
import er.extensions.crypting.ERXCrypterInterface;
import er.extensions.crypting.ERXCrypto;
import er.extensions.foundation.ERXStringUtilities;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.apache.log4j.Logger;

public abstract class ERXAbstractBlowfishCrypter
implements ERXCrypterInterface {
    public static final Logger log = Logger.getLogger(ERXCrypto.class);
    private int _blockSize = 8;
    private Cipher _encryptCipher;
    private Cipher _decryptCipher;

    public void setBlockSize(int blockSize) {
        this._blockSize = blockSize;
    }

    public int blockSize() {
        return this._blockSize;
    }

    protected abstract Key secretBlowfishKey() throws Exception;

    protected Cipher createBlowfishCipher(int mode) {
        try {
            Cipher cipher = Cipher.getInstance("Blowfish/ECB/NoPadding");
            cipher.init(mode, this.secretBlowfishKey());
            return cipher;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NSForwardException((Throwable)ex, "Couldn't find the Blowfish algorithm; perhaps you do not have the SunJCE security provider installed properly?");
        }
        catch (Exception e) {
            throw new NSForwardException((Throwable)e);
        }
    }

    protected Cipher encryptCipher() {
        if (this._encryptCipher == null) {
            this._encryptCipher = this.createBlowfishCipher(1);
        }
        return this._encryptCipher;
    }

    protected Cipher decryptCipher() {
        if (this._decryptCipher == null) {
            this._decryptCipher = this.createBlowfishCipher(2);
        }
        return this._decryptCipher;
    }

    public String decrypt(String cryptedText) {
        if (cryptedText == null) {
            return null;
        }
        int length = cryptedText.length();
        if (length % 16 != 0) {
            return null;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] clearText = null;
        byte[] encryptedBytes = new byte[this._blockSize];
        int i = 0;
        int j = 0;
        while (j < length) {
            char c1;
            int b1 = (c1 = cryptedText.charAt(j++)) < 'a' ? c1 - 48 : c1 - 97 + 10;
            char c2 = cryptedText.charAt(j++);
            int b2 = c2 < 'a' ? c2 - 48 : c2 - 97 + 10;
            encryptedBytes[i++] = (byte)((b1 << 4) + b2);
            if (i != this._blockSize) continue;
            try {
                clearText = this.decryptCipher().doFinal(encryptedBytes);
            }
            catch (Exception e) {
                throw new NSForwardException((Throwable)e);
            }
            for (int k = 0; k < this._blockSize; ++k) {
                if (clearText[k] == 0) continue;
                result.write(clearText[k]);
            }
            i = 0;
        }
        if (i != 0) {
            j = i;
            while (j < this._blockSize) {
                encryptedBytes[j] = 0;
                ++i;
            }
            try {
                clearText = this.decryptCipher().doFinal(encryptedBytes);
            }
            catch (Exception e) {
                throw new NSForwardException((Throwable)e);
            }
            for (int k = 0; k < this._blockSize; ++k) {
                result.write(clearText[k]);
            }
        }
        return ERXStringUtilities.fromUTF8Bytes(result.toByteArray());
    }

    public String encrypt(String clearText) {
        if (clearText == null) {
            return null;
        }
        byte[] clearTextBytes = ERXStringUtilities.toUTF8Bytes(clearText);
        StringBuffer result = new StringBuffer();
        int length = clearTextBytes.length;
        byte[] bytesToEncrypt = new byte[this._blockSize];
        byte[] encryptedBytes = null;
        for (int pos = 0; pos < length; pos += this._blockSize) {
            int k = 0;
            for (int j = pos; j < length && j < pos + this._blockSize; ++j) {
                bytesToEncrypt[k] = clearTextBytes[j];
                ++k;
            }
            if (k < this._blockSize) {
                for (int l = k; l < this._blockSize; ++l) {
                    bytesToEncrypt[l] = 0;
                }
            }
            try {
                encryptedBytes = this.encryptCipher().doFinal(bytesToEncrypt);
            }
            catch (Exception e) {
                throw new NSForwardException((Throwable)e);
            }
            for (k = 0; k < this._blockSize; ++k) {
                result.append(ERXStringUtilities.HEX_CHARS[encryptedBytes[k] >>> 4 & 0xF]);
                result.append(ERXStringUtilities.HEX_CHARS[encryptedBytes[k] & 0xF]);
            }
        }
        return result.toString();
    }
}

