/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.crypting;

import er.extensions.crypting.ERXCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXCryptoString
implements Comparable<ERXCryptoString> {
    private final String value;

    public ERXCryptoString(String clearText) {
        this.value = clearText == null ? "" : clearText;
    }

    public static ERXCryptoString createInstanceFromCryptoString(String encryptedString) {
        return encryptedString == null ? null : new ERXCryptoString(ERXCryptoString.decryptText(encryptedString));
    }

    private static String encryptText(String clearText) {
        return ERXCrypto.defaultCrypter().encrypt(clearText);
    }

    private static String decryptText(String encryptedText) {
        return ERXCrypto.defaultCrypter().decrypt(encryptedText);
    }

    @Override
    public int compareTo(ERXCryptoString cryptoString) {
        return this.value.compareTo(cryptoString.toString());
    }

    public boolean equals(Object object) {
        return object instanceof ERXCryptoString ? this.value.equals(object.toString()) : false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toCryptoString() {
        return ERXCryptoString.encryptText(this.value);
    }

    public String toString() {
        return this.value;
    }
}

