/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOAdaptorChannel;
import com.webobjects.eoaccess.EODatabaseChannel;
import com.webobjects.eoaccess.EODatabaseContext;
import com.webobjects.eoaccess.EOSQLExpression;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXRuntimeUtilities;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXAdaptorChannelDelegate {
    private static Logger log = Logger.getLogger(ERXAdaptorChannelDelegate.class);
    private long _lastMilliseconds;
    private LinkedList _lastStatements;
    private Boolean _collectLastStatements;
    private Integer _numberOfStatementsToCollect;

    public static void setupDelegate() {
        NSNotificationCenter.defaultCenter().addObserver(ERXAdaptorChannelDelegate.class, new NSSelector("dataBaseChannelNeeded", ERXConstant.NotificationClassArray), "EODatabaseChannelNeededNotification", null);
    }

    public void adaptorChannelDidFetchRow(EOAdaptorChannel eoadaptorchannel, NSMutableDictionary nsmutabledictionary) {
        ERXRuntimeUtilities.checkThreadInterrupt();
    }

    public void adaptorChannelDidEvaluateExpression(EOAdaptorChannel channel, EOSQLExpression expression) {
        if (this.collectLastStatements()) {
            if (this._lastStatements == null) {
                this._lastStatements = new LinkedList();
            }
            this._lastStatements.addLast(ERXEOAccessUtilities.createLogString(channel, expression, System.currentTimeMillis() - this._lastMilliseconds));
            while (this._lastStatements.size() > this.numberOfStatementsToCollect()) {
                this._lastStatements.removeFirst();
            }
        }
        ERXEOAccessUtilities.logExpression(channel, expression, this._lastMilliseconds);
    }

    private int numberOfStatementsToCollect() {
        if (this._numberOfStatementsToCollect == null) {
            this._numberOfStatementsToCollect = new Integer(ERXProperties.intForKeyWithDefault("er.extensions.ERXSQLExpressionTracker.numberOfStatementsToCollect", 10));
        }
        return this._numberOfStatementsToCollect;
    }

    private boolean collectLastStatements() {
        if (this._collectLastStatements == null) {
            this._collectLastStatements = new Boolean(ERXProperties.booleanForKeyWithDefault("er.extensions.ERXSQLExpressionTracker.collectLastStatements", false));
        }
        return this._collectLastStatements;
    }

    public boolean adaptorChannelShouldEvaluateExpression(EOAdaptorChannel channel, EOSQLExpression expression) {
        this._lastMilliseconds = System.currentTimeMillis();
        return true;
    }

    public static void dataBaseChannelNeeded(NSNotification n) {
        if (ERXProperties.booleanForKeyWithDefault("er.extensions.ERXAdaptorChannelDelegate.enabled", false)) {
            EODatabaseContext context = (EODatabaseContext)n.object();
            EODatabaseChannel channel = new EODatabaseChannel(context);
            context.registerChannel(channel);
            channel.adaptorChannel().setDelegate((Object)new ERXAdaptorChannelDelegate());
        }
    }

    public synchronized void dumpLastStatements() {
        log.info((Object)"******* dumping collected SQL statements *******");
        if (this._lastStatements != null) {
            for (int i = 0; i < this._lastStatements.size(); ++i) {
                log.info(this._lastStatements.get(i));
            }
        } else {
            log.info((Object)"No collected statements available.");
            if (!this._collectLastStatements.booleanValue()) {
                log.info((Object)"You have to set the property 'er.extensions.ERXSQLExpressionTracker.collectLastStatements = true'. to make this feature work.");
            }
        }
        this._lastStatements = new LinkedList();
        log.info((Object)"************************************************");
    }

    public LinkedList<String> lastStatements() {
        return this._lastStatements;
    }
}

