/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOUtilities;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOObjectStoreCoordinator;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSSelector;
import er.extensions.eof.ERXEC;
import er.extensions.eof.ERXEOAccessUtilities;
import er.extensions.foundation.ERXSelectorUtilities;
import java.util.Enumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ERXEnterpriseObjectChangeListener<T extends EOEnterpriseObject> {
    public static String ClearCacheNotification = "ERXEnterpriseObjectChangeListener.ClearCache";
    private String _entityName;
    private boolean _trackAllChanges;
    private boolean _deep;

    public ERXEnterpriseObjectChangeListener(Class c, boolean trackAllChanges, boolean deep) {
        this(ERXEnterpriseObjectChangeListener.entityNameForClass(c), trackAllChanges, deep);
    }

    public ERXEnterpriseObjectChangeListener(String entityName, boolean trackAllChanges, boolean deep) {
        this._entityName = entityName;
        this._trackAllChanges = trackAllChanges;
        this._deep = deep;
        this.registerForNotifications();
    }

    private static String entityNameForClass(Class c) {
        block3: {
            String string;
            EOEditingContext ec = ERXEC.newEditingContext();
            ec.lock();
            try {
                EOEntity entity = EOUtilities.entityForClass((EOEditingContext)ec, (Class)c);
                if (entity == null) break block3;
                string = entity.name();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                ec.unlock();
                throw throwable;
            }
            ec.unlock();
            return string;
        }
        throw new IllegalArgumentException("There is no entity for the class " + c + ".");
    }

    protected void registerForNotifications() {
        NSSelector selector = ERXSelectorUtilities.notificationSelector("editingContextDidSaveChanges");
        NSNotificationCenter.defaultCenter().addObserver((Object)this, selector, "EOEditingContextDidSaveChangesNotification", null);
        selector = ERXSelectorUtilities.notificationSelector("clearCache");
        NSNotificationCenter.defaultCenter().addObserver((Object)this, selector, ClearCacheNotification, null);
    }

    protected NSArray<T> relevantChanges(EOEditingContext editingContext, NSDictionary dict, String key) {
        NSArray allObjects = (NSArray)dict.objectForKey(key);
        NSMutableArray<EOEnterpriseObject> changedObjects = new NSMutableArray<EOEnterpriseObject>();
        Enumeration enumeration = allObjects.objectEnumerator();
        while (enumeration.hasMoreElements()) {
            EOEnterpriseObject eo = (EOEnterpriseObject)enumeration.nextElement();
            String changedEntityName = eo.entityName();
            if (!this.isRelevant(editingContext, changedEntityName)) continue;
            changedObjects.addObject(eo);
            if (this._trackAllChanges) continue;
            break;
        }
        return changedObjects;
    }

    protected boolean isRelevant(EOEditingContext editingContext, String changedEntityName) {
        boolean relevant = false;
        if (changedEntityName.equals(this._entityName)) {
            relevant = true;
        } else if (this._deep) {
            EOEntity changedEntity = ERXEOAccessUtilities.entityNamed(editingContext, changedEntityName);
            for (EOEntity parent = changedEntity.parentEntity(); !relevant && parent != null; parent = parent.parentEntity()) {
                relevant = changedEntityName.equals(parent.name());
            }
        }
        return relevant;
    }

    public void editingContextDidSaveChanges(NSNotification n) {
        EOEditingContext ec = (EOEditingContext)n.object();
        if (ec.parentObjectStore() instanceof EOObjectStoreCoordinator) {
            NSArray<T> entitiesInserted = this.relevantChanges(ec, n.userInfo(), "inserted");
            NSArray<T> entitiesUpdated = null;
            NSArray<T> entitiesDeleted = null;
            if ((entitiesInserted.count() == 0 || this._trackAllChanges) && ((entitiesUpdated = this.relevantChanges(ec, n.userInfo(), "updated")).count() == 0 || this._trackAllChanges) && (entitiesDeleted = this.relevantChanges(ec, n.userInfo(), "deleted")).count() == 0) {
                return;
            }
            if (entitiesInserted.count() > 0 || entitiesUpdated.count() > 0 || entitiesDeleted.count() > 0) {
                if (this._trackAllChanges) {
                    this.entitiesChanged(entitiesInserted, entitiesUpdated, entitiesDeleted);
                } else {
                    this.entitiesChanged(null, null, null);
                }
            }
        }
    }

    public void clearCache(NSNotification n) {
        if (n.object() == null || this.entityName().equals(n.object())) {
            this.clearCache();
        }
    }

    protected String entityName() {
        return this._entityName;
    }

    public abstract void entitiesChanged(NSArray<T> var1, NSArray<T> var2, NSArray<T> var3);

    public abstract void clearCache();
}

