/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOGlobalID;
import com.webobjects.foundation.NSArray;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXFaultArray<T extends EOEnterpriseObject>
extends NSArray<T> {
    private EOEditingContext _editingContext;
    private EOGlobalID[] _array;
    private WeakReference<T>[] _refs;

    public ERXFaultArray(NSArray<T> array) {
        this._refs = new WeakReference[array.size()];
        this._array = new EOGlobalID[array.size()];
        if (array.count() > 0) {
            this.setEditingContext(((EOEnterpriseObject)array.lastObject()).editingContext());
            int i = 0;
            for (EOEnterpriseObject eo : array) {
                this._refs[i] = new WeakReference<EOEnterpriseObject>(eo);
                this._array[i] = this.editingContext().globalIDForObject(eo);
                ++i;
            }
        }
    }

    public ERXFaultArray(EOEditingContext ec, NSArray<EOGlobalID> array) {
        this.setEditingContext(ec);
        this._refs = new WeakReference[array.size()];
        this._array = new EOGlobalID[array.size()];
        int i = 0;
        for (EOGlobalID gid : array) {
            this._refs[i] = null;
            this._array[i] = gid;
            ++i;
        }
    }

    @Override
    public T objectAtIndex(int index) {
        int count = this.count();
        if (index >= 0 && index < count) {
            EOEnterpriseObject result = null;
            WeakReference<T> ref = this._refs[index];
            if (ref != null) {
                result = (EOEnterpriseObject)ref.get();
            }
            if (result == null) {
                EOGlobalID gid = this._array[index];
                result = this.editingContext().objectForGlobalID(gid);
                if (result == null) {
                    result = this.editingContext().faultForGlobalID(gid, this.editingContext());
                }
                this._refs[index] = new WeakReference<EOEnterpriseObject>(result);
            }
            return (T)result;
        }
        if (count == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this.count() - 1) + "]");
    }

    @Override
    public boolean containsObject(Object object) {
        if (object instanceof EOEnterpriseObject) {
            EOEnterpriseObject eo = (EOEnterpriseObject)object;
            EOGlobalID gid = this.editingContext().globalIDForObject(eo);
            for (int i = 0; i < this.count(); ++i) {
                EOGlobalID current = this._array[i];
                if (!current.equals((Object)gid)) continue;
                return true;
            }
            return false;
        }
        return super.containsObject(object);
    }

    @Override
    public int indexOfObject(Object object) {
        if (object instanceof EOEnterpriseObject) {
            EOEnterpriseObject eo = (EOEnterpriseObject)object;
            EOGlobalID gid = this.editingContext().globalIDForObject(eo);
            for (int i = 0; i < this.count(); ++i) {
                EOGlobalID current = this._array[i];
                if (!current.equals((Object)gid)) continue;
                return i;
            }
            return -1;
        }
        return super.indexOfObject(object);
    }

    @Override
    public int count() {
        return this._array != null ? this._array.length : 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ERXFaultArray.this.count();
            }

            @Override
            public T next() {
                return ERXFaultArray.this.objectAtIndex(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Enumeration objectEnumerator() {
        return new Enumeration<T>(){
            int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < ERXFaultArray.this.count();
            }

            @Override
            public T nextElement() {
                return ERXFaultArray.this.objectAtIndex(this.index++);
            }
        };
    }

    @Override
    public Enumeration<T> reverseObjectEnumerator() {
        return new Enumeration<T>(){
            int index;
            {
                this.index = ERXFaultArray.this.count();
            }

            @Override
            public boolean hasMoreElements() {
                return this.index > 0;
            }

            @Override
            public T nextElement() {
                return ERXFaultArray.this.objectAtIndex(--this.index);
            }
        };
    }

    @Override
    protected Object[] _objects() {
        Object[] result = new Object[this.count()];
        for (int i = 0; i < this.count(); ++i) {
            result[i] = this.objectAtIndex(i);
        }
        return result;
    }

    public EOEditingContext editingContext() {
        return this._editingContext;
    }

    @Override
    public Object clone() {
        ERXFaultArray<T> other = new ERXFaultArray<T>(this._editingContext, NSArray.EmptyArray);
        other._array = this._array;
        return other;
    }

    public void setEditingContext(EOEditingContext ec) {
        if (this._editingContext != ec) {
            for (int i = 0; i < this.count(); ++i) {
                this._refs[i] = null;
            }
        }
        this._editingContext = ec;
    }
}

