/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSLocking;
import java.io.File;
import java.io.IOException;

public class ERXGlobalLock
implements NSLocking {
    private File _lockfile;
    private int _lockcnt;
    private Thread _owner;

    public ERXGlobalLock(String name) {
        this._lockfile = new File(System.getProperty("java.io.tmpdir") + File.separator + "ERXGlobalLock_" + name);
        this._lockcnt = 0;
    }

    public void lock() {
        if (this._owner == Thread.currentThread() && this._lockcnt > 0) {
            ++this._lockcnt;
            return;
        }
        try {
            while (!this._lockfile.createNewFile()) {
                Thread.sleep(5L);
            }
        }
        catch (InterruptedException e) {
            throw new NSForwardException((Throwable)e, "Error while locking " + this._lockfile);
        }
        catch (IOException e) {
            throw new NSForwardException((Throwable)e, "Error while locking " + this._lockfile);
        }
        this._lockfile.deleteOnExit();
        ++this._lockcnt;
        this._owner = Thread.currentThread();
    }

    public void unlock() {
        if (this._lockcnt == 0) {
            throw new IllegalStateException("Can't unlock without lock");
        }
        if (this._owner != Thread.currentThread()) {
            throw new IllegalStateException("Can't unlock, not owner");
        }
        --this._lockcnt;
        if (this._lockcnt == 0) {
            this._owner = null;
            if (!this._lockfile.delete()) {
                throw new IllegalStateException("Error can't delete " + this._lockfile);
            }
        }
    }

    public boolean cleanup() {
        return this._lockfile.delete();
    }

    public static NSLocking lockForName(String name) {
        return new ERXGlobalLock(name);
    }
}

