/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.eof;

import com.webobjects.eocontrol.EOClassDescription;
import com.webobjects.eocontrol.EOEditingContext;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import er.extensions.eof.ERXFetchSpecification;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXGroupingFetchSpecification<T extends NSDictionary>
extends ERXFetchSpecification {
    private NSMutableArray<Aggregate> _aggegrateKeyPaths = new NSMutableArray();
    private EOQualifier _havingQualifier;

    public ERXGroupingFetchSpecification(String entityName, EOQualifier qualifier, NSArray sortOrderings, NSArray<Aggregate> aggregates, EOQualifier havingQualifier) {
        super(entityName, qualifier, sortOrderings);
        this.init();
        this.setAggregates(aggregates);
        this.setHavingQualifier(havingQualifier);
    }

    public ERXGroupingFetchSpecification(EOFetchSpecification spec) {
        super(spec);
        this.init();
    }

    public ERXGroupingFetchSpecification(ERXFetchSpecification spec) {
        super(spec);
        this.init();
    }

    public ERXGroupingFetchSpecification(ERXGroupingFetchSpecification<T> spec) {
        this((ERXFetchSpecification)spec);
        this.setAggregates(spec.aggregates());
        this.setHavingQualifier(spec.havingQualifier());
    }

    private void init() {
        this.setFetchesRawRows(true);
        this.setRawRowKeyPaths(EOClassDescription.classDescriptionForEntityName((String)this.entityName()).attributeKeys());
    }

    public void setRawRowKeyPaths(NSArray keyPaths) {
        super.setRawRowKeyPaths(keyPaths);
    }

    public NSArray<Aggregate> aggregates() {
        return this._aggegrateKeyPaths.immutableClone();
    }

    public void setAggregates(NSArray<Aggregate> value) {
        this._aggegrateKeyPaths.removeAllObjects();
        this._aggegrateKeyPaths.addObjectsFromArray(value);
    }

    public void addAggregateForPath(String operator, String keyPath) {
        this._aggegrateKeyPaths.addObject(new Aggregate(operator, keyPath));
    }

    public void removeAggregateForPath(String operator, String keyPath) {
        this._aggegrateKeyPaths.removeObject(new Aggregate(operator, keyPath));
    }

    public NSArray<String> groupingKeyPaths() {
        NSMutableArray<String> result = new NSMutableArray<String>();
        result.addObjectsFromArray(this.rawRowKeyPaths());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            for (Aggregate aggregate : this.aggregates()) {
                if (!aggregate.keyPath().equals(key)) continue;
                iterator.remove();
            }
        }
        return result;
    }

    public EOQualifier havingQualifier() {
        return this._havingQualifier;
    }

    public void setHavingQualifier(EOQualifier qualifier) {
        this._havingQualifier = qualifier;
    }

    @Override
    protected String additionalIdentifierInfo() {
        return super.additionalIdentifierInfo() + this.aggregates() + ERXGroupingFetchSpecification.identifierForQualifier(this.havingQualifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NSArray<T> fetchObjects(EOEditingContext ec) {
        NSArray oldKeyPaths = this.rawRowKeyPaths();
        try {
            this.setRawRowKeyPaths(this.groupingKeyPaths());
            NSArray nSArray = super.fetchObjects(ec);
            Object var5_4 = null;
            this.setRawRowKeyPaths(oldKeyPaths);
            return nSArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setRawRowKeyPaths(oldKeyPaths);
            throw throwable;
        }
    }

    private static class Aggregate {
        private String _operator;
        private String _keypath;

        public Aggregate(String operator, String keypath) {
            this._operator = operator;
            this._keypath = keypath;
        }

        public String operator() {
            return this._operator;
        }

        public String keyPath() {
            return this._keypath;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._keypath == null ? 0 : this._keypath.hashCode());
            result = 31 * result + (this._operator == null ? 0 : this._operator.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Aggregate other = (Aggregate)obj;
            if (this._keypath == null ? other._keypath != null : !this._keypath.equals(other._keypath)) {
                return false;
            }
            return !(this._operator == null ? other._operator != null : !this._operator.equals(other._operator));
        }

        public String toString() {
            return this._operator + "(" + this._keypath + ")";
        }
    }

    public static interface Operators {
        public static final String SUM = "sum";
        public static final String AVG = "avg";
        public static final String MIN = "min";
        public static final String MAX = "max";
        public static final String CNT = "count";
    }
}

