/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.formatters;

import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ERXOrdinalDateFormatter
extends NSTimestampFormatter {
    private final Pattern ORDINAL_PATTERN = Pattern.compile("(?:([1-3]?[0-9])(?:st|nd|rd|th))");

    public ERXOrdinalDateFormatter() {
    }

    public ERXOrdinalDateFormatter(String aPattern) {
        super(aPattern);
    }

    public ERXOrdinalDateFormatter(String aPattern, DateFormatSymbols symbols) {
        super(aPattern, symbols);
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        NSTimestamp timestamp;
        if (obj instanceof NSTimestamp) {
            timestamp = (NSTimestamp)obj;
        } else if (obj instanceof Date) {
            timestamp = new NSTimestamp((Date)obj);
        } else if (obj instanceof java.sql.Date) {
            timestamp = new NSTimestamp((Date)((java.sql.Date)obj));
        } else {
            throw new IllegalArgumentException("Unable to format " + obj.getClass() + " : " + obj.toString());
        }
        String formatted = super.format((Object)timestamp, new StringBuffer(), pos).toString();
        Matcher matcher = this.ORDINAL_PATTERN.matcher(formatted);
        if (this.pattern().contains("'th") && matcher.find()) {
            formatted = matcher.replaceAll("$1" + this.ordinalSuffix(timestamp));
        }
        return toAppendTo.append(formatted);
    }

    private String ordinalSuffix(NSTimestamp timestamp) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone((TimeZone)this.defaultFormatTimeZone());
        calendar.setTime((Date)timestamp);
        switch (calendar.get(5)) {
            case 1: 
            case 21: 
            case 31: {
                return "st";
            }
            case 2: 
            case 22: {
                return "nd";
            }
            case 3: 
            case 23: {
                return "rd";
            }
        }
        return "th";
    }

    public Object parseObject(String source, ParsePosition pos) {
        Matcher matcher = this.ORDINAL_PATTERN.matcher(source);
        return super.parseObject(matcher.replaceAll("$1th"), pos);
    }
}

