/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.eoaccess.EOEntity;
import com.webobjects.eoaccess.EOModelGroup;
import com.webobjects.eocontrol.EOEnterpriseObject;
import com.webobjects.eocontrol.EOFetchSpecification;
import com.webobjects.eocontrol.EOQualifier;
import com.webobjects.eocontrol.EOQualifierEvaluation;
import com.webobjects.eocontrol.EOSortOrdering;
import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import er.extensions.ERXExtensions;
import er.extensions.eof.ERXConstant;
import er.extensions.eof.ERXKey;
import er.extensions.foundation.ERXAssert;
import er.extensions.foundation.ERXDictionaryUtilities;
import er.extensions.foundation.ERXEqualator;
import er.extensions.foundation.ERXProperties;
import er.extensions.foundation.ERXStringUtilities;
import er.extensions.foundation.ERXUtilities;
import er.extensions.foundation.ERXValueUtilities;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ERXArrayUtilities {
    private static Logger log = Logger.getLogger(ERXArrayUtilities.class);
    public static final String NULL_GROUPING_KEY = "**** NULL GROUPING KEY ****";
    private static boolean initialized = false;
    private static final NSDictionary<String, NSSelector> _selectorsByKey = new NSDictionary<String, NSSelector>(new NSSelector[]{EOSortOrdering.CompareAscending, EOSortOrdering.CompareCaseInsensitiveAscending, EOSortOrdering.CompareCaseInsensitiveDescending, EOSortOrdering.CompareDescending}, new String[]{"compareAscending", "compareCaseInsensitiveAscending", "compareCaseInsensitiveDescending", "compareDescending"});

    public static <T> NSSet<T> setFromArray(NSArray<T> array) {
        if (array == null || array.count() == 0) {
            return NSSet.EmptySet;
        }
        return new NSSet<NSArray<T>>(array);
    }

    public static NSSelector sortSelectorWithKey(String key) {
        NSSelector result = null;
        if (key != null && !key.equals("") && (result = _selectorsByKey.objectForKey(key)) == null) {
            result = new NSSelector(key, ERXConstant.ObjectClassArray);
        }
        return result;
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByKeyPath(NSArray<V> objects, ERXKey<K> keyPath) {
        return ERXArrayUtilities.arrayGroupedByKeyPath(objects, keyPath == null ? null : keyPath.key());
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByKeyPath(NSArray<V> objects, String keyPath) {
        return ERXArrayUtilities.arrayGroupedByKeyPath(objects, keyPath, true, null);
    }

    public static <T, K, V> NSDictionary<K, NSArray<V>> arrayGroupedByKeyPath(NSArray<T> objects, ERXKey<K> keyPath, boolean includeNulls, ERXKey<V> valueKeyPath) {
        return ERXArrayUtilities.arrayGroupedByKeyPath(objects, keyPath == null ? null : keyPath.key(), includeNulls, valueKeyPath == null ? null : valueKeyPath.key());
    }

    public static <T, K, V> NSDictionary<K, NSArray<V>> arrayGroupedByKeyPath(NSArray<T> objects, String keyPath, boolean includeNulls, String valueKeyPath) {
        return ERXArrayUtilities.arrayGroupedByKeyPath(objects, keyPath, includeNulls ? NULL_GROUPING_KEY : null, valueKeyPath);
    }

    public static <T, K, V> NSDictionary<K, NSArray<V>> arrayGroupedByKeyPath(NSArray<T> objects, ERXKey<K> keyPath, K nullGroupingKey, ERXKey<V> valueKeyPath) {
        return ERXArrayUtilities.arrayGroupedByKeyPath(objects, keyPath == null ? null : keyPath.key(), nullGroupingKey, valueKeyPath == null ? null : valueKeyPath.key());
    }

    public static NSDictionary arrayGroupedByKeyPath(NSArray objects, String keyPath, Object nullGroupingKey, String valueKeyPath) {
        if (objects == null) {
            return null;
        }
        NSMutableDictionary result = new NSMutableDictionary();
        Enumeration e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            NSMutableArray<Object> existingGroup;
            boolean isNullKey;
            Object eo = e.nextElement();
            Object key = NSKeyValueCodingAdditions.Utility.valueForKeyPath(eo, (String)keyPath);
            boolean bl = isNullKey = key == null || key instanceof NSKeyValueCoding.Null;
            if (isNullKey && nullGroupingKey == null) continue;
            if (isNullKey) {
                key = nullGroupingKey;
            }
            if ((existingGroup = (NSMutableArray<Object>)result.objectForKey(key)) == null) {
                existingGroup = new NSMutableArray<Object>();
                result.setObjectForKey(existingGroup, key);
            }
            if (valueKeyPath != null) {
                Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath(eo, (String)valueKeyPath);
                if (value == null) continue;
                existingGroup.addObject(value);
                continue;
            }
            existingGroup.addObject(eo);
        }
        return result;
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByToManyKeyPath(NSArray<V> objects, ERXKey<K> keyPath, boolean includeNulls) {
        return ERXArrayUtilities.arrayGroupedByToManyKeyPath(objects, keyPath.key(), includeNulls);
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByToManyKeyPath(NSArray<V> objects, String keyPath, boolean includeNulls) {
        return ERXArrayUtilities.arrayGroupedByToManyKeyPath(objects, keyPath, includeNulls ? NULL_GROUPING_KEY : null);
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByToManyKeyPath(NSArray<V> objects, ERXKey<K> keyPath, K nullGroupingKey) {
        return ERXArrayUtilities.arrayGroupedByToManyKeyPath(objects, keyPath.key(), nullGroupingKey);
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByToManyKeyPath(NSArray<V> objects, String keyPath, K nullGroupingKey) {
        return ERXArrayUtilities.arrayGroupedByToManyKeyPath(objects, keyPath, nullGroupingKey, null);
    }

    public static <T, K, V> NSDictionary<K, NSArray<V>> arrayGroupedByToManyKeyPath(NSArray<T> objects, ERXKey<K> keyPath, K nullGroupingKey, ERXKey<V> valueKeyPath) {
        return ERXArrayUtilities.arrayGroupedByToManyKeyPath(objects, keyPath.key(), nullGroupingKey, valueKeyPath == null ? null : valueKeyPath.key());
    }

    public static NSDictionary arrayGroupedByToManyKeyPath(NSArray objects, String keyPath, Object nullGroupingKey, String valueKeyPath) {
        NSMutableDictionary result = new NSMutableDictionary();
        Enumeration e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            boolean isNullKey;
            Object object = e.nextElement();
            Object key = NSKeyValueCodingAdditions.Utility.valueForKeyPath(object, (String)keyPath);
            boolean bl = isNullKey = key == null || key instanceof NSKeyValueCoding.Null;
            if (isNullKey && nullGroupingKey == null) continue;
            if (isNullKey) {
                key = nullGroupingKey;
            }
            NSArray array = (NSArray)key;
            Enumeration keys = array.objectEnumerator();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                NSMutableArray<Object> existingGroup = (NSMutableArray<Object>)result.objectForKey(key);
                if (existingGroup == null) {
                    existingGroup = new NSMutableArray<Object>();
                    result.setObjectForKey(existingGroup, key);
                }
                if (valueKeyPath != null) {
                    Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath(object, (String)valueKeyPath);
                    if (value == null) continue;
                    existingGroup.addObject(value);
                    continue;
                }
                existingGroup.addObject(object);
            }
        }
        return result;
    }

    public static <T> boolean arraysAreIdenticalSets(NSArray<? super T> a1, NSArray<? super T> a2) {
        T i;
        if (a1 == null || a2 == null) {
            return a1 == a2;
        }
        boolean result = true;
        Enumeration<T> e = a1.objectEnumerator();
        while (e.hasMoreElements()) {
            i = e.nextElement();
            if (a2.containsObject(i)) continue;
            result = false;
            break;
        }
        if (result) {
            e = a2.objectEnumerator();
            while (e.hasMoreElements()) {
                i = e.nextElement();
                if (a1.containsObject(i)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static <T> NSArray<T> filteredArrayWithQualifierEvaluation(NSArray<T> array, EOQualifierEvaluation qualifier) {
        if (array == null) {
            return NSArray.EmptyArray;
        }
        return ERXArrayUtilities.filteredArrayWithQualifierEvaluation(array.objectEnumerator(), qualifier);
    }

    public static <T> NSArray<T> filteredArrayWithQualifierEvaluation(Enumeration<T> enumeration, EOQualifierEvaluation qualifier) {
        NSMutableArray<T> result = new NSMutableArray<T>();
        while (enumeration.hasMoreElements()) {
            T object = enumeration.nextElement();
            if (!qualifier.evaluateWithObject(object)) continue;
            result.addObject(object);
        }
        return result;
    }

    public static boolean enumerationHasMatchWithQualifierEvaluation(Enumeration<?> enumeration, EOQualifierEvaluation qualifier) {
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (!qualifier.evaluateWithObject(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean iteratorHasMatchWithQualifierEvaluation(Iterator<?> iterator, EOQualifierEvaluation qualifier) {
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!qualifier.evaluateWithObject(object)) continue;
            return true;
        }
        return false;
    }

    public static <T> NSArray<T> filteredArrayWithQualifierEvaluation(Iterator<T> iterator, EOQualifierEvaluation qualifier) {
        NSMutableArray<T> result = new NSMutableArray<T>();
        while (iterator.hasNext()) {
            T object = iterator.next();
            if (!qualifier.evaluateWithObject(object)) continue;
            result.addObject(object);
        }
        return result;
    }

    public static <T> NSArray<T> arrayWithoutDuplicateKeyValue(NSArray<T> objects, String key) {
        NSMutableSet<Object> present = new NSMutableSet<Object>();
        NSMutableArray<T> result = new NSMutableArray<T>();
        Enumeration<T> e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            T o = e.nextElement();
            Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath(o, (String)key);
            if (value == null || present.containsObject(value)) continue;
            present.addObject(value);
            result.addObject(o);
        }
        return result;
    }

    public static <T> NSArray<T> arrayMinusArray(NSArray<T> main, NSArray<?> minus) {
        NSSet minusSet = new NSSet(minus);
        NSMutableArray<int> mutableResult = new NSMutableArray<int>(main.count());
        Enumeration<T> e = main.objectEnumerator();
        while (e.hasMoreElements()) {
            T obj = e.nextElement();
            if (minusSet.containsObject(obj)) continue;
            mutableResult.addObject((int)obj);
        }
        return mutableResult.immutableClone();
    }

    public static <T> NSArray<T> arrayMinusObject(NSArray<T> main, Object object) {
        NSMutableArray<T> mutable = new NSMutableArray<T>(main);
        mutable.removeObject(object);
        return mutable.immutableClone();
    }

    public static <T> NSArray<T> arrayByAddingObjectsFromArrayWithoutDuplicates(NSArray<? extends T> a1, NSArray<? extends T> a2) {
        if (a2.count() == 0) {
            return a1;
        }
        NSMutableArray<? extends T> result = new NSMutableArray<T>(a1);
        ERXArrayUtilities.addObjectsFromArrayWithoutDuplicates(result, a2);
        return result;
    }

    public static <T> NSArray<T> arrayByRemovingFirstObject(NSArray<T> array) {
        NSArray<T> result = null;
        if (array != null) {
            int count = array.count();
            result = count > 1 ? array.subarrayWithRange(new NSRange(1, count - 1)) : NSArray.EmptyArray;
        }
        return result;
    }

    public static <T> void safeAddObject(NSMutableArray<T> array, T object) {
        if (array != null && object != null) {
            array.addObject(object);
        }
    }

    public static <T> void addObjectsFromArrayWithoutDuplicates(NSMutableArray<T> a1, NSArray<? extends T> a2) {
        NSMutableSet<T> resultSet = new NSMutableSet<T>(a1);
        Enumeration<T> e = a2.objectEnumerator();
        while (e.hasMoreElements()) {
            T elt = e.nextElement();
            if (resultSet.containsObject(elt)) continue;
            a1.addObject(elt);
            resultSet.addObject(elt);
        }
    }

    public static NSArray flatten(NSArray<?> originalArray, boolean filterDuplicates) {
        NSArray flattenedArray = ERXArrayUtilities.flatten(originalArray);
        if (filterDuplicates) {
            return ERXArrayUtilities.arrayWithoutDuplicates(flattenedArray);
        }
        return flattenedArray;
    }

    public static NSArray flatten(NSArray<?> originalArray) {
        if (originalArray == null || originalArray.count() < 1) {
            return originalArray;
        }
        NSArray<?> newArray = null;
        for (int i = 0; i < originalArray.count(); ++i) {
            Object element = originalArray.objectAtIndex(i);
            if (element instanceof NSArray) {
                if (newArray == null) {
                    newArray = new NSMutableArray();
                    for (int backfillIndex = 0; backfillIndex < i; ++backfillIndex) {
                        ((NSMutableArray)newArray).addObject(originalArray.objectAtIndex(backfillIndex));
                    }
                }
                NSArray flattenedChildArray = ERXArrayUtilities.flatten((NSArray)element);
                ((NSMutableArray)newArray).addObjectsFromArray(flattenedChildArray);
                continue;
            }
            if (newArray == null) continue;
            ((NSMutableArray)newArray).addObject(element);
        }
        return newArray != null ? newArray : originalArray;
    }

    public static NSArray arrayFromPropertyList(String name, NSBundle bundle) {
        return (NSArray)NSPropertyListSerialization.propertyListFromString((String)ERXStringUtilities.stringFromResource(name, "plist", bundle));
    }

    public static NSArray valuesForKeyPaths(Object array, NSArray<String> paths) {
        NSMutableArray<Object> result = new NSMutableArray<Object>();
        Enumeration<String> e = paths.objectEnumerator();
        while (e.hasMoreElements()) {
            Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath((Object)array, (String)e.nextElement());
            result.addObject(value != null ? value : NSKeyValueCoding.NullValue);
        }
        return result;
    }

    public static <T> T firstObject(NSArray<T> array) {
        T result = null;
        if (array != null && array.count() > 0) {
            result = array.objectAtIndex(0);
        }
        return result;
    }

    public static int indexOfFirstObjectWithValueForKeyPath(NSArray<?> array, Object value, String keyPath) {
        int count = array.count();
        int result = -1;
        for (int i = 0; i < count; ++i) {
            Object currentObject = array.objectAtIndex(i);
            if (currentObject == NSKeyValueCoding.NullValue) continue;
            Object currentValue = NSKeyValueCodingAdditions.Utility.valueForKeyPath(currentObject, (String)keyPath);
            Object object = currentValue = currentValue == NSKeyValueCoding.NullValue ? null : currentValue;
            if (currentValue != value && (value == null || !value.equals(currentValue))) continue;
            return i;
        }
        return result;
    }

    public static <T> T firstObjectWithValueForKeyPath(NSArray<T> array, Object value, String keyPath) {
        int index = ERXArrayUtilities.indexOfFirstObjectWithValueForKeyPath(array, value, keyPath);
        return index >= 0 ? (T)array.objectAtIndex(index) : null;
    }

    public static <T> NSArray<T> objectsWithValueForKeyPath(NSArray<T> array, Object valueToLookFor, String keyPath) {
        boolean valueToLookForIsNull = valueToLookFor == null || valueToLookFor == NSKeyValueCoding.NullValue;
        NSArray result = null;
        if (array != null && array.count() > 0) {
            NSMutableArray<T> a = new NSMutableArray<T>();
            Enumeration<T> arrayEnumerator = array.objectEnumerator();
            while (arrayEnumerator.hasMoreElements()) {
                boolean theValueIsNull;
                T theObject = arrayEnumerator.nextElement();
                if (theObject == NSKeyValueCoding.NullValue) continue;
                Object theValue = NSKeyValueCodingAdditions.Utility.valueForKeyPath(theObject, (String)keyPath);
                boolean bl = theValueIsNull = theValue == null || theValue == NSKeyValueCoding.NullValue;
                if ((!theValueIsNull || !valueToLookForIsNull) && !ERXExtensions.safeEquals(valueToLookFor, theValue)) continue;
                a.addObject(theObject);
            }
            result = a.immutableClone();
        }
        return result != null ? result : NSArray.EmptyArray;
    }

    public static <T> int indexOfObjectUsingEqualator(NSArray<T> array, T object, ERXEqualator equalator) {
        int count = array.count();
        int result = -1;
        for (int i = 0; i < count && result == -1; ++i) {
            T currentObject = array.objectAtIndex(i);
            if (!equalator.objectIsEqualToObject(currentObject, object)) continue;
            result = i;
        }
        return result;
    }

    public static <T> NSMutableArray<T> sortedMutableArraySortedWithKey(NSArray<T> array, String key) {
        return ERXArrayUtilities.sortedArraySortedWithKey(array, key).mutableClone();
    }

    public static <T> NSArray<T> sortedArraySortedWithKey(NSArray<T> array, String key) {
        return ERXArrayUtilities.sortedArraySortedWithKey(array, key, null);
    }

    public static <T> NSArray<T> sortedArraySortedWithKey(NSArray<T> array, String key, NSSelector selector) {
        ERXAssert.PRE.notNull("Attempting to sort null array of objects.", array);
        ERXAssert.PRE.notNull("Attepting to sort array of objects with null key.", key);
        NSArray<EOSortOrdering> order = new NSArray<EOSortOrdering>(new EOSortOrdering[]{EOSortOrdering.sortOrderingWithKey((String)key, (NSSelector)(selector == null ? EOSortOrdering.CompareCaseInsensitiveAscending : selector))});
        return EOSortOrdering.sortedArrayUsingKeyOrderArray(array, order);
    }

    public static <T> NSArray<T> sortedArraySortedWithKeys(NSArray<T> array, NSArray<String> keys, NSSelector selector) {
        ERXAssert.PRE.notNull("Attempting to sort null array of objects.", array);
        ERXAssert.PRE.notNull("Attepting to sort an array with null keys.", keys);
        if (keys.count() < 2) {
            return ERXArrayUtilities.sortedArraySortedWithKey(array, keys.lastObject(), selector == null ? EOSortOrdering.CompareCaseInsensitiveAscending : selector);
        }
        NSMutableArray<int> order = new NSMutableArray<int>(keys.count());
        Enumeration<String> keyEnumerator = keys.objectEnumerator();
        while (keyEnumerator.hasMoreElements()) {
            String key = keyEnumerator.nextElement();
            order.addObject((int)EOSortOrdering.sortOrderingWithKey((String)key, (NSSelector)(selector == null ? EOSortOrdering.CompareCaseInsensitiveAscending : selector)));
        }
        return EOSortOrdering.sortedArrayUsingKeyOrderArray(array, order);
    }

    public static void sortArrayWithKey(NSMutableArray<?> array, String key) {
        ERXArrayUtilities.sortArrayWithKey(array, key, null);
    }

    public static void sortArrayWithKey(NSMutableArray<?> array, String key, NSSelector selector) {
        ERXAssert.PRE.notNull("Attempting to sort null array of eos.", array);
        ERXAssert.PRE.notNull("Attempting to sort array of eos with null key.", key);
        NSArray<EOSortOrdering> order = new NSArray<EOSortOrdering>(new EOSortOrdering[]{EOSortOrdering.sortOrderingWithKey((String)key, (NSSelector)(selector == null ? EOSortOrdering.CompareCaseInsensitiveAscending : selector))});
        EOSortOrdering.sortArrayUsingKeyOrderArray(array, order);
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (ERXProperties.booleanForKeyWithDefault("er.extensions.ERXArrayUtilities.ShouldRegisterOperators", true)) {
            NSArray.setOperatorForKey("sort", new SortOperator(EOSortOrdering.CompareAscending));
            NSArray.setOperatorForKey("sortAsc", new SortOperator(EOSortOrdering.CompareAscending));
            NSArray.setOperatorForKey("sortDesc", new SortOperator(EOSortOrdering.CompareDescending));
            NSArray.setOperatorForKey("sortInsensitiveAsc", new SortOperator(EOSortOrdering.CompareCaseInsensitiveAscending));
            NSArray.setOperatorForKey("sortInsensitiveDesc", new SortOperator(EOSortOrdering.CompareCaseInsensitiveDescending));
            NSArray.setOperatorForKey("flatten", new FlattenOperator());
            NSArray.setOperatorForKey("fetchSpec", new FetchSpecOperator());
            NSArray.setOperatorForKey("unique", new UniqueOperator());
            NSArray.setOperatorForKey("isEmpty", new IsEmptyOperator());
            NSArray.setOperatorForKey("subarrayWithRange", new SubarrayWithRangeOperator());
            NSArray.setOperatorForKey("objectAtIndex", new ObjectAtIndexOperator());
            NSArray.setOperatorForKey("avgNonNull", new AvgNonNullOperator());
            NSArray.setOperatorForKey("reverse", new ReverseOperator());
            NSArray.setOperatorForKey("removeNullValues", new RemoveNullValuesOperator());
            NSArray.setOperatorForKey("median", new MedianOperator());
            NSArray.setOperatorForKey("limit", new LimitOperator());
            NSArray.setOperatorForKey("stdDev", new StandardDeviationOperator(false));
            NSArray.setOperatorForKey("popStdDev", new StandardDeviationOperator(true));
        }
    }

    public static Number median(NSArray<?> array, String keypath) {
        BigDecimal value;
        boolean noKeypath;
        int count = array.count();
        boolean bl = noKeypath = keypath == null || keypath.length() <= 0;
        if (count == 0) {
            value = null;
        } else if (count == 1) {
            Object obj = noKeypath ? array.objectAtIndex(0) : array.valueForKeyPath(keypath);
            value = ERXValueUtilities.bigDecimalValue(obj);
        } else {
            NSArray<?> sortedArray;
            if (noKeypath) {
                NSMutableArray<?> sortlist = array.mutableClone();
                Collections.sort(sortlist);
                sortedArray = sortlist;
            } else {
                sortedArray = ERXArrayUtilities.sortedArraySortedWithKey(array, keypath);
            }
            int mid = count / 2;
            Object obj = sortedArray.objectAtIndex(mid);
            if (count % 2 == 0) {
                Object tmp = noKeypath ? obj : NSKeyValueCodingAdditions.Utility.valueForKeyPath(obj, (String)keypath);
                BigDecimal a = ERXValueUtilities.bigDecimalValue(tmp);
                obj = sortedArray.objectAtIndex(mid - 1);
                tmp = noKeypath ? obj : NSKeyValueCodingAdditions.Utility.valueForKeyPath(obj, (String)keypath);
                BigDecimal b = ERXValueUtilities.bigDecimalValue(tmp);
                BigDecimal sum = a.add(b);
                value = sum.divide(BigDecimal.valueOf(2L), sum.scale() + 4, 6);
            } else {
                Object tmp = noKeypath ? obj : NSKeyValueCodingAdditions.Utility.valueForKeyPath(obj, (String)keypath);
                value = ERXValueUtilities.bigDecimalValue(tmp);
            }
        }
        return value;
    }

    public static Number stdDev(NSArray<?> array, String keypath, boolean isPopulation) {
        int count = array.count();
        if (count < 2) {
            return null;
        }
        boolean noKeypath = keypath == null || keypath.length() <= 0;
        Object val = noKeypath ? array.valueForKey("@avg") : array.valueForKeyPath(keypath + ".@avg");
        BigDecimal mean = ERXValueUtilities.bigDecimalValue(val);
        BigDecimal sum = BigDecimal.valueOf(0L);
        BigDecimal divisor = BigDecimal.valueOf(isPopulation ? (long)count : (long)(count - 1));
        for (Object tmp : array) {
            Object obj = noKeypath ? tmp : NSKeyValueCodingAdditions.Utility.valueForKeyPath(tmp, (String)keypath);
            BigDecimal diff = ERXValueUtilities.bigDecimalValue(obj).subtract(mean);
            diff = diff.multiply(diff);
            sum = sum.add(diff);
        }
        sum = sum.divide(divisor, sum.scale() + 4, 6);
        return BigDecimal.valueOf(Math.sqrt(sum.doubleValue()));
    }

    public static <T> NSArray<T> distinct(NSArray<T> array) {
        return ERXArrayUtilities.arrayWithoutDuplicates(array);
    }

    public static <T> NSArray<T> arrayWithoutDuplicates(NSArray<T> anArray) {
        NSMutableArray<T> result = new NSMutableArray<T>();
        NSMutableSet<T> already = new NSMutableSet<T>();
        for (T object : anArray) {
            if (already.containsObject(object)) continue;
            already.addObject(object);
            result.addObject(object);
        }
        return result;
    }

    public static <T> NSArray<NSArray<T>> batchedArrayWithSize(NSArray<T> array, int batchSize) {
        if (array == null || array.count() == 0) {
            return NSArray.EmptyArray;
        }
        NSMutableArray<NSArray<T>> batchedArray = new NSMutableArray<NSArray<T>>();
        int count = array.count();
        for (int i = 0; i < count; i += batchSize) {
            int length = batchSize;
            if (i + length > count) {
                length = count - i;
            }
            batchedArray.addObject(array.subarrayWithRange(new NSRange(i, length)));
        }
        return batchedArray;
    }

    public static <T> NSArray<T> filteredArrayWithEntityFetchSpecification(NSArray<T> array, String entity, String fetchSpec, NSDictionary<String, ?> bindings) {
        NSArray sortOrderings;
        EOEntity wrongParamEntity = EOModelGroup.defaultGroup().entityNamed(fetchSpec);
        if (wrongParamEntity != null) {
            fetchSpec = entity;
            entity = wrongParamEntity.name();
            log.error((Object)"filteredArrayWithEntityFetchSpecification Calling conventions have changed from fetchSpec, entity to entity, fetchSpec");
        }
        EOFetchSpecification spec = EOFetchSpecification.fetchSpecificationNamed((String)fetchSpec, (String)entity);
        if (bindings != null) {
            spec = spec.fetchSpecificationWithQualifierBindings(bindings);
        }
        NSArray result = new NSArray(array);
        EOQualifier qualifier = spec.qualifier();
        if (qualifier != null) {
            result = EOQualifier.filteredArrayWithQualifier(result, (EOQualifier)qualifier);
        }
        if ((sortOrderings = spec.sortOrderings()) != null) {
            result = EOSortOrdering.sortedArrayUsingKeyOrderArray((NSArray)result, (NSArray)sortOrderings);
        }
        return result;
    }

    public static <T> NSArray<T> filteredArrayWithFetchSpecificationNamedEntityNamedBindings(NSArray<T> array, String fetchSpec, String entity, NSDictionary<String, ?> bindings) {
        return ERXArrayUtilities.filteredArrayWithEntityFetchSpecification(array, entity, fetchSpec, bindings);
    }

    public static <T> NSArray<T> filteredArrayWithFetchSpecificationNamedEntityNamed(NSArray<T> array, String fetchSpec, String entity) {
        return ERXArrayUtilities.filteredArrayWithEntityFetchSpecification(array, entity, fetchSpec, null);
    }

    public static <T> NSArray<T> filteredArrayWithEntityFetchSpecification(NSArray<T> array, String entity, String fetchSpec) {
        return ERXArrayUtilities.filteredArrayWithEntityFetchSpecification(array, entity, fetchSpec, null);
    }

    public static <T> void shiftObjectLeft(NSMutableArray<T> array, T object) {
        int index = array.indexOfObject(object);
        if (index == -1) {
            return;
        }
        if (index > 0) {
            array.insertObjectAtIndex(object, index - 1);
            array.removeObjectAtIndex(index + 1);
        }
    }

    public static <T> void shiftObjectRight(NSMutableArray<T> array, T object) {
        int index = array.indexOfObject(object);
        if (index == -1) {
            return;
        }
        if (index < array.count() - 1) {
            array.insertObjectAtIndex(object, index + 2);
            array.removeObjectAtIndex(index);
        }
    }

    public static <T> boolean arrayContainsAnyObjectFromArray(NSArray<? extends T> array, NSArray<? extends T> objects) {
        boolean arrayContainsAnyObject = false;
        if (array != null && objects != null && array.count() > 0 && objects.count() > 0) {
            Enumeration<T> e = objects.objectEnumerator();
            while (e.hasMoreElements()) {
                if (!array.containsObject(e.nextElement())) continue;
                arrayContainsAnyObject = true;
                break;
            }
        }
        return arrayContainsAnyObject;
    }

    public static <T> boolean arrayContainsArray(NSArray<? extends T> array, NSArray<? extends T> objects) {
        boolean arrayContainsAllObjects = true;
        if (array != null && objects != null && array.count() > 0 && objects.count() > 0) {
            Enumeration<T> e = objects.objectEnumerator();
            while (e.hasMoreElements()) {
                if (array.containsObject(e.nextElement())) continue;
                arrayContainsAllObjects = false;
                break;
            }
        } else if (array == null || array.count() == 0) {
            return false;
        }
        return arrayContainsAllObjects;
    }

    public static <T> NSArray<T> intersectingElements(NSArray<? extends T> array1, NSArray<? extends T> array2) {
        NSMutableArray<T> intersectingElements = null;
        if (array1 != null && array1.count() > 0 && array2 != null && array2.count() > 0) {
            intersectingElements = new NSMutableArray<T>();
            NSArray<T> bigger = array1.count() > array2.count() ? array1 : array2;
            NSArray<T> smaller = array1.count() > array2.count() ? array2 : array1;
            Enumeration<T> e = smaller.objectEnumerator();
            while (e.hasMoreElements()) {
                T object = e.nextElement();
                if (!bigger.containsObject(object) || intersectingElements.containsObject(object)) continue;
                intersectingElements.addObject(object);
            }
        }
        return intersectingElements != null ? intersectingElements : NSArray.EmptyArray;
    }

    public static <T> NSArray<T> reverse(NSArray<T> array) {
        NSArray<int> reverse = null;
        if (array != null && array.count() > 0) {
            NSMutableArray<int> reverseTemp = new NSMutableArray<int>(array.count());
            Enumeration<T> reverseEnumerator = array.reverseObjectEnumerator();
            while (reverseEnumerator.hasMoreElements()) {
                reverseTemp.addObject((int)reverseEnumerator.nextElement());
            }
            reverse = reverseTemp.immutableClone();
        }
        return reverse != null ? reverse : NSArray.EmptyArray;
    }

    public static String friendlyDisplayForKeyPath(NSArray<?> list, String attribute, String nullArrayDisplay, String separator, String finalSeparator) {
        int count;
        String result = null;
        int n = count = list != null ? list.count() : 0;
        if (count == 0) {
            result = nullArrayDisplay;
        } else if (count == 1) {
            result = attribute != null ? NSKeyValueCodingAdditions.Utility.valueForKeyPath(list.objectAtIndex(0), (String)attribute) : list.objectAtIndex(0);
        } else if (count > 1) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < count; ++i) {
                Object attributeValue;
                Object object = attributeValue = attribute != null ? NSKeyValueCodingAdditions.Utility.valueForKeyPath(list.objectAtIndex(i), (String)attribute) : list.objectAtIndex(i);
                if (i > 0) {
                    buffer.append(i == count - 1 ? finalSeparator : separator);
                }
                buffer.append(attributeValue);
            }
            result = buffer.toString();
        }
        return result == null ? null : result.toString();
    }

    public static NSArray<?> arrayForKeysPath(NSArray<?> array, NSArray<String> keys) {
        NSMutableArray<NSDictionary<String, Object>> result = new NSMutableArray<NSDictionary<String, Object>>();
        if (array != null && keys != null) {
            Enumeration<?> e = array.objectEnumerator();
            while (e.hasMoreElements()) {
                Object object = e.nextElement();
                result.addObject(ERXDictionaryUtilities.dictionaryFromObjectWithKeys(object, keys));
            }
        }
        return result.immutableClone();
    }

    public static <T> NSArray<T> removeNullValues(NSArray<T> array) {
        return ERXArrayUtilities.removeNullValues(array, array);
    }

    public static <T> NSArray<T> removeNullValues(NSArray<T> target, NSArray<T> array) {
        if (target == null) {
            return null;
        }
        if (array == null) {
            return target;
        }
        NSMutableArray<T> result = new NSMutableArray<T>();
        int i = 0;
        for (T object : array) {
            if (!(object instanceof NSKeyValueCoding.Null)) {
                result.addObject(target.objectAtIndex(i));
            }
            ++i;
        }
        return result;
    }

    public static String[] objectArrayCastToStringArray(Object[] o) {
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = (String)o[i];
        }
        return s;
    }

    public static String objectArrayToString(Object[] o) {
        return new NSArray<Object>(o).toString();
    }

    public static String objectArrayToString(Object[][] array) {
        NSMutableArray<String> result = new NSMutableArray<String>();
        for (Object[] oa : array) {
            result.addObject(ERXArrayUtilities.objectArrayToString(oa));
        }
        return result.toString();
    }

    public static String objectArraysToString(NSArray<Object[][]> array) {
        NSMutableArray<String> aa = new NSMutableArray<String>();
        for (Object[][] oa : array) {
            aa.addObject(ERXArrayUtilities.objectArrayToString(oa));
        }
        return aa.toString();
    }

    public static <T> NSArray<T> removeNullValuesFromEnd(NSArray<T> array) {
        if (array == null) {
            return null;
        }
        NSMutableArray<T> a = array.mutableClone();
        while (a.lastObject() instanceof NSKeyValueCoding.Null) {
            a.removeLastObject();
        }
        return a;
    }

    public static String[] toStringArray(NSArray<?> a) {
        String[] b = new String[a.count()];
        int i = a.count();
        while (i-- > 0) {
            b[i] = a.objectAtIndex(i).toString();
        }
        return b;
    }

    public static <K, T> NSDictionary<K, T> dictionaryOfObjectsIndexedByKeyPath(NSArray<T> array, String keyPath) {
        return ERXArrayUtilities.dictionaryOfObjectsIndexedByKeyPathThrowOnCollision(array, keyPath, false);
    }

    public static <K, T> NSDictionary<K, T> dictionaryOfObjectsIndexedByKeyPathThrowOnCollision(NSArray<T> array, String keyPath, boolean throwOnCollision) {
        if (array == null) {
            return NSDictionary.emptyDictionary();
        }
        NSMutableDictionary<Object, T> result = new NSMutableDictionary<Object, T>();
        Enumeration<T> e = array.objectEnumerator();
        while (e.hasMoreElements()) {
            Object existingObject;
            T theObject = e.nextElement();
            Object theKey = NSKeyValueCodingAdditions.Utility.valueForKeyPath(theObject, (String)keyPath);
            if (theKey == null || theKey == NSKeyValueCoding.NullValue) continue;
            Object v0 = existingObject = throwOnCollision ? result.objectForKey(theKey) : null;
            if (existingObject != null) {
                throw new RuntimeException("Collision with value ('" + theKey + "') for keyPath '" + keyPath + "'.  Initial object: '" + existingObject + ", subsequent object: " + theObject);
            }
            result.setObjectForKey(theObject, theKey);
        }
        return result.immutableClone();
    }

    public static <T> NSArray<T> arrayBySelectingInstancesOfClass(NSArray<?> array, Class<T> aClass) {
        NSArray result = null;
        if (array != null && array.count() > 0) {
            NSMutableArray a = new NSMutableArray();
            Enumeration<?> e = array.objectEnumerator();
            while (e.hasMoreElements()) {
                Object theObject = e.nextElement();
                if (aClass != null && !aClass.isInstance(theObject)) continue;
                a.addObject(theObject);
            }
            if (a.count() > 0) {
                result = a.immutableClone();
            }
        }
        return result != null ? result : NSArray.EmptyArray;
    }

    public static <T> NSArray<T> sortedArrayUsingComparator(NSArray<T> array, NSComparator comparator) {
        NSArray<T> result = array;
        if (array != null) {
            if (array.count() < 2) {
                result = array;
            } else {
                try {
                    result = array.sortedArrayUsingComparator(comparator);
                }
                catch (NSComparator.ComparisonException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return result;
    }

    public static <T> NSArray<T> arrayWithObjectsSwapped(NSArray<T> array, Object object1, Object object2) {
        int indexOfObject1 = array.indexOf(object1);
        int indexOfObject2 = array.indexOf(object2);
        if (indexOfObject1 >= 0 && indexOfObject2 >= 0) {
            return ERXArrayUtilities.arrayWithObjectsAtIndexesSwapped(array, indexOfObject1, indexOfObject2);
        }
        throw new RuntimeException("At least one of the given objects is not element of the array!");
    }

    public static <T> NSArray<T> arrayWithObjectsAtIndexesSwapped(NSArray<T> array, int indexOfObject1, int indexOfObject2) {
        if (array == null || array.count() < 2) {
            throw new RuntimeException("Array is either null or does not have enough elements.");
        }
        NSMutableArray<T> tmpArray = array.mutableClone();
        try {
            T tmpObject = array.objectAtIndex(indexOfObject1);
            tmpArray.set(indexOfObject1, array.objectAtIndex(indexOfObject2));
            tmpArray.set(indexOfObject2, tmpObject);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tmpArray.immutableClone();
    }

    public static <T> void swapObjectsInArray(NSMutableArray<T> array, T a, T b) {
        if (array == null || array.count() < 2) {
            throw new RuntimeException("Array is either null or does not have enough elements.");
        }
        int indexOfA = array.indexOf(a);
        int indexOfB = array.indexOf(b);
        if (indexOfA < 0 || indexOfB < 0) {
            throw new RuntimeException("At least one of the objects is not element of the array!");
        }
        ERXArrayUtilities.swapObjectsAtIndexesInArray(array, indexOfA, indexOfB);
    }

    public static <T> void swapObjectsAtIndexesInArray(NSMutableArray<T> array, int indexOfA, int indexOfB) {
        try {
            T tmp = array.replaceObjectAtIndex(array.objectAtIndex(indexOfA), indexOfB);
            array.replaceObjectAtIndex(tmp, indexOfA);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    public static <T> void swapObjectWithObjectAtIndexInArray(NSMutableArray<T> array, T a, int indexOfB) {
        if (array == null || array.count() < 2) {
            throw new RuntimeException("Array is either null or does not have enough elements.");
        }
        int indexOfA = array.indexOf(a);
        if (indexOfA >= 0 && indexOfB >= 0) {
            if (indexOfA != indexOfB) {
                ERXArrayUtilities.swapObjectsAtIndexesInArray(array, indexOfA, indexOfB);
            }
        } else {
            throw new RuntimeException("At least one of the objects is not element of the array!");
        }
    }

    public static <T> NSArray<T> deepClone(NSArray<T> array, boolean onlyCollections) {
        NSMutableArray<T> clonedArray = null;
        if (array != null) {
            clonedArray = array.mutableClone();
            for (int i = array.count() - 1; i >= 0; --i) {
                T value = array.objectAtIndex(i);
                T clonedValue = ERXUtilities.deepClone(value, onlyCollections);
                if (clonedValue != null) {
                    if (clonedValue == value) continue;
                    clonedArray.replaceObjectAtIndex(clonedValue, i);
                    continue;
                }
                clonedArray.removeObjectAtIndex(i);
            }
        }
        return clonedArray;
    }

    public static <T> NSSet<T> deepClone(NSSet<T> set, boolean onlyCollections) {
        NSMutableSet<T> clonedSet = null;
        if (set != null) {
            clonedSet = set.mutableClone();
            for (T value : set) {
                T clonedValue = ERXUtilities.deepClone(value, onlyCollections);
                if (clonedValue != null) {
                    if (clonedValue == value) continue;
                    clonedSet.removeObject(value);
                    clonedSet.addObject(clonedValue);
                    continue;
                }
                clonedSet.removeObject(value);
            }
        }
        return clonedSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardDeviationOperator
    implements NSArray.Operator {
        private boolean isPop;

        public StandardDeviationOperator(boolean isPopulation) {
            this.isPop = isPopulation;
        }

        @Override
        public Object compute(NSArray<?> array, String keypath) {
            return ERXArrayUtilities.stdDev(array, keypath, this.isPop);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MedianOperator
    implements NSArray.Operator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            return ERXArrayUtilities.median(array, keypath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ReverseOperator
    extends BaseOperator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            array = ERXArrayUtilities.reverse(array);
            return this.contents((NSArray)array, keypath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AvgNonNullOperator
    implements NSArray.Operator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            BigDecimal sum = new BigDecimal(0L);
            int count = 0;
            boolean noKeypath = keypath == null || keypath.length() <= 0;
            Enumeration<?> e = array.objectEnumerator();
            while (e.hasMoreElements()) {
                Object tmp = e.nextElement();
                Object obj = noKeypath ? tmp : NSKeyValueCodingAdditions.Utility.valueForKeyPath(tmp, (String)keypath);
                if (ERXValueUtilities.isNull(obj)) continue;
                ++count;
                BigDecimal val = ERXValueUtilities.bigDecimalValue(obj);
                sum = sum.add(val);
            }
            if (count == 0) {
                return null;
            }
            return sum.divide(BigDecimal.valueOf(count), sum.scale() + 4, 6);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectAtIndexOperator
    implements NSArray.Operator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            int end = keypath.indexOf(".");
            int index = Integer.parseInt(keypath.substring(0, end == -1 ? keypath.length() : end));
            Object value = null;
            if (index < array.count()) {
                value = array.objectAtIndex(index);
            }
            if (end != -1 && value != null) {
                value = NSKeyValueCodingAdditions.Utility.valueForKeyPath(value, (String)keypath.substring(end + 1));
            }
            return value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveNullValuesOperator
    extends BaseOperator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            array = ERXArrayUtilities.removeNullValues(array);
            return this.contents((NSArray)array, keypath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UniqueOperator
    extends BaseOperator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            if (array != null) {
                array = ERXArrayUtilities.arrayWithoutDuplicates(array);
            }
            return this.contents((NSArray)array, keypath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LimitOperator
    extends BaseOperator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            String rest;
            String limitStr;
            int dotIndex = keypath.indexOf(".");
            if (dotIndex == -1) {
                limitStr = keypath;
                rest = null;
            } else {
                limitStr = keypath.substring(0, dotIndex);
                rest = keypath.substring(dotIndex + 1);
            }
            int length = limitStr.length() == 0 ? 0 : Integer.parseInt(limitStr);
            length = Math.min(length, array.count());
            NSArray<?> objects = array.subarrayWithRange(new NSRange(0, length));
            return this.contents((NSArray)objects, rest);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubarrayWithRangeOperator
    extends BaseOperator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            if (ERXStringUtilities.stringIsNullOrEmpty(keypath)) {
                throw new IllegalArgumentException("subarrayWithRange must be used like '@subarrayWithRange.start-length'");
            }
            String rangeString = ERXStringUtilities.firstPropertyKeyInKeyPath(keypath);
            keypath = ERXStringUtilities.keyPathWithoutFirstProperty(keypath);
            int index = rangeString.indexOf(45);
            if (index < 1 || index >= rangeString.length()) {
                throw new IllegalArgumentException("subarrayWithRange must be used like '@subarrayWithRange.start-length' current key path: \"@subarrayWithRange." + rangeString + "\"");
            }
            int start = Integer.valueOf(rangeString.substring(0, index));
            int length = Integer.valueOf(rangeString.substring(++index));
            array = array.subarrayWithRange(new NSRange(start, length));
            return this.contents((NSArray)array, keypath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsEmptyOperator
    implements NSArray.Operator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            return array.count() == 0 ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlattenOperator
    extends BaseOperator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            array = ERXArrayUtilities.flatten(array);
            return this.contents(array, keypath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FetchSpecOperator
    extends BaseOperator {
        @Override
        public Object compute(NSArray<?> array, String keypath) {
            if (array.count() == 0) {
                return array;
            }
            EOEnterpriseObject eo = (EOEnterpriseObject)array.objectAtIndex(0);
            String fetchSpec = ERXStringUtilities.firstPropertyKeyInKeyPath(keypath);
            if ((keypath = ERXStringUtilities.keyPathWithoutFirstProperty(keypath)) == null) {
                return ERXArrayUtilities.filteredArrayWithEntityFetchSpecification(array, eo.entityName(), fetchSpec);
            }
            array = ERXArrayUtilities.filteredArrayWithEntityFetchSpecification(array, eo.entityName(), fetchSpec);
            return this.contents((NSArray)array, keypath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SortOperator
    implements NSArray.Operator {
        private NSSelector selector;

        public SortOperator(NSSelector selector) {
            this.selector = selector;
        }

        @Override
        public Object compute(NSArray<?> array, String keypath) {
            if (array.count() < 2) {
                return array;
            }
            if (keypath != null && keypath.indexOf(",") != -1) {
                return ERXArrayUtilities.sortedArraySortedWithKeys(array, NSArray.componentsSeparatedByString(keypath, ","), this.selector);
            }
            return ERXArrayUtilities.sortedArraySortedWithKey(array, keypath, this.selector);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class BaseOperator
    implements NSArray.Operator {
        BaseOperator() {
        }

        public Object contents(NSArray<?> array, String keypath) {
            if (array != null && array.count() > 0 && keypath != null && keypath.length() > 0) {
                return NSKeyValueCodingAdditions.Utility.valueForKeyPath(array, (String)keypath);
            }
            return array;
        }
    }
}

