/*
 * Decompiled with CFR 0.152.
 */
package er.extensions.foundation;

import com.webobjects.foundation.NSMutableDictionary;
import er.extensions.foundation.ERXMutableDictionary;
import er.extensions.foundation.ERXRandomGUID;
import java.io.File;

public class ERXFileRepository {
    protected File _root;
    protected final Factory _factory;
    private static final NSMutableDictionary _repositories = ERXMutableDictionary.synchronizedDictionary();

    protected ERXFileRepository(File root, Factory factory) {
        this._root = root;
        this._factory = factory;
    }

    public File createFile() {
        return this.getFile(ERXRandomGUID.newGid());
    }

    public File getFile(String id) {
        return new File(this._factory.getDir(this.getRoot(), id), id);
    }

    public boolean hasFile(String id) {
        return this.getFile(id).exists();
    }

    public File getRoot() {
        return this._root;
    }

    public static ERXFileRepository respository(String name) {
        return (ERXFileRepository)_repositories.objectForKey(name);
    }

    public static ERXFileRepository addRepository(String name, File root) {
        return ERXFileRepository.addRepository(name, new ERXFileRepository(root, new DefaultFactory()));
    }

    public static ERXFileRepository addRepository(String name, File root, Factory factory) {
        return ERXFileRepository.addRepository(name, new ERXFileRepository(root, factory));
    }

    public static ERXFileRepository addRepository(String name, ERXFileRepository repository) {
        _repositories.setObjectForKey(repository, name);
        return repository;
    }

    public static class DefaultFactory
    implements Factory {
        public File getDir(File root, String id) {
            File dir = new File(root, id.substring(0, 2) + File.separator + id.substring(2, 4));
            if (!dir.exists()) {
                dir.mkdirs();
            }
            return dir;
        }
    }

    public static interface Factory {
        public File getDir(File var1, String var2);
    }
}

